/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Logging;
import com.sas.ssn.UnicodeInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class KitConfigXML {
    private String mode;
    private String personalType;
    private String personalSID;
    private String personalPlan;
    private String personalPlanB;

    public KitConfigXML(String file) throws IOException, ParserConfigurationException, SAXException {
        this(new File(file));
    }

    public KitConfigXML(File file) throws IOException, ParserConfigurationException, SAXException {
        try {
            Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(file)).getDocumentElement();
            NodeList data = root.getChildNodes();
            if (data != null) {
                for (int i = 0; i < data.getLength(); ++i) {
                    if (data.item(i).getNodeType() != 1) continue;
                    Element element = (Element)data.item(i);
                    if ("mode".equals(element.getTagName())) {
                        this.mode = element.getFirstChild().getNodeValue();
                        continue;
                    }
                    if ("personalType".equals(element.getTagName())) {
                        this.personalType = element.getFirstChild().getNodeValue();
                        continue;
                    }
                    if ("personalSID".equals(element.getTagName())) {
                        this.personalSID = element.getFirstChild().getNodeValue();
                        continue;
                    }
                    if ("personalPlan".equals(element.getTagName())) {
                        this.personalPlan = element.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (!"personalPlanB".equals(element.getTagName())) continue;
                    this.personalPlanB = element.getFirstChild().getNodeValue();
                }
            }
        }
        catch (FileNotFoundException e) {
            Logging.log.fine("Config XML File Not Found. " + e.getMessage());
        }
    }

    public String getMode() {
        return this.mode;
    }

    public String getPersonalType() {
        return this.personalType;
    }

    public String getPersonalSID() {
        return this.personalSID;
    }

    public String getPersonalPlan() {
        return this.personalPlan;
    }

    public String getPersonalPlanB() {
        return this.personalPlanB;
    }
}

