/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.WizardCallbackIface;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public class KitBrowseButton
extends JButton
implements ActionListener {
    protected static SSNResource bundle = new SSNResource(KitBrowseButton.class);
    private int m_mode = 0;
    private JTextComponent m_companion = null;
    private JComboBox m_comboBox = null;
    private String m_defdir = null;
    private String m_deffile = null;
    private int m_smode = 0;
    private WizardCallbackIface m_callbackPanel = null;
    private FileFilter m_filter;
    private JFileChooser m_chooser;
    private boolean m_forceMac = false;

    public KitBrowseButton(String title, String defdir, int mode, JTextComponent companion) {
        super(title);
        this.m_mode = mode;
        this.m_defdir = defdir;
        this.m_companion = companion;
        this.addActionListener(this);
    }

    public KitBrowseButton(String title, String defdir, int mode, JComboBox companion) {
        super(title);
        this.m_mode = mode;
        this.m_defdir = defdir;
        this.m_comboBox = companion;
        this.addActionListener(this);
    }

    public KitBrowseButton(String title, String defdir, int mode, JTextComponent companion, boolean forceMac) {
        super(title);
        this.m_mode = mode;
        this.m_defdir = defdir;
        this.m_companion = companion;
        this.m_forceMac = forceMac;
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int shifted = e.getModifiers() & 1 | (this.m_forceMac ? 1 : 0);
        String uFile = null;
        int returnVal = 0;
        String title = null;
        title = this.m_mode == 0 ? bundle.getString("Common.Open.txt") : bundle.getString("KitBrowseButton.FileSave.txt");
        if (Globals.g_mode == 2) {
            String inSASHome = "in" + Globals.g_wizardData.getPreference("SASHome", "");
            this.m_defdir = Globals.g_wizardData.getPreference("LastSidDir" + inSASHome, null) != null ? Globals.g_wizardData.getPreference("LastSidDir" + inSASHome, null) : (Utils.getOS() == 1 ? Utils.joinPath(new JFileChooser().getFileSystemView().getDefaultDirectory().toString(), ".") : Utils.joinPath(System.getProperty("user.home"), "."));
        } else {
            File cfile = null;
            if (this.m_companion != null) {
                cfile = new File(this.m_companion.getText());
            } else if (this.m_comboBox != null) {
                cfile = new File(this.getComboText());
            }
            if (cfile != null) {
                switch (this.m_smode) {
                    case 0: {
                        if (cfile.isDirectory()) {
                            this.m_defdir = cfile.getPath() + File.separator + ".";
                            break;
                        }
                        this.m_defdir = cfile.getPath();
                        break;
                    }
                    default: {
                        this.m_defdir = cfile.getPath();
                    }
                }
            }
        }
        if (shifted != 0) {
            int mode = this.m_mode == 0 ? 0 : 1;
            FileDialog fd = new FileDialog(this.getParentFrame(this), title, mode);
            if (this.m_deffile != null) {
                fd.setFile(this.m_deffile);
            }
            fd.setDirectory(this.m_defdir);
            if (this.m_smode == 1 && this.m_forceMac) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
            }
            fd.show();
            if (this.m_smode == 1 && this.m_forceMac) {
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            }
            if (fd.getFile() != null) {
                switch (this.m_smode) {
                    case 0: {
                        uFile = Utils.joinPath(fd.getDirectory(), fd.getFile());
                        break;
                    }
                    default: {
                        uFile = this.m_forceMac ? Utils.joinPath(fd.getDirectory(), fd.getFile()) : fd.getDirectory();
                    }
                }
            }
        } else {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(title);
            chooser.setDialogType(this.m_mode);
            chooser.setFileSelectionMode(this.m_smode);
            chooser.setSelectedFile(new File(this.m_defdir));
            if (this.m_filter != null) {
                chooser.addChoosableFileFilter(this.m_filter);
            }
            this.m_chooser = chooser;
            if (System.getProperty("java.version").startsWith("1.4.1") && this.m_smode != 1) {
                chooser.addPropertyChangeListener("directoryChanged", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        String prop = e.getPropertyName();
                        if ("directoryChanged".equals(prop)) {
                            KitBrowseButton.this.m_chooser.setSelectedFile(new File(""));
                        }
                    }
                });
            }
            if ((returnVal = chooser.showOpenDialog(this.getParentComponent(this))) == 0) {
                if (this.m_smode == 0) {
                    File file = chooser.getSelectedFile();
                    uFile = file.getPath();
                } else {
                    File file = chooser.getSelectedFile();
                    uFile = file.getPath();
                }
            }
        }
        if (uFile != null) {
            uFile = uFile.replaceAll(Pattern.compile("^/(\\.\\.?/)+").toString(), "/");
        }
        if (uFile != null) {
            if (this.m_companion != null) {
                this.m_companion.setText(uFile);
            } else if (this.m_comboBox != null) {
                ((JTextField)this.m_comboBox.getEditor().getEditorComponent()).setText(uFile);
            }
            if (this.m_callbackPanel != null) {
                this.m_callbackPanel.updateTextArea();
            }
        }
    }

    public Frame getParentFrame(Component comp) {
        Frame parentFrame = null;
        Component parent = comp;
        while (parent != null) {
            if (parent instanceof Frame) {
                parentFrame = (Frame)parent;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        return parentFrame;
    }

    public Component getParentComponent(Component comp) {
        Component parentFrame = null;
        Component parent = comp;
        while (parent != null) {
            if (parent instanceof Frame || parent instanceof Dialog) {
                parentFrame = parent;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        return parentFrame;
    }

    public void setCallbackPanel(WizardCallbackIface panel) {
        this.m_callbackPanel = panel;
    }

    public void setDefaultFile(String df) {
        this.m_deffile = df;
    }

    public void setFileSelectionMode(int m) {
        this.m_smode = m;
    }

    public void setFilter(FileFilter m_filter) {
        this.m_filter = m_filter;
    }

    public void setFileName(String fileName) {
        this.m_chooser.setSelectedFile(new File(fileName));
    }

    private String getComboText() {
        return ((JTextField)this.m_comboBox.getEditor().getEditorComponent()).getText();
    }
}

