/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class Kerberos {
    private SSNResource bundle = new SSNResource(Kerberos.class);
    HttpResponse response = null;
    HttpClient httpclient = null;

    public HttpResponse invokeKerberos(final String url, String user, String password, final String proxy_host, final int proxy_port) {
        if (!this.setKrb5ConfProperty()) {
            return null;
        }
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        if (Globals.g_logLevel == 2) {
            System.setProperty("sun.security.krb5.debug", "true");
            System.setProperty("sun.security.jgss.debug", "true");
        }
        try {
            Configuration config = new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new HashMap<String, Object>(){
                        {
                            this.put("useTicketCache", "false");
                            this.put("useKeyTab", "true");
                            this.put("refreshKrb5Config", "true");
                            this.put("storeKey", "true");
                            this.put("doNotPrompt", "false");
                            this.put("isInitiator", "true");
                            if (Globals.g_logLevel == 2) {
                                this.put("debug", "true");
                            }
                        }
                    })};
                }
            };
            HashSet<KerberosPrincipal> princ = new HashSet<KerberosPrincipal>(1);
            princ.add(new KerberosPrincipal(user));
            Subject sub = new Subject(false, princ, new HashSet(), new HashSet());
            LoginContext loginContext = new LoginContext("", sub, new KerberosCallBackHandler(user, password), config);
            loginContext.login();
            PrivilegedAction<Object> sendAction = new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        Subject current = Subject.getSubject(AccessController.getContext());
                        Logging.log.finer("-----");
                        Set<Principal> principals = current.getPrincipals();
                        for (Principal next : principals) {
                            Logging.log.finer("DoAS Principal: " + next.getName());
                        }
                        Logging.log.finer("-----");
                        Kerberos.this.call(proxy_host, proxy_port, url);
                    }
                    catch (IOException e) {
                        Logging.logStackTrace(e);
                    }
                    return true;
                }
            };
            Subject.doAs(loginContext.getSubject(), sendAction);
        }
        catch (LoginException le) {
            Logging.logStackTrace(le);
        }
        return this.response;
    }

    private boolean setKrb5ConfProperty() {
        boolean found = true;
        if (Globals.g_krb5confpath != null) {
            if (new File(Globals.g_krb5confpath).isFile()) {
                System.setProperty("java.security.krb5.conf", Globals.g_krb5confpath);
            } else {
                Logging.log.severe("krb5.conf file not found at location specified: " + Globals.g_krb5confpath);
                found = false;
            }
        } else if (new File("/etc/krb5/krb5.conf").isFile()) {
            System.setProperty("java.security.krb5.conf", "/etc/krb5/krb5.conf");
        } else if (new File("/etc/krb5.conf").isFile()) {
            System.setProperty("java.security.krb5.conf", "/etc/krb5.conf");
        } else {
            Logging.log.severe("krb5.conf file not found in /etc/ or /etc/krb5/");
            found = false;
        }
        if (!found) {
            CustMsgBox.showMessageDialog(null, this.bundle.messageString("Kerberos.krb5.missing.txt"), this.bundle.getString("Common.Error.txt"), 0);
        }
        return found;
    }

    private void call(String proxy_host, int proxy_port, String url) throws IOException {
        this.httpclient = this.getHttpClient(proxy_host, proxy_port);
        try {
            HttpGet request = new HttpGet(url);
            this.response = this.httpclient.execute(request);
            Logging.log.finer("STATUS >> " + this.response.getStatusLine());
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
    }

    public void shutdown() throws IOException {
        EntityUtils.consume(this.response.getEntity());
        this.httpclient.getConnectionManager().shutdown();
    }

    private HttpClient getHttpClient(String proxy_host, int proxy_port) {
        Credentials use_jaas_creds = new Credentials(){

            @Override
            public String getPassword() {
                return null;
            }

            @Override
            public Principal getUserPrincipal() {
                return null;
            }
        };
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(null, -1, null), use_jaas_creds);
        Registry<AuthSchemeProvider> authSchemeRegistry = RegistryBuilder.create().register("Negotiate", new SPNegoSchemeFactory(true)).build();
        CloseableHttpClient httpclient = HttpClients.custom().setProxy(new HttpHost(proxy_host, proxy_port)).setDefaultAuthSchemeRegistry(authSchemeRegistry).setDefaultCredentialsProvider(credsProvider).build();
        return httpclient;
    }

    class KerberosCallBackHandler
    implements CallbackHandler {
        private final String user;
        private final String password;

        public KerberosCallBackHandler(String user, String password) {
            this.user = user;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(this.user);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    pc.setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unknown Callback");
            }
        }
    }
}

