/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.PropsParser;
import com.sas.ssn.RegistryAccess;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public class InstallData {
    public static final String SID_SITE_NUM = "sid.site.num";
    public static final String SID_SITE_NAME = "sid.site.name";
    public static final String DEPLOYAGENT_CONFIG_IS_SKIP = "deployagent.config.is_skip";
    public static final String DEPLOYAGENT_CONFIG_IS_FORCE = "deployagent.config.is_force";
    public static final String GRAPHAPPLET_IS_SELECTED = "graphapplet.is.selected";
    public static final String MSOFFICEINT_IS_SELECTED = "msofficeint.is.selected";
    public static final String SASINSTALL_IS_SELECTED = "sasinstall.is.selected";
    public static final String DEPLOYMENT_IS_PLANNED = "deployment.is.planned";
    public static final String DEPLOYMENT_IS_UIP = "deployment.is.uip";
    public static final String DEPLOYMENT_IS_ADDON = "deployment.is.addon";
    public static final String DEPLOYMENT_IS_METADATASRV_TIER = "deployment.is.metadatasrv.tier";
    public static final String OS_LOCALHOST_FQDN_HOST_NAME = "os.localhost.fqdn.host.name";
    public static final String OS_LOCALHOST_HOST_NAME = "os.localhost.host.name";
    public static final String OS_LOCALHOST_MACHINE_TYPE = "os.localhost.machine.type";
    public static final String OS_LOCALHOST_USER_HOME_DIR = "os.localhost.user.home.dir";
    public static final String SAS_HOME_DIR = "sas.home.dir";
    public static final String WINDOWS_UTILITIES_DIR = "windows.utilities.dir";
    public static final String CFGWIZARD_INSTALL_DIR = "cfgwizard.install.dir";
    public static final String DEPLOYAGENT_INSTALL_DIR = "deployagent.install.dir";
    public static final String DEPLOYAGTCLT_INSTALL_DIR = "deployagtclt.install.dir";
    public static final String WIZARD_MANAGER_TASK = "wizard.manager.task";
    public static final String WIZARD_TYPE = "wizard.type";
    public static final String ZOS_BIT_COUNT = "zos.bit.count";
    public static final String ZOS_INTERMEDIATE_FILES = "zos.intermediate.files";
    public static final String WIN_PROGRAM_DATA_DIR = "win.program.data";
    public static final String SAS_STARTUP_LOCATION = "sas.startup.location";
    public static final String FILE_NAME = "install.properties";
    public static final String OS_LOCALHOST_USERID = "os.localhost.userid";
    public static final String OS_LOCALHOST_LOGON_DOMAIN = "os.localhost.logon.domain";
    public static final String SAS_HOME_PARENT_DIR = "sas.home.parent.dir";
    public static final String MACHINE_INSTALLED_LIST = "machine.installed.list";
    public static final String MOMINSTALL_PRODUCTS_SIDLOCATION = "mominstall.products.sidlocation";
    private boolean m_changed = false;
    private boolean m_temporary = true;
    private Properties m_installProps = new Properties();
    private File m_propsFile = new File(Globals.g_tempLocation, "install.properties");
    private String m_machineInstalledList = null;

    public boolean load(String installDataDir) {
        boolean valid = true;
        this.clear();
        this.m_temporary = false;
        this.m_propsFile = new File(installDataDir, FILE_NAME);
        if (this.m_propsFile.isFile()) {
            try {
                FileInputStream fis = new FileInputStream(this.m_propsFile);
                this.m_installProps.load(fis);
                fis.close();
            }
            catch (Exception e) {
                valid = false;
                Logging.log.info("Error loading install properties file: " + this.m_propsFile.getAbsolutePath());
            }
        } else {
            Logging.log.fine("Install properties file does not exist: " + this.m_propsFile.getAbsolutePath());
        }
        File configFile = new File(installDataDir, "sassw.config");
        if (configFile.isFile()) {
            try {
                PropsParser configINIFile = new PropsParser(true);
                configINIFile.load(configFile, null);
                String environmentsURL = configINIFile.getINIValue("properties", "SASENVIRONMENTSURL", null);
                if (environmentsURL == null) {
                    this.removeProperty("sas.environments.url");
                } else {
                    this.setProperty("sas.environments.url", environmentsURL);
                }
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadMachineInstalledList() {
        if (this.m_machineInstalledList == null) {
            TreeSet<String> prodCodeSet = new TreeSet<String>();
            try (RegistryAccess ra = RegistryAccess.getRegistryAccess();){
                if (ra != null && ra.open()) {
                    String[] hosts = ra.getInstallHosts();
                    for (int i = 0; i < hosts.length; ++i) {
                        String[] codes = ra.getInstallCodes(hosts[i]);
                        for (int n = 0; n < codes.length; ++n) {
                            prodCodeSet.add(codes[n].toUpperCase(Locale.ENGLISH));
                        }
                    }
                }
            }
            StringBuffer sb = new StringBuffer();
            for (String prodCode : prodCodeSet) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(prodCode);
            }
            this.m_machineInstalledList = sb.toString();
            Logging.log.finer("getMachineInstalledList() setting m_machineInstalledList=" + this.m_machineInstalledList);
        }
        return this.m_machineInstalledList;
    }

    public boolean loadTemporary(String installDataDir) {
        boolean valid = true;
        this.clear();
        File propsFile = new File(installDataDir, FILE_NAME);
        if (propsFile.isFile()) {
            try {
                FileInputStream fis = new FileInputStream(propsFile);
                this.m_installProps.load(fis);
                fis.close();
            }
            catch (Exception e) {
                valid = false;
                Logging.log.info("Error loading install properties file: " + propsFile.getAbsolutePath());
            }
        } else {
            Logging.log.fine("Install properties file does not exist: " + propsFile.getAbsolutePath());
        }
        return valid;
    }

    public void makeTemporary() {
        this.m_temporary = true;
        this.m_propsFile = new File(Globals.g_tempLocation, FILE_NAME);
    }

    public boolean save() {
        boolean valid = false;
        try {
            FileOutputStream fos = new FileOutputStream(this.m_propsFile);
            this.m_installProps.store(fos, null);
            fos.close();
            valid = true;
        }
        catch (Exception e) {
            Logging.log.severe("Error saving install properties file: " + this.m_propsFile.toString());
        }
        this.deleteINIFile(this.m_propsFile.toString());
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveWithoutPasswords(String filePath) {
        boolean valid = false;
        Properties props = new Properties();
        String key = null;
        String value = null;
        Enumeration<Object> e = this.m_installProps.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (Globals.g_installPasswords == null || Globals.g_installPasswords.containsKey(key) || (value = this.m_installProps.getProperty(key, null)) == null) continue;
            props.setProperty(key, value);
        }
        FileOutputStream fos = null;
        try {
            File file = new File(filePath);
            fos = new FileOutputStream(file);
            props.store(fos, null);
            valid = true;
        }
        catch (Exception e2) {
            Logging.logStackTrace(e2);
            Logging.log.severe("Error saving install properties file: " + props.toString());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e3) {
                    Logging.logStackTrace(e3);
                }
            }
        }
        this.deleteINIFile(filePath);
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveWithPasswordHashes(String filePath) {
        boolean valid = false;
        Properties props = new Properties();
        String key = null;
        String value = null;
        Enumeration<Object> e = this.m_installProps.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (Globals.g_installPasswords == null || Globals.g_installPasswords.containsKey(key) && !key.endsWith(".hash") || (value = this.m_installProps.getProperty(key, null)) == null) continue;
            props.setProperty(key, value);
        }
        FileOutputStream fos = null;
        try {
            File file = new File(filePath);
            fos = new FileOutputStream(file);
            props.store(fos, null);
            valid = true;
        }
        catch (Exception e2) {
            Logging.logStackTrace(e2);
            Logging.log.severe("Error saving install properties file: " + props.toString());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e3) {
                    Logging.logStackTrace(e3);
                }
            }
        }
        this.deleteINIFile(filePath);
        return valid;
    }

    private void deleteINIFile(String propsFile) {
        File props = new File(propsFile);
        try {
            File iniFile;
            if (props.isFile() && (iniFile = new File(props.getParentFile(), "installprops.ini")).isFile() && iniFile.delete()) {
                Logging.log.info("The installprops.ini file was successfully deleted: " + iniFile.toString());
            }
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
    }

    public void clear() {
        this.m_installProps.clear();
    }

    public boolean delete() {
        boolean valid = false;
        try {
            valid = this.m_propsFile.exists() ? this.m_propsFile.delete() : true;
        }
        catch (Exception e) {
            Logging.log.info("Error deleting install properties file: " + this.m_propsFile.toString());
        }
        return valid;
    }

    public String getFilePath() {
        return this.m_propsFile.toString();
    }

    public void setProperty(String key, String value) {
        Logging.log.fine("Install property: " + key + "=" + value);
        String oldValue = this.getProperty(key, null);
        if (oldValue == null || !oldValue.equals(value)) {
            this.m_changed = true;
        }
        this.m_installProps.setProperty(key, value);
    }

    public void removeProperty(String key) {
        this.m_installProps.remove(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.m_installProps.getProperty(key, defaultValue);
    }

    public Properties getProperties() {
        return this.m_installProps;
    }

    public boolean changed() {
        return this.m_changed;
    }

    public void resetChanged() {
        this.m_changed = false;
    }

    public boolean isTemporary() {
        return this.m_temporary;
    }

    public void loadProperties(Properties props) {
        this.m_installProps.putAll((Map<?, ?>)props);
    }
}

