/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.CustMsgBox;
import com.sas.ssn.EsdInternet;
import com.sas.ssn.EsdPart;
import com.sas.ssn.Globals;
import com.sas.ssn.HotFixDeploymentData;
import com.sas.ssn.HotFixIndexData;
import com.sas.ssn.HotFixManager;
import com.sas.ssn.Logging;
import com.sas.ssn.OrderData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SkuData;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import com.sas.ssn.VolserData;
import com.sas.ssn.schema.esd.hotfix.gen.Hosts;
import com.sas.ssn.schema.esd.hotfix.gen.Hotfix;
import com.sas.ssn.schema.esd.hotfix.gen.Nls;
import com.sas.ssn.schema.esd.hotfix.gen.SASHotFixDLM;
import com.sas.ssn.schema.esd.hotfix.gen.Urls;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;

public class HotfixData {
    private SSNResource bundle = new SSNResource(HotfixData.class);
    private String order = null;
    private boolean doDownload = false;
    private boolean initFailed = false;
    private String hotfixVersion = null;
    private String hotfixURL = null;
    private String tmpHotFixDir = null;
    private String hotfixXMLFile = null;
    private LinkedHashMap<String, HotFixDeploymentData> hotFixDeploymentDataList = null;
    private LinkedHashMap<String, Hotfix> hfdata = null;
    private LinkedHashMap<String, List<String>> hfdata_ref = null;
    private ArrayList<Nls> nlsList = null;
    private ArrayList<String> hfkeys = null;
    private HashMap<String, HashSet<String>> hfLangs = null;
    private HashMap<String, String> urls = null;
    private HashMap<String, String> hosts = null;
    private LinkedHashMap<String, List<String>> dl_hfids = null;
    private LinkedHashSet<String> dl_keys = null;
    private LinkedHashSet<String> hfidhstlist = null;
    private LinkedList<EsdPart> hfDownloadList = null;
    private Map<String, HotFixIndexData> dlnameToHfds;
    private ArrayList<String> hotFixFilesToTry = new ArrayList();
    private HotFixManager hotfixManager = null;
    private boolean downloadComplete = false;
    private boolean canceled = false;
    private HFMode hotfixMode = null;
    private String hotFixDownloadDataFilename = null;
    private String depotDir = null;
    private String orderMaintLevel = null;
    private String orderShipEvent = null;
    private static Unmarshaller hotfixUnmarshaller = null;

    private static Unmarshaller getHotFixUnmarshaller() throws JAXBException {
        if (hotfixUnmarshaller == null) {
            JAXBContext jc = JAXBContext.newInstance("com.sas.ssn.schema.esd.hotfix.gen", HotfixData.class.getClassLoader());
            hotfixUnmarshaller = jc.createUnmarshaller();
        }
        return hotfixUnmarshaller;
    }

    public HotfixData(String order) {
        this.order = order;
        this.hotfixMode = HFMode.UPDATE;
        this.depotDir = Globals.g_deploymentData.getMediaRoot();
        this.init();
    }

    public HotfixData(String order, HFMode hotfixMode) {
        this.order = order;
        this.hotfixMode = hotfixMode;
        this.depotDir = Globals.g_deploymentData.getMediaRoot();
        this.init();
    }

    public HotfixData(String order, HFMode hotfixMode, String depotDir) {
        this.order = order;
        this.hotfixMode = hotfixMode;
        this.depotDir = depotDir;
        this.init();
    }

    private void init() {
        if (Globals.g_mode == 1) {
            this.tmpHotFixDir = Utils.joinPath(Globals.g_downloadDir + "hf", "hotfix");
        } else {
            if (!this.checkDirectory(this.depotDir)) {
                this.initFailed = true;
                return;
            }
            this.tmpHotFixDir = Utils.joinPath(this.depotDir, "downloadhf", "hotfix");
        }
        switch (Globals.g_deploymentData.getOrder(this.order).getDepotVersionAsInt()) {
            case 1: {
                this.hotfixVersion = "92";
                break;
            }
            case 2: {
                this.hotfixVersion = "93";
                break;
            }
            case 3: {
                this.hotfixVersion = "94";
                break;
            }
            case 4: {
                this.hotfixVersion = "94";
                break;
            }
            default: {
                this.hotfixVersion = "94";
            }
        }
        this.orderMaintLevel = Globals.g_deploymentData.getOrder(this.order).getMaintLevel();
        this.orderShipEvent = Globals.g_deploymentData.getOrder(this.order).getShipEvent();
        this.hotFixDownloadDataFilename = "SAS" + this.hotfixVersion + "_hot_fix_data.xml";
        this.hotfixURL = Globals.g_httponly ? "http://ftp.sas.com/techsup/download/hotfix/HF2/util01/SASHotFixDLM/data/SAS" : "https://tshf.sas.com/techsup/download/hotfix/HF2/util01/SASHotFixDLM/data/SAS";
        if (this.orderMaintLevel != null && this.orderShipEvent != null && !this.orderMaintLevel.isEmpty() && !this.orderShipEvent.isEmpty()) {
            this.hotFixFilesToTry.add(this.hotfixURL + this.hotfixVersion + "_" + this.orderMaintLevel + "_" + this.orderShipEvent + "_hot_fix_data.xml");
            this.hotFixFilesToTry.add(this.hotfixURL + this.hotfixVersion + "_" + this.orderMaintLevel + "_hot_fix_data.xml");
        }
        this.hotFixFilesToTry.add(this.hotfixURL + this.hotfixVersion + "_hot_fix_data.xml");
        this.hotfixXMLFile = Utils.joinPath(this.tmpHotFixDir, this.hotFixDownloadDataFilename);
        File tHFD = new File(this.tmpHotFixDir);
        if (tHFD != null && tHFD.exists()) {
            Utils.deleteFolder(tHFD);
        }
        this.hotFixDeploymentDataList = new LinkedHashMap();
        this.hfdata = new LinkedHashMap();
        this.hfdata_ref = new LinkedHashMap();
        this.nlsList = new ArrayList();
        this.hfkeys = new ArrayList();
        this.hfLangs = new HashMap();
        this.dl_hfids = new LinkedHashMap();
        this.dl_keys = new LinkedHashSet();
        this.hfidhstlist = new LinkedHashSet();
        this.hfDownloadList = new LinkedList();
        this.doDownload = false;
        this.urls = new HashMap();
        this.hosts = new HashMap();
        this.downloadComplete = false;
        this.canceled = false;
    }

    public void grabAndAnalyzeHotfixes() {
        if (this.initFailed) {
            return;
        }
        try {
            this.downloadHotFixIndex();
            this.loadOrderInformation();
            this.parseHotFixXML();
            this.filterForSecurityFix();
            this.generateDownloadList();
            this.hotfixProcess();
            this.checkAgainstDepot();
            this.setupDownload();
        }
        catch (Exception e) {
            Logging.log.warning("Download and processing of hot fix index data failed.");
            Logging.logStackTrace(e);
            this.canceledMessage(e.getMessage(), HFMode.BEFORE);
            this.canceled = true;
        }
    }

    public void downloadHotfixes() {
        if (this.initFailed) {
            return;
        }
        try {
            if (this.doDownload) {
                this.startDownloadHotfixes();
            }
        }
        catch (Exception e) {
            Logging.log.warning("Commit of HotFixes failed");
            Logging.logStackTrace(e);
            this.canceledMessage(e.getMessage(), HFMode.AFTER);
            this.canceled = true;
        }
    }

    public void deleteHotfixStagingDir() {
        File tHFD = new File(this.tmpHotFixDir);
        if (tHFD != null && tHFD.getParentFile().exists()) {
            Utils.deleteFolder(tHFD.getParentFile());
        }
    }

    public void processHotfixes() {
        if (this.initFailed && !this.canceled) {
            return;
        }
        try {
            this.hotfixManager.commitHotFixes(this.tmpHotFixDir, this.hotfixXMLFile);
        }
        catch (Exception e) {
            Logging.log.warning("Commit of HotFixes failed");
            Logging.logStackTrace(e);
            this.canceledMessage(e.getMessage(), HFMode.AFTER);
            this.canceled = true;
        }
        if (!this.canceled) {
            this.downloadComplete = true;
        }
    }

    public void downloadHotFixIndex() throws HotFixDataException {
        boolean result = true;
        File tHFD = new File(this.tmpHotFixDir);
        if (tHFD.exists()) {
            Utils.deleteFolder(tHFD);
        }
        tHFD.mkdirs();
        EsdInternet internet = new EsdInternet();
        for (String hotfixURL : this.hotFixFilesToTry) {
            Logging.log.finer("Attempting to download hot fix file:" + hotfixURL);
            try {
                result = internet.downloadFileRetries(hotfixURL, this.hotfixXMLFile, false);
            }
            catch (Exception e) {
                Logging.log.warning("Download of Hot Fix Index file failed");
                Logging.logStackTrace(e);
                result = false;
                throw new HotFixDataException(e.getMessage());
            }
            if (result) {
                Logging.log.info("Successfully downloading hot fix file:" + hotfixURL);
                break;
            }
            Logging.log.finer("Unsuccessfully tried to download hot fix file:" + hotfixURL);
        }
        if (!result) {
            throw new HotFixDataException(this.bundle.messageString("HotfixData.downloadXMLFailed.txt"));
        }
    }

    private String[] removeSkus(String[] skus, List<String> omitlist) {
        ArrayList<String> newlist = new ArrayList<String>(Arrays.asList(skus));
        for (String sku : omitlist) {
            newlist.remove(sku);
        }
        return newlist.toArray(new String[0]);
    }

    public void loadOrderInformation() {
        HotFixDeploymentData hfDeployDat = new HotFixDeploymentData();
        ArrayList<String> omitlist = null;
        if (Globals.g_subsetData != null && Globals.g_subsetData.isSubsetActive()) {
            omitlist = Globals.g_subsetData.getOmitList();
        }
        OrderData orderData = Globals.g_deploymentData.getOrder(this.order);
        String[] volsers = orderData.getVolsers(orderData.getMediaType());
        for (int i = 0; i < volsers.length; ++i) {
            VolserData volserData = Globals.g_deploymentData.getVolser(volsers[i]);
            String[] spsSkus = volserData.getSpsSkus();
            if (omitlist != null) {
                spsSkus = this.removeSkus(spsSkus, omitlist);
            }
            for (int j = 0; j < spsSkus.length; ++j) {
                if (!volserData.isPayloadIncluded(spsSkus[j])) continue;
                SpsSkuData spsSkuData = Globals.g_deploymentData.getSpsSku(spsSkus[j]);
                SkuData[] skuData = spsSkuData.getSkus();
                for (int k = 0; k < skuData.length; ++k) {
                    hfDeployDat.setHost(skuData[k].getPlatform());
                    hfDeployDat.setProduct(spsSkuData.getProdCode());
                    hfDeployDat.setVersion(spsSkuData.getVersion());
                    hfDeployDat.setDisplayName(spsSkuData.getDisplayName("en"));
                    hfDeployDat.setProdVersion(spsSkuData.getDisplayVer("en"));
                    hfDeployDat.setMaintenance(spsSkuData.getMaintLevel());
                    String key = hfDeployDat.getKey();
                    this.hfkeys.add(key);
                    hfDeployDat.setRef(key);
                    this.hotFixDeploymentDataList.put(key, hfDeployDat);
                    HashSet<String> langs = this.hfLangs.get(key);
                    if (langs == null) {
                        langs = new HashSet();
                        this.hfLangs.put(key, langs);
                    }
                    langs.add(spsSkuData.getLanguage().toUpperCase());
                }
            }
        }
        HashSet<String> deleteKeys = new HashSet<String>();
        for (String key : this.hfkeys) {
            String[] keyParts = key.split("~");
            if ("0".equals(keyParts[3])) continue;
            String deleteKey = keyParts[0] + "~" + keyParts[1] + "~" + keyParts[2] + "~0";
            this.hotFixDeploymentDataList.remove(deleteKey);
            deleteKeys.add(key);
        }
        for (String key : deleteKeys) {
            this.hfkeys.remove(key);
        }
    }

    private void parseHotFixXML() throws HotFixDataException {
        try {
            File hotFixXML = new File(this.hotfixXMLFile);
            JAXBElement<SASHotFixDLM> element = HotfixData.getHotFixUnmarshaller().unmarshal(new StreamSource(hotFixXML), SASHotFixDLM.class);
            Logging.log.info("Hot fix download data: " + hotFixXML.getName() + " Ver. " + element.getValue().getVer().toString() + " Generated: " + element.getValue().getUpdated() + " [" + element.getValue().getTstamp().toString() + "]");
            for (Hotfix hotfix : element.getValue().getHotfix()) {
                String primarykey = hotfix.getId() + "_" + hotfix.getHost();
                this.hfdata.put(primarykey, hotfix);
                String crossrefkey = hotfix.getHost() + "~" + hotfix.getTbyte() + "~" + hotfix.getProdRel() + "~" + hotfix.getProdMaint();
                List<String> primarykeys = this.hfdata_ref.get(crossrefkey);
                if (primarykeys == null) {
                    primarykeys = new LinkedList<String>();
                    this.hfdata_ref.put(crossrefkey, primarykeys);
                }
                primarykeys.add(primarykey);
            }
            for (Nls nls : element.getValue().getNls()) {
                this.nlsList.add(nls);
            }
            for (Urls url : element.getValue().getUrls()) {
                this.urls.put(url.getUrlcode(), url.getUrlval());
            }
            for (Hosts host : element.getValue().getHosts()) {
                this.hosts.put(host.getHostcode(), host.getHostdesc());
            }
        }
        catch (JAXBException e) {
            Logging.log.warning("Could not parse Hot Fix XML data");
            Logging.logStackTrace(e);
            throw new HotFixDataException(this.bundle.messageString("HotfixData.JAXBFailed.txt"));
        }
    }

    private void filterForSecurityFix() {
        if (!Globals.g_hfInclOnly) {
            Logging.log.info("Globals.g_securityFixOnly is false. No filtering of hot fixes required.");
            return;
        }
        ArrayList<String> removeKeys = new ArrayList<String>(this.hfdata.size());
        Logging.log.info("Globals.g_securityFixOnly is true. Perform filtering of hot fixes.");
        for (String key : this.hfdata.keySet()) {
            String isSecHf;
            String id = this.hfdata.get(key).getId();
            if (id.equals("W83001") || (isSecHf = this.hfdata.get(key).getSecurityfix()).equals("1")) continue;
            removeKeys.add(key);
        }
        for (String key : removeKeys) {
            Hotfix hotfix = this.hfdata.get(key);
            String refkey = hotfix.getHost() + "~" + hotfix.getTbyte() + "~" + hotfix.getProdRel() + "~" + hotfix.getProdMaint();
            this.hfdata_ref.remove(refkey);
            this.hfdata.remove(key);
        }
    }

    private void generateDownloadList() {
        for (String key : this.hotFixDeploymentDataList.keySet()) {
            if (!this.hfdata_ref.containsKey(key)) continue;
            for (String hfid : this.hfdata_ref.get(key)) {
                List<String> hfids = this.dl_hfids.get(key);
                if (hfids == null) {
                    hfids = new LinkedList<String>();
                    this.dl_hfids.put(key, hfids);
                }
                hfids.add(hfid);
                this.dl_keys.add(key);
            }
        }
    }

    private void hotfixProcess() {
        HashSet<String> thiscontainerprocessed = new HashSet<String>();
        for (String key : this.dl_keys) {
            for (String hfidhst : this.dl_hfids.get(key)) {
                String[] splitA = hfidhst.split("_");
                String hfid = splitA[0];
                String host = splitA[1];
                if (this.hfdata.get(hfidhst).getContype().matches("2|3")) {
                    String[] incontainerarray = null;
                    String incontainer = this.hfdata.get(hfidhst).getIncontainer();
                    incontainerarray = incontainer.contains(":") ? incontainer.split(":") : new String[]{incontainer};
                    for (String thiscontainer : incontainerarray) {
                        String thisconkey = thiscontainer + "_" + host;
                        if (thiscontainerprocessed.contains(thisconkey)) continue;
                        this.processRow(thisconkey, key);
                        thiscontainerprocessed.add(thisconkey);
                    }
                    continue;
                }
                this.processRow(hfidhst, key);
            }
        }
    }

    private boolean compareLangs(HashSet<String> list1, String list2) {
        if (list1.contains("XX")) {
            return true;
        }
        for (String lang2asArray : list2.split(",")) {
            if (!list1.contains(lang2asArray)) continue;
            return true;
        }
        return false;
    }

    private void processRow(String hfidhst, String key) {
        if (!"1".equals(this.hfdata.get(hfidhst).getNodownload()) && !"1".equals(this.hfdata.get(hfidhst).getNomit()) && (Globals.g_hotfixoverride || "1".equals(this.hfdata.get(hfidhst).getOrders())) && this.compareLangs(this.hfLangs.get(key), this.hfdata.get(hfidhst).getLangs())) {
            this.hfidhstlist.add(hfidhst);
        }
    }

    private void checkAgainstDepot() {
        try {
            this.hotfixManager = new HotFixManager(Globals.g_depotManager.getDepotData().getMediaRoot(), this.order);
        }
        catch (Exception e) {
            Logging.log.warning("Init of HotFixManager failed");
            Logging.logStackTrace(e);
            throw new HotFixDataException(e.getMessage());
        }
        ArrayList<HotFixIndexData> hfids = new ArrayList<HotFixIndexData>();
        HashMap<String, String> dlnameToHfids = new HashMap<String, String>();
        HashSet<String> seen = new HashSet<String>();
        this.dlnameToHfds = new HashMap<String, HotFixIndexData>();
        for (String key : this.hfidhstlist) {
            Hotfix hf = this.hfdata.get(key);
            if (!seen.contains(hf.getDlname())) {
                dlnameToHfids.put(hf.getDlname(), key);
                String maint_value = "";
                if (hf.getProdMaint().compareTo(BigInteger.ZERO) == 1) {
                    maint_value = "_M" + hf.getProdMaint();
                }
                String displayName = hf.getProduct() + " " + hf.getProdRel() + maint_value;
                HotFixIndexData hfd = new HotFixIndexData(hf.getId(), hf.getDlname(), hf.getMd5(), hf.getSize(), hf.getJx(), displayName, hf.getProdRel() + maint_value, hf.getReleaseDate());
                String forceuip = hf.getForceuip();
                if (forceuip != null && forceuip.equals("1")) {
                    hfd.setForceDuringUpdate(true);
                } else {
                    hfd.setForceDuringUpdate(false);
                }
                String onlyinchain = hf.getOnlyinchain();
                if (onlyinchain != null && onlyinchain.equals("1")) {
                    hfd.setForceOnlyInChain(true);
                } else {
                    hfd.setForceOnlyInChain(false);
                }
                String securityfix = hf.getSecurityfix();
                if (securityfix != null && securityfix.equals("1")) {
                    hfd.setSecurityFix(true);
                } else {
                    hfd.setSecurityFix(false);
                }
                if ("1".equals(hf.getIdoc())) {
                    hfd.setIdoc(true);
                }
                hfd.addDocs(hf.getHost(), hf.getIdocurl());
                this.dlnameToHfds.put(hf.getDlname(), hfd);
                hfids.add(hfd);
                Logging.log.finer("Adding " + hf.getDlname() + " for key " + key);
            } else {
                this.dlnameToHfds.get(hf.getDlname()).addDocs(hf.getHost(), hf.getIdocurl());
                Logging.log.finer("Adding Doc " + hf.getIdocurl() + " for " + hf.getDlname() + " for key " + key);
            }
            seen.add(hf.getDlname());
        }
        this.hotfixManager.setHotFixes(hfids);
        List<String> resultingDLnames = this.hotfixManager.missingHotFixes();
        this.dl_keys.clear();
        for (String dlname : resultingDLnames) {
            this.dl_keys.add((String)dlnameToHfids.get(dlname));
        }
        if (this.dl_keys.size() > 0) {
            this.doDownload = true;
        }
    }

    private void setupDownload() {
        StringBuffer logentry = new StringBuffer();
        for (String hfidhst : this.dl_keys) {
            Hotfix hf = this.hfdata.get(hfidhst);
            logentry.append(String.format("%18s: %12s %5s:%-2s %s\n", hf.getDlname(), hf.getTbyte(), hf.getProdRel(), hf.getProdMaint(), hf.getProduct()));
            String hxurl = "";
            hxurl = Globals.g_httponly ? this.urls.get(hf.getXurl().split(",")[1]) + hf.getDlurl() : "https://tshf.sas.com/techsup/download/hotfix/HF2" + hf.getDlurl();
            this.hfDownloadList.add(new EsdPart(hxurl, 0L, new Long("".equals(hf.getSize()) ? "0" : hf.getSize()), hf.getMd5(), "Z", Utils.joinPath(this.tmpHotFixDir, hf.getDlname())));
            if (!"1".equals(hf.getIdoc())) continue;
            HotFixIndexData hfds = this.dlnameToHfds.get(hf.getDlname());
            for (String host : hfds.getDocs().keySet()) {
                String docurl = hfds.getDocUrl(host);
                String docfn = hfds.getDocFilename(host);
                docurl = Globals.g_httponly ? this.urls.get(hf.getXurl().split(",")[2]) + docurl : "https://tshf.sas.com/techsup/download/hotfix/HF2" + docurl;
                this.hfDownloadList.add(new EsdPart(docurl, 0L, 0L, "", "D", Utils.joinPath(this.tmpHotFixDir, docfn)));
                logentry.append(String.format("%18s: %12s %5s:%-2s %s\n", "Doc:" + docfn, hf.getTbyte(), hf.getProdRel(), hf.getProdMaint(), hf.getProduct()));
            }
        }
        Logging.log.info("Hot Fixes to be downloaded:\n" + logentry);
    }

    private void startDownloadHotfixes() throws HotFixDataException {
        int retries = 3;
        boolean result = true;
        for (EsdPart hfpart : this.hfDownloadList) {
            retries = 3;
            result = false;
            while (!result && retries-- > 0) {
                EsdInternet internet = new EsdInternet();
                try {
                    Logging.log.finer("Going after: " + hfpart.getLink());
                    internet.downloadFileRetries(hfpart.getLink(), hfpart.getLocalFilename(), !Globals.g_onlydownloadhotfixes && !"D".equals(hfpart.getType()));
                    if (!"D".equals(hfpart.getType()) && !hfpart.getChecksum().equals(internet.getChecksum())) {
                        result = false;
                        File dlFile = new File(hfpart.getLocalFilename());
                        if (dlFile.exists()) {
                            dlFile.delete();
                            Logging.log.finer("Blew away " + hfpart.getLocalFilename());
                        }
                        Logging.log.warning("Failed to download (CRC): " + hfpart.getLink() + " to " + hfpart.getLocalFilename());
                        continue;
                    }
                    Logging.log.finer("Good download of " + hfpart.getLink());
                    result = true;
                }
                catch (Exception e) {
                    Logging.log.warning("Failed to download: " + hfpart.getLink() + " to " + hfpart.getLocalFilename());
                    Logging.logStackTrace(e);
                    result = false;
                }
            }
            if (result) continue;
            break;
        }
        if (!result) {
            Logging.log.warning("Unsuccessfully downloaded hotfixes");
            throw new HotFixDataException(this.bundle.messageString("HotfixData.downloadFailed.txt"));
        }
        Logging.log.info("Successfully downloaded hotfixes");
    }

    public void setDoDownload(boolean doDld) {
        this.doDownload = doDld;
    }

    public boolean getDoDownload() {
        return !this.canceled && this.doDownload && this.getNumHotfixesToDownload() > 0;
    }

    public int getNumHotfixesToDownload() {
        if (this.doDownload) {
            return this.hfDownloadList.size();
        }
        return 0;
    }

    public long getTotalSizeOfHotfixes() {
        long totalSize = 0L;
        if (this.doDownload) {
            for (EsdPart hfpart : this.hfDownloadList) {
                totalSize += hfpart.getSizeCompressed();
            }
        }
        return totalSize;
    }

    public boolean getDownloadComplete() {
        if (this.doDownload) {
            return this.downloadComplete;
        }
        return !this.hfFailed();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void resetData() {
        this.init();
    }

    private void canceledMessage(String message, HFMode whichMsg) {
        if (message == null || "null".equalsIgnoreCase(message)) {
            message = this.bundle.getString("Install.Error.-16");
        }
        String msgTop = null;
        String msgBtm = null;
        if (this.hotfixMode == HFMode.UPDATE) {
            whichMsg = HFMode.UPDATE;
        }
        switch (whichMsg.ordinal()) {
            case 0: {
                msgTop = "HotfixData.canceledMessage.Download.txt";
                msgBtm = "HotfixData.canceledMessage.Before.txt";
                break;
            }
            case 1: {
                msgTop = "HotfixData.canceledMessage.Download.txt";
                msgBtm = "HotfixData.canceledMessage.After.txt";
                break;
            }
            case 2: {
                msgTop = "HotfixData.canceledMessage.CopyDepot.txt";
                msgBtm = "HotfixData.canceledMessage.Copy.txt";
                break;
            }
            case 3: {
                msgTop = "HotfixData.canceledMessage.Download.txt";
                msgBtm = "HotfixData.canceledMessage.Update.txt";
            }
        }
        if (!Globals.g_quietMode) {
            String fullMessage = this.bundle.messageString(msgTop) + "\n\n" + message + "\n\n" + this.bundle.messageString(msgBtm);
            CustMsgBox.showMessageDialog(null, fullMessage, this.bundle.getString("Common.Error.txt"), 0);
        }
    }

    public void copyHotfixes(String source, String dest) {
        try {
            if (!new File(source, HotFixManager.getHotFixSubDir()).exists()) {
                return;
            }
            HotFixManager hotFixManager = new HotFixManager(dest, Globals.g_order);
            String sourceOrderNumber = null;
            sourceOrderNumber = Globals.g_subsetData != null && Globals.g_subsetData.isSubsetActive() ? Globals.g_subsetData.getOrigOrder() : Globals.g_order;
            String hotFixDownloadDataDir = Utils.joinPath(HotFixManager.getHotFixSubDir(), HotFixManager.getHotFixDownloadDataSubDir());
            String sourceHotFixXMLFile = Utils.joinPath(source, hotFixDownloadDataDir, this.hotFixDownloadDataFilename);
            hotFixManager.copyHotFixes(Utils.joinPath(source, HotFixManager.getHotFixSubDir()), sourceOrderNumber, sourceHotFixXMLFile);
        }
        catch (Exception e) {
            Logging.log.severe("Error in copying hot fixes from " + source + " to " + dest);
            Logging.logStackTrace(e);
            this.canceledMessage(e.getMessage(), HFMode.COPY);
        }
    }

    public boolean checkDirectory(String dir) {
        if (!Utils.canWriteToPath(dir)) {
            this.canceledMessage(this.bundle.messageString("Common.Error.NoPermissions.txt", this.bundle.getString("HotfixData.canceledMessage.FieldName.txt")), this.hotfixMode);
            return false;
        }
        return true;
    }

    public boolean hfFailed() {
        return this.initFailed || this.canceled;
    }

    public static enum HFMode {
        BEFORE,
        AFTER,
        COPY,
        UPDATE;

    }

    protected class HotFixDataException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public HotFixDataException(String translatedMsg) {
            super(translatedMsg);
        }
    }
}

