/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.HotFix;
import com.sas.ssn.HotFixContainer;
import com.sas.ssn.HotFixContainerException;
import com.sas.ssn.HotFixPackageData;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import com.sas.tools.installs.it.DeploymentXMLReader;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class HotFixesWithConfiguration {
    private static List<HotFix> installedHotFixData = null;
    private static List<HotFix> hotFixesInstalledWithConfiguration = null;
    private Map<String, HotFix> hotFixesByProductCode = new HashMap<String, HotFix>();
    private boolean hasDeterminedLatestHotFixIds = false;

    public HotFixesWithConfiguration() {
        this.hotFixesByProductCode.clear();
        this.hasDeterminedLatestHotFixIds = false;
        this.determineInstalledHotFixes();
    }

    @Deprecated
    public void unitTestReset() {
        this.hasDeterminedLatestHotFixIds = false;
    }

    public Map<String, String> getNewestHotFixIds() {
        return this.getNewestHotFixIds(null);
    }

    @Deprecated
    public Map<String, String> getNewestHotFixIds(RegistryAccess registryAccess) {
        HashMap<String, String> newestHotFixIds = new HashMap<String, String>();
        this.determineLatestHotFixIds(registryAccess);
        for (HotFix hotFix : this.hotFixesByProductCode.values()) {
            newestHotFixIds.put(hotFix.getProdCode(), hotFix.getHotFixName());
        }
        return newestHotFixIds;
    }

    public String getNewestHotFixId(String productCode) {
        return this.getNewestHotFixId(productCode, null);
    }

    @Deprecated
    public String getNewestHotFixId(String productCode, RegistryAccess registryAccess) {
        String hotFixId = null;
        this.determineLatestHotFixIds(registryAccess);
        HotFix hotFix = this.hotFixesByProductCode.get(productCode);
        if (hotFix != null) {
            hotFixId = hotFix.getHotFixName();
        }
        return hotFixId;
    }

    @Deprecated
    public void nullHotFixesInstalledWithConfiguration() {
        hotFixesInstalledWithConfiguration = null;
    }

    @Deprecated
    public void nullAllInstalledHotFixes() {
        installedHotFixData = null;
    }

    private List<HotFix> getConfigurableHotFixesToInstall() {
        ArrayList<HotFix> configurableHotFixes = new ArrayList<HotFix>();
        if (Globals.g_mode == 2) {
            for (HotFix hotFix : Globals.g_configurableHotFixes) {
                String hotFixName = hotFix.getHotFixName();
                if (hotFix.isConfigurationDataOnly()) {
                    hotFixName = hotFix.getPairedInstallHotFixName();
                }
                if (hotFixName == null || !this.isHotFixToBeInstalled(hotFixName)) continue;
                configurableHotFixes.add(hotFix);
            }
        }
        return configurableHotFixes;
    }

    private boolean isHotFixToBeInstalled(String hotFixName) {
        for (ProductData hotFixToInstall : Globals.g_selectedHotFixesToInstall) {
            if (hotFixToInstall.getType() != 4 || !hotFixName.equals(((HotFix)hotFixToInstall).getHotFixName())) continue;
            return true;
        }
        return false;
    }

    private List<HotFix> getInstalledConfigurableHotFixes(RegistryAccess registryAccess) {
        if (hotFixesInstalledWithConfiguration != null) {
            return hotFixesInstalledWithConfiguration;
        }
        hotFixesInstalledWithConfiguration = new ArrayList<HotFix>();
        if (registryAccess == null) {
            Logging.log.warning("Cannot determine installed configurable hot fixes because the deployment registry cannot be opened.");
            return hotFixesInstalledWithConfiguration;
        }
        for (HotFix hotFix : installedHotFixData) {
            if (!hotFix.isConfigurable()) continue;
            String installedMaintLevel = this.getInstalledMaintLevelForTargetedProduct(hotFix, registryAccess);
            if (hotFix.isConfigurationDataOnly()) {
                HotFix installableHotFix = this.getHotFixByHotFixName(installedHotFixData, hotFix.getPairedInstallHotFixName());
                if (installableHotFix == null) continue;
                installedMaintLevel = this.getInstalledMaintLevelForTargetedProduct(installableHotFix, registryAccess);
                if (!installableHotFix.getProdMaint().equals(installedMaintLevel) || !this.isHotFixInstalled(installableHotFix, registryAccess)) continue;
                hotFixesInstalledWithConfiguration.add(hotFix);
                continue;
            }
            if (!hotFix.getProdMaint().equals(installedMaintLevel) || !this.isHotFixInstalled(hotFix, registryAccess)) continue;
            hotFixesInstalledWithConfiguration.add(hotFix);
        }
        return hotFixesInstalledWithConfiguration;
    }

    private HotFix getHotFixByHotFixName(List<HotFix> hotFixes, String hotFixName) {
        for (HotFix hotFix : hotFixes) {
            if (!hotFixName.equalsIgnoreCase(hotFix.getHotFixName())) continue;
            return hotFix;
        }
        return null;
    }

    private void determineLatestHotFixIds(RegistryAccess registryAccess) {
        if (!this.hasDeterminedLatestHotFixIds) {
            HotFix existingHotFix;
            String productCode;
            if (Globals.g_mode == 2) {
                if (registryAccess == null) {
                    registryAccess = this.getDeploymentRegistryAccess();
                }
                if (registryAccess != null) {
                    for (HotFix hotFix : this.getInstalledConfigurableHotFixes(registryAccess)) {
                        productCode = hotFix.getProdCode();
                        if (this.hotFixesByProductCode.containsKey(productCode)) {
                            existingHotFix = this.hotFixesByProductCode.get(productCode);
                            this.hotFixesByProductCode.put(productCode, this.compareLatestHotFixIds(hotFix, existingHotFix));
                            continue;
                        }
                        this.hotFixesByProductCode.put(productCode, hotFix);
                    }
                    registryAccess.close();
                }
            }
            for (HotFix hotFix : this.getConfigurableHotFixesToInstall()) {
                productCode = hotFix.getProdCode();
                if (this.hotFixesByProductCode.containsKey(productCode)) {
                    existingHotFix = this.hotFixesByProductCode.get(productCode);
                    this.hotFixesByProductCode.put(productCode, this.compareLatestHotFixIds(hotFix, existingHotFix));
                    continue;
                }
                this.hotFixesByProductCode.put(productCode, hotFix);
            }
            this.hasDeterminedLatestHotFixIds = true;
        }
    }

    private HotFix compareLatestHotFixIds(HotFix hotFix1, HotFix hotFix2) {
        String hotFixId2;
        String hotFixId1 = hotFix1.getHotFixName();
        int result = hotFixId1.compareToIgnoreCase(hotFixId2 = hotFix2.getHotFixName());
        if (result < 0) {
            return hotFix2;
        }
        return hotFix1;
    }

    private void determineInstalledHotFixes() {
        String[] contents;
        if (installedHotFixData != null) {
            return;
        }
        HotFixContainers hotFixContainers = new HotFixContainers(Utils.joinPath(Utils.getSDMHome(Globals.g_cmtSASHome), "hot_fix", "hot_fix_data"));
        installedHotFixData = new ArrayList<HotFix>();
        ArrayList<String> hotFixSkuDataDirs = new ArrayList<String>();
        File hotFixProductDataDir = new File(Utils.getSDMHome(Globals.g_cmtSASHome), Utils.joinPath("hot_fix", "product_data"));
        if (hotFixProductDataDir.isDirectory() && (contents = hotFixProductDataDir.list()) != null) {
            for (String file : contents) {
                Utils.joinPath(hotFixProductDataDir.getAbsolutePath(), file);
                File skuDir = new File(hotFixProductDataDir.getAbsolutePath(), file);
                if (!skuDir.isDirectory()) continue;
                hotFixSkuDataDirs.add(skuDir.getAbsolutePath());
            }
        }
        for (String hotFixDataSkuDir : hotFixSkuDataDirs) {
            File productXmlFile = new File(hotFixDataSkuDir, "product.xml");
            File deploymentXmlFile = new File(hotFixDataSkuDir, "deployment.xml");
            if (!productXmlFile.exists()) {
                Logging.log.severe("Product.xml file is missing and therefore skipping: " + hotFixDataSkuDir);
                continue;
            }
            SpsSkuData spsSkuData = null;
            try {
                spsSkuData = new SpsSkuData(productXmlFile);
            }
            catch (IOException e) {
                Logging.log.severe("An error occurred while reading " + productXmlFile.getAbsolutePath() + ", hot fix will be skipped");
                Logging.logStackTrace(e);
                continue;
            }
            catch (ParserConfigurationException e) {
                Logging.log.severe("An error occurred while parsing " + productXmlFile.getAbsolutePath() + ", hot fix will be skipped");
                Logging.logStackTrace(e);
                continue;
            }
            catch (SAXException e) {
                Logging.log.severe("An error occurred while parsing " + productXmlFile.getAbsolutePath() + ", hot fix will be skipped");
                Logging.logStackTrace(e);
                continue;
            }
            DeploymentXMLReader deploymentXmlData = null;
            if (deploymentXmlFile.exists()) {
                try {
                    deploymentXmlData = new DeploymentXMLReader(deploymentXmlFile);
                }
                catch (JAXBException e) {
                    Logging.log.severe("An error occurred while parsing " + deploymentXmlFile.getAbsolutePath() + ", hot fix will be skipped");
                    Logging.logStackTrace(e);
                    continue;
                }
            }
            String platform = HotFixPackageData.getPlatformToDeploy(spsSkuData.getPlatform());
            HotFixContainer hotFixContainer = null;
            if (hotFixContainers.manifestFileExists()) {
                hotFixContainer = hotFixContainers.getContainerForHotFixSku(spsSkuData.getSpsSku());
            }
            installedHotFixData.add(HotFixPackageData.constructHotFixObject(hotFixContainer, spsSkuData, deploymentXmlData, platform));
        }
    }

    private String getInstalledMaintLevelForTargetedProduct(HotFix hotFix, RegistryAccess registryAccess) {
        String maintLevel = null;
        maintLevel = registryAccess.getMaintLevel(hotFix.getProdCode(), hotFix.getProdVersion(), hotFix.getPlatform());
        return maintLevel;
    }

    private boolean isHotFixInstalled(HotFix hotFix, RegistryAccess registryAccess) {
        String[] maintVersions = registryAccess.getMaintVersions(hotFix.getProdCode(), hotFix.getProdVersion(), hotFix.getPlatform());
        String hotFixName = hotFix.getHotFixName();
        if (maintVersions != null) {
            for (String maintVersion : maintVersions) {
                if (!maintVersion.equalsIgnoreCase(hotFixName)) continue;
                return true;
            }
        }
        return false;
    }

    private RegistryAccess getDeploymentRegistryAccess() {
        RegistryAccess registryAccess = null;
        try {
            RegistryData.setRegistry(Globals.g_wizardData.getPreference("SASHome", ""));
            registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
            if (!registryAccess.open()) {
                Logging.log.warning("Unable to open deployment registry for hot fix processing: " + RegistryData.getDeployRegJar());
                return null;
            }
        }
        catch (FileNotFoundException e) {
            Logging.log.severe("Unable to open deployment registry for hot fix processing: file not found: " + RegistryData.getDeployRegJar());
            Logging.logStackTrace(e);
            return null;
        }
        catch (Exception e) {
            Logging.log.severe("Unable to open deployment registry for hot fix processing: general error: " + RegistryData.getDeployRegJar());
            Logging.logStackTrace(e);
            return null;
        }
        return registryAccess;
    }

    private class HotFixContainers {
        private List<File> manifestFiles = new ArrayList<File>();
        private List<HotFixContainer> hotFixContainers = new ArrayList<HotFixContainer>();

        HotFixContainers(String hotFixDataDir) {
            this.manifestFiles = this.getListOfFiles(hotFixDataDir, "manifest.xml");
            for (File manifestFile : this.manifestFiles) {
                try {
                    HotFixContainer hotFixContainer = new HotFixContainer(manifestFile);
                    this.hotFixContainers.add(hotFixContainer);
                }
                catch (HotFixContainerException e) {
                    Logging.log.severe("Can not load manifest " + manifestFile.getAbsolutePath());
                    Logging.logStackTrace(e);
                }
            }
        }

        public boolean manifestFileExists() {
            return this.manifestFiles.size() > 0;
        }

        public HotFixContainer getContainerForHotFixSku(String hotFixSku) {
            for (HotFixContainer hotFixContainer : this.hotFixContainers) {
                if (hotFixContainer.getMemberIdForSku(hotFixSku) == null) continue;
                return hotFixContainer;
            }
            return null;
        }

        private List<File> getListOfFiles(String hotFixDataDir, String fileName) {
            ArrayList<File> listOfFiles = new ArrayList<File>();
            File dir = new File(hotFixDataDir);
            File[] dirs = dir.listFiles();
            if (dirs != null) {
                for (int i = 0; i < dirs.length; ++i) {
                    File fileToCheck;
                    File possibleDir = dirs[i];
                    if (!possibleDir.isDirectory() || !(fileToCheck = new File(possibleDir, fileName)).exists()) continue;
                    listOfFiles.add(fileToCheck);
                }
            }
            return listOfFiles;
        }
    }
}

