/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class HotFix
extends ProductData {
    private String hotFixSkuDataDir;
    private String hotFixSkuPayloadDir;
    private String hotFixLanguage;
    private String hotFixName;
    private String hotFixMinMaintVersion;
    private String hotFixMaxMaintVersion;
    private boolean hotFixMaintVerExclusive = true;
    private String hotFixPackageFilename;
    private File hotFixPackageFile = null;
    private SpsSkuData spsSkuData = null;
    private boolean hotFixAlreadyInstalled = false;
    private boolean successfulInstall = false;
    private String installableStatus = "productNotInstalled";
    private String skuProductDataSubDir;
    private String skuProductSubDir;
    private String containerId;
    private boolean configurable;
    private boolean installable = true;
    private String pairedConfigureHotFixName = null;
    private String pairedInstallHotFixName = null;
    private String manifestXmlZipEntryKey;
    private boolean requireInitRestart = false;
    private boolean forceuip = false;
    private boolean forceoic = false;
    private boolean securityFix = false;
    private int securityFixSequence = 0;
    private boolean iDoc;
    private String displayName;
    private String displayVersion;
    private String releaseDate;
    private String docFilename;
    private String hotFixID;
    public static final String READY_TO_INSTALL = "readyToInstall";
    public static final String PRODUCT_NOT_INSTALLED = "productNotInstalled";
    public static final String NOT_INSTALLABLE_DUE_TO_EXISTING_SASHOME = "notInstallableDueToExistingSASHome";
    public static final String NOT_INSTALLBLE_DUE_TO_REINSTALL_DISABLED = "notInstallableDueToReinstallDisabled";
    private SSNResource bundle = new SSNResource(ProductData.class);
    List<File> filesToExtract = new ArrayList<File>();

    public HotFix(String code, String spsSku, String platform, String version, String custVer, String maint, String lastPortDate, String sasRelease, String displayName, int type, int status, int selectable, boolean configEnabled, String interactiveRef, String silentRef, String indexRef, String interactiveArgs, String silentArgs, boolean foundation, boolean useSasinstall, boolean useSrw, boolean useJre, boolean prompt, String mediaCode, String mediaName, long sequenceNum) {
        super(code, spsSku, platform, version, custVer, maint, lastPortDate, sasRelease, displayName, type, status, selectable, configEnabled, interactiveRef, silentRef, indexRef, interactiveArgs, silentArgs, foundation, useSasinstall, useSrw, useJre, prompt, mediaCode, mediaName, sequenceNum);
        this.setSkuProductDirs();
    }

    public void setSkuProductDirs() {
        this.skuProductDataSubDir = Utils.joinPath("product_data", super.getSpsSku());
        this.skuProductSubDir = Utils.joinPath("products", super.getSpsSku());
    }

    @Override
    public String getProdNameExtended() {
        StringBuffer displayNameExtended = new StringBuffer(super.getProdName());
        displayNameExtended.append(" (").append(this.getHotFixDisplayVersionTag()).append(")");
        return displayNameExtended.toString();
    }

    public String getHotFixDisplayVersionTag() {
        String language = "";
        StringBuffer bitTag = new StringBuffer();
        String platform = this.getSpsSkuData().getPlatform();
        if (!"prt".equals(platform) && (Utils.getOS_Suffix().equals("wx6") || Utils.getOS_Suffix().equals("lax"))) {
            if (platform != null && (platform.equals("wx6") || platform.equals("lax"))) {
                bitTag.append(this.bundle.getString("PanelExecute.64BitTag.txt"));
            } else if (platform != null && (platform.equals("win") || platform.equals("lnx"))) {
                bitTag.append(this.bundle.getString("PanelExecute.32BitTag.txt"));
            }
        }
        StringBuffer langStringTag = new StringBuffer();
        language = this.getSpsSkuData().getLanguage();
        if (language == null || language.length() <= 0 || !"xx".equalsIgnoreCase(language)) {
            if (language != null && language.length() > 0 && "ne".equalsIgnoreCase(language)) {
                langStringTag.append(this.bundle.getString("PanelExecute.MVSNonEncodedTag.txt"));
            } else if (language != null && language.length() > 0 && ("c0".equalsIgnoreCase(language) || "f0".equalsIgnoreCase(language) || "r0".equalsIgnoreCase(language) || "w0".equalsIgnoreCase(language) || "w2".equalsIgnoreCase(language) || "w3".equalsIgnoreCase(language) || "w5".equalsIgnoreCase(language) || "w6".equalsIgnoreCase(language) || "w7".equalsIgnoreCase(language) || "w8".equalsIgnoreCase(language) || "w9".equalsIgnoreCase(language) || "wa".equalsIgnoreCase(language) || "wb".equalsIgnoreCase(language) || "wu".equalsIgnoreCase(language))) {
                langStringTag.append(this.bundle.getString("PanelExecute.MVSEncodedTag.txt"));
            } else {
                langStringTag.append(this.bundle.getString("Common.LangCode" + language.toUpperCase() + ".txt"));
            }
        }
        if (bitTag.length() > 0 && langStringTag.length() > 0) {
            return this.bundle.messageString("PanelExecute.HotFixBitAndLangTag.txt", this.hotFixName, bitTag, langStringTag);
        }
        if (bitTag.length() == 0 && langStringTag.length() == 0) {
            return this.bundle.messageString("PanelExecute.HotFixTag.txt", this.hotFixName);
        }
        return this.bundle.messageString("PanelExecute.HotFixBitOrLangTag.txt", this.hotFixName, bitTag.length() > 0 ? bitTag : langStringTag);
    }

    public boolean extractHotFix(String extractLocation) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.hotFixPackageFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            Logging.log.severe("Error loading hot fix package file: " + this.hotFixPackageFile.getAbsolutePath());
            return false;
        }
        this.getFilesToExtract(zipFile, super.getSpsSku());
        if (this.filesToExtract.isEmpty()) {
            Logging.log.severe("There are no hot fix packages to extract from " + this.hotFixPackageFile.getAbsolutePath() + " for " + super.getSpsSku());
            return false;
        }
        if (!Utils.extractFilesFromZip(zipFile, this.filesToExtract, extractLocation)) {
            Logging.log.severe("An error occurred while extracting files from " + zipFile.getName());
        }
        this.hotFixSkuDataDir = Utils.joinPath(extractLocation, this.skuProductDataSubDir);
        this.hotFixSkuPayloadDir = Utils.joinPath(extractLocation, this.skuProductSubDir);
        super.setSilentRef(Utils.joinPath(this.hotFixSkuDataDir, "install.xml"));
        return true;
    }

    public boolean copyProductData(String sdmHome) {
        boolean result = false;
        super.getSpsSku();
        File source = new File(this.hotFixSkuDataDir);
        File target = new File(Utils.joinPath(sdmHome, "hot_fix"), this.skuProductDataSubDir);
        if (!target.exists()) {
            target.mkdirs();
        }
        Logging.log.info("Copy data for hot fix: source: " + source.getAbsolutePath() + "target: " + target.getAbsolutePath());
        if (source.exists() && target.exists()) {
            result = Utils.movefiles(source, target);
        }
        return result;
    }

    private void getFilesToExtract(ZipFile zipFile, String sku) {
        this.filesToExtract.clear();
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            if (zipEntry.isDirectory() || !zipEntry.getName().contains(sku)) continue;
            this.filesToExtract.add(new File(zipEntry.getName()));
        }
    }

    public void setHotFixSkuDataDir(String dataDir) {
        this.hotFixSkuDataDir = dataDir;
    }

    public String getHotFixSkuDataDir() {
        return this.hotFixSkuDataDir;
    }

    public void setHotFixSkuPayloadDir(String payloadDir) {
        this.hotFixSkuPayloadDir = payloadDir;
    }

    public String getHotFixSkuPayloadDir() {
        return this.hotFixSkuPayloadDir;
    }

    public void setHotFixLanguage(String lang) {
        this.hotFixLanguage = lang;
    }

    public String getHotFixLanguage() {
        return this.hotFixLanguage;
    }

    public void setHotFixName(String name) {
        this.hotFixName = name;
    }

    public String getHotFixName() {
        return this.hotFixName;
    }

    public void setHotFixMinMaintVersion(String minVersion) {
        this.hotFixMinMaintVersion = minVersion;
    }

    public String getHotFixMinMaintVersion() {
        return this.hotFixMinMaintVersion;
    }

    public void setHotFixMaxMaintVersion(String maxVersion) {
        this.hotFixMaxMaintVersion = maxVersion;
    }

    public String getHotFixMaxMaintVersion() {
        return this.hotFixMaxMaintVersion;
    }

    public void setHotFixMaintVerExclusive(boolean exclusive) {
        this.hotFixMaintVerExclusive = exclusive;
    }

    public boolean isHotFixMaintVerExclusive() {
        return this.hotFixMaintVerExclusive;
    }

    public void setHotFixPackageFilename(String hfPkgFilename) {
        this.hotFixPackageFilename = hfPkgFilename;
    }

    public String getHotFixPackageFilename() {
        return this.hotFixPackageFilename;
    }

    public void setHotFixPackageFile(File hotFixPackage) {
        this.hotFixPackageFile = hotFixPackage;
    }

    public File getHotFixPackageFile() {
        return this.hotFixPackageFile;
    }

    public SpsSkuData getSpsSkuData() {
        return this.spsSkuData;
    }

    public void setSpsSkuData(SpsSkuData spsSkuData) {
        this.spsSkuData = spsSkuData;
    }

    public boolean isHotFixAlreadyInstalled() {
        return this.hotFixAlreadyInstalled;
    }

    public void setHotFixAlreadyInstalled(boolean hotFixAlreadyInstalled) {
        this.hotFixAlreadyInstalled = hotFixAlreadyInstalled;
    }

    public boolean isSuccessfulInstall() {
        return this.successfulInstall;
    }

    public void setSuccessfulInstall(boolean successfulInstall) {
        this.successfulInstall = successfulInstall;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setConfigurable(boolean configurable) {
        this.configurable = configurable;
    }

    public boolean isConfigurable() {
        return this.configurable;
    }

    public void setPairedConfigureHotFixName(String pairedConfigureHotFixName) {
        this.pairedConfigureHotFixName = pairedConfigureHotFixName;
    }

    public String getPairedConfigureHotFixName() {
        return this.pairedConfigureHotFixName;
    }

    public void setPairedInstallHotFixName(String pairedInstallHotFixName) {
        this.pairedInstallHotFixName = pairedInstallHotFixName;
    }

    public String getPairedInstallHotFixName() {
        return this.pairedInstallHotFixName;
    }

    public String getSkuProductDataSubDir() {
        return this.skuProductDataSubDir;
    }

    public void setManifestXmlZipEntryKey(String manifestXmlZipEntryKey) {
        this.manifestXmlZipEntryKey = manifestXmlZipEntryKey;
    }

    public String getManifestXmlZipEntryKey() {
        return this.manifestXmlZipEntryKey;
    }

    public void setInstallable(boolean installable) {
        this.installable = installable;
    }

    public boolean isInstallable() {
        return this.installable;
    }

    public boolean isConfigurationDataOnly() {
        return !this.installable;
    }

    public void setForceDuringUpdate(boolean force) {
        this.forceuip = force;
    }

    public boolean forceDuringUpdate() {
        return this.forceuip;
    }

    public void setForceOnlyInChain(boolean force) {
        this.forceoic = force;
    }

    public boolean forceOnlyInChain() {
        return this.forceoic;
    }

    public void setSecurityFix(boolean security) {
        this.securityFix = security;
    }

    public boolean isSecurityFix() {
        return this.securityFix;
    }

    public void setSecurityFixSequence(int sequence) {
        this.securityFixSequence = sequence;
    }

    public int getSecurityFixSequence() {
        return this.securityFixSequence;
    }

    public void initRestartRequired(boolean requireInitRestart) {
        this.requireInitRestart = requireInitRestart;
    }

    public boolean requireInitRestart() {
        return this.requireInitRestart;
    }

    public boolean isiDoc() {
        return this.iDoc;
    }

    public void setiDoc(boolean iDoc) {
        this.iDoc = iDoc;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNamePlusPlatform() {
        String dispName = this.getDisplayName();
        String platform = this.getPlatform().toUpperCase(Locale.ENGLISH);
        String platStringKey = String.format("Common.Platform%s.txt", platform);
        String dispPlat = this.bundle.getRawString(platStringKey);
        if (dispPlat == null) {
            return dispName;
        }
        return String.format("%s for %s", dispName, dispPlat);
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayVersion() {
        return this.displayVersion;
    }

    public void setDisplayVersion(String displayVersion) {
        this.displayVersion = displayVersion;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    public String getDocFilename() {
        return this.docFilename;
    }

    public void setDocFilename(String docFilename) {
        this.docFilename = docFilename;
    }

    public String getHotFixID() {
        return this.hotFixID;
    }

    public void setHotFixID(String hotFixID) {
        this.hotFixID = hotFixID;
    }

    public String getInstallableStatus() {
        return this.installableStatus;
    }

    public void setInstallableStatus(String installableStatus) {
        this.installableStatus = installableStatus;
    }

    public boolean isInSecurityUpdateDir() {
        String packageFile = this.getHotFixPackageFile().getAbsolutePath().toLowerCase(Locale.ENGLISH);
        return packageFile.contains("securityupdates");
    }
}

