/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.CustMsgBox;
import com.sas.ssn.EsdPart;
import com.sas.ssn.Globals;
import com.sas.ssn.Kerberos;
import com.sas.ssn.Logging;
import com.sas.ssn.PanelProgress;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.security.DigestInputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.HeaderGroup;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class EsdInternet {
    private DefaultHttpClient client = new DefaultHttpClient();
    private int status = 0;
    private String statusString = null;
    private String checksum = null;
    private boolean interrupted = false;
    private HeaderGroup headers = null;
    private String errorMessage = "";
    private boolean doEncryption = false;
    private String key = "";
    private boolean m_removeZeros = false;
    private int m_removeZerosCount = 0;
    private long sizeOfFileExpected = 0L;
    private CookieStore cookieStore = null;
    private HttpContext localContext = null;
    protected static SSNResource bundle = new SSNResource(EsdInternet.class);

    public EsdInternet() {
        this.client.getParams().setParameter("http.protocol.cookie-policy", "netscape");
        this.headers = new HeaderGroup();
        this.cookieStore = new BasicCookieStore();
        this.localContext = new BasicHttpContext();
        this.localContext.setAttribute("http.cookie-store", this.cookieStore);
    }

    public void downloadFile(String url, String filename, boolean countBytes, EsdPart part) throws IOException {
        if (Globals.g_cipher != null && (filename.endsWith(".ezip") || part.getType().indexOf(69) >= 0)) {
            this.doEncryption = true;
            this.key = part.getChecksum();
            this.sizeOfFileExpected = part.getSizeCompressed();
        }
        this.downloadFile(url, filename, countBytes);
    }

    public void downloadFile(String url, String filename, boolean countBytes, EsdPart part, int removeZeros) throws IOException, HttpException {
        if (removeZeros > 0) {
            this.m_removeZeros = true;
            this.m_removeZerosCount = removeZeros;
        }
        this.downloadFile(url, filename, countBytes, part);
    }

    public boolean downloadFileRetries(String url, String toFilename, boolean countBytes) throws IOException {
        return this.downloadFileRetries(url, toFilename, countBytes, null);
    }

    public boolean downloadFileRetries(String url, String toFilename, boolean countBytes, EsdPart part) throws IOException {
        boolean keepTrying = true;
        boolean success = false;
        int retries = 3;
        while (keepTrying && retries > 0) {
            try {
                if (part == null) {
                    this.downloadFile(url, toFilename, countBytes);
                } else {
                    this.downloadFile(url, toFilename, countBytes, part);
                }
                if (this.checkStatus(this.getStatus())) {
                    success = true;
                    keepTrying = false;
                    continue;
                }
                if (toFilename != null && !new File(toFilename).delete()) {
                    Logging.log.severe("Error removing partial/damaged file: " + toFilename);
                }
                --retries;
                keepTrying = true;
                Logging.log.warning("Problem downloading file " + url + ", status = " + this.getStatus());
            }
            catch (SocketTimeoutException e) {
                if ((Globals.g_useTimeouts *= 2) > 256) {
                    Globals.g_useTimeouts = 256;
                    --retries;
                }
                Logging.log.warning("For " + url + ", Socket Timeout Exception with 0 bytes transfered: Virus scanning proxy suspected--increasing timeout to:" + Globals.g_useTimeouts);
                keepTrying = true;
            }
        }
        return success;
    }

    private boolean checkStatus(int status) {
        return status == 200 || status == 206 || status == 304 || status == 204 || status == 402 || status == 401 || status == 409 || status == 415 || status == 410 || status == 500 || status == 403;
    }

    public void downloadFile(String url, String filename, boolean countBytes) throws IOException {
        boolean downloadingFile;
        MessageDigest digester;
        OutputStream dos;
        ByteArrayOutputStream fos;
        RandomAccessFile raf;
        InputStream dis;
        InputStream fis;
        HttpResponse httpResponse;
        HttpGet method;
        boolean needRange;
        block66: {
            File fin;
            needRange = false;
            long range = 0L;
            int statusCode = 0;
            this.statusString = null;
            this.checksum = null;
            this.interrupted = false;
            if (filename != null && (fin = new File(filename)).exists() && fin.isFile()) {
                range = fin.length();
                if (range < 1000000L || this.m_removeZeros) {
                    fin.delete();
                } else {
                    needRange = true;
                    range = (range % 8L == 0L ? range - 8L : range - range % 8L) - 8L;
                }
            }
            method = new HttpGet(url);
            if (Globals.g_proxyBypass && !Globals.g_useProxyAnyway && "true".equals(System.getProperty("http.proxySet"))) {
                System.setProperty("http.proxySet", "false");
            } else if (!Globals.g_proxyBypass && !Globals.g_forceProxy && !Globals.g_useProxyAnyway && "true".equals(System.getProperty("http.proxySet")) && Globals.g_order.startsWith("0")) {
                Logging.log.finer("Shutting off use of proxy since order number has leading zero");
                System.setProperty("http.proxySet", "false");
                Globals.g_proxyBypass = true;
            }
            this.setProxy();
            int timeout = Globals.g_useTimeouts * 45000;
            HttpParams params = this.client.getParams();
            HttpConnectionParams.setConnectionTimeout(params, timeout);
            HttpConnectionParams.setSoTimeout(params, timeout);
            if (needRange) {
                method.setHeader("Range", "bytes=" + range + "-");
                Logging.log.info("Continuing download of file  " + url + " at byte offset " + range);
            }
            method.setHeader("Pragma", "no-cache");
            method.setHeader("Cache-Control", "no-store");
            method.setHeader("Expires", "-1");
            Header[] hdrs = this.headers.getAllHeaders();
            for (int i = 0; i < hdrs.length; ++i) {
                method.setHeader(hdrs[i]);
            }
            httpResponse = null;
            try {
                if (Globals.g_kerberosproxy) {
                    Kerberos krb = new Kerberos();
                    httpResponse = krb.invokeKerberos(url, System.getProperty("http.proxyUser"), System.getProperty("http.proxyPassword"), System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort", "3128")));
                } else {
                    httpResponse = this.client.execute((HttpUriRequest)method, this.localContext);
                }
                statusCode = httpResponse.getStatusLine() == null ? 2 : httpResponse.getStatusLine().getStatusCode();
            }
            catch (SocketTimeoutException e) {
                if ((Globals.g_useTimeouts *= 2) > 256) {
                    Globals.g_useTimeouts = 256;
                }
                Logging.log.warning("Socket Timeout Exception with 0 bytes transfered: Virus scanning proxy suspected--increasing timeout to:" + Globals.g_useTimeouts);
                throw e;
            }
            catch (IOException e) {
                Logging.log.warning("Caught Exception:" + e.getLocalizedMessage());
                if (Globals.g_proxyBypass && !Globals.g_useProxyAnyway) {
                    Globals.g_useProxyAnyway = true;
                    Logging.log.finer("Overriding proxy bypass since there was an error accessing a server");
                    System.setProperty("http.proxySet", "true");
                    this.setProxy();
                    httpResponse = this.client.execute((HttpUriRequest)method, this.localContext);
                    statusCode = httpResponse.getStatusLine() == null ? 2 : httpResponse.getStatusLine().getStatusCode();
                }
                throw e;
            }
            if (needRange) {
                Header contentRange = httpResponse.getFirstHeader("Content-Range");
                Header contentLength = httpResponse.getFirstHeader("Content-Length");
                Header acceptHeader = httpResponse.getFirstHeader("Accept-Ranges");
                if (statusCode == 206) {
                    Logging.log.finer("Server returned 206:Partical Content");
                } else if (contentRange != null) {
                    Logging.log.finer("Server supports Content-Range: " + contentRange.getValue());
                } else if (contentLength != null && Long.parseLong(contentLength.getValue()) <= this.sizeOfFileExpected - range) {
                    Logging.log.finer("Content length seems to represent remaining bytes: " + contentLength.getValue());
                } else if (!(acceptHeader == null || "bytes".equals(acceptHeader.getValue()) || contentLength != null && Long.parseLong(contentLength.getValue()) != this.sizeOfFileExpected)) {
                    Logging.log.warning("Proxy does not support byte ranges! Instead it supports " + acceptHeader.getValue());
                    Utils.loggingToFiner();
                    needRange = false;
                    new File(filename).delete();
                    Logging.log.warning("Deleting file and starting download from scratch for " + filename);
                }
            }
            this.status = statusCode;
            fis = httpResponse.getEntity().getContent();
            dis = null;
            raf = null;
            fos = null;
            dos = null;
            digester = null;
            downloadingFile = false;
            byte[] ivBuf = new byte[8];
            if (filename != null && (statusCode == 200 || statusCode == 206)) {
                downloadingFile = true;
                raf = new RandomAccessFile(filename, "rw");
                if (needRange) {
                    raf.seek(range + 8L);
                    DataInputStream isr = new DataInputStream(fis);
                    isr.readFully(ivBuf);
                } else if (this.m_removeZeros) {
                    long bytesSkipped = fis.skip(this.m_removeZerosCount);
                    if (bytesSkipped != (long)this.m_removeZerosCount) {
                        Logging.log.severe("Could not skip " + this.m_removeZerosCount + " bytes from network byte stream. Skipped" + bytesSkipped + "instead.");
                    } else {
                        Logging.log.info("Skipped " + bytesSkipped + " bytes from network byte stream.");
                    }
                }
                try {
                    digester = MessageDigest.getInstance("MD5");
                    if (this.doEncryption) {
                        Constructor<?> c;
                        MessageDigest md = MessageDigest.getInstance("MD5");
                        byte[] kbytes = md.digest(this.key.getBytes("UTF-8"));
                        Class<?> sksC = Class.forName("javax.crypto.spec.SecretKeySpec");
                        Constructor<?> c1 = sksC.getConstructor(Array.newInstance(Byte.TYPE, kbytes.length).getClass(), String.class);
                        Object sksI = c1.newInstance(kbytes, "Blowfish");
                        Class<?> ipsC = Class.forName("javax.crypto.spec.IvParameterSpec");
                        Object ipsI = null;
                        if (needRange) {
                            c = ipsC.getConstructor(Array.newInstance(Byte.TYPE, ivBuf.length).getClass());
                            ipsI = c.newInstance(new Object[]{ivBuf});
                        } else {
                            c = ipsC.getConstructor(Array.newInstance(Byte.TYPE, "SASRulez".getBytes("UTF-8").length).getClass());
                            ipsI = c.newInstance(new Object[]{"SASRulez".getBytes("UTF-8")});
                        }
                        Globals.g_cipher.init(2, (Key)((SecretKeySpec)sksI), (AlgorithmParameterSpec)ipsI);
                        Class<?> cisC = Class.forName("javax.crypto.CipherInputStream");
                        Constructor<?> c2 = cisC.getConstructor(InputStream.class, Cipher.class);
                        Object cisI = c2.newInstance(fis, Globals.g_cipher);
                        dis = new DigestInputStream((InputStream)cisI, digester);
                        break block66;
                    }
                    dis = new DigestInputStream(fis, digester);
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                    if (!Globals.g_quietMode) {
                        CustMsgBox.showMessageDialog(null, bundle.messageString("Common.ESD.UnexpectedError.txt"), bundle.getString("Common.Error.txt"), 0);
                    }
                    Globals.g_kit.exitKit(-1);
                }
            } else if (fis != null) {
                this.doEncryption = false;
                countBytes = false;
                downloadingFile = false;
                fos = new ByteArrayOutputStream();
                dis = fis;
            }
        }
        if (fis != null) {
            long totalCount = 0L;
            byte[] buffer = new byte[262144];
            if (countBytes) {
                while (Globals.g_wizard == null) {
                    try {
                        Logging.log.finer("Waiting for main thread to set Globals.g_wizard");
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Logging.log.finer("Sleep failed while waiting for main thread to set Globals.g_wizard");
                        Logging.logStackTrace(e);
                    }
                }
                ((PanelProgress)Globals.g_wizard.getPanel("progress")).resumeProgressBar();
            }
            try {
                int length = 0;
                while ((length = dis.read(buffer)) != -1) {
                    if (fos != null) {
                        ((OutputStream)fos).write(buffer, 0, length);
                    } else {
                        raf.write(buffer, 0, length);
                    }
                    if (countBytes) {
                        Globals.g_esdStats.addToTask("DOWNLOAD", length);
                        totalCount += (long)length;
                    }
                    if (!Thread.interrupted()) continue;
                    Logging.log.info("Downloading interrupted");
                    this.interrupted = true;
                }
            }
            catch (SocketTimeoutException e) {
                if (totalCount == 0L) {
                    if ((Globals.g_useTimeouts *= 2) > 256) {
                        Globals.g_useTimeouts = 256;
                    }
                    Logging.log.warning("Socket Timeout Exception with 0 bytes transfered: Virus scanning proxy suspected--increasing timeout to:" + Globals.g_useTimeouts);
                }
                throw e;
            }
            catch (IOException e) {
                if (e.getMessage().contains("Read timed out") && totalCount == 0L) {
                    if ((Globals.g_useTimeouts *= 2) > 256) {
                        Globals.g_useTimeouts = 256;
                    }
                    Logging.log.warning("IO Timeout Exception with 0 bytes transfered: Virus scanning proxy suspected--increasing timeout to:" + Globals.g_useTimeouts);
                }
                throw e;
            }
            finally {
                EntityUtils.consume(httpResponse.getEntity());
                fis.close();
                if (fos != null) {
                    ((OutputStream)fos).close();
                }
                if (dos != null) {
                    dos.close();
                }
                if (raf != null) {
                    raf.close();
                }
            }
            if (countBytes) {
                while (Globals.g_wizard == null) {
                    try {
                        Logging.log.finer("Waiting for main thread to set Globals.g_wizard");
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Logging.log.finer("Sleep failed while waiting for main thread to set Globals.g_wizard");
                        Logging.logStackTrace(e);
                    }
                }
                ((PanelProgress)Globals.g_wizard.getPanel("progress")).pauseProgressBar();
            }
            this.statusString = httpResponse.getStatusLine().getReasonPhrase();
            if (this.status != 404 && this.status != 400) {
                this.headers.setHeaders(httpResponse.getAllHeaders());
            }
            if (downloadingFile) {
                this.checksum = !needRange && digester != null ? EsdInternet.md5sumToString(digester) : EsdInternet.getMd5sum(filename);
            } else {
                this.errorMessage = ((Object)fos).toString();
            }
            Globals.g_bytesMoved = totalCount;
        }
        method.releaseConnection();
    }

    private void setProxy() throws IOException {
        if ("true".equals(System.getProperty("http.proxySet"))) {
            String pHost = System.getProperty("http.proxyHost");
            String pPort = System.getProperty("http.proxyPort", "80");
            String pUserName = System.getProperty("http.proxyUser");
            String pPassword = System.getProperty("http.proxyPassword");
            CredentialsProvider creds = this.client.getCredentialsProvider();
            HttpHost proxy = new HttpHost(pHost, Integer.parseInt(pPort), "http");
            this.client.getParams().setParameter("http.route.default-proxy", proxy);
            if (pUserName != null && !"".equals(pUserName) && pPassword != null) {
                String domain = "";
                String username = pUserName;
                int domainIndex = pUserName.indexOf(92);
                if (domainIndex > 0 && pUserName.length() > domainIndex + 1) {
                    domain = pUserName.substring(0, domainIndex);
                    username = pUserName.substring(domainIndex + 1);
                }
                this.client.getCredentialsProvider().setCredentials(AuthScope.ANY, new NTCredentials(username, pPassword, InetAddress.getLocalHost().getHostName(), domain));
            }
        }
    }

    public static String getMd5sum(String filename) {
        Logging.log.info("Starting MD5 scan on file: " + filename);
        MessageDigest digester = null;
        FileInputStream fis = null;
        FilterInputStream dis = null;
        try {
            fis = new FileInputStream(filename);
            digester = MessageDigest.getInstance("MD5");
            dis = new DigestInputStream(fis, digester);
            byte[] bytes = new byte[8192];
            int count = dis.read(bytes);
            while (count != -1 && count <= 8192) {
                count = dis.read(bytes);
            }
            fis.close();
            dis.close();
        }
        catch (Exception e) {
            try {
                fis.close();
                dis.close();
                Logging.log.finer("Closed files for md5 scanner in exception handler");
            }
            catch (Exception e2) {
                Logging.log.warning("Could not close files for md5 scanner in exception handler:" + e.getLocalizedMessage());
            }
            Logging.logStackTrace(e);
            return null;
        }
        return EsdInternet.md5sumToString(digester);
    }

    public static String md5sumToString(MessageDigest digester) {
        byte[] chk = digester.digest();
        String hexvalue = "";
        for (int i = 0; i < chk.length; ++i) {
            int bytevalue = chk[i] >= 0 ? chk[i] : 256 + chk[i];
            String hexvaluestring = Integer.toHexString(bytevalue);
            if (hexvaluestring.length() == 1) {
                hexvaluestring = "0" + hexvaluestring;
            }
            hexvalue = hexvalue + hexvaluestring;
        }
        return hexvalue;
    }

    public String getChecksum() {
        return this.checksum == null ? "null" : this.checksum;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusString() {
        return this.statusString;
    }

    public void setCookies(List<Cookie> cookies) {
        for (Cookie cookie : cookies) {
            this.cookieStore.addCookie(cookie);
        }
    }

    public List<Cookie> getCookies() {
        return this.cookieStore.getCookies();
    }

    public void setHeader(String header, String value) {
        this.headers.addHeader(new BasicHeader(header, value));
    }

    public String getHeader(String header) {
        Header h = this.headers.getLastHeader(header);
        if (h != null) {
            return h.getValue();
        }
        Logging.log.finer("Server did not return header:" + header);
        return "";
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

