/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DeploymentData;
import com.sas.ssn.DepotManager;
import com.sas.ssn.DlgRetryESD;
import com.sas.ssn.DlgRetryESDConsole;
import com.sas.ssn.DownloadLogger;
import com.sas.ssn.EsdControl;
import com.sas.ssn.EsdInternet;
import com.sas.ssn.EsdPart;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.RetryIface;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SubsetData;
import com.sas.ssn.Unzip;
import com.sas.ssn.Utils;
import com.sas.ssn.VolserData;
import com.sas.tools.installs.it.vjr.VJRManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.zip.ZipException;
import javax.swing.Timer;
import org.apache.logging.log4j.Level;

public class EsdDownloadController
extends Thread {
    private SSNResource bundle = new SSNResource(EsdDownloadController.class);
    public static final int MAX_RETRIES = 4;
    public static final String ALT_SERVER_HTTP = "http://hq.esd.sasinstitute.net";
    public static final String ALT_SERVER_HTTPS = "https://tlshq.esd.sasinstitute.net";
    private volatile LinkedList partDownloadList = new LinkedList();
    private volatile LinkedList partExpandList = new LinkedList();
    private volatile LinkedList partDoneList = new LinkedList();
    private volatile boolean allDone = false;
    private volatile boolean canceled = false;
    private Object obj = new Object();
    private Object retryObj = new Object();
    private volatile boolean retryActive = false;
    private double downloadSize = 0.0;
    Thread downLoaderThread = null;
    Thread expanderThread = null;
    Thread controllerThread = null;
    private Timer timer = null;
    private LinkedList previousChecksums = new LinkedList();
    private boolean ChecksumsMatch = false;
    private long previousCurrentFileSize = 0L;

    public EsdDownloadController() {
        if (Globals.g_resumeESD) {
            this.loadPartDownloadList();
            this.loadPartExpandList();
            this.loadPartDoneList();
            EsdControl savedEsdControl = null;
            savedEsdControl = this.loadEsdControl();
            Globals.g_control.resolve(savedEsdControl, this.partDownloadList, this.partExpandList, this.partDoneList);
            Globals.g_orderDesc = savedEsdControl.getOrderDesc();
            Globals.g_control.setOrderDesc(Globals.g_orderDesc);
            Globals.g_control.setControlFileIncrement(savedEsdControl.getControlFileIncrement());
            Globals.g_control.setFirstNonce(savedEsdControl.getFirstNonce());
            Globals.g_control.setLastNonce(savedEsdControl.getLastNonce());
            Globals.g_depotCompressionAfterDownload = savedEsdControl.getDepotCompression();
        } else {
            this.loadListsFromControl(Globals.g_control.getDownloadControlList());
            this.sortList();
        }
        this.savePartDownloadList();
        this.savePartExpandList();
        this.savePartDoneList();
        this.saveEsdControl(Globals.g_control);
        SubsetData.saveSubsetData(Globals.g_subsetData);
        Globals.g_wizardData.save();
        Globals.g_esdStats.saveStats();
        this.createTemporarySpace();
    }

    private void loadListsFromControl(LinkedList controlList) {
        for (EsdPart part : controlList) {
            if ("".equals(part.getFullPath())) {
                part.setDownloaded(false);
                part.setExpanded(false);
                part.setRetries(0);
                part.setFullPath(Utils.joinPath(Globals.g_downloadDir, part.getAltSku(), part.getLocalFilename()));
                this.partDownloadList.addLast(part);
                continue;
            }
            if (part.isDownloaded()) {
                if (!part.isExpanded()) {
                    this.partExpandList.add(part);
                    continue;
                }
                this.partDoneList.add(part);
                continue;
            }
            part.setExpanded(false);
            this.partDownloadList.addLast(part);
        }
    }

    private void sortList() {
        int i;
        class Compareit
        implements Comparator {
            Compareit() {
            }

            public int compare(Object o1, Object o2) {
                return new Long(((EsdPart)o2).getSizeCompressed()).compareTo(new Long(((EsdPart)o1).getSizeCompressed()));
            }
        }
        Collections.sort(this.partDownloadList, new Compareit());
        int sizeOfPDL = this.partDownloadList.size();
        if (sizeOfPDL >= 5) {
            for (i = 2; i < sizeOfPDL; i += 2) {
                this.partDownloadList.add(0, this.partDownloadList.remove(i));
            }
        }
        i = 1;
        for (EsdPart part : this.partDownloadList) {
            part.setFileNum(i++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName("Controller");
        this.controllerThread = this;
        this.downLoaderThread = new Downloader();
        this.downLoaderThread.setPriority(2);
        this.downLoaderThread.start();
        this.expanderThread = new Expander();
        this.expanderThread.setPriority(2);
        this.expanderThread.start();
        while (!(this.allDone || this.canceled || this.isInterrupted())) {
            int size_partDownloadList = 0;
            LinkedList linkedList = this.partDownloadList;
            synchronized (linkedList) {
                size_partDownloadList = this.partDownloadList.size();
            }
            int size_partExpandList = 0;
            Object object = this.partExpandList;
            synchronized (object) {
                size_partExpandList = this.partExpandList.size();
            }
            if (this.canceled) continue;
            if (size_partDownloadList != 0 || size_partExpandList != 0) {
                object = this.obj;
                synchronized (object) {
                    try {
                        this.obj.wait();
                    }
                    catch (InterruptedException e) {
                        Logging.log.warning("Download Controller Thread Interrupted.");
                        return;
                    }
                }
            }
            Globals.g_esdStats.finishTask("DOWNLOAD");
            Globals.g_esdStats.finishTask("EXTRACT", (long)Globals.g_esdStats.getCurrCount("EXTRACT"));
            this.smackPartDownloadList();
            this.smackPartExpandList();
            this.deleteTemporarySpace();
            Globals.g_control.setDisableCancel(true);
            Globals.g_wizardData.setPreference("ActiveDownloadFolder", "");
            this.downLoaderThread.interrupt();
            this.expanderThread.interrupt();
            if (Globals.g_consoleMode) {
                ConsoleMode.printInfoText(this.bundle.messageString("EsdDownloadStats.StartJob.txt"));
            }
            Globals.g_esdStats.eventMsg("EsdDownloadStats.StartJob.txt");
            boolean success = true;
            Iterator partIter = this.partDoneList.iterator();
            while (success && partIter.hasNext()) {
                EsdPart onePart = (EsdPart)partIter.next();
                File onePartFile = new File(Globals.g_downloadDir, onePart.getAltSku());
                VolserData volserData = Globals.g_deploymentData.getVolser(Globals.g_deploymentData.getOrder(Globals.g_order).getVolsers("esdm")[0]);
                if ("standard".equals(volserData.getFormat(onePart.getAltSku()))) {
                    File prodSource = new File(onePartFile, "products/" + onePart.getAltSku());
                    File dataSource = new File(onePartFile, "product_data/" + onePart.getAltSku());
                    File prodTarget = new File(onePartFile.getParentFile(), volserData.getProductPath(onePart.getAltSku()));
                    File dataTarget = new File(onePartFile.getParentFile(), volserData.getDataPath(onePart.getAltSku()));
                    success &= Utils.movefilesWithRetry(prodSource, prodTarget);
                    success &= Utils.movefilesWithRetry(dataSource, dataTarget);
                    continue;
                }
                success &= Utils.movefilesWithRetry(onePartFile, onePartFile.getParentFile());
            }
            if (success) {
                Globals.g_job.run();
                Globals.g_esdStats.addToTask("JOB", 100000000);
                Globals.g_esdStats.finishTask("JOB");
                if (Globals.g_job.getStatus() == 4) {
                    DownloadLogger dl = new DownloadLogger();
                    dl.finalStatus("success");
                    dl.Send();
                    Globals.g_control.sendSignal("complete");
                    if (Globals.g_depotCompressionAfterDownload && Globals.g_mode != 2) {
                        String vjrLogPath;
                        int ret = 0;
                        Globals.g_depotCompressionStatus = true;
                        String logPrefix = "depotcompression_";
                        Globals.g_depotCompressionLog = vjrLogPath = Utils.joinPath(Utils.getSDWDataPath(false), logPrefix + Logging.getTimeStamp() + ".log");
                        VJRManager.setVJRLogLevel(Globals.g_debug ? Level.DEBUG : Level.INFO, vjrLogPath);
                        Globals.g_esdStats.eventMsg("PanelProgress.DepotOptimizationStarting.txt");
                        String taskTitle = "";
                        VJRManager vjrManager = VJRManager.getInstance();
                        String depotPath = Globals.g_depotManager.getDepotData().getMediaRoot();
                        Logging.log.info("Running Depot Compression on depot: " + depotPath);
                        try {
                            vjrManager.loadDepot(depotPath);
                            taskTitle = this.bundle.getString("VJRManager.DepotCompressionTitle.txt");
                            String startMsg = this.bundle.messageString("Kit.RunningMsg.txt", taskTitle);
                            if (!Utils.canWriteToPath(depotPath)) {
                                Globals.g_esdStats.eventMsg("VJRManager.FilePermissionDenied.txt", depotPath, taskTitle);
                                Logging.log.severe(this.bundle.messageString("VJRManager.FilePermissionDenied.txt", depotPath, taskTitle));
                                ret = -1;
                            } else {
                                if (Globals.g_consoleMode) {
                                    ConsoleMode.busyMsgStart(startMsg);
                                }
                                vjrManager.compressDepot();
                                if (Globals.g_consoleMode) {
                                    ConsoleMode.printInfoText(this.bundle.messageString("VJRManager.TaskCompleted.txt", taskTitle, vjrLogPath));
                                }
                                Logging.log.info(this.bundle.messageString("VJRManager.TaskCompleted.txt", taskTitle, vjrLogPath));
                            }
                        }
                        catch (SecurityException se) {
                            VJRManager.log.error("An error was caught in depot compression!", (Throwable)se);
                            Logging.log.severe("An error was caught in depot compression!" + se);
                            if (Globals.g_consoleMode) {
                                ConsoleMode.errorMsg(this.bundle.messageString("VJRManager.FilePermissionDenied.txt", depotPath, taskTitle));
                            }
                            Logging.log.severe(this.bundle.messageString("VJRManager.FilePermissionDenied.txt", depotPath, taskTitle));
                            Globals.g_esdStats.eventMsg("VJRManager.GeneralError.txt", taskTitle, vjrLogPath);
                            Globals.g_depotCompressionStatus = false;
                            success = false;
                            ret = -1;
                        }
                        catch (Throwable t) {
                            VJRManager.log.error("An error was caught in depot compression!", t);
                            Logging.log.severe("An error was caught in depot compression! " + t);
                            if (Globals.g_consoleMode) {
                                ConsoleMode.errorMsg(this.bundle.messageString("VJRManager.GeneralError.txt", taskTitle, vjrLogPath));
                            }
                            Logging.log.severe(this.bundle.messageString("VJRManager.GeneralError.txt", taskTitle, vjrLogPath));
                            Globals.g_esdStats.eventMsg("VJRManager.GeneralError.txt", taskTitle, vjrLogPath);
                            Globals.g_depotCompressionStatus = false;
                            success = false;
                            ret = -1;
                        }
                        finally {
                            if (Globals.g_consoleMode) {
                                ConsoleMode.busyMsgStop();
                            }
                        }
                        VJRManager.log.info("Exit Code = " + ret);
                        Logging.log.info("Depot Compression exit code = " + ret);
                    }
                    if (success && Globals.g_hotfixData != null) {
                        if (Globals.g_hotfixData.getDoDownload()) {
                            if (Globals.g_consoleMode) {
                                ConsoleMode.printInfoText(this.bundle.messageString("PanelProgress.DownloadHotfixes.txt", Globals.g_hotfixData.getNumHotfixesToDownload()));
                            }
                            Globals.g_esdStats.eventMsg("PanelProgress.DownloadHotfixes.txt", Globals.g_hotfixData.getNumHotfixesToDownload());
                            Globals.g_esdStats.setCurrCountFromLong("DOWNLOAD", 1L);
                            Globals.g_esdStats.resetTask("DOWNLOAD", 1L, Globals.g_hotfixData.getTotalSizeOfHotfixes());
                            Globals.g_esdStats.resetTask("EXTRACT", 0L, 0L);
                            Globals.g_esdStats.resetProgressBar();
                            Globals.g_hotfixData.downloadHotfixes();
                        } else {
                            Globals.g_esdStats.eventMsg("PanelProgress.NoHotFixesToDownload.txt");
                        }
                        if (!Globals.g_quietMode && Globals.g_wizard != null) {
                            Globals.g_wizard.getNextButton().setEnabled(false);
                        }
                        Globals.g_hotfixData.processHotfixes();
                        Globals.g_hotfixData.deleteHotfixStagingDir();
                        if (!Globals.g_quietMode && Globals.g_wizard != null) {
                            Globals.g_wizard.getNextButton().setEnabled(true);
                        }
                    }
                } else {
                    success = false;
                    Logging.log.warning("Depot Job returned status " + Globals.g_job.getStatus());
                }
            } else {
                success = false;
                Logging.log.warning("Post-download file promotion failed");
            }
            if (success) {
                Globals.g_esdStats.eventMsg("EsdDownloadStats.AllDone.txt");
                Logging.log.info("Done.");
            } else {
                Globals.g_esdStats.eventMsg("EsdDownloadStats.Failed.txt");
                Logging.log.severe("Failed.");
            }
            this.allDone = true;
            Globals.g_depotManager.setLock(false);
        }
    }

    private boolean checkControlFile(boolean reloadCookies) throws IOException {
        boolean onHold = true;
        boolean isValid = false;
        EsdControl newControlFile = null;
        if (!reloadCookies) {
            return true;
        }
        while (!isValid && onHold) {
            newControlFile = new EsdControl(Globals.g_control, reloadCookies);
            isValid = newControlFile.isValid();
            newControlFile.checkCancelAndDie();
            onHold = newControlFile.checkHoldRetryAndContinue();
            if (isValid || onHold) continue;
            newControlFile.checkRetry();
        }
        if (!newControlFile.isNotModified() && newControlFile.isValid()) {
            Globals.g_deploymentData = new DeploymentData(new File(Globals.g_ssdDestDir, "download"));
            Globals.g_deploymentData.loadOrders();
            Logging.log.finer("Order count from new Control file1: " + Globals.g_deploymentData.getOrderCount());
            if (Globals.g_deploymentData.getOrderCount() < 1) {
                Logging.log.severe("Bad order information--expected getOrderCount to return >0 entries.");
                DownloadLogger dl = new DownloadLogger();
                dl.finalStatus("badControl");
                dl.Send();
                if (!Globals.g_quietMode) {
                    CustMsgBox.showMessageDialog(null, this.bundle.messageString("EsdDownloadController.BadOrder.txt"), this.bundle.getString("Common.Error.txt"), 0);
                }
                Globals.g_wizard.exitWizard(-1);
            }
            Globals.g_job = Globals.g_depotManager.createAddJob(Globals.g_deploymentData, Globals.g_order);
            Logging.log.finer("Order count from new Control file2: " + Globals.g_deploymentData.getOrderCount());
            ((DepotManager.AddJob)Globals.g_job).setMode(3);
            Logging.log.finer("Order count from new Control file3: " + Globals.g_deploymentData.getOrderCount());
            newControlFile.setAltSkuList(Globals.g_job.getSpsSkusToProcess());
            Logging.log.info("Have new Control File, waiting for Expander to finish file before resolving");
            while (Globals.g_esdStats.activeTask("EXTRACT")) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Logging.logStackTrace(e);
                }
            }
            newControlFile.resolve(Globals.g_control, this.partDownloadList, this.partExpandList, this.partDoneList);
            Globals.g_control = newControlFile;
            this.partDownloadList.clear();
            this.partExpandList.clear();
            this.partDoneList.clear();
            this.loadListsFromControl(Globals.g_control.getDownloadControlList());
            Globals.g_control.renumber(this.partDownloadList);
            this.saveEsdControl(Globals.g_control);
            Globals.g_esdStats.resetTask("DOWNLOAD", Globals.g_control.getTotalDownloadSize() - Globals.g_control.getRemainingDownloadSize(), Globals.g_control.getTotalDownloadSize());
            Globals.g_esdStats.resetTask("EXTRACT", Globals.g_control.getTotalExtractSize() - Globals.g_control.getRemainingExtractSize(), Globals.g_control.getTotalExtractSize());
            Globals.g_esdStats.resetProgressBar();
        }
        return true;
    }

    public double getDownloadSize() {
        if (this.downloadSize != 0.0) {
            return this.downloadSize;
        }
        double maxBytes = 0.0;
        for (EsdPart part : this.partDownloadList) {
            maxBytes += (double)part.getSizeCompressed();
            File fd = new File(part.getFullPath());
            if (!fd.exists()) continue;
            maxBytes -= (double)fd.length();
        }
        this.downloadSize = maxBytes;
        return maxBytes;
    }

    public void stopDownload(String reason) {
        if (Globals.g_control.isDisableCancel()) {
            return;
        }
        Logging.log.finer("StopDownload: sending interrupts...");
        this.downLoaderThread.interrupt();
        if (this.downLoaderThread.isInterrupted()) {
            Logging.log.finer("Terminated downloader.");
        }
        this.expanderThread.interrupt();
        if (this.expanderThread.isInterrupted()) {
            Logging.log.finer("Terminated expander.");
        }
        DownloadLogger dl = new DownloadLogger();
        dl.finalStatus(reason);
        dl.Send();
        this.controllerThread.interrupt();
    }

    private void savePartDownloadList() {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(Utils.joinPath(Globals.g_downloadDir, "resume1")));
            oos.writeObject(this.partDownloadList);
            Logging.log.finer("Saved partDownloadList to resume1 from thread " + Thread.currentThread().getName());
            Logging.log.finer("partDownloadList = " + this.partDownloadList);
        }
        catch (IOException e) {
            Logging.logStackTrace(e);
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
    }

    private void loadPartDownloadList() {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(Utils.joinPath(Globals.g_downloadDir, "resume1")));
            this.partDownloadList = (LinkedList)ois.readObject();
            Logging.log.finer("Loaded partDownloadList from resume1 from thread " + Thread.currentThread().getName());
            Logging.log.finer("partDownloadList = " + this.partDownloadList);
        }
        catch (IOException e) {
            Logging.logStackTrace(e);
        }
        catch (ClassNotFoundException e) {
            Logging.logStackTrace(e);
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
    }

    private void smackPartDownloadList() {
        File f = new File(Utils.joinPath(Globals.g_downloadDir, "resume1"));
        f.delete();
    }

    private void savePartExpandList() {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(Utils.joinPath(Globals.g_downloadDir, "resume2")));
            oos.writeObject(this.partExpandList);
            Logging.log.finer("Saved partExpandList to resume2 from thread " + Thread.currentThread().getName());
            Logging.log.finer("partExpandList = " + this.partExpandList);
        }
        catch (IOException e) {
            Logging.logStackTrace(e);
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
    }

    private void loadPartExpandList() {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(Utils.joinPath(Globals.g_downloadDir, "resume2")));
            this.partExpandList = (LinkedList)ois.readObject();
            Logging.log.finer("Loaded partExpandList from resume2 from thread " + Thread.currentThread().getName());
            Logging.log.finer("partExpandList = " + this.partExpandList);
        }
        catch (IOException e) {
            Logging.logStackTrace(e);
        }
        catch (ClassNotFoundException e) {
            Logging.logStackTrace(e);
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
    }

    private void smackPartExpandList() {
        File f = new File(Utils.joinPath(Globals.g_downloadDir, "resume2"));
        f.delete();
    }

    private void savePartDoneList() {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(Utils.joinPath(Globals.g_downloadDir, "history")));
            oos.writeObject(this.partDoneList);
            Logging.log.finer("Saved partDoneList to history from thread " + Thread.currentThread().getName());
            Logging.log.finer("partDoneList = " + this.partDoneList);
        }
        catch (IOException e) {
            Logging.logStackTrace(e);
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
    }

    private void loadPartDoneList() {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(Utils.joinPath(Globals.g_downloadDir, "history")));
            this.partDoneList = (LinkedList)ois.readObject();
            Logging.log.finer("Loaded partDoneList from history from thread " + Thread.currentThread().getName());
            Logging.log.finer("partDoneList = " + this.partDoneList);
        }
        catch (IOException e) {
            Logging.logStackTrace(e);
        }
        catch (ClassNotFoundException e) {
            Logging.logStackTrace(e);
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEsdControl(EsdControl esdControl) {
        ObjectOutputStream oos = null;
        try {
            int retries = 5;
            boolean finished = false;
            oos = new ObjectOutputStream(new FileOutputStream(Utils.joinPath(Globals.g_downloadDir, "control")));
            while (!finished && retries-- > 0) {
                try {
                    oos.writeObject(esdControl);
                    finished = true;
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
            }
            Logging.log.finer("Saved esdControl to control from thread " + Thread.currentThread().getName());
        }
        catch (IOException e) {
            Logging.logStackTrace(e);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EsdControl loadEsdControl() {
        EsdControl esdControl = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(Utils.joinPath(Globals.g_downloadDir, "control")));
            esdControl = (EsdControl)ois.readObject();
            Logging.log.finer("Loaded esdControl from control from thread " + Thread.currentThread().getName());
        }
        catch (IOException e) {
            Logging.logStackTrace(e);
        }
        catch (ClassNotFoundException e) {
            Logging.logStackTrace(e);
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
        return esdControl;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void startTimer() {
        this.timer = new Timer(900000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EsdDownloadController.this.timerEvent();
            }
        });
        this.timer.start();
    }

    public void stopTimer() {
        this.timer.stop();
    }

    private void timerEvent() {
        Globals.g_control.sendSignal("alive");
    }

    private int getTotalNumParts() {
        return this.partDownloadList.size() + this.partExpandList.size() + this.partDoneList.size();
    }

    private void createTemporarySpace() {
        Logging.log.finer("Creating temporary space");
        PrintStream out = null;
        try {
            out = new PrintStream(Utils.joinPath(Globals.g_downloadDir, "temporaryspace.txt"));
        }
        catch (FileNotFoundException e) {
            Logging.log.severe("Could not create temporary space file");
            Logging.logStackTrace(e);
        }
        if (out == null) {
            Logging.log.severe("Could not create temporary space file");
            return;
        }
        String msg = "This  is  being  used  as  temporary  space.";
        for (int i = 0; i < 25000; ++i) {
            out.println(msg);
        }
        out.close();
        Logging.log.finer("Temporary space created");
    }

    private void deleteTemporarySpace() {
        File f = new File(Utils.joinPath(Globals.g_downloadDir, "temporaryspace.txt"));
        if (f != null) {
            f.delete();
        }
    }

    class Downloader
    extends Thread
    implements RetryIface {
        private boolean allowRetry = false;
        private String link = "";
        int tryUsingLeadingZeros = 0;
        private boolean reloadCookies = false;

        Downloader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setName("Downloader");
            while (!(EsdDownloadController.this.allDone || EsdDownloadController.this.canceled || this.isInterrupted())) {
                LinkedList linkedList = EsdDownloadController.this.partDownloadList;
                synchronized (linkedList) {
                    EsdPart part;
                    block82: {
                        while (EsdDownloadController.this.partDownloadList.size() == 0) {
                            try {
                                Globals.g_esdStats.stopped("DOWNLOAD");
                                EsdDownloadController.this.partDownloadList.wait();
                                Globals.g_esdStats.started("DOWNLOAD");
                            }
                            catch (InterruptedException ex) {
                                Logging.log.fine("Downloader Thread interrupted");
                                return;
                            }
                        }
                        boolean valid = false;
                        while (!valid) {
                            try {
                                if (EsdDownloadController.this.checkControlFile(this.reloadCookies)) {
                                    valid = true;
                                }
                                this.reloadCookies = false;
                            }
                            catch (Exception e) {
                                valid = false;
                                Logging.logStackTrace(e);
                            }
                        }
                        EsdDownloadController.this.startTimer();
                        if (EsdDownloadController.this.partDownloadList.size() < 1) {
                            Object e = EsdDownloadController.this.obj;
                            synchronized (e) {
                                EsdDownloadController.this.obj.notifyAll();
                            }
                        }
                        part = (EsdPart)EsdDownloadController.this.partDownloadList.getFirst();
                        DownloadLogger dl = new DownloadLogger(part, EsdDownloadController.this.getTotalNumParts());
                        EsdInternet internet = null;
                        this.link = part.getLink();
                        if (Globals.g_esdDownloadServer != null) {
                            this.link = Globals.g_esdDownloadServer + this.link.substring(this.link.lastIndexOf("/esd/"));
                            Logging.log.info("Replacing server, now url=" + this.link);
                        }
                        String alt_server = Globals.g_httponly ? EsdDownloadController.ALT_SERVER_HTTP : EsdDownloadController.ALT_SERVER_HTTPS;
                        if (part.getRetries() == 3) {
                            this.link = alt_server + this.link.substring(this.link.lastIndexOf("/esd/"));
                            Logging.log.info("Trying alt server, now url=" + this.link);
                        } else if (part.getRetries() == 4) {
                            this.tryUsingLeadingZeros = 1;
                        }
                        if (Globals.g_testRetries && part.getFileNum() % 10 == 0 && part.getRetries() < 5) {
                            int splitpoint = this.link.lastIndexOf(47);
                            this.link = this.link.substring(0, splitpoint + 1) + "0" + this.link.substring(splitpoint + 1);
                        }
                        try {
                            File fp;
                            Logging.log.info("Starting Download[" + part.getRetries() + "]: " + part.getFullPath());
                            if (part.getRetries() > 0) {
                                Globals.g_esdStats.eventMsg("EsdDownloadStats.DownloadRetries.txt", part.getRetries(), part.getFileNum(), EsdDownloadController.this.getTotalNumParts());
                            } else {
                                Globals.g_esdStats.eventMsg("EsdDownloadStats.DownloadStart.txt", part.getFileNum(), EsdDownloadController.this.getTotalNumParts());
                            }
                            File parentDir = new File(part.getFullPath()).getParentFile();
                            if (!parentDir.exists()) {
                                parentDir.mkdirs();
                            }
                            internet = new EsdInternet();
                            internet.setCookies(Globals.g_cookies);
                            if (Globals.g_protocol == 1) {
                                String altsku = this.link.substring(this.link.lastIndexOf("/") + 1);
                                int chopPoint = this.link.indexOf("/esd/");
                                this.link = this.link.substring(0, chopPoint) + "/esd/0000-0000-0000/000000/" + altsku;
                            }
                            if (this.tryUsingLeadingZeros == 1) {
                                this.link = alt_server + this.link.substring(this.link.lastIndexOf("/esd/")) + "?z=256";
                                Logging.log.info("Trying alt server with leading zeros protocol, now url=" + this.link);
                                internet.downloadFile(this.link, part.getFullPath(), true, part, 256);
                                this.tryUsingLeadingZeros = 2;
                            } else {
                                internet.downloadFile(this.link, part.getFullPath(), true, part);
                            }
                            long currentFileSize = 0L;
                            File partFD = new File(part.getFullPath());
                            if (partFD != null) {
                                currentFileSize = partFD.length();
                            }
                            if (internet.getStatus() != 200 && internet.getStatus() != 206) {
                                Logging.log.severe("Failed to download file " + part.getFullPath() + " with http status = " + internet.getStatus());
                                Globals.g_esdStats.eventMsg("EsdDownloadStats.BadDownload.txt", internet.getStatus(), part.getFileNum());
                                dl.reportBadStatusError(internet.getStatus());
                                dl.finalLogEntries(this.link, part, internet, false);
                                if (internet.getStatus() == 416) {
                                    fp = new File(part.getFullPath());
                                    if (fp.exists()) {
                                        if (fp.delete()) {
                                            Logging.log.warning("Got 416, so blew away " + part.getFullPath());
                                        } else {
                                            Logging.log.severe("Got 416, so tried to blew away " + part.getFullPath() + " but delete failed.");
                                        }
                                    } else {
                                        Logging.log.warning("Got 416, but file " + part.getFullPath() + " doesn't exist, which doesn't make sense!");
                                    }
                                } else if (internet.getStatus() == 503 && !Globals.g_useProxyAnyway && Globals.g_order.startsWith("0")) {
                                    Globals.g_useProxyAnyway = true;
                                    Logging.log.warning("Forcing the use of the proxy anyway even though order had leading zero");
                                } else if (internet.getStatus() == 403) {
                                    if (this.tryUsingLeadingZeros == 0) {
                                        this.tryUsingLeadingZeros = 1;
                                        Logging.log.severe("Got 403--proxy security software likely cause. Attempting work-around.");
                                    } else {
                                        this.reloadCookies = true;
                                    }
                                } else if (internet.getStatus() == 404) {
                                    this.reloadCookies = true;
                                }
                                part.setRetries(part.getRetries() + 1);
                                break block82;
                            }
                            if (currentFileSize > part.getSizeCompressed()) {
                                Logging.log.severe("Failed to download file " + part.getFullPath() + " because we got too many bytes.  Wanted " + part.getSizeCompressed() + " but got " + currentFileSize);
                                Utils.loggingToFiner();
                                Globals.g_esdStats.eventMsg("EsdDownloadStats.TooManyBytes", part.getFileNum());
                                Globals.g_esdStats.delFromTask("DOWNLOAD", currentFileSize);
                                dl.reportBadStatusError(1000);
                                dl.finalLogEntries(this.link, part, internet, false);
                                fp = new File(part.getFullPath());
                                if (fp.exists()) {
                                    if (fp.delete()) {
                                        Logging.log.warning("Got too-many-bytes error, so blew away " + part.getFullPath());
                                    } else {
                                        Logging.log.severe("Got too-many-bytes error, so tried to blew away " + part.getFullPath() + " but delete failed.");
                                    }
                                } else {
                                    Logging.log.warning("Got too-many-bytes error, but file " + part.getFullPath() + " doesn't exist, which doesn't make sense!");
                                }
                                part.setRetries(part.getRetries() + 1);
                                this.checkChecksums(part.getChecksum());
                                break block82;
                            }
                            if (currentFileSize < part.getSizeCompressed()) {
                                Logging.log.severe("Failed to download file " + part.getFullPath() + " because we got too few bytes.  Wanted " + part.getSizeCompressed() + " but got " + currentFileSize);
                                Utils.loggingToFiner();
                                Logging.log.finer("Header content-length = " + internet.getHeader("Content-Length"));
                                Globals.g_esdStats.eventMsg("EsdDownloadStats.TooFewBytes", part.getFileNum());
                                if (currentFileSize > EsdDownloadController.this.previousCurrentFileSize) {
                                    EsdDownloadController.this.previousCurrentFileSize = currentFileSize;
                                } else {
                                    this.checkChecksums(part.getChecksum());
                                    part.setRetries(part.getRetries() + 1);
                                }
                                break block82;
                            }
                            if (!part.getChecksum().equals(internet.getChecksum())) {
                                Globals.g_esdStats.delFromTask("DOWNLOAD", part.getSizeCompressed());
                                Logging.log.severe("Failed to download file " + part.getFullPath() + " with correct checksum.  Wanted " + part.getChecksum() + " but got " + internet.getChecksum());
                                Globals.g_esdStats.eventMsg("EsdDownloadStats.BadChecksum.txt", part.getFileNum());
                                dl.reportCheckSumError(part.getChecksum(), internet.getChecksum());
                                dl.finalLogEntries(this.link, part, internet, false);
                                fp = new File(part.getFullPath());
                                if (fp.exists()) {
                                    if (Globals.g_debug) {
                                        Utils.movefiles(fp, new File(part.getFullPath() + ".badckm"));
                                    } else if (fp.delete()) {
                                        Logging.log.warning("Got checksum error, so blew away " + part.getFullPath());
                                    } else {
                                        Logging.log.severe("Got checksum error, so tried to blew away " + part.getFullPath() + " but delete failed.");
                                    }
                                } else {
                                    Logging.log.warning("Got checksum error, but file " + part.getFullPath() + " doesn't exist, which doesn't make sense!");
                                }
                                part.setRetries(part.getRetries() + 1);
                                this.checkChecksums(part.getChecksum());
                                break block82;
                            }
                            Logging.log.info("Finished download of: " + part.getFullPath());
                            Globals.g_esdStats.eventMsg("EsdDownloadStats.DownloadSuccess.txt", part.getFileNum());
                            dl.finalLogEntries(this.link, part, internet, true);
                            part.setDownloaded(true);
                            part.setRetries(0);
                            EsdDownloadController.this.partDownloadList.removeFirst();
                            EsdDownloadController.this.savePartDownloadList();
                            EsdDownloadController.this.saveEsdControl(Globals.g_control);
                            this.clearChecksums();
                            EsdDownloadController.this.previousCurrentFileSize = 0L;
                            this.tryUsingLeadingZeros = 0;
                            LinkedList linkedList2 = EsdDownloadController.this.partExpandList;
                            synchronized (linkedList2) {
                                EsdDownloadController.this.partExpandList.add(part);
                                EsdDownloadController.this.savePartExpandList();
                                EsdDownloadController.this.partExpandList.notifyAll();
                            }
                        }
                        catch (Exception e) {
                            Logging.log.severe("Failed to download file " + part.getFullPath() + " because " + e.getMessage());
                            Logging.logStackTrace(e);
                            Utils.loggingToFiner();
                            if (e instanceof SocketTimeoutException) {
                                Globals.g_esdStats.eventMsg("EsdDownloadStats.Timeout.txt", new Integer(part.getFileNum()));
                            } else {
                                Globals.g_esdStats.eventMsg("EsdDownloadStats.BadDownloadException.txt", new Integer(part.getFileNum()), e.getMessage() == null ? "NULL" : e.getMessage());
                            }
                            dl.exception(e.getMessage());
                            dl.finalLogEntries(this.link, part, internet, false);
                            part.setRetries(part.getRetries() + 1);
                            if (!Globals.g_useProxyAnyway && Globals.g_order.startsWith("0")) {
                                Globals.g_useProxyAnyway = true;
                                Logging.log.warning("Forcing the use of the proxy anyway even though order had leading zero");
                            }
                        }
                        finally {
                            dl.Send();
                            EsdDownloadController.this.timer.stop();
                        }
                    }
                    if (part.getRetries() > 4 && !EsdDownloadController.this.ChecksumsMatch) {
                        boolean skipRetry = false;
                        if (EsdDownloadController.this.retryActive) {
                            skipRetry = true;
                        } else {
                            EsdDownloadController.this.retryActive = true;
                        }
                        Object object = EsdDownloadController.this.retryObj;
                        synchronized (object) {
                            if (!skipRetry) {
                                this.allowRetry = false;
                                if (!Globals.g_quietMode) {
                                    while (Globals.g_wizard == null) {
                                        try {
                                            Logging.log.finer("Waiting for main thread to set Globals.g_wizard");
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException e) {
                                            Logging.log.finer("Sleep failed while waiting for main thread to set Globals.g_wizard");
                                            Logging.logStackTrace(e);
                                        }
                                    }
                                    if (Globals.g_consoleMode) {
                                        DlgRetryESDConsole e = new DlgRetryESDConsole(this, 60, EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Title.txt"), EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Message.txt"), EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Countdown.txt"), EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Cancel.txt"));
                                    } else {
                                        DlgRetryESD dlgRetryESD = new DlgRetryESD(Globals.g_wizard.getFrame(), this, 60, EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Title.txt"), EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Message.txt"), EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Countdown.txt"), EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Cancel.txt"));
                                        dlgRetryESD.setVisible(true);
                                    }
                                }
                                if (!this.allowRetry) {
                                    EsdDownloadController.this.deleteTemporarySpace();
                                    EsdDownloadController.this.stopDownload("skuDownloadErrors");
                                    EsdDownloadController.this.canceled = true;
                                }
                            }
                            if (EsdDownloadController.this.retryActive) {
                                EsdDownloadController.this.retryActive = false;
                            }
                        }
                    }
                }
            }
        }

        private void checkChecksums(String checksum) {
            String firstChecksum = null;
            EsdDownloadController.this.previousChecksums.add(checksum);
            if (EsdDownloadController.this.previousChecksums.size() >= 3) {
                boolean same = true;
                Iterator iter = EsdDownloadController.this.previousChecksums.iterator();
                while (iter.hasNext() && same) {
                    String iterChecksum = (String)iter.next();
                    if (firstChecksum == null) {
                        firstChecksum = iterChecksum;
                        continue;
                    }
                    if (firstChecksum.equals(iterChecksum)) continue;
                    same = false;
                }
                if (same) {
                    EsdDownloadController.this.ChecksumsMatch = true;
                    int result = this.showBadOrderDataDlg();
                    if (result == 0) {
                        EsdDownloadController.this.deleteTemporarySpace();
                        EsdDownloadController.this.stopDownload("skuDownloadErrors");
                        EsdDownloadController.this.canceled = true;
                    }
                } else {
                    EsdDownloadController.this.ChecksumsMatch = false;
                }
            }
        }

        private void clearChecksums() {
            EsdDownloadController.this.previousChecksums.clear();
            EsdDownloadController.this.ChecksumsMatch = false;
        }

        private int showBadOrderDataDlg() {
            if (Globals.g_quietMode) {
                Logging.log.severe(EsdDownloadController.this.bundle.getString("EsdDownloadController.showBadOrderDataDlg.message.txt"));
                return 0;
            }
            this.allowRetry = false;
            if (Globals.g_consoleMode) {
                DlgRetryESDConsole dlgRetryESDConsole = new DlgRetryESDConsole(this, 60, EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Title.txt"), EsdDownloadController.this.bundle.getString("EsdDownloadController.showBadOrderDataDlg.message.txt"), EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Countdown.txt"), EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Cancel.txt"));
            } else {
                DlgRetryESD dlgRetryESD = new DlgRetryESD(Globals.g_wizard.getFrame(), this, 60, EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Title.txt"), EsdDownloadController.this.bundle.getString("EsdDownloadController.showBadOrderDataDlg.message.txt"), EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Countdown.txt"), EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Cancel.txt"));
                dlgRetryESD.setVisible(true);
            }
            if (this.allowRetry) {
                return 1;
            }
            return 0;
        }

        @Override
        public void retry() {
            this.allowRetry = true;
        }
    }

    class Expander
    extends Thread
    implements RetryIface {
        private boolean allowRetry = false;

        Expander() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setName("Expander");
            while (!(EsdDownloadController.this.allDone || EsdDownloadController.this.canceled || this.isInterrupted())) {
                Object object;
                EsdPart part = null;
                long countAtStart = Globals.g_esdStats.getCurrCountAsLong("EXTRACT");
                LinkedList linkedList = EsdDownloadController.this.partExpandList;
                synchronized (linkedList) {
                    while (EsdDownloadController.this.partExpandList.size() == 0) {
                        try {
                            Globals.g_esdStats.stopped("EXTRACT");
                            EsdDownloadController.this.partExpandList.wait();
                            Globals.g_esdStats.started("EXTRACT");
                        }
                        catch (InterruptedException ex) {
                            Logging.log.fine("Expander Thread interrupted");
                            this.interrupt();
                            return;
                        }
                    }
                    part = (EsdPart)EsdDownloadController.this.partExpandList.getFirst();
                }
                if (part.getType().indexOf("Z") >= 0) {
                    try {
                        if (part.getRetries() > 0) {
                            Globals.g_esdStats.eventMsg("EsdDownloadStats.ExtractionRetries.txt", part.getRetries(), part.getFileNum(), EsdDownloadController.this.getTotalNumParts());
                        } else {
                            Globals.g_esdStats.eventMsg("EsdDownloadStats.ExtractionStart.txt", part.getFileNum(), EsdDownloadController.this.getTotalNumParts());
                        }
                        Unzip.getAll(part.getFullPath(), Utils.joinPath(Globals.g_downloadDir, part.getAltSku()));
                        part.setExpanded(true);
                        EsdDownloadController.this.partDoneList.addLast(part);
                        EsdDownloadController.this.savePartDoneList();
                        EsdDownloadController.this.saveEsdControl(Globals.g_control);
                        linkedList = EsdDownloadController.this.partExpandList;
                        synchronized (linkedList) {
                            EsdDownloadController.this.partExpandList.removeFirst();
                            EsdDownloadController.this.savePartExpandList();
                        }
                        part.setRetries(0);
                        File f = new File(part.getFullPath());
                        if (!f.delete()) {
                            Logging.log.warning("Could not delete zip file: " + part.getFullPath());
                            if (!f.delete()) {
                                Logging.log.warning("Could not delete zip file again: " + part.getFullPath());
                            }
                        }
                        f = null;
                        Logging.log.info("Unzipped: " + part.getFullPath());
                        Globals.g_esdStats.eventMsg("EsdDownloadStats.ExtractionSuccess.txt", part.getFileNum());
                        object = EsdDownloadController.this.obj;
                        synchronized (object) {
                            EsdDownloadController.this.obj.notifyAll();
                        }
                    }
                    catch (FileNotFoundException e) {
                        Logging.log.severe("File Not Found Exception with " + part.getFullPath() + " because " + e.getMessage());
                        Logging.logStackTrace(e);
                        Globals.g_esdStats.eventMsg("EsdDownloadStats.BadExtractionException.txt", new Integer(part.getFileNum()), e.getMessage() == null ? "NULL" : e.getMessage());
                        part.setRetries(part.getRetries() + 1);
                    }
                    catch (ZipException e) {
                        Logging.log.severe("Zip Exception with " + part.getFullPath() + " because " + e.getMessage());
                        Logging.logStackTrace(e);
                        Globals.g_esdStats.eventMsg("EsdDownloadStats.BadExtractionException.txt", new Integer(part.getFileNum()), e.getMessage() == null ? "NULL" : e.getMessage());
                        part.setRetries(part.getRetries() + 1);
                    }
                    catch (IOException e) {
                        Logging.log.severe("IO Exception with " + part.getFullPath() + " because " + e.getMessage());
                        Logging.logStackTrace(e);
                        Globals.g_esdStats.eventMsg("EsdDownloadStats.BadExtractionException.txt", new Integer(part.getFileNum()), e.getMessage() == null ? "NULL" : e.getMessage());
                        part.setRetries(part.getRetries() + 1);
                    }
                }
                if (part.getRetries() < 1) continue;
                boolean skipRetry = false;
                if (EsdDownloadController.this.retryActive) {
                    skipRetry = true;
                } else {
                    EsdDownloadController.this.retryActive = true;
                }
                object = EsdDownloadController.this.retryObj;
                synchronized (object) {
                    if (!skipRetry) {
                        this.allowRetry = false;
                        if (!Globals.g_quietMode) {
                            while (Globals.g_wizard == null) {
                                try {
                                    Logging.log.finer("Waiting for main thread to set Globals.g_wizard");
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    Logging.log.finer("Sleep failed while waiting for main thread to set Globals.g_wizard");
                                    Logging.logStackTrace(e);
                                }
                            }
                            if (Globals.g_consoleMode) {
                                DlgRetryESDConsole e = new DlgRetryESDConsole(this, 60, EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Title.txt"), EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Message.txt"), EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Countdown.txt"), EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Cancel.txt"));
                            } else {
                                DlgRetryESD dlgRetryESD = new DlgRetryESD(Globals.g_wizard.getFrame(), this, 60, EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Title.txt"), EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Message.txt"), EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Countdown.txt"), EsdDownloadController.this.bundle.getString("EsdDownloadController.Retry.Cancel.txt"));
                                dlgRetryESD.setVisible(true);
                            }
                        }
                        if (!this.allowRetry) {
                            EsdDownloadController.this.deleteTemporarySpace();
                            EsdDownloadController.this.stopDownload("skuDownloadErrors");
                            EsdDownloadController.this.canceled = true;
                        }
                    }
                    Globals.g_esdStats.setCurrCountFromLong("EXTRACT", countAtStart);
                    if (EsdDownloadController.this.retryActive) {
                        EsdDownloadController.this.retryActive = false;
                    }
                }
            }
        }

        @Override
        public void retry() {
            this.allowRetry = true;
        }
    }
}

