/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DlgRetryESD;
import com.sas.ssn.DlgRetryESDConsole;
import com.sas.ssn.DlgUserNamePassword;
import com.sas.ssn.DlgUserNamePasswordConsole;
import com.sas.ssn.DownloadLogger;
import com.sas.ssn.EsdControlData;
import com.sas.ssn.EsdInternet;
import com.sas.ssn.EsdPart;
import com.sas.ssn.Globals;
import com.sas.ssn.KitAction;
import com.sas.ssn.Logging;
import com.sas.ssn.RetryIface;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Unzip;
import com.sas.ssn.Utils;
import com.sas.swing.visuals.util.Util;
import com.sas.util.BASE64;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.xml.sax.SAXException;

public class EsdControl
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int ProtocolVersion = 18;
    private static final int ControlFileVersion = 2;
    private static final String CREDENTIALS_PASSWORD = "Tell me if this hurts";
    private static final String IV = "SASRulez";
    private static String ControlURL = "";
    private static String TestControlURL = "";
    private static String DevControlURL = "";
    private static String SoftwareDepotControlURL = "";
    private static String TestPipe01URL = "";
    private static String TestPipe02URL = "";
    private static String TweekControlURL = "";
    private static String LocalHostURL = "";
    private static String BackupHost = "";
    private static final String ControlURLDomain = ".sas.com";
    private static final String ControlBasename = "control%%%.xml";
    private LinkedList<EsdPart> m_fullControlList = null;
    private LinkedList<EsdPart> m_downloadControlList = null;
    private HashMap<String, EsdPart> m_altSku2EsdPart = new HashMap();
    private String m_orderNumber = "";
    private String m_fullOrderNumber = "";
    private String m_installationKey = "";
    private String m_tmpWorkDirectory;
    private String m_controlFilename = "";
    private int m_controlFileIncrement = 0;
    private String m_tmpCustomContentZipFile = "";
    private String m_lastModified = "";
    private String m_ETag = "";
    private int m_status_control = 0;
    private int m_status_xml = 0;
    private int m_statusFromControl = 0;
    private int m_valid_control = 0;
    private int m_valid_xml = 0;
    private String m_orderDesc;
    private long m_downloadSize;
    private String m_currentNonce = "";
    private String m_firstNonce = "";
    private String m_lastNonce = "";
    private boolean m_hasMessageFromControl = false;
    private String m_messageFromControl = "";
    private boolean disableCancel = false;
    protected static SSNResource bundle = new SSNResource(EsdControl.class);
    private int m_serverProtocolVersion = -1;
    private String m_baseUrl = "";
    private String m_authServer = null;
    boolean m_redirectRequested = false;
    private HashMap<String, Cookie> m_cookieJar = null;
    private boolean m_reloadCookies = false;
    private boolean m_depotCompression = false;

    public EsdControl(String orderNumber, String installationKey) throws IOException {
        this.m_cookieJar = new HashMap();
        this.m_orderNumber = orderNumber;
        this.m_installationKey = installationKey;
        this.m_depotCompression = Globals.g_depotCompressionAfterDownload;
        if (Globals.g_resumeESD && !"".equals(Globals.g_downloadDir) && new File(Globals.g_downloadDir).exists()) {
            this.m_tmpWorkDirectory = Globals.g_downloadDir;
        } else {
            this.m_tmpWorkDirectory = Utils.joinPath(Globals.g_tempLocation, "download");
            File tWD = new File(this.m_tmpWorkDirectory);
            if (tWD.exists()) {
                Utils.deleteFolder(tWD);
            }
            tWD.mkdir();
        }
        do {
            boolean result;
            this.m_redirectRequested = false;
            String fileVersion = this.toZeroPaddedString(this.m_controlFileIncrement++, 3);
            this.m_controlFilename = Utils.joinPath(this.m_tmpWorkDirectory, ControlBasename);
            this.m_controlFilename = Utils.stringReplaceAll(this.m_controlFilename, "%%%", fileVersion);
            File cf = new File(this.m_controlFilename);
            if (cf.exists()) {
                cf.renameTo(new File(this.m_controlFilename + "_old"));
            }
            this.downloadControl();
            if (!this.isNewDownload()) continue;
            boolean bl = result = this.parseControlData() && this.checkEncryption() && this.updateCookies() && this.downloadCustomContent() && this.processCustomContent();
            if (this.m_redirectRequested) continue;
            this.m_valid_control = result ? 0 : 2;
        } while (this.m_redirectRequested);
        if (!this.isValid()) {
            Logging.log.warning("Control file is not valid: status=" + this.m_status_control + " status_xml=" + this.m_status_xml + " statusFromControl=" + this.m_statusFromControl);
            if (this.m_status_control == 410 || this.m_status_xml == 410) {
                if (!Globals.g_quietMode) {
                    CustMsgBox.showMessageDialog(null, bundle.getString("EsdControl.DownloadCountExceeded.txt"), bundle.getString("Common.Error.txt"), 0);
                }
            } else if (!this.checkCancelAndContinue() && !this.checkHoldAndContinue()) {
                if (!Globals.g_quietMode) {
                    Logging.log.severe(bundle.getString("EsdControl.BadControlMsg.txt"));
                }
                CustMsgBox.showMessageDialog(null, bundle.getString("EsdControl.BadControlMsg.txt"), bundle.getString("Common.Error.txt"), 0);
            }
        }
    }

    public EsdControl(EsdControl currControl, boolean reloadCookies) throws IOException {
        File cf;
        this.m_orderNumber = currControl.getOrderNumber();
        this.m_installationKey = currControl.getInstallationKey();
        this.m_lastModified = currControl.getLastModified();
        this.m_ETag = currControl.getETag();
        this.m_cookieJar = currControl.getCookieJar();
        this.m_downloadControlList = currControl.getDownloadControlList();
        this.m_orderDesc = currControl.getOrderDesc();
        if (Globals.g_orderDesc == null) {
            Globals.g_orderDesc = this.m_orderDesc;
        }
        this.m_currentNonce = currControl.getCurrentNonce();
        this.m_lastNonce = currControl.getLastNonce();
        this.m_firstNonce = currControl.getFirstNonce();
        this.m_authServer = currControl.get_authServer();
        this.m_tmpWorkDirectory = Globals.g_downloadDir;
        this.m_controlFilename = Utils.joinPath(this.m_tmpWorkDirectory, ControlBasename);
        this.m_controlFileIncrement = currControl.getControlFileIncrement();
        String fileVersion = this.toZeroPaddedString(this.m_controlFileIncrement, 3);
        this.m_controlFilename = Utils.stringReplaceAll(this.m_controlFilename, "%%%", fileVersion);
        this.m_valid_control = 0;
        this.m_depotCompression = Globals.g_depotCompressionAfterDownload;
        if (reloadCookies) {
            this.m_reloadCookies = true;
        }
        if ((cf = new File(this.m_controlFilename)).exists()) {
            cf.renameTo(new File(this.m_controlFilename + "_old"));
        }
        this.downloadControl();
        if (this.isNotModified()) {
            return;
        }
        if (this.isNewDownload()) {
            boolean result = this.parseControlData() && this.updateCookies() && this.downloadCustomContent() && this.processCustomContent();
            this.m_valid_control = result ? 0 : 2;
        }
        if (!this.isValid()) {
            Logging.log.severe("Bad status while rechecking and downloading control file: status=" + this.m_status_control + " valid=" + this.m_valid_control);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void downloadControl() throws IOException {
        String urlP0 = "";
        String urlP12 = "";
        String finalUrl = "";
        boolean success = false;
        this.m_status_control = 0;
        String orderNumber = "";
        String hostOptionText = "";
        String hostChar = "";
        String techSupportFlag = "";
        this.SetServerNames();
        if (this.m_authServer != null) {
            Logging.log.finer("Setting baseUrl from m_authServer");
            this.m_baseUrl = this.m_authServer;
        } else if (Globals.g_esdAuthServer != null) {
            Logging.log.finer("Setting baseUrl from Globals");
            this.m_baseUrl = Globals.g_esdAuthServer;
        } else {
            Logging.log.finer("Setting baseUrl from order number");
            Pattern pattern_orderNumber = Pattern.compile("^(\\w{6,8})(-([0-5LT])(S)?)?$");
            Matcher matcher_orderNumber = pattern_orderNumber.matcher(this.m_orderNumber);
            if (!matcher_orderNumber.matches()) {
                Logging.log.severe("Bad Order Number: " + this.m_orderNumber);
                this.m_valid_control = 2;
                return;
            }
            orderNumber = matcher_orderNumber.group(1);
            hostOptionText = matcher_orderNumber.group(2);
            hostChar = matcher_orderNumber.group(3);
            techSupportFlag = matcher_orderNumber.group(4);
            if (hostOptionText == null || "".equals(hostOptionText)) {
                this.m_baseUrl = orderNumber.startsWith("0") ? TestControlURL : ControlURL;
            } else if ("t".equalsIgnoreCase(hostChar)) {
                this.m_baseUrl = orderNumber.startsWith("0") ? TestControlURL : ControlURL;
                Globals.g_order = orderNumber;
            } else if ("0".equals(hostChar)) {
                this.m_baseUrl = DevControlURL;
                Globals.g_order = orderNumber;
            } else if ("1".equals(hostChar)) {
                this.m_baseUrl = TweekControlURL;
                Globals.g_order = orderNumber;
            } else if ("2".equals(hostChar)) {
                this.m_baseUrl = TestControlURL;
                Globals.g_order = orderNumber;
            } else if ("3".equals(hostChar)) {
                this.m_baseUrl = SoftwareDepotControlURL;
                Globals.g_order = orderNumber;
            } else if ("4".equals(hostChar)) {
                this.m_baseUrl = TestPipe01URL;
                Globals.g_order = orderNumber;
            } else if ("5".equals(hostChar)) {
                this.m_baseUrl = TestPipe02URL;
                Globals.g_order = orderNumber;
            } else if ("l".equalsIgnoreCase(hostChar)) {
                this.m_baseUrl = LocalHostURL;
                Globals.g_order = orderNumber;
                Globals.g_proxyBypass = true;
                Logging.log.finer("Shutting off use of proxy since we are using localhost");
            } else {
                Logging.log.severe("Bad Order Number: " + this.m_orderNumber);
                Logging.log.finer("OrderNumber parse error: " + this.m_orderNumber);
                this.m_valid_control = 2;
                return;
            }
            if ("t".equalsIgnoreCase(hostChar) || "s".equalsIgnoreCase(techSupportFlag)) {
                MessageDigest digester = null;
                try {
                    digester = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                digester.update(new String(orderNumber + ":" + this.m_installationKey).getBytes("UTF-8"));
                String tsCookieValue = BASE64.encode(digester.digest());
                this.m_cookieJar.put("esd-ts", this.createCookie(ControlURLDomain, "esd-ts", tsCookieValue, "/", null, false));
            }
        }
        Logging.log.info("Order Number: " + Globals.g_order);
        Logging.log.finer("Order number baseURL: " + this.m_baseUrl);
        this.m_serverProtocolVersion = this.checkProtocolVersion(this.m_baseUrl);
        if (this.m_redirectRequested) {
            Logging.log.info("Redirecting to new authentication server: " + this.m_authServer);
            Globals.g_protocol = -1;
            this.m_lastModified = "";
            this.m_ETag = "";
            this.m_reloadCookies = true;
            this.m_redirectRequested = false;
        }
        urlP0 = this.m_baseUrl + "/" + this.m_installationKey + "/" + this.m_orderNumber.substring(0, 6);
        urlP12 = this.m_baseUrl + "/0000-0000-0000/000000";
        EsdInternet internet = null;
        if (this.m_cookieJar.get("esd-etag") != null || !"".equals(this.m_lastModified) && !"".equals(this.m_ETag)) {
            internet = new EsdInternet();
            if (this.m_reloadCookies) {
                this.clearAuthCookies();
                Globals.g_cookies = this.combineAllCookies();
                Iterator<Cookie> cookieIter = Globals.g_cookies.iterator();
                while (cookieIter.hasNext()) {
                    Cookie cookie = cookieIter.next();
                    if (!"esd-etag".equals(cookie.getName())) continue;
                    cookieIter.remove();
                }
                Logging.log.finer("Status indicates Cookies need to be reloaded...");
            } else {
                Globals.g_cookies = this.combineAllCookies();
            }
            if (this.m_cookieJar.get("esd-etag") == null) {
                internet.setHeader("If-Modified-Since", this.m_lastModified);
                internet.setHeader("If-None-Match", this.m_ETag);
            }
            internet.setCookies(Globals.g_cookies);
            if (Globals.g_protocol > -1) {
                finalUrl = Globals.g_protocol == 0 ? urlP0 : urlP12;
                internet.downloadFileRetries(finalUrl, this.m_controlFilename, false);
                this.setStatus(internet);
                Logging.log.info("Chased: " + finalUrl + " -- got status " + this.m_status_control);
                if (!this.m_reloadCookies && this.isNotModified()) {
                    return;
                }
                if (this.isNewDownload()) {
                    success = true;
                    if (Globals.g_protocol == 2) {
                        this.decrypt(this.m_controlFilename);
                    }
                    this.clearAuthCookies();
                    this.m_reloadCookies = true;
                    Logging.log.finer("New control file downloaded, so cookies need to be reloaded...");
                }
            }
        }
        if (!this.isNewDownload() && !this.isNotModified()) {
            boolean needAuthentication = false;
            String userName = null;
            String password = null;
            do {
                String authStr;
                if (!success && Globals.g_cipher != null) {
                    String onkStr = null;
                    authStr = null;
                    try {
                        onkStr = this.encryptCookie(Globals.g_order + ":" + this.m_installationKey);
                        if (needAuthentication) {
                            if (Globals.g_quietMode) {
                                if (Globals.g_authName == null || Globals.g_authPassword == null) return;
                                userName = Globals.g_authName;
                                password = Globals.g_authPassword;
                            } else if (Globals.g_consoleMode) {
                                DlgUserNamePasswordConsole dlgc = new DlgUserNamePasswordConsole();
                                userName = dlgc.getUserName();
                                password = dlgc.getPassword();
                            } else {
                                DlgUserNamePassword dlg = null;
                                dlg = new DlgUserNamePassword(Globals.g_wizard == null ? null : Globals.g_wizard.getFrame());
                                dlg.setVisible(true);
                                if (dlg.cancelled()) return;
                                userName = dlg.getUserName();
                                password = dlg.getPassword();
                            }
                            authStr = this.encryptCookie(BASE64.encode(new String(userName + ":" + password).getBytes("UTF-8")));
                        }
                    }
                    catch (Exception e) {
                        Logging.log.warning("Exception attempting Protocol 2 when retrieving the control file.");
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        Logging.log.severe(sw.getBuffer().toString());
                        Globals.g_cipher = null;
                        Globals.g_protocol = 1;
                        success = false;
                    }
                    this.m_cookieJar.put("esd-onk", this.createCookie(ControlURLDomain, "esd-onk", onkStr, "/", null, false));
                    if (needAuthentication && authStr != null) {
                        this.m_cookieJar.put("esd-auth", this.createCookie(ControlURLDomain, "esd-auth", authStr, "/", null, false));
                        Logging.log.finer("Internal Authentication--cookie created");
                    }
                    finalUrl = urlP12;
                    internet = new EsdInternet();
                    Globals.g_cookies = this.combineAllCookies();
                    internet.setCookies(Globals.g_cookies);
                    internet.downloadFileRetries(finalUrl, this.m_controlFilename, false);
                    this.setStatus(internet);
                    Logging.log.info("Chased: " + finalUrl + " -- got status " + this.m_status_control);
                    if (this.requiresAuthentication()) {
                        if (needAuthentication) {
                            Logging.log.info("Got Internal Authentication Required signal again.  Username/Password no good.");
                            if (!Globals.g_quietMode) {
                                CustMsgBox.showMessageDialog(null, bundle.messageString("EsdControl.UserNamePasswordFailure.txt"), bundle.getString("Common.Error.txt"), 0);
                            }
                        }
                        needAuthentication = true;
                        Logging.log.info("Need Internal Authentication--signal received");
                        continue;
                    }
                    if (this.authenticationDenied()) {
                        Logging.log.info("Internal Authentication Denied--signal received");
                        if (!needAuthentication) {
                            Logging.log.severe("Got int-auth-denied signal before I got a int-auth-req.  Authentication system failed!");
                            if (Globals.g_quietMode) return;
                            CustMsgBox.showMessageDialog(null, bundle.messageString("EsdControl.Auth409PrematureFailure.txt"), bundle.getString("Common.Error.txt"), 0);
                            return;
                        }
                        if (Globals.g_quietMode) continue;
                        CustMsgBox.showMessageDialog(null, bundle.messageString("EsdControl.AuthFailure.txt"), bundle.getString("Common.Error.txt"), 0);
                        continue;
                    }
                    if (this.isNotModified() && !this.m_reloadCookies) {
                        return;
                    }
                    if (this.isNewDownload()) {
                        this.decrypt(this.m_controlFilename);
                        success = true;
                        this.m_reloadCookies = true;
                        needAuthentication = false;
                        Globals.g_protocol = 2;
                        Globals.g_url = finalUrl;
                        Logging.log.info("Protocol: 2");
                    }
                }
                if (!success) {
                    String onk = "c" + Globals.g_order + ":" + this.m_installationKey;
                    this.m_cookieJar.put("esd-onk", this.createCookie(ControlURLDomain, "esd-onk", onk, "/", null, false));
                    if (needAuthentication) {
                        if (Globals.g_quietMode) {
                            if (Globals.g_authName == null || Globals.g_authPassword == null) return;
                            userName = Globals.g_authName;
                            password = Globals.g_authPassword;
                        } else if (!Globals.g_consoleMode) {
                            DlgUserNamePassword dlg = new DlgUserNamePassword(Globals.g_wizard == null ? null : Globals.g_wizard.getFrame());
                            dlg.setVisible(true);
                            if (dlg.cancelled()) return;
                            userName = dlg.getUserName();
                            password = dlg.getPassword();
                        }
                        authStr = null;
                        authStr = "c" + BASE64.encode(new String(userName + ":" + password).getBytes("UTF-8"));
                        this.m_cookieJar.put("esd-auth", this.createCookie(ControlURLDomain, "esd-auth", authStr, "/", null, false));
                    }
                    finalUrl = urlP12;
                    internet = new EsdInternet();
                    Globals.g_cookies = this.combineAllCookies();
                    internet.setCookies(Globals.g_cookies);
                    internet.downloadFileRetries(finalUrl, this.m_controlFilename, false);
                    this.setStatus(internet);
                    Logging.log.info("Chased: " + finalUrl + " -- got status " + this.m_status_control);
                    if (this.requiresAuthentication()) {
                        needAuthentication = true;
                        Logging.log.info("Status code implies Need Authentication");
                        continue;
                    }
                    if (this.authenticationDenied()) {
                        Logging.log.info("Need Authentication--Got 409 (authentication denied)");
                        if (!needAuthentication) {
                            Logging.log.severe("Got a 409 before I got a 402.  Authentication system failed!");
                            if (Globals.g_quietMode) return;
                            CustMsgBox.showMessageDialog(null, bundle.messageString("EsdControl.Auth409PrematureFailure.txt"), bundle.getString("Common.Error.txt"), 0);
                            return;
                        }
                        if (Globals.g_quietMode) continue;
                        CustMsgBox.showMessageDialog(null, bundle.messageString("EsdControl.AuthFailure.txt"), bundle.getString("Common.Error.txt"), 0);
                        continue;
                    }
                    if (this.isNotModified() && !this.m_reloadCookies) {
                        return;
                    }
                    if (this.isNewDownload()) {
                        success = true;
                        this.m_reloadCookies = true;
                        needAuthentication = false;
                        Globals.g_protocol = 1;
                        Globals.g_url = finalUrl;
                        Logging.log.info("Protocol: 1");
                    }
                }
                if (success) continue;
                finalUrl = urlP0;
                internet = new EsdInternet();
                this.m_cookieJar.remove("esd-onk");
                this.clearAuthCookies();
                Globals.g_cookies = this.combineAllCookies();
                internet.setCookies(Globals.g_cookies);
                internet.downloadFileRetries(finalUrl, this.m_controlFilename, false);
                this.setStatus(internet);
                Logging.log.info("Chased: " + finalUrl + " -- got status " + this.m_status_control);
                if (this.isNotModified() && !this.m_reloadCookies) {
                    return;
                }
                if (!this.isNewDownload()) continue;
                success = true;
                this.m_reloadCookies = true;
                Globals.g_protocol = 0;
                Globals.g_url = finalUrl;
                Logging.log.info("Protocol: 0");
            } while (needAuthentication);
        }
        if (success || this.m_reloadCookies) {
            this.m_authServer = this.m_baseUrl;
            List<Cookie> cookies = internet.getCookies();
            String nonce = "";
            String sessionID = "";
            String domain = "";
            String path = "";
            for (Cookie cookie : cookies) {
                if (!ControlURLDomain.equals(cookie.getDomain())) continue;
                if ("esd-nonce".equals(cookie.getName())) {
                    this.m_cookieJar.put("esd-nonce", cookie);
                    nonce = cookie.getValue();
                    domain = cookie.getDomain();
                    path = cookie.getPath();
                    this.m_currentNonce = nonce;
                    if ("".equals(this.m_lastNonce)) {
                        this.m_lastNonce = nonce;
                    }
                    if (!"".equals(this.m_firstNonce)) continue;
                    this.m_firstNonce = nonce;
                    continue;
                }
                if ("esd-session".equals(cookie.getName())) {
                    sessionID = cookie.getValue();
                    this.m_cookieJar.put("esd-session", cookie);
                    continue;
                }
                if (!"esd-etag".equals(cookie.getName())) continue;
                this.m_cookieJar.put("esd-etag", cookie);
            }
            if (!("".equals(nonce) || "".equals(sessionID) || "".equals(domain))) {
                String token = nonce + sessionID + this.m_installationKey;
                try {
                    MessageDigest digester = MessageDigest.getInstance("MD5");
                    digester.update(token.getBytes("UTF-8"));
                    token = EsdInternet.md5sumToString(digester);
                    this.m_cookieJar.put("esd-token", this.createCookie(domain, "esd-token", token, path, null, false));
                }
                catch (NoSuchAlgorithmException e) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    Logging.log.severe(sw.getBuffer().toString());
                    if (!Globals.g_quietMode) {
                        Logging.log.severe(bundle.messageString("Common.ESD.UnexpectedError.txt"));
                        CustMsgBox.showMessageDialog(null, bundle.messageString("Common.ESD.UnexpectedError.txt"), bundle.getString("Common.Error.txt"), 0);
                    }
                    Globals.g_kit.exitKit(-1);
                }
            }
            if (this.m_cookieJar.get("esd-etag") == null) {
                this.m_lastModified = internet.getHeader("Last-Modified");
                this.m_ETag = internet.getHeader("ETag");
            } else {
                this.m_lastModified = null;
                this.m_ETag = null;
            }
            Globals.g_cookies = this.combineAllCookies();
            if (!this.m_reloadCookies) return;
            Logging.log.finer("Reloaded cookies");
            this.m_reloadCookies = false;
            return;
        }
        if (this.isNotModified()) return;
        Logging.log.severe("Failed to download Control file from link: " + finalUrl);
    }

    private void clearAuthCookies() {
        this.m_cookieJar.remove("esd-token");
        this.m_cookieJar.remove("esd-nonce");
        this.m_cookieJar.remove("esd-session");
    }

    private boolean updateCookies() {
        Globals.g_cookies = this.combineAllCookies();
        return true;
    }

    private ArrayList<Cookie> combineAllCookies() {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(this.m_cookieJar.values());
        this.updateCookiesForAllDomains(cookies);
        return cookies;
    }

    private void updateCookiesForAllDomains(List<Cookie> cookies) {
        if (cookies == null) {
            return;
        }
        Pattern pattern = Pattern.compile("^https?://(.*?)/.*");
        HashSet<String> controlFileHostnames = new HashSet<String>();
        controlFileHostnames.add(BackupHost);
        if (this.m_fullControlList != null) {
            for (EsdPart part : this.m_fullControlList) {
                Matcher matcher = pattern.matcher(part.getLink());
                if (!matcher.matches()) continue;
                controlFileHostnames.add(matcher.group(1));
            }
        }
        if (!controlFileHostnames.isEmpty()) {
            LinkedHashSet<Cookie> newCookies = new LinkedHashSet<Cookie>();
            for (Cookie cookie : cookies) {
                String cookieDomainStr = cookie.getDomain();
                ((BasicClientCookie)cookie).setExpiryDate(null);
                int numOfDomainElements = 0;
                for (int i = 0; i < cookieDomainStr.length(); ++i) {
                    if (cookieDomainStr.charAt(i) != '.') continue;
                    ++numOfDomainElements;
                }
                for (String controlHostnameStr : controlFileHostnames) {
                    int lastIndex = controlHostnameStr.length();
                    for (int i = 0; i < numOfDomainElements; ++i) {
                        lastIndex = controlHostnameStr.lastIndexOf(46, lastIndex - 1);
                    }
                    String controlDomain = controlHostnameStr.substring(lastIndex, controlHostnameStr.length());
                    if (controlDomain.equals(cookieDomainStr)) continue;
                    newCookies.add(this.createCookie(controlDomain, cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getExpiryDate(), cookie.isSecure()));
                }
            }
            cookies.addAll(newCookies);
        }
    }

    private String encryptCookie(String cookieValue) throws Exception {
        byte[] encrypted = null;
        byte[] fourRandBytes = new byte[4];
        new Random().nextBytes(fourRandBytes);
        MessageDigest digester = null;
        digester = MessageDigest.getInstance("MD5");
        digester.update(CREDENTIALS_PASSWORD.getBytes("UTF-8"));
        digester.update(fourRandBytes);
        byte[] dd = digester.digest();
        Class<?> sks = Class.forName("javax.crypto.spec.SecretKeySpec");
        Constructor<?> c1 = sks.getConstructor(Array.newInstance(Byte.TYPE, dd.length).getClass(), String.class);
        Object sksI = c1.newInstance(dd, "Blowfish");
        Class<?> ips = Class.forName("javax.crypto.spec.IvParameterSpec");
        Constructor<?> c2 = ips.getConstructor(Array.newInstance(Byte.TYPE, IV.getBytes("UTF-8").length).getClass());
        Object ipsI = c2.newInstance(new Object[]{IV.getBytes("UTF-8")});
        Globals.g_cipher.init(1, (Key)((SecretKeySpec)sksI), (IvParameterSpec)ipsI);
        encrypted = Globals.g_cipher.doFinal(cookieValue.getBytes("UTF-8"));
        byte[] concat = new byte[fourRandBytes.length + encrypted.length];
        System.arraycopy(fourRandBytes, 0, concat, 0, fourRandBytes.length);
        System.arraycopy(encrypted, 0, concat, fourRandBytes.length, encrypted.length);
        return "e" + BASE64.encode(concat);
    }

    private void decrypt(String fileToDecrypt) {
        String newFile = null;
        File ftd = new File(fileToDecrypt);
        if (!ftd.exists()) {
            return;
        }
        newFile = fileToDecrypt + ".new";
        File nf = new File(newFile);
        if (nf == null) {
            return;
        }
        try {
            RandomAccessFile rf = new RandomAccessFile(ftd, "r");
            int size = (int)rf.length();
            byte[] imext = new byte[size];
            rf.readFully(imext);
            rf.close();
            byte[] buffer = BASE64.decode(new String(imext, "UTF-8"));
            byte[] ivBuf = new byte[4];
            System.arraycopy(buffer, 0, ivBuf, 0, 4);
            byte[] data = new byte[buffer.length - 4];
            System.arraycopy(buffer, 4, data, 0, buffer.length - 4);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(CREDENTIALS_PASSWORD.getBytes("UTF-8"));
            md.update(ivBuf);
            byte[] kbytes = md.digest();
            Class<?> sks = Class.forName("javax.crypto.spec.SecretKeySpec");
            Constructor<?> c1 = sks.getConstructor(Array.newInstance(Byte.TYPE, kbytes.length).getClass(), String.class);
            Object sksI = c1.newInstance(kbytes, "Blowfish");
            Class<?> ips = Class.forName("javax.crypto.spec.IvParameterSpec");
            Constructor<?> c2 = ips.getConstructor(Array.newInstance(Byte.TYPE, IV.getBytes("UTF-8").length).getClass());
            Object ipsI = c2.newInstance(new Object[]{IV.getBytes("UTF-8")});
            Globals.g_cipher.init(2, (Key)((SecretKeySpec)sksI), (IvParameterSpec)ipsI);
            byte[] decrypted = Globals.g_cipher.doFinal(data);
            FileOutputStream fos = new FileOutputStream(newFile);
            fos.write(decrypted);
            fos.close();
            new File(fileToDecrypt).delete();
            new File(newFile).renameTo(new File(fileToDecrypt));
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            Logging.log.severe(sw.getBuffer().toString());
            return;
        }
    }

    private boolean parseControlData() {
        boolean result = false;
        try {
            EsdControlData ecd = new EsdControlData(this.m_controlFilename);
            Logging.log.finer("DLM control file version check:  DLM=2 -- controlfile=" + ecd.getVersion());
            if (ecd.getVersion() > 2) {
                Logging.log.severe("DLM manager is out of date.  DLM=2 while controlfile=" + ecd.getVersion());
                ShowDLMOutOfDateMsg msg = new ShowDLMOutOfDateMsg();
                msg.showMsg();
                Globals.g_kit.exitKit(-1);
            }
            if (ecd.getType().equalsIgnoreCase("set")) {
                if (!Globals.g_quietMode) {
                    Logging.log.severe(bundle.getString("EsdControl.RenewalOrder.txt"));
                    CustMsgBox.showMessageDialog(null, bundle.getString("EsdControl.RenewalOrder.txt"), bundle.getString("Common.Error.txt"), 2);
                }
                result = false;
            }
            if (ecd.getPipeline() != null) {
                this.m_redirectRequested = true;
                this.m_authServer = "http://" + ecd.getPipeline() + "/esd";
                result = false;
            } else if (ecd.getStatus().equalsIgnoreCase("ok")) {
                this.m_statusFromControl = 0;
                this.m_fullControlList = ecd.getParts();
                for (EsdPart part : this.m_fullControlList) {
                    this.m_altSku2EsdPart.put(part.getAltSku(), part);
                }
                result = true;
            } else if (ecd.getStatus().equalsIgnoreCase("hold")) {
                this.m_statusFromControl = 3;
                result = false;
            } else if (ecd.getStatus().equalsIgnoreCase("cancel")) {
                this.m_statusFromControl = 4;
                result = false;
            }
            this.m_hasMessageFromControl = false;
            String message = ecd.getMessage();
            if (message != null && message.trim().length() > 0) {
                this.m_hasMessageFromControl = true;
                this.m_messageFromControl = message;
            }
        }
        catch (FileNotFoundException e) {
            Logging.log.severe("File Not Found Error while parsing Control Data.");
            this.m_valid_control = 2;
            result = false;
        }
        catch (IOException e) {
            Logging.log.severe("IO Error while parsing Control Data.");
            this.m_valid_control = 2;
            result = false;
        }
        catch (ParserConfigurationException e) {
            Logging.log.severe("Parser Config Error while parsing Control Data.");
            this.m_valid_control = 2;
            result = false;
        }
        catch (SAXException e) {
            Logging.log.severe("SAX parse Error while parsing Control Data.");
            this.m_valid_control = 2;
            result = false;
        }
        return result;
    }

    private boolean checkEncryption() {
        if (Globals.g_cipher != null) {
            return true;
        }
        for (EsdPart part : this.m_fullControlList) {
            if (!part.getLocalFilename().endsWith(".ezip") && part.getType().indexOf(69) < 0) continue;
            Logging.log.warning("Tried to use encryption, but encryption libraries don't exist!");
            return false;
        }
        return true;
    }

    private boolean downloadCustomContent() throws IOException {
        if (this.m_fullControlList == null) {
            return true;
        }
        EsdInternet internet = new EsdInternet();
        Globals.g_cookies = this.combineAllCookies();
        internet.setCookies(Globals.g_cookies);
        EsdPart customContentPart = this.m_fullControlList.removeFirst();
        this.m_tmpCustomContentZipFile = Utils.joinPath(this.m_tmpWorkDirectory, customContentPart.getLocalFilename());
        if (Globals.g_protocol == 0) {
            internet.downloadFileRetries(customContentPart.getLink(), this.m_tmpCustomContentZipFile, false, customContentPart);
            this.m_status_xml = internet.getStatus();
        } else {
            String link = customContentPart.getLink();
            int chopPoint = link.indexOf("/esd/");
            link = link.substring(0, chopPoint) + "/esd/0000-0000-0000/000000/xmlpackage";
            internet.downloadFileRetries(link.toString(), this.m_tmpCustomContentZipFile, false, customContentPart);
            this.m_status_xml = internet.getStatus();
        }
        return this.isValid();
    }

    private boolean processCustomContent() {
        boolean result = true;
        try {
            Unzip.getAll(this.m_tmpCustomContentZipFile, this.m_tmpWorkDirectory);
        }
        catch (FileNotFoundException e) {
            Logging.log.severe("File Not Found Error while processing Custom Content.");
            this.m_valid_xml = 2;
            result = false;
        }
        catch (ZipException e) {
            Logging.log.severe("Zip Error while processing Custom Content.");
            this.m_valid_xml = 2;
            result = false;
        }
        catch (IOException e) {
            Logging.log.severe("IO Error while processing Custom Content.");
            this.m_valid_xml = 2;
            result = false;
        }
        if (!new File(this.m_tmpCustomContentZipFile).delete()) {
            Logging.log.severe("Could not delete file:" + this.m_tmpCustomContentZipFile);
        }
        return result;
    }

    public void writeControlToSSD(String ssdPath) {
        String tempPath = Utils.joinPath(ssdPath, ControlBasename);
        tempPath.replaceAll("%%%", "");
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(tempPath)));
            for (EsdPart line : this.m_fullControlList) {
                out.println(line);
            }
            out.close();
        }
        catch (Exception e) {
            Logging.log.info(e.getMessage());
            System.err.println(e.getLocalizedMessage());
        }
    }

    public String[] getDownloadLinks() {
        String[] retString = new String[this.m_downloadControlList.size()];
        int i = 0;
        for (EsdPart part : this.m_downloadControlList) {
            retString[i++] = part.getLink();
        }
        return retString;
    }

    public long getTotalDownloadSize() {
        if (this.m_downloadSize != 0L) {
            return this.m_downloadSize;
        }
        long retValue = 0L;
        if (this.m_downloadControlList == null) {
            return retValue;
        }
        for (EsdPart part : this.m_downloadControlList) {
            retValue += part.getSizeCompressed();
        }
        this.m_downloadSize = retValue;
        return retValue;
    }

    public long getRemainingDownloadSize() {
        long retValue = 0L;
        if (this.m_downloadControlList == null) {
            return retValue;
        }
        for (EsdPart part : this.m_downloadControlList) {
            File fd;
            if (!part.isDownloaded()) {
                retValue += part.getSizeCompressed();
            }
            if (!(fd = new File(part.getFullPath())).exists()) continue;
            retValue -= fd.length();
        }
        return retValue;
    }

    public long getTotalExtractSize() {
        long retValue = 0L;
        if (this.m_downloadControlList == null) {
            return retValue;
        }
        for (EsdPart part : this.m_downloadControlList) {
            retValue += part.getSizeUncompressed();
        }
        return retValue;
    }

    public long getRemainingExtractSize() {
        long retValue = 0L;
        if (this.m_downloadControlList == null) {
            return retValue;
        }
        for (EsdPart part : this.m_downloadControlList) {
            if (part.isExpanded()) continue;
            retValue += part.getSizeUncompressed();
        }
        return retValue;
    }

    public void resolve(EsdControl olderEsdControl, LinkedList<EsdPart> partDownloadList, LinkedList partExpandList, LinkedList partDoneList) {
        LinkedList<EsdPart> removedParts;
        LinkedList<EsdPart> newParts;
        this.m_downloadSize = 0L;
        LinkedList<EsdPart> changedParts = new LinkedList<EsdPart>();
        for (EsdPart oldPart : olderEsdControl.getDownloadControlList()) {
            EsdPart newPart = this.getPart(oldPart.getAltSku());
            if (newPart == null) continue;
            newPart.setRetries(0);
            newPart.setFullPath(Utils.joinPath(Globals.g_downloadDir, newPart.getAltSku(), newPart.getLocalFilename()));
            if (!oldPart.getChecksum().equals(newPart.getChecksum())) {
                newPart.setDownloaded(false);
                newPart.setExpanded(false);
                changedParts.add(oldPart);
                continue;
            }
            newPart.setDownloaded(oldPart.isDownloaded());
            newPart.setExpanded(oldPart.isExpanded());
        }
        if (changedParts != null && changedParts.size() > 0) {
            this.smashDirectories(changedParts);
            Logging.log.info("Parts Changed:" + changedParts);
        }
        if ((newParts = this.this_but_not_that(this.m_downloadControlList, olderEsdControl.getDownloadControlList())) != null && newParts.size() > 0) {
            for (EsdPart part : newParts) {
                if (!"".equals(part.getFullPath())) continue;
                part.setDownloaded(false);
                part.setExpanded(false);
                part.setRetries(0);
                part.setFullPath(Utils.joinPath(Globals.g_downloadDir, part.getAltSku(), part.getLocalFilename()));
            }
            partDownloadList.addAll(newParts);
            Logging.log.info("Parts Added:" + newParts);
        }
        if ((removedParts = this.this_but_not_that(olderEsdControl.getDownloadControlList(), this.m_downloadControlList)) != null && removedParts.size() > 0) {
            this.removePartsFromList(this.m_downloadControlList, removedParts);
            this.smashDirectories(removedParts);
            Logging.log.info("Parts Removed:" + removedParts);
        }
        Logging.log.finer("Resolve: " + newParts.size() + " new parts, " + removedParts.size() + " removed parts, " + changedParts.size() + " changed parts.");
        if (newParts.size() != 0 || removedParts.size() != 0 || changedParts.size() != 0) {
            Globals.g_esdStats.eventMsg("EsdDownloadStats.OrderUpdated.txt", newParts.size(), removedParts.size(), changedParts.size());
        }
    }

    private String toZeroPaddedString(int i, int len) {
        String s = Integer.toString(i);
        if (s.length() > len) {
            return s.substring(0, len);
        }
        if (s.length() < len) {
            return "0000000000".substring(0, len - s.length()) + s;
        }
        return s;
    }

    private void smashDirectories(LinkedList<EsdPart> removedParts) {
        for (EsdPart part : removedParts) {
            Utils.deleteFolder(new File(part.getFullPath()).getParentFile());
        }
    }

    private LinkedList<EsdPart> this_but_not_that(LinkedList<EsdPart> thisList, LinkedList<EsdPart> thatList) {
        HashMap<String, EsdPart> thisListHash = new HashMap<String, EsdPart>();
        HashSet<String> thisListSet = new HashSet<String>();
        HashSet<String> thatListSet = new HashSet<String>();
        for (EsdPart part : thisList) {
            thisListHash.put(part.getAltSku(), part);
            thisListSet.add(part.getAltSku());
        }
        for (EsdPart part : thatList) {
            thatListSet.add(part.getAltSku());
        }
        HashSet finalSet = (HashSet)thisListSet.clone();
        finalSet.removeAll(thatListSet);
        LinkedList<EsdPart> finalList = new LinkedList<EsdPart>();
        Iterator i = finalSet.iterator();
        while (i.hasNext()) {
            finalList.add((EsdPart)thisListHash.get(i.next()));
        }
        return finalList;
    }

    private void removePartsFromList(LinkedList<EsdPart> list, LinkedList<EsdPart> parts) {
        for (EsdPart aPart : parts) {
            ListIterator i = list.listIterator();
            while (i.hasNext()) {
                EsdPart iPart = (EsdPart)i.next();
                if (!iPart.getAltSku().equals(aPart.getAltSku())) continue;
                i.remove();
            }
        }
    }

    public boolean requiresAuthentication() {
        if (this.m_serverProtocolVersion == 1) {
            return this.m_status_control == 401;
        }
        return this.m_status_control == 402;
    }

    public boolean authenticationDenied() {
        return this.m_status_control == 409;
    }

    public boolean problemWithTCP() {
        return this.m_status_control == 503;
    }

    public boolean isNewDownload() {
        return this.m_status_control == 200;
    }

    public boolean isValid() {
        return !(this.m_status_control != 200 && this.m_status_control != 304 && this.m_status_control != 204 || this.m_status_xml != 200 && this.m_status_xml != 0 || this.m_valid_control != 0 || this.m_valid_xml != 0);
    }

    public boolean isNotModified() {
        return this.m_status_control == 304 || this.m_status_control == 204;
    }

    public boolean isOnHold() {
        return this.m_statusFromControl == 3;
    }

    public boolean isCanceled() {
        return this.m_statusFromControl == 4;
    }

    public String retrieveRealMessage(String messageFromControl) {
        String message = null;
        message = bundle.getRawString("EsdControl.ServerMessage." + messageFromControl + ".txt");
        return message == null ? messageFromControl : message;
    }

    private boolean checkCancel(String message) {
        if (!this.isValid() && this.isCanceled()) {
            if (this.m_hasMessageFromControl) {
                message = this.retrieveRealMessage(this.m_messageFromControl);
            }
            if (!Globals.g_quietMode) {
                Logging.log.severe(message);
                CustMsgBox.showMessageDialog(null, message, bundle.getString("EsdControl.ServerMessage.txt"), 0);
            }
            this.sendSignal("release");
            return true;
        }
        return false;
    }

    public boolean checkCancelAndContinue() {
        String message = bundle.getString("EsdControl.CancelContinue.txt");
        if (this.checkCancel(message)) {
            Logging.log.info("Order Cancel received, continuing...");
            return true;
        }
        return false;
    }

    public void checkCancelAndDie() {
        String message = bundle.getString("EsdControl.CancelDie.txt");
        if (this.checkCancel(message)) {
            Logging.log.info("Order Cancel received, shutting down...");
            DownloadLogger dl = new DownloadLogger();
            dl.finalStatus("orderCanceled");
            dl.Send();
            Utils.deleteFolder(new File(Globals.g_downloadDir));
            Globals.g_kit.exitKit(-1);
        }
    }

    public boolean checkHold(String message) {
        String messageTitle = bundle.getString("EsdControl.HoldTitle.txt");
        if (!this.isValid() && this.isOnHold()) {
            if (this.m_hasMessageFromControl) {
                message = this.retrieveRealMessage(this.m_messageFromControl);
                messageTitle = bundle.getString("EsdControl.ServerMessage.txt");
            }
            if (!Globals.g_quietMode) {
                Logging.log.severe(message);
                CustMsgBox.showMessageDialog(null, message, messageTitle, 0);
            }
            return true;
        }
        return false;
    }

    public boolean checkHoldRetryAndContinue() {
        String message = bundle.getString("EsdControl.HoldContinue.txt");
        boolean returnCode = false;
        if (this.checkHold(message)) {
            HoldCheck hc = new HoldCheck();
            if (hc.holdDialog()) {
                returnCode = true;
            } else {
                Logging.log.info("Order is on hold, and the user has decided to Quit");
                DownloadLogger dl = new DownloadLogger();
                dl.finalStatus("userQuitFromHold");
                dl.Send();
                Globals.g_kit.exitKit(-1);
            }
        }
        return returnCode;
    }

    public boolean checkHoldAndContinue() {
        String message = bundle.getString("EsdControl.HoldContinue.txt");
        return this.checkHold(message);
    }

    public void checkHoldAndDie() {
        String message = bundle.getString("EsdControl.HoldDie.txt");
        String messageTitle = bundle.getString("EsdControl.HoldTitle.txt");
        if (!this.isValid() && this.isOnHold()) {
            if (this.m_hasMessageFromControl) {
                message = this.retrieveRealMessage(this.m_messageFromControl);
                messageTitle = bundle.getString("EsdControl.ServerMessage.txt");
            }
            if (!Globals.g_quietMode) {
                Logging.log.severe(message);
                CustMsgBox.showMessageDialog(null, message, messageTitle, 0);
            }
            Logging.log.info("Order Hold received, shutting down...");
            Globals.g_kit.exitKit(-1);
        }
    }

    public void checkRetry() {
        RetryCheck rc = new RetryCheck();
        if (!rc.retryDialog()) {
            Logging.log.info("Control file download is failing, and the user has decided to Quit");
            DownloadLogger dl = new DownloadLogger();
            dl.finalStatus("controlDownloadErrors");
            dl.Send();
            Globals.g_kit.exitKit(-1);
        }
    }

    public void sendSignal(String signal) {
        EsdInternet internet = new EsdInternet();
        internet.setCookies(Globals.g_cookies);
        try {
            internet.downloadFileRetries(Globals.g_url + "/" + signal, null, false);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            Logging.log.severe("Error sending signal: " + signal + "\n" + sw.getBuffer().toString());
            return;
        }
        Logging.log.info("Sent signal: " + signal + "  Got status: " + internet.getStatus());
    }

    public int checkProtocolVersion(String baseUrl) {
        EsdInternet internet = new EsdInternet();
        int serverProtocolVersion = -1;
        for (int i = 0; i <= 23 && serverProtocolVersion == -1; ++i) {
            int pvToTest = i == 0 ? 18 : i;
            internet = new EsdInternet();
            try {
                internet.downloadFileRetries(baseUrl + "/version/" + pvToTest, null, false);
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                Logging.log.severe("Error checking protocol version: " + sw.getBuffer().toString());
                return -1;
            }
            Logging.log.finer("Sent Protocol Version Check (" + pvToTest + ") : Got status: " + internet.getStatus());
            if (internet.getStatus() == 200) {
                serverProtocolVersion = pvToTest;
                Logging.log.finer("Server Protocol version is " + pvToTest + " and client is " + 18);
                continue;
            }
            if (internet.getStatus() == 415) {
                Logging.log.finest("Server Protocol is not " + pvToTest + " and client is " + 18);
                continue;
            }
            Logging.log.warning("Sent Protocol Version Check (" + pvToTest + ") : Got status: " + internet.getStatus());
        }
        if (18 < serverProtocolVersion) {
            Logging.log.severe("DLM manager is out of date.  Server Protocol Version is " + serverProtocolVersion + " and client is " + 18);
            ShowDLMOutOfDateMsg msg = new ShowDLMOutOfDateMsg();
            msg.showMsg();
            Globals.g_kit.exitKit(-1);
        }
        return serverProtocolVersion;
    }

    private void setStatus(EsdInternet internet) {
        String lastModified = internet.getHeader("Last-Modified");
        String eTag = internet.getHeader("ETag");
        Cookie eTagInternet = this.getCookie("esd-etag", internet);
        Cookie eTagLocal = this.m_cookieJar.get("esd-etag");
        this.m_status_control = internet.getStatus();
        if (internet.getStatus() == 200) {
            if (eTagInternet != null && eTagLocal != null && eTagInternet.getValue().equals(eTagLocal.getValue())) {
                this.m_status_control = 204;
                Logging.log.finer("Got 200 back from server instead of 204--changing status to 204 anyway and reloading cookies.");
                this.m_reloadCookies = true;
            } else if (!"".equals(this.m_lastModified) && lastModified != null && lastModified.equalsIgnoreCase(this.m_lastModified) && !"".equals(this.m_ETag) && eTag != null && eTag.equalsIgnoreCase(this.m_ETag)) {
                this.m_status_control = 304;
                Logging.log.finer("Got 200 back from server instead of 304--changing status to 304 anyway and reloading cookies.");
                this.m_reloadCookies = true;
            }
        }
    }

    private Cookie getCookie(String cookieName, EsdInternet internet) {
        if (cookieName == null || internet == null) {
            return null;
        }
        List<Cookie> cookies = internet.getCookies();
        for (Cookie cookie : cookies) {
            if (!cookieName.equals(cookie.getName()) || !ControlURLDomain.equals(cookie.getDomain())) continue;
            return cookie;
        }
        return null;
    }

    public Cookie createCookie(String domain, String name, String value, String path, Date expires, boolean secure) {
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        cookie.setDomain(domain);
        cookie.setPath(path);
        cookie.setExpiryDate(expires);
        cookie.setSecure(secure);
        cookie.setAttribute("domain", "true");
        return cookie;
    }

    private void SetServerNames() {
        if (Globals.g_httponly) {
            ControlURL = "http://esd.sas.com/esd";
            TestControlURL = "http://esdtest.unx.sas.com/esd";
            DevControlURL = "http://esddev.unx.sas.com/esd";
            SoftwareDepotControlURL = "http://softwaredepot.sas.com/esd";
            TestPipe01URL = "http://esdtestpipe01.unx.sas.com/esd";
            TestPipe02URL = "http://esdtestpipe02.unx.sas.com/esd";
            TweekControlURL = "http://tweek.unx.sas.com/esd";
            LocalHostURL = "http://localhost/esd";
            BackupHost = "hq.esd.sasinstitute.net";
        } else {
            ControlURL = "https://tlsesd.sas.com/esd";
            TestControlURL = "https://tlsesdtest.unx.sas.com/esd";
            DevControlURL = "https://tlsesddev.unx.sas.com/esd";
            SoftwareDepotControlURL = "https://softwaredepot.sas.com/esd";
            TestPipe01URL = "https://tlsesdtestpipe01.unx.sas.com/esd";
            TestPipe02URL = "https://tlsesdtestpipe02.unx.sas.com/esd";
            TweekControlURL = "https://tlstweek.unx.sas.com/esd";
            LocalHostURL = "https://localhost/esd";
            BackupHost = "tlshq.esd.sasinstitute.net";
        }
    }

    public LinkedList<EsdPart> get_controlList() {
        return this.m_fullControlList;
    }

    public void set_controlList(LinkedList<EsdPart> list) {
        this.m_fullControlList = list;
    }

    public String getTmpWorkDirectory() {
        return this.m_tmpWorkDirectory;
    }

    public void setAltSkuList(String[] spsSkusToProcess) {
        this.m_downloadControlList = new LinkedList();
        for (int i = 0; i < spsSkusToProcess.length; ++i) {
            if (!this.m_altSku2EsdPart.containsKey(spsSkusToProcess[i])) continue;
            this.m_downloadControlList.add(this.m_altSku2EsdPart.get(spsSkusToProcess[i]));
        }
    }

    public LinkedList<EsdPart> getDownloadControlList() {
        return this.m_downloadControlList;
    }

    public int getDownloadControlListSize() {
        return this.m_downloadControlList.size();
    }

    public String getETag() {
        return this.m_ETag;
    }

    public String getLastModified() {
        return this.m_lastModified;
    }

    public String getInstallationKey() {
        return this.m_installationKey;
    }

    public String getOrderNumber() {
        return this.m_orderNumber;
    }

    public String getFullOrderNumber() {
        return this.m_fullOrderNumber;
    }

    public String getOrderDesc() {
        return this.m_orderDesc;
    }

    public void setOrderDesc(String desc) {
        this.m_orderDesc = desc;
    }

    public int getControlFileIncrement() {
        return this.m_controlFileIncrement + 1;
    }

    public void setControlFileIncrement(int controlFileIncrement) {
        this.m_controlFileIncrement = controlFileIncrement;
    }

    public static ArrayList deepCopy(ArrayList list) {
        ArrayList newlist = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(10240);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(list);
            byte[] buf = baos.toByteArray();
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            ObjectInputStream ois = new ObjectInputStream(bais);
            newlist = (ArrayList)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            newlist = null;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            Logging.log.severe(sw.getBuffer().toString());
        }
        return newlist;
    }

    public String getCurrentNonce() {
        return this.m_currentNonce;
    }

    public void setCurrentNonce(String nonce) {
        this.m_currentNonce = nonce;
    }

    public String getFirstNonce() {
        return this.m_firstNonce;
    }

    public void setFirstNonce(String nonce) {
        this.m_firstNonce = nonce;
    }

    public String getLastNonce() {
        return this.m_lastNonce;
    }

    public void setLastNonce(String nonce) {
        this.m_lastNonce = nonce;
    }

    public EsdPart getPart(String altSku) {
        if (altSku == null) {
            return null;
        }
        for (EsdPart part : this.m_downloadControlList) {
            if (!altSku.equals(part.getAltSku())) continue;
            return part;
        }
        return null;
    }

    public void renumber(LinkedList partDownloadList) {
        int i = this.m_downloadControlList.size() - partDownloadList.size() + 1;
        for (EsdPart part : partDownloadList) {
            part.setFileNum(i++);
        }
    }

    public boolean isDisableCancel() {
        return this.disableCancel;
    }

    public void setDisableCancel(boolean disableCancel) {
        this.disableCancel = disableCancel;
    }

    public String get_baseUrl() {
        return this.m_baseUrl;
    }

    public String get_authServer() {
        return this.m_authServer;
    }

    public HashMap<String, Cookie> getCookieJar() {
        return this.m_cookieJar;
    }

    public boolean getDepotCompression() {
        return this.m_depotCompression;
    }

    public void setDepotCompression(boolean compressDepot) {
        this.m_depotCompression = compressDepot;
    }

    private class ShowDLMOutOfDateMsg
    implements HyperlinkListener {
        private ShowDLMOutOfDateMsg() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                KitAction.launchWebBrowser(event.getURL());
            }
        }

        public void showMsg() {
            JEditorPane msgArea = new JEditorPane();
            msgArea.setOpaque(false);
            msgArea.setEditable(false);
            msgArea.setContentType("text/html");
            msgArea.addHyperlinkListener(this);
            String msgPrefix = "<html><font size=4 face=\"" + Globals.g_wizard.getCancelButton().getFont().getFontName() + "\">";
            String msgPostfix = "</font></html>";
            Object[] options = new Object[]{Util.getLabelWithoutMnemonic(bundle.getString("Common.OK.txt"))};
            String title = bundle.getString("EsdControl.DLMOutOfDateTitle.txt");
            String msgTxt = bundle.getString("EsdControl.DLMOutOfDate.txt");
            msgArea.setText(msgPrefix + msgTxt + msgPostfix);
            msgArea.setCaretPosition(0);
            if (Globals.g_consoleMode) {
                ConsoleMode.printInfoText(msgTxt);
                ConsoleMode.promptPause(true, false);
            } else {
                JOptionPane.showOptionDialog(Globals.g_wizard.getFrame(), msgArea, title, 2, 0, null, options, options[0]);
            }
        }
    }

    class HoldCheck
    implements RetryIface {
        private boolean allowRetry = false;

        HoldCheck() {
        }

        public boolean holdDialog() {
            this.allowRetry = false;
            if (Globals.g_consoleMode) {
                DlgRetryESDConsole dlgRetryESDConsole = new DlgRetryESDConsole(this, 300, bundle.getString("EsdControl.Hold.Title.txt"), bundle.getString("EsdControl.Hold.Message.txt"), bundle.getString("EsdControl.Hold.Countdown.txt"), bundle.getString("EsdControl.Hold.Cancel.txt"));
                return this.allowRetry;
            }
            DlgRetryESD dlgRetryESD = new DlgRetryESD(Globals.g_wizard == null ? null : Globals.g_wizard.getFrame(), this, 300, bundle.getString("EsdControl.Hold.Title.txt"), bundle.getString("EsdControl.Hold.Message.txt"), bundle.getString("EsdControl.Hold.Countdown.txt"), bundle.getString("EsdControl.Hold.Cancel.txt"));
            dlgRetryESD.setVisible(true);
            return this.allowRetry;
        }

        @Override
        public void retry() {
            this.allowRetry = true;
        }
    }

    class RetryCheck
    implements RetryIface {
        private boolean allowRetry = false;

        RetryCheck() {
        }

        public boolean retryDialog() {
            this.allowRetry = false;
            if (Globals.g_consoleMode) {
                DlgRetryESDConsole dlgRetryESDConsole = new DlgRetryESDConsole(this, 60, bundle.getString("EsdControl.Retry.Title.txt"), bundle.getString("EsdControl.Retry.Message.txt"), bundle.getString("EsdControl.Retry.Countdown.txt"), bundle.getString("EsdControl.Retry.Cancel.txt"));
                return this.allowRetry;
            }
            DlgRetryESD dlgRetryESD = new DlgRetryESD(Globals.g_wizard == null ? null : Globals.g_wizard.getFrame(), this, 60, bundle.getString("EsdControl.Retry.Title.txt"), bundle.getString("EsdControl.Retry.Message.txt"), bundle.getString("EsdControl.Retry.Countdown.txt"), bundle.getString("EsdControl.Retry.Cancel.txt"));
            dlgRetryESD.setVisible(true);
            return this.allowRetry;
        }

        @Override
        public void retry() {
            this.allowRetry = true;
        }
    }
}

