/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.KitTextField;
import com.sas.ssn.SSNResource;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class DlgUserNamePassword
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -2321820701622185569L;
    private SSNResource bundle = new SSNResource(DlgUserNamePassword.class);
    private JPanel m_contentPane = null;
    private JPanel m_buttonPanel = null;
    private JLabel m_userNameLabel = null;
    private KitTextField m_userName = null;
    private JLabel m_passwordLabel = null;
    private JPasswordField m_password = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private cKeyHandler m_keyHandler = new cKeyHandler();
    private boolean m_cancelled = false;

    public DlgUserNamePassword(JFrame parent) {
        this.initialize();
        this.m_contentPane = new JPanel(new GridBagLayout());
        this.m_buttonPanel = new JPanel();
        this.layoutWidgets();
        this.setTitle(this.bundle.getString("DlgUserNamePassword.Title.txt"));
        this.pack();
        this.resizeButtons();
        this.setSize(this.getPreferredSize());
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
        this.setModal(true);
    }

    private int consoleEvent() {
        int returnCode = ConsoleMode.promptText(this.m_userNameLabel.getText(), this.m_userName);
        returnCode = returnCode > -1 ? ConsoleMode.promptPassword(this.m_passwordLabel.getText(), this.m_password) : -1;
        return returnCode;
    }

    private void initialize() {
        this.m_userName = new KitTextField();
        String mtxt = this.bundle.getString("DlgUserNamePassword.UserName.txt");
        this.m_userNameLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_userNameLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_userNameLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_userNameLabel.setLabelFor(this.m_userName);
        this.m_password = new JPasswordField();
        mtxt = this.bundle.getString("DlgUserNamePassword.Password.txt");
        this.m_passwordLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_passwordLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_passwordLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_passwordLabel.setLabelFor(this.m_password);
        mtxt = this.bundle.getString("Common.OK.txt");
        this.m_okButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_okButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_okButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_okButton.addActionListener(this);
        mtxt = this.bundle.getString("Common.Cancel.txt");
        this.m_cancelButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_cancelButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_cancelButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.m_okButton);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        this.layoutButtons();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(10, 10, 0, 5);
        this.m_contentPane.add((Component)this.m_userNameLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 13;
        c.insets = new Insets(10, 0, 0, 10);
        this.m_contentPane.add((Component)this.m_userName, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(10, 10, 0, 5);
        this.m_contentPane.add((Component)this.m_passwordLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 13;
        c.insets = new Insets(10, 0, 0, 10);
        this.m_contentPane.add((Component)this.m_password, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 15;
        c.insets = new Insets(10, 10, 10, 10);
        this.m_contentPane.add((Component)this.m_buttonPanel, c);
        this.m_contentPane.setOpaque(true);
        this.setContentPane(this.m_contentPane);
        this.addKeyListeners(this, this.m_keyHandler);
    }

    private void layoutButtons() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weighty = 1.0;
        c.fill = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_buttonPanel.add((Component)this.m_okButton, c);
        c.gridx = 1;
        c.weightx = 0.0;
        c.anchor = 13;
        c.insets = new Insets(20, 10, 0, 0);
        this.m_buttonPanel.add((Component)this.m_cancelButton, c);
    }

    private void resizeButtons() {
        double width = Math.max(this.m_okButton.getSize().getWidth(), this.m_cancelButton.getSize().getWidth());
        double height = Math.max(this.m_okButton.getSize().getHeight(), this.m_cancelButton.getSize().getHeight());
        Dimension buttonSize = new Dimension();
        buttonSize.setSize(width, height);
        this.m_okButton.setPreferredSize(buttonSize);
        this.m_cancelButton.setPreferredSize(buttonSize);
        float ratio = (float)this.bundle.getString("DlgUserNamePassword.Title.txt").length() / (float)this.bundle.getString("DlgUserNamePassword.UserName.txt").length();
        Dimension size = new Dimension();
        size.setSize(width * (double)ratio, height);
        this.m_userName.setPreferredSize(size);
        this.m_password.setPreferredSize(size);
    }

    private void onCancel() {
        this.m_cancelled = true;
        this.m_userName.setText("");
        this.m_password.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_cancelButton) {
            this.onCancel();
        }
        this.dispose();
    }

    public String getUserName() {
        return this.m_userName.getText();
    }

    public String getPassword() {
        return String.valueOf(this.m_password.getPassword());
    }

    public boolean cancelled() {
        return this.m_cancelled;
    }

    protected void addKeyListeners(Container container, cKeyHandler keyHandler) {
        Component[] componentArray = container.getComponents();
        int nComps = componentArray.length;
        for (int iComp = 0; iComp < nComps; ++iComp) {
            componentArray[iComp].addKeyListener(keyHandler);
            if (!(componentArray[iComp] instanceof Container)) continue;
            this.addKeyListeners((Container)componentArray[iComp], keyHandler);
        }
    }

    protected class cKeyHandler
    extends KeyAdapter {
        protected cKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int eKeyCode = e.getKeyCode();
            switch (eKeyCode) {
                case 27: {
                    DlgUserNamePassword.this.onCancel();
                    DlgUserNamePassword.this.dispose();
                }
            }
        }
    }
}

