/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.PanelSelectPlan;
import com.sas.ssn.SSNResource;
import com.sas.ssn.StandardDeploymentPlan;
import com.sas.ssn.Utils;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.Document;

public class DlgSelectPlan
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -3614195722211332813L;
    private SSNResource bundle = new SSNResource(DlgSelectPlan.class);
    private JComboBox numMachinesCombo = null;
    private TableRowSorter<StandardPlanTableModel> tableSorter = null;
    private RowFilter<StandardPlanTableModel, Integer> searchFilter = null;
    private RowFilter<StandardPlanTableModel, Integer> machCountFilter = null;
    private String filterString = null;
    private JTable table = null;
    private JTextField searchBox = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private StandardDeploymentPlan chosenStandardPlan = null;
    private PanelSelectPlan.StandardPlanComboBox parentStdPlanComboBox = null;
    private Map<String, StandardDeploymentPlan> plans = null;
    private SortedSet<String> machineCounts = null;
    private static final int DIALOG_WIDTH = 510;
    private static final int DIALOG_HEIGHT = 565;
    public static final float MIN_SWING_JAVA_VERSION = Float.parseFloat("1.6");

    public DlgSelectPlan(JFrame parent, PanelSelectPlan.StandardPlanComboBox stdPlanComboBox, Map<String, StandardDeploymentPlan> stdPlans, SortedSet<String> machCounts) {
        super((Frame)parent, true);
        this.setTitle(this.bundle.getString("PanelSelectPlan.Header.txt"));
        this.setSize(new Dimension(510, 565));
        this.setMinimumSize(new Dimension(510, 565));
        this.parentStdPlanComboBox = stdPlanComboBox;
        this.plans = stdPlans;
        this.machineCounts = machCounts;
        this.initialize();
        this.pack();
        this.resizeButtons();
        this.setLocationRelativeTo(parent);
        this.setResizable(true);
        this.setVisible(true);
    }

    private void initialize() {
        this.filterString = "";
        StandardPlanTableModel tableModel = new StandardPlanTableModel(this.plans, this.machineCounts);
        this.tableSorter = new TableRowSorter<StandardPlanTableModel>(tableModel);
        this.table = new JTable(tableModel){
            private static final long serialVersionUID = 8645682729657736857L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String toolTip = null;
                Point point = mouseEvent.getPoint();
                int rowIndex = this.rowAtPoint(point);
                int colIndex = this.columnAtPoint(point);
                int realColumnIndex = this.convertColumnIndexToModel(colIndex);
                if (realColumnIndex == 0 && rowIndex != -1) {
                    toolTip = (String)this.getModel().getValueAt(rowIndex, colIndex);
                }
                return toolTip;
            }
        };
        this.table.removeColumn(this.table.getColumnModel().getColumn(0));
        JPanel contentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gBagConstr = new GridBagConstraints();
        gBagConstr.gridheight = 1;
        JTextArea instructionsLabel = new JTextArea(this.bundle.getString("DlgSelectPlan.Instructions.txt"));
        instructionsLabel.setEditable(false);
        instructionsLabel.setFocusable(false);
        instructionsLabel.setLineWrap(true);
        instructionsLabel.setWrapStyleWord(true);
        instructionsLabel.setOpaque(false);
        gBagConstr.gridx = 0;
        gBagConstr.gridy = 0;
        gBagConstr.gridwidth = 6;
        gBagConstr.weightx = 1.0;
        gBagConstr.weighty = 0.0;
        gBagConstr.anchor = 23;
        gBagConstr.fill = 2;
        gBagConstr.insets = new Insets(15, 10, 5, 5);
        contentPanel.add((Component)instructionsLabel, gBagConstr);
        String searchLabelText = this.bundle.getString("DlgSelectPlan.Search.txt");
        JLabel searchLabel = new JLabel(Util.getLabelWithoutMnemonic(searchLabelText));
        searchLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(searchLabelText));
        searchLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(searchLabelText));
        searchLabel.setAlignmentY(1.0f);
        this.searchBox = new JTextField();
        searchLabel.setLabelFor(this.searchBox);
        gBagConstr.gridx = 0;
        gBagConstr.gridy = 1;
        gBagConstr.gridwidth = 1;
        gBagConstr.weightx = 0.0;
        gBagConstr.weighty = 0.0;
        gBagConstr.anchor = 23;
        gBagConstr.fill = 0;
        gBagConstr.insets = new Insets(15, 10, 5, 5);
        contentPanel.add((Component)searchLabel, gBagConstr);
        this.searchBox.setPreferredSize(new Dimension(325, 25));
        gBagConstr.gridx = 1;
        gBagConstr.gridy = 1;
        gBagConstr.gridwidth = 5;
        gBagConstr.weightx = 1.0;
        gBagConstr.weighty = 0.0;
        gBagConstr.anchor = 19;
        gBagConstr.fill = 2;
        gBagConstr.insets = new Insets(10, 0, 5, 10);
        contentPanel.add((Component)this.searchBox, gBagConstr);
        this.searchBox.getDocument().addDocumentListener(new SearchFilterListener());
        String numMachinesLabelText = this.bundle.getString("DlgSelectPlan.MachineCount.txt");
        JLabel numMachinesLabel = new JLabel(Util.getLabelWithoutMnemonic(numMachinesLabelText));
        numMachinesLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(numMachinesLabelText));
        numMachinesLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(numMachinesLabelText));
        this.numMachinesCombo = new JComboBox<Object>(tableModel.getMachineCounts().toArray());
        numMachinesLabel.setLabelFor(this.numMachinesCombo);
        gBagConstr.gridx = 2;
        gBagConstr.gridy = 2;
        gBagConstr.gridwidth = 1;
        gBagConstr.weightx = 0.0;
        gBagConstr.weighty = 0.0;
        gBagConstr.anchor = 10;
        gBagConstr.fill = 0;
        gBagConstr.insets = new Insets(2, 10, 2, 5);
        contentPanel.add((Component)numMachinesLabel, gBagConstr);
        gBagConstr.gridx = 3;
        gBagConstr.gridy = 2;
        gBagConstr.gridwidth = 2;
        gBagConstr.weightx = 0.0;
        gBagConstr.weighty = 0.0;
        gBagConstr.anchor = 10;
        gBagConstr.fill = 0;
        gBagConstr.insets = new Insets(2, 0, 2, 5);
        contentPanel.add((Component)this.numMachinesCombo, gBagConstr);
        this.numMachinesCombo.addActionListener(this);
        this.numMachinesCombo.setPreferredSize(new Dimension(40, 23));
        this.table.setPreferredScrollableViewportSize(new Dimension(420, 300));
        this.table.setAutoCreateRowSorter(true);
        String planColHeader = this.bundle.getString("DlgSelectPlan.Table.PlanColumnHeader.txt");
        String machinesColHeader = this.bundle.getString("DlgSelectPlan.Table.MachinesColumnHeader.txt");
        this.table.getColumn(planColHeader).setPreferredWidth(230);
        this.table.getColumn(machinesColHeader).setPreferredWidth(5);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        this.table.getColumn(machinesColHeader).setCellRenderer(renderer);
        renderer.setHorizontalAlignment(4);
        this.table.setIntercellSpacing(new Dimension(5, 0));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    JTable target = (JTable)mouseEvent.getSource();
                    if (target.getSelectedRow() == -1) {
                        return;
                    }
                    StandardPlanTableModel tableModel = (StandardPlanTableModel)target.getModel();
                    StandardDeploymentPlan stdPlan = tableModel.getStandardDeploymentPlan((String)target.getModel().getValueAt(target.convertRowIndexToModel(target.getSelectedRow()), 0));
                    DlgSelectPlan.this.setChosenStandardPlan(stdPlan);
                }
            }
        });
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.setFocusTraversalKeysEnabled(false);
        this.table.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "enterKeyOnTable");
        this.table.getActionMap().put("enterKeyOnTable", new AbstractAction(){
            private static final long serialVersionUID = 1452635780085209715L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTable target = (JTable)actionEvent.getSource();
                if (target.getSelectedRow() == -1) {
                    return;
                }
                StandardPlanTableModel tableModel = (StandardPlanTableModel)target.getModel();
                StandardDeploymentPlan stdPlan = tableModel.getStandardDeploymentPlan((String)target.getModel().getValueAt(target.convertRowIndexToModel(target.getSelectedRow()), 0));
                DlgSelectPlan.this.setChosenStandardPlan(stdPlan);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.table);
        gBagConstr.gridx = 0;
        gBagConstr.gridy = 3;
        gBagConstr.gridwidth = 7;
        gBagConstr.weightx = 1.0;
        gBagConstr.weighty = 1.0;
        gBagConstr.anchor = 10;
        gBagConstr.fill = 1;
        gBagConstr.insets = new Insets(10, 10, 10, 10);
        contentPanel.add((Component)scrollPane, gBagConstr);
        int rowHeight = Utils.getPreferredRowHeight(this.table);
        if (rowHeight > 0) {
            this.table.setRowHeight(rowHeight);
        }
        JPanel buttonPanel = new JPanel(new GridLayout(0, 2, 5, 0));
        String text = null;
        text = this.bundle.getString("DlgSelectPlan.OKButton.txt");
        this.okButton = new JButton(Util.getLabelWithoutMnemonic(text));
        this.okButton.setMnemonic(Util.getDisplayedMnemonic(text));
        this.okButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(text));
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        buttonPanel.add(this.okButton);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelEvent) {
                DlgSelectPlan.this.okButton.setEnabled(DlgSelectPlan.this.table.getSelectedRow() != -1);
            }
        });
        text = this.bundle.getString("DlgSelectPlan.CancelButton.txt");
        this.cancelButton = new JButton(Util.getLabelWithoutMnemonic(text));
        this.cancelButton.setMnemonic(Util.getDisplayedMnemonic(text));
        this.cancelButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(text));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.cancelButton);
        gBagConstr.gridx = 0;
        gBagConstr.gridy = 4;
        gBagConstr.gridwidth = 7;
        gBagConstr.weightx = 1.0;
        gBagConstr.weighty = 0.0;
        gBagConstr.anchor = 20;
        gBagConstr.fill = 0;
        gBagConstr.insets = new Insets(5, 0, 10, 0);
        contentPanel.add((Component)buttonPanel, gBagConstr);
        this.searchFilter = new RowFilter<StandardPlanTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends StandardPlanTableModel, ? extends Integer> entry) {
                StandardPlanTableModel tableModel = entry.getModel();
                StandardDeploymentPlan stdPlan = tableModel.getStandardDeploymentPlan((String)entry.getValue(0));
                Pattern patrn = Pattern.compile(".*" + DlgSelectPlan.this.filterString + ".*", 2);
                return patrn.matcher(stdPlan.getName()).matches();
            }
        };
        this.machCountFilter = new RowFilter<StandardPlanTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends StandardPlanTableModel, ? extends Integer> entry) {
                StandardPlanTableModel tableModel = entry.getModel();
                StandardDeploymentPlan stdPlan = tableModel.getStandardDeploymentPlan((String)entry.getValue(0));
                return stdPlan.getMachineCount() == Integer.parseInt((String)DlgSelectPlan.this.numMachinesCombo.getSelectedItem());
            }
        };
        this.tableSorter.setRowFilter(this.searchFilter);
        this.table.setRowSorter(this.tableSorter);
        this.setContentPane(contentPanel);
    }

    private void resizeButtons() {
        int MAX_WIDTH = 75;
        int MAX_HEIGHT = 23;
        Dimension buttonSize = this.cancelButton.getSize();
        double maxWidth = buttonSize.getWidth();
        double maxHeight = buttonSize.getHeight();
        if ((buttonSize = this.okButton.getSize(buttonSize)).getWidth() > maxWidth) {
            maxWidth = buttonSize.getWidth();
        }
        if (buttonSize.getHeight() > maxHeight) {
            maxHeight = buttonSize.getHeight();
        }
        if (maxWidth < 75.0) {
            maxWidth = 75.0;
        }
        if (maxHeight < 23.0) {
            maxHeight = 23.0;
        }
        buttonSize.setSize(maxWidth, maxHeight);
        this.cancelButton.setPreferredSize(buttonSize);
        this.okButton.setPreferredSize(buttonSize);
    }

    protected final boolean hasFilterString() {
        return this.filterString != null && !"".equals(this.filterString);
    }

    protected final boolean hasMachCountFilter() {
        return !"".equals(this.numMachinesCombo.getSelectedItem());
    }

    protected final void applyFilters() {
        if (this.hasMachCountFilter()) {
            ArrayList<RowFilter<StandardPlanTableModel, Integer>> filters = new ArrayList<RowFilter<StandardPlanTableModel, Integer>>();
            filters.add(this.searchFilter);
            if (this.hasMachCountFilter()) {
                filters.add(this.machCountFilter);
            }
            RowFilter comboFilter = RowFilter.andFilter(filters);
            this.tableSorter.setRowFilter(comboFilter);
        } else {
            this.tableSorter.setRowFilter(this.searchFilter);
        }
    }

    public final void setFilterString(String filterStr) {
        String oldFilter = this.filterString;
        this.filterString = filterStr;
        this.applyFilters();
        this.firePropertyChange("filterString", oldFilter, this.filterString);
    }

    private void setChosenStandardPlan(StandardDeploymentPlan stdPlan) {
        this.chosenStandardPlan = stdPlan;
        this.parentStdPlanComboBox.setSelectedItem(this.chosenStandardPlan);
        this.dispose();
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        Object obj = actionEvent.getSource();
        if (obj.equals(this.numMachinesCombo)) {
            this.applyFilters();
        } else if (obj.equals(this.okButton)) {
            if (this.table.getSelectedRow() == -1) {
                return;
            }
            StandardPlanTableModel tableModel = (StandardPlanTableModel)this.table.getModel();
            StandardDeploymentPlan stdPlan = tableModel.getStandardDeploymentPlan((String)this.table.getModel().getValueAt(this.table.convertRowIndexToModel(this.table.getSelectedRow()), 0));
            this.setChosenStandardPlan(stdPlan);
        } else if (obj.equals(this.cancelButton)) {
            this.dispose();
        }
    }

    static /* synthetic */ SSNResource access$500(DlgSelectPlan x0) {
        return x0.bundle;
    }

    class StandardPlanTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 7185097731662938497L;
        private Map<String, StandardDeploymentPlan> plans = new HashMap<String, StandardDeploymentPlan>();
        private String[] columnNames = new String[]{"", DlgSelectPlan.access$500(DlgSelectPlan.this).getString("DlgSelectPlan.Table.PlanColumnHeader.txt"), DlgSelectPlan.access$500(DlgSelectPlan.this).getString("DlgSelectPlan.Table.MachinesColumnHeader.txt")};
        private SortedSet<String> webAppServers = null;
        private SortedSet<String> machineCounts = null;

        public StandardPlanTableModel(Map<String, StandardDeploymentPlan> planMap, SortedSet<String> planMachineCounts) {
            this.plans = planMap;
            planMachineCounts.add("");
            this.machineCounts = planMachineCounts;
            this.setColumnIdentifiers(this.columnNames);
            TreeSet<StandardDeploymentPlan> planSet = new TreeSet<StandardDeploymentPlan>(this.plans.values());
            for (StandardDeploymentPlan currPlan : planSet) {
                this.add(currPlan);
            }
        }

        private void addRowToVectorData(StandardDeploymentPlan newPlan) {
            Object[] newRowData = new Object[]{newPlan.getUniqueKey(), newPlan.getName(), newPlan.getMachineCount()};
            this.addRow(newRowData);
        }

        private void add(StandardDeploymentPlan newPlan) {
            int index = this.plans.size();
            this.addRowToVectorData(newPlan);
            this.fireTableRowsInserted(index, index);
        }

        public StandardDeploymentPlan getStandardDeploymentPlan(String key) {
            return this.plans.get(key);
        }

        public SortedSet<String> getWebAppServers() {
            return this.webAppServers;
        }

        public SortedSet<String> getMachineCounts() {
            return this.machineCounts;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class SearchFilterListener
    implements DocumentListener {
        SearchFilterListener() {
        }

        protected final void changeFilter(DocumentEvent docEvent) {
            Document doc = docEvent.getDocument();
            try {
                DlgSelectPlan.this.setFilterString(doc.getText(0, doc.getLength()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public final void changedUpdate(DocumentEvent docEvent) {
            this.changeFilter(docEvent);
        }

        @Override
        public final void insertUpdate(DocumentEvent docEvent) {
            this.changeFilter(docEvent);
        }

        @Override
        public final void removeUpdate(DocumentEvent docEvent) {
            this.changeFilter(docEvent);
        }
    }
}

