/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DepotManager;
import com.sas.ssn.Globals;
import com.sas.ssn.KitBrowseButton;
import com.sas.ssn.KitTextField;
import com.sas.ssn.OrderData;
import com.sas.ssn.ProgressBar;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class DlgCreateMedia
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 6292902887853465778L;
    private SSNResource bundle = new SSNResource(DlgCreateMedia.class);
    private JPanel m_contentPane = new JPanel(new GridBagLayout());
    private JPanel m_buttonPanel = new JPanel();
    private JLabel m_typeLabel;
    private JComboBox m_typeCombo;
    private JLabel m_mediaDestLabel;
    private KitTextField m_mediaDest;
    private KitBrowseButton m_browseButton;
    private ProgressBar m_progressBar;
    private JButton m_startButton;
    private JButton m_cancelButton;
    private Timer m_timer;
    private ActionListener m_timerAction;
    private OrderData m_orderData = null;
    private MediaType[] m_mediaTypes = null;
    private DepotManager.Job m_job = null;
    private boolean m_jobStarted = false;
    private boolean m_jobFinished = false;
    private cKeyHandler m_keyHandler;

    public DlgCreateMedia(JFrame parent, OrderData orderData) {
        this.m_orderData = orderData;
        this.m_keyHandler = new cKeyHandler();
        this.initialize();
        this.layoutWidgets();
        this.setTitle(this.bundle.messageString("DlgCreateMedia.Title.txt", orderData.getOrder()));
        this.pack();
        this.resizeButtons();
        this.setSize(new Dimension(parent.getWidth() - 20, this.getHeight()));
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
        this.setModal(true);
    }

    private void initialize() {
        this.m_typeCombo = new JComboBox();
        this.loadComboBox();
        String mtxt = this.bundle.getString("DlgCreateMedia.MediaType.txt");
        this.m_typeLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_typeLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_typeLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_typeLabel.setLabelFor(this.m_typeCombo);
        this.m_mediaDest = new KitTextField();
        mtxt = this.bundle.getString("DlgCreateMedia.TargetDir.txt");
        this.m_mediaDestLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_mediaDestLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_mediaDestLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_mediaDestLabel.setLabelFor(this.m_mediaDest);
        mtxt = this.bundle.getString("Common.Browse1.txt");
        this.m_browseButton = new KitBrowseButton(Util.getLabelWithoutMnemonic(mtxt), "", 0, this.m_mediaDest);
        this.m_browseButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_browseButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_browseButton.setFileSelectionMode(1);
        this.m_progressBar = new ProgressBar(100.0, true, false);
        mtxt = this.bundle.getString("DlgCreateMedia.StartButton.txt");
        this.m_startButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_startButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_startButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_startButton.addActionListener(this);
        mtxt = this.bundle.getString("Common.Cancel.txt");
        this.m_cancelButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_cancelButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_cancelButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.m_startButton);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.weighty = 1.0;
        this.layoutButtons();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(10, 10, 0, 5);
        this.m_contentPane.add((Component)this.m_typeLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 13;
        c.insets = new Insets(10, 0, 0, 5);
        this.m_contentPane.add((Component)this.m_typeCombo, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(10, 10, 0, 5);
        this.m_contentPane.add((Component)this.m_mediaDestLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 13;
        c.insets = new Insets(10, 0, 0, 5);
        this.m_contentPane.add((Component)this.m_mediaDest, c);
        c.gridx = 2;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        c.insets = new Insets(10, 0, 0, 10);
        this.m_contentPane.add((Component)this.m_browseButton, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(10, 10, 0, 10);
        this.m_contentPane.add((Component)this.m_progressBar, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 15;
        c.insets = new Insets(10, 10, 10, 10);
        this.m_contentPane.add((Component)this.m_buttonPanel, c);
        this.m_contentPane.setOpaque(true);
        this.setContentPane(this.m_contentPane);
        this.addKeyListeners(this, this.m_keyHandler);
    }

    private void layoutButtons() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weighty = 1.0;
        c.fill = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 10);
        this.m_buttonPanel.add((Component)this.m_startButton, c);
        c.gridx = 1;
        c.weightx = 0.0;
        c.anchor = 13;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_buttonPanel.add((Component)this.m_cancelButton, c);
    }

    private void resizeButtons() {
        Dimension buttonSize = this.m_cancelButton.getSize();
        double maxWidth = buttonSize.getWidth();
        double maxHeight = buttonSize.getHeight();
        if ((buttonSize = this.m_startButton.getSize(buttonSize)).getWidth() > maxWidth) {
            maxWidth = buttonSize.getWidth();
        }
        if (buttonSize.getHeight() > maxHeight) {
            maxHeight = buttonSize.getHeight();
        }
        if (maxWidth < 75.0) {
            maxWidth = 75.0;
        }
        if (maxHeight < 23.0) {
            maxHeight = 23.0;
        }
        buttonSize.setSize(maxWidth, maxHeight);
        this.m_startButton.setPreferredSize(buttonSize);
        this.m_cancelButton.setPreferredSize(buttonSize);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_startButton) {
            if (this.m_jobFinished) {
                this.dispose();
            } else if (this.m_jobStarted) {
                if (CustMsgBox.showConfirmDialog((Component)this, this.bundle.getString("DlgCreateMedia.InterruptMsg.txt"), this.bundle.getString("DlgCreateMedia.InterruptTitle.txt"), 0, 3, 1) == 0) {
                    this.m_jobFinished = true;
                    this.m_job.interrupt();
                    this.timerEvent();
                }
            } else {
                int selectedIndex = this.m_typeCombo.getSelectedIndex();
                if (selectedIndex > -1) {
                    this.m_job = Globals.g_depotManager.createExportJob(this.m_mediaDest.getText(), this.m_orderData.getOrder(), this.m_mediaTypes[selectedIndex].getType());
                    if (this.validTarget()) {
                        this.createMedia();
                    }
                }
            }
        } else {
            this.dispose();
        }
    }

    private boolean validTarget() {
        long freeSpace;
        File targetFile;
        boolean valid = true;
        String errMsg = null;
        String targetDir = Utils.trimTrailingSlashes(this.m_mediaDest.getText());
        this.m_mediaDest.setText(targetDir);
        if (targetDir.length() == 0) {
            valid = false;
            errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("DlgCreateMedia.FieldName.txt"));
        }
        if (valid) {
            if (Utils.getOS() == 6) {
                targetDir = Utils.VMSToUnixPath(targetDir);
            }
            if (Utils.pathContainsValidChars(targetDir)) {
                valid = Utils.validatePath(targetDir);
                if (!valid) {
                    errMsg = this.bundle.messageString("Common.Error.InvalidField.txt", this.bundle.getString("DlgCreateMedia.FieldName.txt"));
                }
            } else {
                valid = false;
                errMsg = Utils.getOS() == 1 ? this.bundle.messageString("Common.Error.InvalidChars.Windows.txt", this.bundle.getString("DlgCreateMedia.FieldName.txt")) : (Utils.getOS() == 9 ? this.bundle.messageString("Common.Error.InvalidChars.Mac.txt", this.bundle.getString("DlgCreateMedia.FieldName.txt")) : this.bundle.messageString("Common.Error.InvalidChars.UNIX.txt", this.bundle.getString("DlgCreateMedia.FieldName.txt")));
            }
        }
        if (valid && !(valid = Utils.canWriteToPath(targetDir))) {
            errMsg = this.bundle.messageString("Common.Error.NoPermissions.txt", this.bundle.getString("DlgCreateMedia.FieldName.txt"));
        }
        if (valid && Utils.pathContainsFiles(targetFile = new File(targetDir))) {
            CustMsgBox.showMessageDialog((Component)this, this.bundle.getString("DlgCreateMedia.ExistingFilesMsg.txt"), this.getTitle(), 2);
            valid = false;
        }
        if (!valid) {
            if (errMsg != null) {
                CustMsgBox.showMessageDialog((Component)this, errMsg, this.bundle.getString("Common.Warning.txt"), 2);
            }
            this.m_mediaDest.requestFocus();
        }
        if (valid && !Globals.g_skipSpaceCheck && (freeSpace = Utils.getFreeSpace(targetDir)) < this.m_job.getTotalSize()) {
            DecimalFormat gigFormat = new DecimalFormat("###,##0.000");
            String requiredSpace = gigFormat.format((double)this.m_job.getTotalSize() / 1.073741824E9);
            valid = this.confirmPrompt(this.bundle.messageString("DlgCreateMedia.InsufficientSpaceMsg.txt", requiredSpace));
        }
        if (valid && !(targetFile = new File(targetDir)).exists()) {
            valid = targetFile.mkdirs();
        }
        return valid;
    }

    private void loadComboBox() {
        String[] types = this.m_orderData.getExportMediaTypes();
        this.m_mediaTypes = new MediaType[types.length];
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == null) continue;
            this.m_mediaTypes[i] = new MediaType(types[i]);
        }
        for (int i = this.m_mediaTypes.length - 1; i > 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (this.m_mediaTypes[j].getName().compareTo(this.m_mediaTypes[j + 1].getName()) <= 0) continue;
                MediaType temp = this.m_mediaTypes[j];
                this.m_mediaTypes[j] = this.m_mediaTypes[j + 1];
                this.m_mediaTypes[j + 1] = temp;
            }
        }
        int currentRank = 0;
        int currentDisks = 0;
        for (int i = 0; i < this.m_mediaTypes.length; ++i) {
            this.m_typeCombo.addItem(this.m_mediaTypes[i].getName());
            int disks = this.m_orderData.getVolsers(this.m_mediaTypes[i].getType()).length;
            int rank = this.m_mediaTypes[i].getRank();
            if (disks < currentDisks || currentRank == 0) {
                currentDisks = disks;
                currentRank = rank;
                this.m_typeCombo.setSelectedIndex(i);
                continue;
            }
            if (disks != currentDisks || rank >= currentRank) continue;
            currentDisks = disks;
            currentRank = rank;
            this.m_typeCombo.setSelectedIndex(i);
        }
    }

    private void createMedia() {
        this.m_jobStarted = true;
        String mtxt = this.bundle.getString("DlgCreateMedia.StopButton.txt");
        this.m_startButton.setText(Util.getLabelWithoutMnemonic(mtxt));
        this.m_startButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_startButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_cancelButton.setEnabled(false);
        this.m_typeLabel.setEnabled(false);
        this.m_typeCombo.setEnabled(false);
        this.m_mediaDestLabel.setEnabled(false);
        this.m_mediaDest.setEnabled(false);
        this.m_browseButton.setEnabled(false);
        Globals.g_bytesMoved = 0L;
        this.m_progressBar.setMaxValue(this.m_job.getTotalSize());
        this.m_job.start();
        this.m_timerAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgCreateMedia.this.timerEvent();
            }
        };
        this.m_timer = new Timer(250, this.m_timerAction);
        this.m_timer.start();
    }

    private void timerEvent() {
        if (this.m_jobFinished || !this.m_job.isAlive()) {
            if (this.m_job.getStatus() == 4) {
                this.m_progressBar.finished();
            } else {
                this.m_progressBar.stopped();
            }
            this.m_timer.stop();
            String mtxt = this.bundle.getString("Common.OK.txt");
            this.m_startButton.setText(Util.getLabelWithoutMnemonic(mtxt));
            this.m_startButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
            this.m_startButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            this.m_jobFinished = true;
        } else {
            this.m_progressBar.setCurrentValue(Globals.g_bytesMoved);
        }
        this.validate();
    }

    protected void addKeyListeners(Container container, cKeyHandler keyHandler) {
        Component[] componentArray = container.getComponents();
        int nComps = componentArray.length;
        for (int iComp = 0; iComp < nComps; ++iComp) {
            componentArray[iComp].addKeyListener(keyHandler);
            if (!(componentArray[iComp] instanceof Container)) continue;
            this.addKeyListeners((Container)componentArray[iComp], keyHandler);
        }
    }

    private boolean confirmPrompt(String message) {
        boolean valid = true;
        if (CustMsgBox.showConfirmDialog((Component)this, message, this.getTitle(), 0, 3, 0) == 1) {
            valid = false;
        }
        return valid;
    }

    private class MediaType {
        private String type;
        private String name;
        private int rank;

        public MediaType(String mediaType) {
            if (mediaType == null) {
                throw new NullPointerException();
            }
            this.type = mediaType.toLowerCase(Locale.ENGLISH);
            if ("esdm".equals(this.type)) {
                this.name = DlgCreateMedia.this.bundle.getString("DlgCreateMedia.MediaNameESD.txt");
                this.rank = 1;
            } else if ("cdrm".equals(this.type)) {
                this.name = DlgCreateMedia.this.bundle.getString("DlgCreateMedia.MediaNameCD.txt");
                this.rank = 2;
            } else if ("dvdm".equals(this.type)) {
                this.name = DlgCreateMedia.this.bundle.getString("DlgCreateMedia.MediaNameDVD.txt");
                this.rank = 3;
            } else if ("dvd2".equals(this.type)) {
                this.name = DlgCreateMedia.this.bundle.getString("DlgCreateMedia.MediaNameDVD2.txt");
                this.rank = 4;
            } else {
                this.name = DlgCreateMedia.this.bundle.messageString("DlgCreateMedia.MediaNameUnknown.txt", this.type);
                this.rank = 5;
            }
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public int getRank() {
            return this.rank;
        }
    }

    protected class cKeyHandler
    extends KeyAdapter {
        protected cKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int eKeyCode = e.getKeyCode();
            switch (eKeyCode) {
                case 27: {
                    DlgCreateMedia.this.dispose();
                }
            }
        }
    }
}

