/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.SSNResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class DlgBusyMsg {
    private SSNResource bundle = new SSNResource(DlgBusyMsg.class);
    private JFrame m_parent = null;
    private String m_title = null;
    private String m_message = null;
    private Thread m_thread = null;
    private BusyDialog m_busyDialog = null;

    public DlgBusyMsg(JFrame parent, String title, String message) {
        this.m_parent = parent;
        this.m_title = title;
        this.m_message = message;
    }

    public void execute(Runnable runOperation) {
        this.m_thread = new OperationThread(runOperation);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DlgBusyMsg.this.m_thread.start();
            }
        });
        this.m_busyDialog = new BusyDialog(this.m_parent, this.m_title, this.m_message);
        this.m_busyDialog.setVisible(true);
    }

    private class BusyDialog
    extends JDialog {
        private static final long serialVersionUID = -5364259790887272682L;
        private JPanel m_contentPane;
        private JLabel m_messageTxt;
        private JLabel m_processing;
        private Timer m_timer;
        private ImageIcon m_time1;
        private ImageIcon m_time2;
        private ImageIcon m_time3;
        private ImageIcon m_time4;
        private ImageIcon m_time5;
        private int m_imageCount;

        public BusyDialog(JFrame parent, String title, String message) {
            super(parent);
            this.m_contentPane = new JPanel(new GridBagLayout());
            this.m_messageTxt = null;
            this.m_processing = new JLabel();
            this.m_timer = null;
            this.m_time1 = DlgBusyMsg.this.bundle.getImageIcon("Common.time1.image");
            this.m_time2 = DlgBusyMsg.this.bundle.getImageIcon("Common.time2.image");
            this.m_time3 = DlgBusyMsg.this.bundle.getImageIcon("Common.time3.image");
            this.m_time4 = DlgBusyMsg.this.bundle.getImageIcon("Common.time4.image");
            this.m_time5 = DlgBusyMsg.this.bundle.getImageIcon("Common.time5.image");
            this.m_imageCount = 1;
            this.initialize();
            this.layoutWidgets();
            if (title != null) {
                this.setTitle(title);
            } else {
                this.setTitle(parent.getTitle());
            }
            this.setDefaultCloseOperation(0);
            this.setResizable(false);
            this.setModal(true);
            this.pack();
            this.setLocationRelativeTo(parent);
        }

        private void initialize() {
            this.m_messageTxt = new JLabel(DlgBusyMsg.this.m_message);
            this.m_messageTxt.setHorizontalAlignment(0);
            this.m_processing.setIcon(this.m_time1);
            this.m_processing.setHorizontalAlignment(0);
            this.m_timer = new Timer(250, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (DlgBusyMsg.this.m_thread == null || !DlgBusyMsg.this.m_thread.isAlive()) {
                        BusyDialog.this.dispose();
                    } else {
                        BusyDialog.this.m_imageCount++;
                        if (BusyDialog.this.m_imageCount > 8) {
                            BusyDialog.this.m_imageCount = 1;
                        }
                        switch (BusyDialog.this.m_imageCount) {
                            case 1: {
                                BusyDialog.this.m_processing.setIcon(BusyDialog.this.m_time1);
                                break;
                            }
                            case 2: {
                                BusyDialog.this.m_processing.setIcon(BusyDialog.this.m_time2);
                                break;
                            }
                            case 3: {
                                BusyDialog.this.m_processing.setIcon(BusyDialog.this.m_time3);
                                break;
                            }
                            case 4: {
                                BusyDialog.this.m_processing.setIcon(BusyDialog.this.m_time4);
                                break;
                            }
                            case 5: {
                                BusyDialog.this.m_processing.setIcon(BusyDialog.this.m_time5);
                                break;
                            }
                            case 6: {
                                BusyDialog.this.m_processing.setIcon(BusyDialog.this.m_time4);
                                break;
                            }
                            case 7: {
                                BusyDialog.this.m_processing.setIcon(BusyDialog.this.m_time3);
                                break;
                            }
                            default: {
                                BusyDialog.this.m_processing.setIcon(BusyDialog.this.m_time2);
                            }
                        }
                    }
                }
            });
            this.m_timer.start();
        }

        private void layoutWidgets() {
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.anchor = 10;
            c.fill = 0;
            c.gridy = 0;
            c.insets = new Insets(15, 15, 0, 15);
            this.m_contentPane.add((Component)this.m_messageTxt, c);
            c.gridy = 1;
            c.insets = new Insets(10, 15, 15, 15);
            this.m_contentPane.add((Component)this.m_processing, c);
            this.m_contentPane.setOpaque(true);
            this.setContentPane(this.m_contentPane);
        }
    }

    private class OperationThread
    extends Thread {
        private Runnable m_runOperation;

        public OperationThread(Runnable runOperation) {
            super("BackgroundOperation");
            this.m_runOperation = runOperation;
            this.setPriority(5);
        }

        @Override
        public void run() {
            this.m_runOperation.run();
            if (DlgBusyMsg.this.m_busyDialog != null) {
                DlgBusyMsg.this.m_busyDialog.dispose();
                DlgBusyMsg.this.m_busyDialog = null;
            }
        }
    }
}

