/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.KitAction;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.utils.ProductDirUtils;
import com.sas.swing.visuals.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DialogData
implements HyperlinkListener {
    private static SSNResource bundle = new SSNResource(DialogData.class);
    public static final String CONFIG_BUNDLE_FILE_NAME = "configBundle.xml";
    public static final String SCHEMA_FILE_NAME = "configBundle_schema.xml";
    public static final String CONFIG_DIALOG_ORDER_FILE_NAME = "dialog_order.txt";
    public static final String CONFIGURE_SUBDIR = "configure";
    private static final Pattern DEPENDS_ON_PATTERN = Pattern.compile("(\\w+)\\.dependson\\.(\\w+)\\.fqid");
    private static String cfgwizardConfigBundlePath = null;
    private static String levUtiltiesConfigBundlePath = null;
    private static String tempConfigBundlePath = null;
    private static String currentConfigBundleName = null;
    private DocumentBuilder docBuilderValEnabled = null;
    private DocumentBuilder docBuilderValDisabled = null;
    private HashMap<String, TreeSet<Dialog>> sortedDialogsByPlat = new HashMap();
    private HashMap<String, Dialog[]> cachedDialogsByPlat = new HashMap();
    private TreeSet<DialogElement> sortedDialogElems = new TreeSet();
    private LinkedHashMap<String, Integer> sortedDialogNames = new LinkedHashMap();
    private Document document = null;
    private boolean isLegacy = false;
    private boolean isDialogOrderFileLoaded = false;
    private float dialogGroupCounter = 0.0f;
    private HashMap<String, HashSet<String>> parentToDependentsMap = new HashMap();
    private HashMap<String, HashSet<String>> dependentToParentsMap = new HashMap();
    private boolean ignoreErrors = false;
    private static DialogData singleton = null;

    public static String getLevUtilitiesConfigBundlePath() {
        if (levUtiltiesConfigBundlePath == null && Globals.g_configData != null) {
            levUtiltiesConfigBundlePath = Utils.joinPath(Globals.g_configData.getProperty("config.lev.utilities.dir", ""), CONFIG_BUNDLE_FILE_NAME);
        }
        return levUtiltiesConfigBundlePath;
    }

    public static String getTempConfigBundlePath() {
        if (tempConfigBundlePath == null && Globals.g_tempLocation != null) {
            tempConfigBundlePath = Utils.joinPath(Globals.g_tempLocation, CONFIG_BUNDLE_FILE_NAME);
        }
        return tempConfigBundlePath;
    }

    public static String getCfgwizardConfigBundlePath() {
        String productDataDir;
        if (cfgwizardConfigBundlePath == null && Globals.g_deploymentData != null && (productDataDir = Globals.g_deploymentData.getProductDataDir(Globals.g_order, "cfgwizard", true, true)) != null) {
            cfgwizardConfigBundlePath = Utils.joinPath(productDataDir, CONFIGURE_SUBDIR, CONFIG_BUNDLE_FILE_NAME);
        }
        return cfgwizardConfigBundlePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DialogData getConfigDialogData() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        Class<DialogData> clazz = DialogData.class;
        synchronized (DialogData.class) {
            if (singleton == null) {
                String configBundleFile = DialogData.getCfgwizardConfigBundlePath();
                try {
                    if (configBundleFile != null) {
                        singleton = new DialogData(configBundleFile);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                if (singleton == null) {
                    singleton = new DialogData();
                }
                if (singleton == null || !singleton.containsData()) {
                    throw new FileNotFoundException("No valid cfgwizard configBundle.xml or any <12byte>_configBundle.xml was found!");
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private DialogData() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        ProductData[] allProdData = Globals.g_deploymentData.getAllProducts(Globals.g_order, true);
        String cfgwizardConfigBundlePath = Globals.g_deploymentData.getProductDataDir(Globals.g_order, "cfgwizard", true, true);
        File dialogOrderFileName = new File(Utils.joinPath(cfgwizardConfigBundlePath, CONFIGURE_SUBDIR, CONFIG_DIALOG_ORDER_FILE_NAME));
        if (dialogOrderFileName.isFile()) {
            this.loadDialogOrderFile(dialogOrderFileName);
        }
        if (allProdData != null) {
            for (int i = 0; i < allProdData.length; ++i) {
                String prodCodeFileName;
                String prodCode = allProdData[i].getProdCode();
                File configBundleFile = ProductDirUtils.getProductDataFile(prodCode, Utils.joinPath(CONFIGURE_SUBDIR, prodCodeFileName = prodCode + "_" + CONFIG_BUNDLE_FILE_NAME));
                if (configBundleFile == null) {
                    configBundleFile = ProductDirUtils.getProductDataFile("cfgwizard", Utils.joinPath(CONFIGURE_SUBDIR, prodCodeFileName));
                }
                if (configBundleFile == null) continue;
                boolean retry = false;
                do {
                    try {
                        this.parseConfigBundleFile(configBundleFile, true);
                        retry = false;
                    }
                    catch (Exception e) {
                        if (this.ignoreErrors) continue;
                        retry = this.promptForRetry(configBundleFile, e);
                    }
                } while (retry);
            }
        }
        if (!this.containsData()) {
            throw new FileNotFoundException("No valid <12byte>_configBundle.xml was found!");
        }
    }

    public DialogData(String file) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this(new File(file));
    }

    public DialogData(File file) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this.isLegacy = true;
        this.document = this.parseConfigBundleFile(file, false);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            KitAction.launchWebBrowser(event.getURL());
        }
    }

    private String getHTMLLinkText(File file) {
        String linkText = "<a href=\"" + Utils.pathToURL(file.getAbsolutePath()) + "\">" + file.getName() + "</a>";
        return linkText;
    }

    private void loadDialogOrderFile(File fn) {
        LinkedHashSet<String> dialogNames = Utils.loadFileWithComments(fn, "#");
        Iterator it = dialogNames.iterator();
        Integer order = 0;
        while (it.hasNext()) {
            Integer n = order;
            order = order + 1;
            this.sortedDialogNames.put((String)it.next(), n);
        }
        this.dialogGroupCounter = this.sortedDialogNames.size();
        this.isDialogOrderFileLoaded = true;
    }

    private float getOrderFromDialogList(String name) {
        float order = 0.0f;
        if (!this.sortedDialogNames.containsKey(name)) {
            Logging.log.warning("[" + name.toUpperCase() + "] was not found in the master list. It will be appended to the end.");
            float f = this.dialogGroupCounter;
            this.dialogGroupCounter = f + 1.0f;
            order = f;
        } else {
            order = this.sortedDialogNames.get(name).intValue();
        }
        return order;
    }

    private float getOrderFromDialogElem(Element dialogElem) {
        float order = 0.0f;
        String tmpAttr = dialogElem.getAttribute("order");
        if (tmpAttr == null || tmpAttr.equals("")) {
            float f = this.dialogGroupCounter;
            this.dialogGroupCounter = f + 1.0f;
            order = f;
        } else {
            try {
                order = Float.parseFloat(tmpAttr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return order;
    }

    private boolean promptForRetry(File file, Exception e) {
        boolean doRetry = false;
        if (!Globals.g_quietMode) {
            String title = bundle.getString("DialogData.ConfigBundleErrorTitle.txt");
            String msgTxt = bundle.messageString("DialogData.ConfigBundleErrorMessage.txt", this.getHTMLLinkText(file)) + "<p>" + e.getMessage();
            Object[] options = new String[]{Util.getLabelWithoutMnemonic(bundle.getString("Common.Ignore.txt")), Util.getLabelWithoutMnemonic(bundle.getString("Common.IgnoreForAll.txt")), Util.getLabelWithoutMnemonic(bundle.getString("Common.RetryButton.txt"))};
            int defaultButton = 2;
            int returnCode = 0;
            if (Globals.g_consoleMode) {
                ConsoleMode.printInfoText(msgTxt);
                returnCode = ConsoleMode.promptSingleChoice((String[])options, null, null, defaultButton, true);
            } else {
                JEditorPane msgArea = new JEditorPane();
                msgArea.setOpaque(false);
                msgArea.setEditable(false);
                msgArea.setCaretPosition(0);
                msgArea.setContentType("text/html");
                msgArea.addHyperlinkListener(this);
                msgTxt = "<html><font size=-1 face=\"" + Globals.g_wizard.getCancelButton().getFont().getFontName() + "\">" + msgTxt + "</font></html>";
                msgArea.setText(msgTxt);
                returnCode = JOptionPane.showOptionDialog(Globals.g_wizard.getFrame(), msgArea, title, 0, 0, null, options, options[defaultButton]);
            }
            switch (returnCode) {
                case 0: {
                    doRetry = false;
                    break;
                }
                case 1: {
                    doRetry = false;
                    this.ignoreErrors = true;
                    break;
                }
                default: {
                    doRetry = true;
                }
            }
        }
        return doRetry;
    }

    public boolean containsData() {
        return this.sortedDialogsByPlat.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File file) throws ParserConfigurationException, IOException, SAXException, DOMException, TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        if (this.document == null) {
            this.document = this.getDocumentBuilder(false).newDocument();
            Element root = this.document.createElement("configDlgs");
            this.document.appendChild(root);
            for (DialogElement dialogElem : this.sortedDialogElems) {
                root.appendChild(this.document.adoptNode(dialogElem.getElement().cloneNode(true)));
            }
            this.sortedDialogElems.clear();
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        FileOutputStream fos = new FileOutputStream(file);
        try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)fos, "UTF-8");){
            transformer.transform(new DOMSource(this.document), new StreamResult(fileWriter));
        }
        Utils.removeBlankLines(file);
    }

    public boolean isLegacy() {
        return this.isLegacy;
    }

    public boolean isDialogOrderFileLoaded() {
        return this.isDialogOrderFileLoaded;
    }

    private void addDependsOnProperty(String propertyName) {
        Matcher matcher = DEPENDS_ON_PATTERN.matcher(propertyName);
        if (matcher.find()) {
            String dependent = matcher.group(1);
            String parent = matcher.group(2);
            HashSet<String> dependents = this.parentToDependentsMap.get(parent);
            if (dependents == null) {
                dependents = new HashSet();
                this.parentToDependentsMap.put(parent, dependents);
            }
            dependents.add(dependent);
            HashSet<String> parents = this.dependentToParentsMap.get(dependent);
            if (parents == null) {
                parents = new HashSet();
                this.dependentToParentsMap.put(dependent, parents);
            }
            parents.add(parent);
        }
    }

    public Set<String> getDependenciesOnParent(String parentProdCode) {
        HashSet<String> emptySet = new HashSet<String>();
        HashSet<String> ret = this.parentToDependentsMap.get(parentProdCode);
        if (ret == null) {
            ret = emptySet;
        }
        return ret;
    }

    public Set<String> getParentDependencies(String dependentProdCode) {
        HashSet<String> emptySet = new HashSet<String>();
        HashSet<String> ret = this.dependentToParentsMap.get(dependentProdCode);
        if (ret == null) {
            ret = emptySet;
        }
        return ret;
    }

    private TreeSet<Dialog> getSortedDialogsForPlat(String platform) {
        TreeSet<Dialog> sortedDialogs = this.sortedDialogsByPlat.get(platform);
        if (sortedDialogs == null) {
            sortedDialogs = new TreeSet();
            this.sortedDialogsByPlat.put(platform, sortedDialogs);
        }
        return sortedDialogs;
    }

    private Dialog getExistingDialog(Dialog targetDialog) {
        Dialog ret = null;
        TreeSet<Dialog> sortedDialogs = this.getSortedDialogsForPlat(targetDialog.getPlatform());
        for (Dialog dialog : sortedDialogs) {
            if (!dialog.equals(targetDialog)) continue;
            ret = dialog;
            break;
        }
        return ret;
    }

    private void addDialog(Dialog dialog) {
        if (dialog != null) {
            Dialog existingDialog = this.getExistingDialog(dialog);
            if (existingDialog == null) {
                this.getSortedDialogsForPlat(dialog.getPlatform()).add(dialog);
                if (Globals.g_debug && Globals.g_logLevel == 2) {
                    Logging.log.finer("DialogData::Added: " + dialog);
                }
            } else {
                if (Globals.g_debug && Globals.g_logLevel == 2) {
                    Logging.log.finer("DialogData::Before merge: " + existingDialog);
                }
                existingDialog.addProperties(dialog.getProperties());
                if (Globals.g_debug && Globals.g_logLevel == 2) {
                    Logging.log.finer("DialogData::After merge: " + existingDialog);
                }
            }
        }
    }

    private Document parseConfigBundleFile(File file, boolean enableValidation) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        currentConfigBundleName = file.getName();
        FileInputStream fis = new FileInputStream(file);
        Document document = this.getDocumentBuilder(enableValidation).parse(new InputSource(new InputStreamReader((InputStream)fis, "UTF-8")));
        this.parseConfigDlgsElement(document.getDocumentElement());
        if (Globals.g_debug && Globals.g_logLevel == 2) {
            Logging.log.finer("DialogData::Successfully loaded " + file);
        }
        return document;
    }

    private void parseConfigDlgsElement(Element configDlgsElem) throws SAXException {
        NodeList dialogElemList = configDlgsElem.getElementsByTagName("dialog");
        for (int i = 0; i < dialogElemList.getLength(); ++i) {
            Element dialogElem = (Element)dialogElemList.item(i);
            this.parseDialogElement(dialogElem);
        }
    }

    private void parseDialogElement(Element dialogElem) throws SAXException {
        String groupName = dialogElem.getAttribute("group").toLowerCase(Locale.ENGLISH);
        String task = dialogElem.getAttribute("task");
        float order = 0.0f;
        if (this.isLegacy()) {
            float f = this.dialogGroupCounter;
            this.dialogGroupCounter = f + 1.0f;
            order = f;
        } else {
            order = this.isDialogOrderFileLoaded() ? this.getOrderFromDialogList(groupName) : this.getOrderFromDialogElem(dialogElem);
        }
        NodeList platformElemList = dialogElem.getElementsByTagName("platform");
        for (int i = 0; i < platformElemList.getLength(); ++i) {
            Element platformElem = (Element)platformElemList.item(i);
            Dialog dialog = this.parsePlatformElem(platformElem, groupName, order, task);
            if (dialog.getPropertyCount() <= 0) continue;
            this.addDialog(dialog);
        }
        DialogElement newElem = new DialogElement(groupName, order, dialogElem);
        Iterator<DialogElement> it = this.sortedDialogElems.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(newElem)) continue;
            Logging.log.severe("Another dialog with the same name was found: " + groupName + ". ConfigBundle: " + currentConfigBundleName + ".");
            throw new SAXException("Another dialog with the same name was found: " + groupName + ".");
        }
        this.sortedDialogElems.add(newElem);
    }

    private Dialog parsePlatformElem(Element platformElem, String groupName, float order, String task) {
        String platformName = platformElem.getAttribute("plat").toLowerCase(Locale.ENGLISH);
        Dialog dialog = new Dialog(groupName, platformName, order, task);
        NodeList propertyElemList = platformElem.getElementsByTagName("property");
        for (int i = 0; i < propertyElemList.getLength(); ++i) {
            Element propertyElem = (Element)propertyElemList.item(i);
            Property property = this.parsePropertyElem(propertyElem);
            dialog.addProperty(property);
            this.addDependsOnProperty(property.getName());
        }
        return dialog;
    }

    private Property parsePropertyElem(Element propertyElem) {
        Property property = new Property();
        property.name = propertyElem.getAttribute("name");
        property.order = Integer.parseInt(propertyElem.getAttribute("order"));
        property.rule = propertyElem.getAttribute("rule");
        property.owner = propertyElem.getAttribute("owner");
        String temp = propertyElem.getAttribute("depends");
        if (temp == null) {
            Property.access$1002(property, new String[0]);
        } else {
            StringTokenizer tokens = new StringTokenizer(temp);
            Property.access$1002(property, new String[tokens.countTokens()]);
            int i = 0;
            while (tokens.hasMoreTokens()) {
                ((Property)property).depends[i] = tokens.nextToken();
                ++i;
            }
        }
        temp = propertyElem.getAttribute("prompt");
        if ("true".equalsIgnoreCase(temp)) {
            property.prompt = true;
        } else if ("false".equalsIgnoreCase(temp)) {
            property.prompt = false;
        } else {
            property.genPrompt = temp;
        }
        property.setType(propertyElem.getAttribute("type"));
        temp = propertyElem.getAttribute("control").toLowerCase(Locale.ENGLISH);
        if ("small".equals(temp)) {
            property.size = 1;
        } else if ("medium".equals(temp)) {
            property.size = 2;
        } else if ("large".equals(temp)) {
            property.size = 3;
        }
        temp = propertyElem.getAttribute("level").toLowerCase(Locale.ENGLISH);
        if ("basic".equals(temp)) {
            property.level = 1;
        } else if ("advanced".equals(temp)) {
            property.level = 2;
        }
        String minLen = propertyElem.getAttribute("minlength").trim();
        if (minLen != null && minLen.length() > 0) {
            try {
                property.minLength = Integer.parseInt(minLen);
            }
            catch (Exception e) {
                property.minLength = 0;
            }
        } else {
            property.minLength = 0;
        }
        String maxLen = propertyElem.getAttribute("maxlength").trim();
        if (maxLen != null && maxLen.length() > 0) {
            try {
                property.maxLength = Integer.parseInt(maxLen);
            }
            catch (Exception e) {
                property.maxLength = 0;
            }
        } else {
            property.maxLength = 0;
        }
        temp = propertyElem.getAttribute("persist");
        if ("true".equalsIgnoreCase(temp)) {
            property.persist = true;
        } else if ("false".equalsIgnoreCase(temp)) {
            property.persist = false;
        }
        temp = propertyElem.getAttribute("scope").toLowerCase(Locale.ENGLISH);
        if ("public".equals(temp)) {
            property.scope = 1;
        } else if ("private".equals(temp)) {
            property.scope = 2;
        }
        String ver = propertyElem.getAttribute("version").trim();
        if (ver != null && ver.length() > 0) {
            try {
                property.version = Float.parseFloat(ver);
            }
            catch (Exception e) {
                property.version = 0.0f;
            }
        } else {
            property.version = 0.0f;
        }
        property.setMaintType(propertyElem.getAttribute("mainttype"));
        return property;
    }

    public DocumentBuilder getDocumentBuilder(boolean enableValidation) throws SAXException, ParserConfigurationException {
        DocumentBuilder docBuilder = null;
        docBuilder = enableValidation ? this.docBuilderValEnabled : this.docBuilderValDisabled;
        if (docBuilder == null) {
            File schemaFile;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            if (enableValidation && (schemaFile = ProductDirUtils.getProductDataFile("cfgwizard", Utils.joinPath(CONFIGURE_SUBDIR, SCHEMA_FILE_NAME))) != null) {
                factory.setNamespaceAware(true);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(schemaFile);
                factory.setSchema(schema);
            }
            docBuilder = factory.newDocumentBuilder();
            if (enableValidation) {
                docBuilder.setErrorHandler(new ErrorHandler(){

                    @Override
                    public void warning(SAXParseException e) throws SAXException {
                        Logging.logStackTrace(e);
                    }

                    @Override
                    public void error(SAXParseException e) throws SAXException {
                        Logging.logStackTrace(e);
                        throw e;
                    }

                    @Override
                    public void fatalError(SAXParseException e) throws SAXException {
                        Logging.logStackTrace(e);
                        throw e;
                    }
                });
            }
            if (enableValidation) {
                this.docBuilderValEnabled = docBuilder;
            } else {
                this.docBuilderValDisabled = docBuilder;
            }
        }
        return docBuilder;
    }

    public Dialog[] getDialogs(String plat) {
        Dialog[] ret = this.cachedDialogsByPlat.get(plat);
        if (ret == null) {
            TreeSet<Dialog> prtDialogs;
            if (Globals.g_debug && Globals.g_logLevel == 2) {
                Logging.log.finer("DialogData::getDialogs(" + plat + ")++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            }
            TreeSet<Dialog> platDialogs = prtDialogs = this.getSortedDialogsForPlat("prt");
            if (!plat.equalsIgnoreCase("prt")) {
                platDialogs = this.getSortedDialogsForPlat(plat);
                for (Dialog prtDialog : prtDialogs) {
                    Dialog key = new Dialog(prtDialog.getGroup(), plat, 0.0f, prtDialog.getTask());
                    Dialog existingDialog = this.getExistingDialog(key);
                    if (existingDialog == null) {
                        platDialogs.add(prtDialog);
                        if (!Globals.g_debug || Globals.g_logLevel != 2) continue;
                        Logging.log.finer("DialogData::Added: " + prtDialog);
                        continue;
                    }
                    if (Globals.g_debug && Globals.g_logLevel == 2) {
                        Logging.log.finer("DialogData::Before merge: " + existingDialog);
                    }
                    existingDialog.addProperties(prtDialog.getProperties());
                    if (!Globals.g_debug || Globals.g_logLevel != 2) continue;
                    Logging.log.finer("DialogData::After merge: " + existingDialog);
                }
            }
            ret = platDialogs.toArray(new Dialog[0]);
            this.cachedDialogsByPlat.put(plat, ret);
        }
        return ret;
    }

    private class DialogElement
    implements Comparable<DialogElement> {
        private String group = null;
        private float order = 0.0f;
        private Element element = null;

        private DialogElement(String group, float order, Element element) {
            this.group = group;
            this.order = order;
            this.element = element;
        }

        public int hashCode() {
            return this.group.hashCode();
        }

        public boolean equals(Object obj) {
            boolean ret = false;
            if (obj != null && obj instanceof DialogElement) {
                DialogElement other = (DialogElement)obj;
                ret = this.group.equalsIgnoreCase(other.group);
            }
            return ret;
        }

        @Override
        public int compareTo(DialogElement other) {
            int ret = 0;
            if (other != null && (ret = Float.compare(this.order, other.order)) == 0) {
                ret = this.group.compareTo(other.group);
            }
            return ret;
        }

        private Element getElement() {
            return this.element;
        }
    }

    public class Dialog
    implements Comparable<Dialog> {
        private String group = null;
        private String platform = null;
        private String task = null;
        private float order = 0.0f;
        private TreeSet<Property> propertyList = new TreeSet();

        private Dialog(String group, String platform, float order, String task) {
            this.group = group;
            this.platform = platform;
            this.order = order;
            this.task = task;
        }

        private void addProperty(Property property) {
            this.propertyList.add(property);
        }

        private void addProperties(Property[] properties) {
            for (int i = 0; i < properties.length; ++i) {
                this.addProperty(properties[i]);
            }
        }

        private String getPlatform() {
            return this.platform;
        }

        public String getGroup() {
            return this.group;
        }

        public String getTask() {
            return this.task;
        }

        public int getPropertyCount() {
            return this.propertyList.size();
        }

        public Property[] getProperties() {
            return this.propertyList.toArray(new Property[0]);
        }

        public String toString() {
            return "(dialog=" + this.group + ",plat=" + this.platform + ",order=" + this.order + ") contains " + this.propertyList;
        }

        public int hashCode() {
            return this.group.hashCode();
        }

        public boolean equals(Object obj) {
            boolean ret = false;
            if (obj != null && obj instanceof Dialog) {
                Dialog other = (Dialog)obj;
                ret = this.group.equalsIgnoreCase(other.group) && this.platform.equalsIgnoreCase(other.platform);
            }
            return ret;
        }

        @Override
        public int compareTo(Dialog other) {
            int ret = 0;
            if (other != null && (ret = Float.compare(this.order, other.order)) == 0) {
                ret = this.group.compareTo(other.group);
            }
            return ret;
        }
    }

    public static class Property
    implements Comparable<Property> {
        public static final int TYPE_STRING = 1;
        public static final int TYPE_STRING_REQUIRED = 2;
        public static final int TYPE_NUMBER = 3;
        public static final int TYPE_BOOLEAN = 4;
        public static final int TYPE_USERID = 5;
        public static final int TYPE_USERID_MS = 6;
        public static final int TYPE_USERID_STATIC = 7;
        public static final int TYPE_PASSWORD = 8;
        public static final int TYPE_PASSWORD_OS = 9;
        public static final int TYPE_PASSWORD_OS_BAT = 10;
        public static final int TYPE_PASSWORD_MS = 11;
        public static final int TYPE_PASSWORD_MS_NEW = 12;
        public static final int TYPE_PASSWORD_PLAIN = 13;
        public static final int TYPE_FILE = 14;
        public static final int TYPE_FILE_EXISTS = 15;
        public static final int TYPE_FILE_OPTIONAL = 16;
        public static final int TYPE_DIR = 17;
        public static final int TYPE_DIR_EXISTS = 18;
        public static final int TYPE_DIR_OPTIONAL = 19;
        public static final int TYPE_URL = 20;
        public static final int TYPE_URI = 21;
        public static final int TYPE_PORT = 22;
        public static final int TYPE_COMBO = 23;
        public static final int TYPE_JOBCARD = 24;
        public static final int TYPE_STATIC = 25;
        public static final int TYPE_UNIQUE = 26;
        public static final int TYPE_RELATIVE_DIR = 27;
        public static final int TYPE_HIGH_LEVEL_QUALIFIER = 28;
        public static final int TYPE_WORKSPC = 29;
        public static final int TYPE_INTRDR = 30;
        public static final int TYPE_EMAIL = 31;
        public static final int TYPE_DEPENDENCY = 32;
        public static final int TYPE_USER_SVC_NUMBER = 33;
        public static final int TYPE_PASSWORD_OPTIONAL = 34;
        public static final int TYPE_MULTICAST = 35;
        public static final int TYPE_RANGE = 36;
        public static final int TYPE_WEB_APP_SERVER_NAME = 37;
        public static final int TYPE_DIR_WRITABLE = 38;
        public static final int TYPE_JAR_EXISTS = 39;
        public static final int TYPE_JARDIR_EXISTS = 40;
        public static final int TYPE_VALIDATOR_GROOVY_CLASS = 41;
        public static final int TYPE_HOSTNAME = 42;
        public static final int TYPE_HOSTNAME_OPTIONAL = 43;
        public static final int TYPE_DIR_DOES_NOT_EXIST = 44;
        public static final int TYPE_STRING_NOSPACE = 45;
        public static final int TYPE_PORT_NEW = 46;
        public static final int TYPE_BOOLEAN_GROUP_VALIDATOR = 47;
        public static final int TYPE_STATIC_AREA = 48;
        public static final int TYPE_USERID_MS_UNIQUE = 49;
        public static final int TYPE_DIR_WIN = 50;
        public static final int TYPE_DIR_UNX = 51;
        public static final int TYPE_DIR_MAC = 52;
        public static final int TYPE_SMS_PARAMS = 53;
        public static final int TYPE_SMS_PDSE_PARAMS = 54;
        public static final int TYPE_DISKUNIT = 55;
        public static final int TYPE_TMPUNI = 56;
        public static final int TYPE_VOLDISK = 57;
        public static final int TYPE_CNTL_AVAILABLE = 58;
        public static final int SIZE_SMALL = 1;
        public static final int SIZE_MEDIUM = 2;
        public static final int SIZE_LARGE = 3;
        public static final int LEVEL_BASIC = 1;
        public static final int LEVEL_ADVANCED = 2;
        public static final int SCOPE_PUBLIC = 1;
        public static final int SCOPE_PRIVATE = 2;
        private String name = null;
        private String rule = null;
        private String owner = null;
        private String genPrompt = null;
        private String comboData = null;
        private String genType = null;
        private String uniqueData = null;
        private String rangeData = null;
        private String[] depends = null;
        private int order = 0;
        private int type = 0;
        private int size = 0;
        private int level = 0;
        private int minLength = 0;
        private int maxLength = 0;
        private int scope = 0;
        private int maintType = 0;
        private float version = 0.0f;
        private boolean prompt = false;
        private boolean persist = false;

        public static String parseNamespacePrefix(String propertyName) {
            String namespacePrefix = "";
            int indexPeriod = propertyName.lastIndexOf(46);
            if (indexPeriod != -1) {
                namespacePrefix = propertyName.substring(0, indexPeriod);
            }
            return namespacePrefix;
        }

        public Property() {
        }

        public Property(String name) {
            this.name = name;
        }

        public Property(String name, String rule, String owner, int type, boolean prompt) {
            this.name = name;
            this.rule = rule;
            this.owner = owner;
            this.type = type;
            this.prompt = prompt;
        }

        public String toString() {
            return "(property=" + this.name + ",type=" + this.type + ",order=" + this.order + ")";
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            boolean ret = false;
            if (obj != null && obj instanceof Property) {
                Property other = (Property)obj;
                ret = this.name.equalsIgnoreCase(other.name);
            }
            return ret;
        }

        @Override
        public int compareTo(Property other) {
            int ret = 0;
            if (other != null && (ret = this.order - other.order) == 0) {
                ret = this.name.compareTo(other.name);
            }
            return ret;
        }

        public void setType(String fieldType) {
            String temp = fieldType.toLowerCase(Locale.ENGLISH);
            if ("string".equals(temp)) {
                this.type = 1;
            } else if ("string_required".equals(temp)) {
                this.type = 2;
            } else if ("number".equals(temp)) {
                this.type = 3;
            } else if ("boolean".equals(temp)) {
                this.type = 4;
            } else if ("userid".equals(temp)) {
                this.type = 5;
            } else if ("userid_ms".equals(temp)) {
                this.type = 6;
            } else if ("userid_static".equals(temp)) {
                this.type = 7;
            } else if ("password".equals(temp)) {
                this.type = 8;
            } else if ("password_opt".equals(temp)) {
                this.type = 34;
            } else if ("password_os".equals(temp)) {
                this.type = 9;
            } else if ("password_os_bat".equals(temp)) {
                this.type = 10;
            } else if ("password_ms".equals(temp)) {
                this.type = 11;
            } else if ("password_ms_new".equals(temp)) {
                this.type = 12;
            } else if ("password_plain".equals(temp)) {
                this.type = 13;
            } else if ("file".equals(temp)) {
                this.type = 14;
            } else if ("file_exists".equals(temp)) {
                this.type = 15;
            } else if ("jar_exists".equals(temp)) {
                this.type = 39;
            } else if ("validator_groovy_class".equals(temp)) {
                this.type = 41;
            } else if ("file_optional".equals(temp)) {
                this.type = 16;
            } else if ("dir".equals(temp)) {
                this.type = 17;
            } else if ("dir_exists".equals(temp)) {
                this.type = 18;
            } else if ("jardir_exists".equals(temp)) {
                this.type = 40;
            } else if ("dir_win".equals(temp)) {
                this.type = 50;
            } else if ("dir_unx".equals(temp)) {
                this.type = 51;
            } else if ("dir_mac".equals(temp)) {
                this.type = 52;
            } else if ("dir_writable".equals(temp)) {
                this.type = 38;
            } else if ("dir_optional".equals(temp)) {
                this.type = 19;
            } else if ("dir_does_not_exist".equals(temp)) {
                this.type = 44;
            } else if ("url".equals(temp)) {
                this.type = 20;
            } else if ("uri".equals(temp)) {
                this.type = 21;
            } else if ("port".equals(temp)) {
                this.type = 22;
            } else if ("port_new".equals(temp)) {
                this.type = 46;
            } else if ("boolean_group_validator".equals(temp)) {
                this.type = 47;
            } else if ("static_area".equals(temp)) {
                this.type = 48;
            } else if ("userid_ms_unique".equals(temp)) {
                this.type = 49;
            } else if (temp != null && temp.startsWith("combo")) {
                this.type = 23;
                this.comboData = fieldType.length() > 7 && fieldType.substring(5, 6).equals("[") && fieldType.endsWith("]") ? fieldType.substring(6, fieldType.length() - 1) : "";
            } else if ("jobcard".equals(temp)) {
                this.type = 24;
            } else if ("static".equals(temp)) {
                this.type = 25;
            } else if (temp != null && temp.startsWith("unique")) {
                this.type = 26;
                this.uniqueData = fieldType.length() > 8 && fieldType.substring(6, 7).equals("[") && fieldType.endsWith("]") ? fieldType.substring(7, fieldType.length() - 1) : "";
            } else if ("relative_dir".equals(temp)) {
                this.type = 27;
            } else if ("high_level_qualifier".equals(temp)) {
                this.type = 28;
            } else if ("sms_params".equals(temp)) {
                this.type = 53;
            } else if ("sms_pdse_params".equals(temp)) {
                this.type = 54;
            } else if ("diskunit".equals(temp)) {
                this.type = 55;
            } else if ("tmpuni".equals(temp)) {
                this.type = 56;
            } else if ("voldisk".equals(temp)) {
                this.type = 57;
            } else if ("cntl_available".equals(temp)) {
                this.type = 58;
            } else if ("workspc".equals(temp)) {
                this.type = 29;
            } else if ("intrdr".equals(temp)) {
                this.type = 30;
            } else if ("email".equals(temp)) {
                this.type = 31;
            } else if (temp != null && temp.startsWith("dependency")) {
                this.type = 32;
                this.comboData = fieldType.length() > 12 && fieldType.substring(10, 11).equals("[") && fieldType.endsWith("]") ? fieldType.substring(11, fieldType.length() - 1) : "";
            } else if ("user_svc_number".equals(temp)) {
                this.type = 33;
            } else if ("multicast".equals(temp)) {
                this.type = 35;
            } else if (temp != null && temp.startsWith("range")) {
                this.type = 36;
                this.rangeData = fieldType.length() > 7 && fieldType.substring(5, 6).equals("[") && fieldType.endsWith("]") ? fieldType.substring(6, fieldType.length() - 1) : "";
            } else if ("dir_win".equals(temp)) {
                this.type = 50;
            } else if ("dir_unx".equals(temp)) {
                this.type = 51;
            } else if ("dir_mac".equals(temp)) {
                this.type = 52;
            } else if ("web_app_server_name".equals(temp)) {
                this.type = 37;
            } else if ("hostname".equals(temp)) {
                this.type = 42;
            } else if ("hostname_optional".equals(temp)) {
                this.type = 43;
            } else if ("string_nospace".equals(temp)) {
                this.type = 45;
            } else {
                this.genType = fieldType;
            }
            if (this.type != 23 && this.type != 32) {
                this.comboData = "";
            }
            if (this.type != 26) {
                this.uniqueData = "";
            }
            if (this.type != 36) {
                this.rangeData = "";
            }
        }

        public void setMaintType(String fieldMaintType) {
            String temp = fieldMaintType.toLowerCase(Locale.ENGLISH);
            if ("string".equals(temp)) {
                this.maintType = 1;
            } else if ("string_required".equals(temp)) {
                this.maintType = 2;
            } else if ("number".equals(temp)) {
                this.maintType = 3;
            } else if ("boolean".equals(temp)) {
                this.maintType = 4;
            } else if ("userid".equals(temp)) {
                this.maintType = 5;
            } else if ("userid_ms".equals(temp)) {
                this.maintType = 6;
            } else if ("userid_static".equals(temp)) {
                this.maintType = 7;
            } else if ("password".equals(temp)) {
                this.maintType = 8;
            } else if ("password_opt".equals(temp)) {
                this.maintType = 34;
            } else if ("password_os".equals(temp)) {
                this.maintType = 9;
            } else if ("password_os_bat".equals(temp)) {
                this.maintType = 10;
            } else if ("password_ms".equals(temp)) {
                this.maintType = 11;
            } else if ("password_ms_new".equals(temp)) {
                this.maintType = 12;
            } else if ("password_plain".equals(temp)) {
                this.maintType = 13;
            } else if ("file".equals(temp)) {
                this.maintType = 14;
            } else if ("file_exists".equals(temp)) {
                this.maintType = 15;
            } else if ("jar_exists".equals(temp)) {
                this.maintType = 39;
            } else if ("validator_groovy_class".equals(temp)) {
                this.maintType = 41;
            } else if ("file_optional".equals(temp)) {
                this.maintType = 16;
            } else if ("dir".equals(temp)) {
                this.maintType = 17;
            } else if ("dir_exists".equals(temp)) {
                this.maintType = 18;
            } else if ("dir_win".equals(temp)) {
                this.maintType = 50;
            } else if ("dir_unx".equals(temp)) {
                this.maintType = 51;
            } else if ("dir_mac".equals(temp)) {
                this.maintType = 52;
            } else if ("jardir_exists".equals(temp)) {
                this.maintType = 40;
            } else if ("dir_writable".equals(temp)) {
                this.maintType = 38;
            } else if ("dir_optional".equals(temp)) {
                this.maintType = 19;
            } else if ("dir_does_not_exist".equals(temp)) {
                this.maintType = 44;
            } else if ("url".equals(temp)) {
                this.maintType = 20;
            } else if ("uri".equals(temp)) {
                this.maintType = 21;
            } else if ("port".equals(temp)) {
                this.maintType = 22;
            } else if ("port_new".equals(temp)) {
                this.maintType = 46;
            } else if ("boolean_group_validator".equals(temp)) {
                this.maintType = 47;
            } else if ("jobcard".equals(temp)) {
                this.maintType = 24;
            } else if ("static".equals(temp)) {
                this.maintType = 25;
            } else if ("relative_dir".equals(temp)) {
                this.maintType = 27;
            } else if ("high_level_qualifier".equals(temp)) {
                this.maintType = 28;
            } else if ("workspc".equals(temp)) {
                this.maintType = 29;
            } else if ("intrdr".equals(temp)) {
                this.maintType = 30;
            } else if ("sms_params".equals(temp)) {
                this.maintType = 53;
            } else if ("sms_pdse_params".equals(temp)) {
                this.maintType = 54;
            } else if ("diskunit".equals(temp)) {
                this.maintType = 55;
            } else if ("tmpuni".equals(temp)) {
                this.maintType = 56;
            } else if ("voldisk".equals(temp)) {
                this.maintType = 57;
            } else if ("cntl_available".equals(temp)) {
                this.maintType = 58;
            } else if ("email".equals(temp)) {
                this.maintType = 31;
            } else if ("user_svc_number".equals(temp)) {
                this.maintType = 33;
            } else if ("multicast".equals(temp)) {
                this.maintType = 35;
            } else if ("hostname".equals(temp)) {
                this.maintType = 42;
            } else if ("hostname_optional".equals(temp)) {
                this.maintType = 43;
            } else if ("web_app_server_name".equals(temp)) {
                this.maintType = 37;
            } else if ("string_nospace".equals(temp)) {
                this.maintType = 45;
            } else if ("static_area".equals(temp)) {
                this.maintType = 48;
            } else if ("userid_ms_unique".equals(temp)) {
                this.maintType = 49;
            }
        }

        public String getName() {
            return this.name;
        }

        public int getOrder() {
            return this.order;
        }

        public String getRule() {
            return this.rule;
        }

        public String[] getDepends() {
            return this.depends;
        }

        public String getOwner() {
            return this.owner;
        }

        public boolean getPrompt() {
            return this.prompt;
        }

        public String getGenPrompt() {
            return this.genPrompt;
        }

        public int getType(boolean maintenance) {
            if (maintenance) {
                if (this.maintType > 0) {
                    return this.maintType;
                }
                return this.type;
            }
            return this.type;
        }

        public String getGenType() {
            return this.genType;
        }

        public String getComboData() {
            return this.comboData;
        }

        public String getRangeData() {
            return this.rangeData;
        }

        public String getUniqueData() {
            return this.uniqueData;
        }

        public int getSize() {
            return this.size;
        }

        public int getLevel() {
            return this.level;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public int getMinLength() {
            return this.minLength;
        }

        public boolean getPersist() {
            return this.persist;
        }

        public int getScope() {
            return this.scope;
        }

        public float getVersion() {
            return this.version;
        }

        public int getMaintType() {
            return this.maintType;
        }

        static /* synthetic */ String[] access$1002(Property x0, String[] x1) {
            x0.depends = x1;
            return x1;
        }
    }
}

