/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.CdId;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DeploymentData;
import com.sas.ssn.DepotExclusions;
import com.sas.ssn.ExtendedOrderData;
import com.sas.ssn.FileMode;
import com.sas.ssn.Globals;
import com.sas.ssn.HotFix;
import com.sas.ssn.HotFixInstructions;
import com.sas.ssn.HotFixSecurityManager;
import com.sas.ssn.JREData;
import com.sas.ssn.Logging;
import com.sas.ssn.OrderData;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SkuData;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import com.sas.ssn.VolserData;
import com.sas.tools.installs.it.vjr.VJRException;
import com.sas.tools.installs.it.vjr.VJRManager;
import com.sas.tools.installs.it.vjr.VJRPluginZip;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;

public class DepotManager {
    public static final int NORMAL_DEPOT = 0;
    public static final int CLIENT_SERVER = 1;
    public static final int PERSONAL_SERVER = 2;
    private final String XML_DATE_FORMAT = "yyyyMMddHHmmss";
    private final String GUI_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private final String LOCK_FILE = "sassd.lck";
    private final SSNResource bundle = new SSNResource(DepotManager.class);
    private boolean writable = false;
    private boolean preSPSDepot = false;
    private boolean installDepot = false;
    private boolean createdLockFile = false;
    private String target;
    private String exportTarget;
    private String lockFile;
    private DeploymentData depotData;
    private boolean existingDepot;
    private boolean allowMoreOrders;
    private RandomAccessFile lockRAF;
    private FileLock lock;
    private int depotType = 0;
    private int depotVersion = 0;

    public DepotManager(File target) {
        this(target.getAbsolutePath());
    }

    public DepotManager(String target) {
        this.depotData = this.loadDeploymentData(target, true);
        this.target = this.depotData.getMediaRoot();
        this.lockFile = new File(this.target, "sassd.lck").getAbsolutePath();
        this.refreshDepotData(this.depotData, false);
    }

    public DepotManager(DeploymentData depotData) {
        this.target = depotData.getMediaRoot();
        this.lockFile = new File(this.target, "sassd.lck").getAbsolutePath();
        this.refreshDepotData(depotData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDepotData(DeploymentData depotData, boolean reload) {
        if (reload) {
            depotData.clear();
            depotData.loadOrders();
        }
        this.depotData = depotData;
        File file = new File(this.target, "sassd.txt");
        this.existingDepot = file.isFile() && depotData.getOrderCount() > 0;
        this.allowMoreOrders = true;
        this.writable = Utils.canWriteToPath(depotData.getMediaRoot());
        this.preSPSDepot = false;
        this.installDepot = false;
        if (this.existingDepot) {
            OrderData[] orders = depotData.getOrders();
            for (int i = 0; this.depotVersion == 0 && i < orders.length; ++i) {
                this.depotVersion = orders[i].getDepotVersionAsInt();
            }
            try {
                FileInputStream stream = null;
                BufferedReader reader = null;
                try {
                    stream = new FileInputStream(file);
                    reader = new BufferedReader(new InputStreamReader((InputStream)stream, "UTF-8"));
                    String type = reader.readLine();
                    while (type != null) {
                        if ("locked".equals(type) && this.depotVersion < 2) {
                            this.allowMoreOrders = false;
                        } else if ("locked2".equals(type) && this.depotVersion >= 2) {
                            this.allowMoreOrders = false;
                        } else if ("personal".equals(type)) {
                            this.allowMoreOrders = false;
                            this.depotType = 2;
                        } else if ("client".equals(type)) {
                            this.allowMoreOrders = false;
                            this.depotType = 1;
                        } else if ("presps".equals(type)) {
                            this.allowMoreOrders = false;
                            this.writable = false;
                            this.preSPSDepot = true;
                        } else if ("installdepot".equals(type)) {
                            this.installDepot = true;
                        }
                        type = reader.readLine();
                    }
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException stream) {
                // empty catch block
            }
            if (this.allowMoreOrders) {
                for (int i = 0; this.allowMoreOrders && i < orders.length; ++i) {
                    if (!orders[i].isStandAlone()) continue;
                    this.allowMoreOrders = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateBootstrapDataFile(DeploymentData deploymentData) {
        if (deploymentData != null) {
            File file = new File(deploymentData.getMediaRoot(), "setup.dat");
            try (PrintStream stream = null;){
                String path = null;
                stream = new PrintStream((OutputStream)new FileOutputStream(file), false, "UTF-8");
                stream.println("[default]");
                SpsSkuData spsSkuData = deploymentData.getNewestSpsSku("deploywiz", null, false);
                if (spsSkuData != null && (path = deploymentData.getVolser(spsSkuData.getVolsers()[0]).getProductPath(spsSkuData.getSpsSku())) != null) {
                    stream.println("inifile=" + path + "/deploywiz.ini");
                }
                stream.println("");
                stream.println("[properties]");
                if (path != null) {
                    stream.println("DEPLOYWIZ_PRT_PKG=" + path);
                }
                String[] hosts = new String[]{"ALX", "H64", "H6I", "LAX", "LIX", "LNX", "MAC", "R64", "S64", "SAX", "VMI", "W64", "WIN", "WX6"};
                for (int i = 0; i < hosts.length; ++i) {
                    VolserData volserData;
                    int j;
                    String[] volsers;
                    spsSkuData = deploymentData.getNewestSpsSku("privatejre", hosts[i], false);
                    if (spsSkuData != null) {
                        path = null;
                        volsers = spsSkuData.getVolsers();
                        for (j = 0; path == null && j < volsers.length; ++j) {
                            volserData = deploymentData.getVolser(volsers[j]);
                            if (!volserData.isPayloadIncluded(spsSkuData.getSpsSku())) continue;
                            path = volserData.getProductPath(spsSkuData.getSpsSku());
                        }
                        if (path == null) continue;
                        stream.println("privatejre".toUpperCase() + "_" + hosts[i] + "_PKG=" + path);
                        continue;
                    }
                    spsSkuData = deploymentData.getNewestSpsSku("javaruntime", hosts[i], false);
                    if (spsSkuData == null) continue;
                    path = null;
                    volsers = spsSkuData.getVolsers();
                    for (j = 0; path == null && j < volsers.length; ++j) {
                        volserData = deploymentData.getVolser(volsers[j]);
                        if (!volserData.isPayloadIncluded(spsSkuData.getSpsSku())) continue;
                        path = volserData.getProductPath(spsSkuData.getSpsSku());
                    }
                    if (path == null) continue;
                    stream.println("javaruntime".toUpperCase() + "_" + hosts[i] + "_PKG=" + path);
                }
                stream.checkError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDepotSummary() {
        File file = new File(this.target, "depotsummary.html");
        try (PrintStream stream = null;){
            stream = new PrintStream((OutputStream)new FileOutputStream(file), false, "UTF-8");
            stream.println("<html>");
            stream.println("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            stream.println("");
            stream.println("  <head>");
            stream.println("    <title>SAS Software Depot Summary Information</title>");
            stream.println("  </head>");
            stream.println("");
            stream.println("  <body>");
            stream.println("    <h3>SAS Software Depot Summary Information</h3>");
            stream.println("");
            stream.println("    <table border=1>");
            stream.println("      <tr>");
            stream.println("        <th>Order Number</th>");
            stream.println("        <th>Description</th>");
            stream.println("        <th>Software</th>");
            stream.println("        <th>Date Added</th>");
            stream.println("        <th>Added By</th>");
            stream.println("        <th>QuickStart Guide</th>");
            stream.println("      </tr>");
            OrderData[] orders = this.depotData.getOrders();
            for (int i = 0; i < orders.length; ++i) {
                stream.println("");
                stream.println("      <tr>");
                stream.println("        <td valign=\"top\" rowspan=2>" + Utils.escapeHTMLString(orders[i].getOrder()) + "</td>");
                stream.println("        <td valign=\"top\">" + Utils.escapeHTMLString(orders[i].getDescription("en")) + "</td>");
                stream.println("        <td valign=\"top\">" + Utils.escapeHTMLString(orders[i].getOriginalDescription("en")) + "</td>");
                stream.println("        <td valign=\"top\">" + Utils.escapeHTMLString(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new SimpleDateFormat("yyyyMMddHHmmss").parse(orders[i].getExtendedData().getTime(), new ParsePosition(0)))) + "</td>");
                stream.println("        <td valign=\"top\">" + Utils.escapeHTMLString(orders[i].getExtendedData().getUser()) + "</td>");
                String qsPDF = null;
                String qsHTML = null;
                String qsProductDir = this.depotData.getProductDir(orders[i].getOrder(), "quickstart", true, false);
                if (qsProductDir != null) {
                    if (qsProductDir.startsWith("./")) {
                        qsProductDir = qsProductDir.substring(2);
                    }
                    if (!new File(this.target, qsPDF = qsProductDir + "/quickstart.pdf").isFile()) {
                        qsPDF = null;
                    }
                    if (!new File(this.target, qsHTML = qsProductDir + "/quickstart.html").isFile()) {
                        qsHTML = null;
                    }
                } else {
                    qsPDF = "install_doc/" + orders[i].getOrder() + "/quickstart.pdf";
                    if (!new File(this.target, qsPDF).isFile()) {
                        qsPDF = null;
                    }
                    if (!new File(this.target, qsHTML = "install_doc/" + orders[i].getOrder() + "/quickstart.html").isFile()) {
                        qsHTML = null;
                    }
                }
                if (qsPDF != null || qsHTML != null) {
                    stream.println("        <td valign=\"top\">");
                    if (qsPDF != null) {
                        stream.println("          <a href=\"" + qsPDF + "\">PDF format</a>");
                    }
                    if (qsPDF != null && qsHTML != null) {
                        stream.println("          <br>");
                    }
                    if (qsHTML != null) {
                        stream.println("          <a href=\"" + qsHTML + "\">HTML format</a>");
                    }
                    stream.println("        </td>");
                } else {
                    stream.println("        <td valign=\"top\">" + Utils.escapeHTMLString("<none>") + "</td>");
                }
                stream.println("      </tr>");
                String note = orders[i].getExtendedData().getNote();
                if (note == null) {
                    note = "<none>";
                }
                note = Utils.escapeHTMLString(note);
                note = note.replaceAll("\\n", "<br>");
                stream.println("");
                stream.println("      <tr>");
                stream.println("        <td valign=\"top\" colspan=5>");
                stream.println("          <table border=0 cellspacing=0 cellpadding=0>");
                stream.println("            <td valign=\"top\"><b>Notes:</b></td>");
                stream.println("            <td valign=\"top\">" + note + "</td>");
                stream.println("          </table>");
                stream.println("        </td>");
                stream.println("      </tr>");
            }
            stream.println("    </table>");
            stream.println("  </body>");
            stream.println("</html>");
            stream.checkError();
        }
    }

    private DeploymentData loadDeploymentData(String source, boolean loadFileLists) {
        DeploymentData data = new DeploymentData(source);
        data.setLoadFileLists(loadFileLists);
        data.loadOrders();
        return data;
    }

    public boolean setLock(boolean b) {
        boolean success;
        block19: {
            success = false;
            if (!this.isLocked()) {
                if (b) {
                    try {
                        File file = new File(this.lockFile);
                        if (!file.isFile() && file.createNewFile()) {
                            this.createdLockFile = true;
                        }
                        if (!file.isFile()) break block19;
                        this.lockRAF = new RandomAccessFile(this.lockFile, "rw");
                        if (!Globals.g_skipsysfilelock) {
                            this.lock = this.lockRAF.getChannel().tryLock();
                            if (this.lock != null) {
                                success = true;
                            } else {
                                this.lockRAF.close();
                                this.lockRAF = null;
                                if (this.createdLockFile) {
                                    new File(this.lockFile).delete();
                                    this.createdLockFile = false;
                                }
                            }
                            break block19;
                        }
                        success = true;
                    }
                    catch (Exception e) {
                        if (this.lockRAF != null) {
                            try {
                                this.lockRAF.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.lockRAF = null;
                        }
                        if (this.createdLockFile) {
                            new File(this.lockFile).delete();
                            this.createdLockFile = false;
                        }
                    }
                }
            } else if (!b) {
                try {
                    if (!Globals.g_skipsysfilelock) {
                        this.lock.release();
                    }
                    this.lockRAF.close();
                    this.lockRAF = null;
                    if (this.createdLockFile) {
                        new File(this.lockFile).delete();
                        this.createdLockFile = false;
                    }
                    this.lock = null;
                    success = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked() {
        boolean locked = false;
        if (this.lock != null) {
            locked = true;
        } else if (new File(this.lockFile).isFile()) {
            RandomAccessFile lockRAF = null;
            FileLock lock = null;
            try {
                lockRAF = new RandomAccessFile(this.lockFile, "rw");
                if (!Globals.g_skipsysfilelock) {
                    lock = lockRAF.getChannel().tryLock();
                    if (lock == null) {
                        locked = true;
                    } else {
                        lock.release();
                        lock = null;
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (lockRAF != null) {
                    try {
                        lockRAF.close();
                    }
                    catch (Exception exception) {}
                    lockRAF = null;
                }
            }
        }
        return locked;
    }

    public DeploymentData getDepotData() {
        return this.depotData;
    }

    public boolean existingDepot() {
        return this.existingDepot;
    }

    public boolean allowMoreOrders() {
        return this.allowMoreOrders;
    }

    public int getDepotType() {
        return this.depotType;
    }

    public int getDepotVersion() {
        return this.depotVersion;
    }

    public boolean isWritable() {
        return this.writable && (this.lock != null || !this.isLocked());
    }

    public boolean isCompressed() {
        VJRManager sourceVJRManager = VJRManager.getInstance();
        if (this.target != null && !this.target.equalsIgnoreCase(sourceVJRManager.getDepotHome())) {
            try {
                sourceVJRManager.loadDepot(this.target);
            }
            catch (VJRException vjre) {
                Logging.log.severe(vjre.getMessage());
            }
        }
        return sourceVJRManager.isDepotCompressed();
    }

    public boolean isPreSPSDepot() {
        return this.preSPSDepot;
    }

    public boolean isInstallDepot() {
        return this.installDepot;
    }

    public boolean containsOrder(String order) {
        return this.depotData.getOrder(order) != null;
    }

    public AddJob createAddJob(DeploymentData sourceData, String order) {
        return new AddJob(sourceData, order);
    }

    public DelJob createDelJob(String order) {
        return new DelJob(order);
    }

    public ExportJob createExportJob(String target, String order, String type) {
        return new ExportJob(target, order, type);
    }

    public boolean setDescription(String order, String description) {
        boolean success = true;
        OrderData orderData = this.depotData.getOrder(order);
        if (orderData == null) {
            success = false;
        } else if (description != null) {
            try {
                ExtendedOrderData eod = orderData.getExtendedData();
                if (description.equals(orderData.getOriginalDescription("en"))) {
                    eod.removeDescription();
                    success = eod.write();
                } else if (!description.equals(eod.getDescription())) {
                    eod.setDescription(description);
                    success = eod.write();
                }
            }
            catch (Exception e) {
                success = false;
                Logging.log.warning(e.getMessage());
            }
        }
        if (success) {
            this.generateDepotSummary();
        }
        return success;
    }

    public boolean setNote(String order, String note) {
        boolean success = true;
        OrderData orderData = this.depotData.getOrder(order);
        if (orderData == null) {
            success = false;
        } else if (note != null) {
            try {
                ExtendedOrderData eod = orderData.getExtendedData();
                if (note.trim().length() == 0) {
                    eod.removeNote();
                    success = eod.write();
                } else if (!note.equals(eod.getNote())) {
                    eod.setNote(note);
                    success = eod.write();
                }
            }
            catch (Exception e) {
                success = false;
                Logging.log.warning(e.getMessage());
            }
        }
        if (success) {
            this.generateDepotSummary();
        }
        return success;
    }

    private boolean is32bPrivateJRE() {
        if (Globals.g_jreHome == null) {
            return false;
        }
        if (!Globals.g_jreHome.contains("x86")) {
            return false;
        }
        String sasHome = Globals.g_wizardData.getPreference("SASHome", "");
        Path jreHome = Paths.get(sasHome, "x86", "SASPrivateJavaRuntimeEnvironment", "9.4", "jre");
        Path globalsJreHome = Paths.get(Globals.g_jreHome, new String[0]);
        try {
            if (Files.isSameFile(jreHome, globalsJreHome)) {
                return true;
            }
        }
        catch (IOException e) {
            Logging.log.info(e.getMessage());
        }
        return false;
    }

    public class AddJob
    extends Job {
        private boolean move;
        private String source;
        private String cloneDataSource;
        private String altSource;
        private String altTarget;
        private DeploymentData sourceData;
        private Vector omitSourceSpsSkus;
        private Hashtable replaceSourceSpsSkus;
        private VJRManager targetVJRManager;

        public AddJob(DeploymentData sourceData, String order) {
            super(order);
            this.move = false;
            this.cloneDataSource = null;
            this.omitSourceSpsSkus = new Vector();
            this.replaceSourceSpsSkus = new Hashtable();
            this.targetVJRManager = null;
            this.sourceData = sourceData;
            this.source = sourceData.getMediaRoot();
            this.setMode(0);
        }

        public void setMode(int mode) {
            this.mode = mode;
            switch (mode) {
                case 1: {
                    this.setSource(null);
                    this.setTarget(DepotManager.this.target + File.separator + "staging" + File.separator + this.order);
                    this.setMoveFiles(false);
                    break;
                }
                case 2: {
                    this.setSource(DepotManager.this.target + File.separator + "staging" + File.separator + this.order);
                    this.setTarget(null);
                    this.setMoveFiles(true);
                    break;
                }
                case 3: {
                    this.setSource(null);
                    this.setTarget(null);
                    this.setMoveFiles(true);
                    break;
                }
                case 4: {
                    this.setSource(null);
                    this.setTarget(null);
                    this.setMoveFiles(false);
                    break;
                }
                default: {
                    this.mode = 0;
                    this.setSource(null);
                    this.setTarget(null);
                    this.setMoveFiles(false);
                }
            }
            if (mode != 2) {
                this.setType(0);
            }
        }

        public int getMode() {
            return this.mode;
        }

        public void setType(int type) {
            try {
                this.setType(type, (File)null, (File)null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void setType(int type, String filterFile, String installFile) throws IOException {
            this.setType(type, filterFile == null ? null : new File(filterFile), installFile == null ? null : new File(installFile));
        }

        public void setType(int type, File filterFile, File installFile) throws IOException {
            this.type = type;
            switch (type) {
                case 0: {
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    this.type = 0;
                }
            }
            if (this.mode != 2) {
                this.loadEntities();
                if (filterFile != null) {
                    DepotExclusions installed = null;
                    if (installFile != null) {
                        installed = new DepotExclusions(installFile);
                    }
                    Enumeration e = new DepotExclusions(filterFile).elements();
                    while (e.hasMoreElements()) {
                        SkuData[] skuData;
                        String spsSku = (String)e.nextElement();
                        if (installed != null && installed.contains(spsSku)) {
                            this.omitSpsSkuPayload(spsSku);
                            continue;
                        }
                        this.omitSpsSku(spsSku);
                        SpsSkuData spsSkuData = this.sourceData.getSpsSku(spsSku);
                        if (spsSkuData == null || !"en".equals(spsSkuData.getLanguage()) || (skuData = spsSkuData.getSkus()).length != 1) continue;
                        ProductData[] maintData = this.sourceData.getMaintenance(this.order, spsSkuData.getProdCode(), skuData[0].getPlatform(), true);
                        for (int i = 0; i < maintData.length; ++i) {
                            this.omitSpsSku(maintData[i].getSpsSku());
                        }
                    }
                }
                if (this.mode == 4) {
                    this.omitSpsSku(this.sourceData.getNewestSpsSku("sdwstartup", null, true).getSpsSku());
                }
            }
        }

        public boolean omitSpsSkuPayload(String spsSku) {
            boolean success = false;
            if (spsSku != null) {
                Job.Entity entity = null;
                Enumeration e = this.entities.elements();
                while (!success && e.hasMoreElements()) {
                    entity = (Job.Entity)e.nextElement();
                    if (!spsSku.equals(entity.getSpsSku())) continue;
                    entity.setProcessPayload(false);
                    entity.setReferencePayload(false);
                    success = true;
                }
            }
            return success;
        }

        public boolean restoreSpsSkuPayload(String spsSku) {
            boolean success = false;
            if (spsSku != null) {
                Job.Entity entity = null;
                Enumeration e = this.entities.elements();
                while (!success && e.hasMoreElements()) {
                    entity = (Job.Entity)e.nextElement();
                    if (!spsSku.equals(entity.getSpsSku())) continue;
                    entity.setProcessPayload(true);
                    entity.setReferencePayload(true);
                    success = true;
                }
            }
            return success;
        }

        public boolean omitSpsSku(String spsSku) {
            boolean success = false;
            if (spsSku != null) {
                Job.Entity entity = null;
                Enumeration e = this.entities.elements();
                while (entity == null && e.hasMoreElements()) {
                    entity = (Job.Entity)e.nextElement();
                    if (!spsSku.equals(entity.getSpsSku())) {
                        entity = null;
                        continue;
                    }
                    if (!this.entities.remove(entity)) continue;
                    if (this.omitSourceSpsSkus.add(entity)) {
                        success = true;
                        continue;
                    }
                    this.entities.add(entity);
                }
            }
            return success;
        }

        public boolean restoreSpsSku(String spsSku) {
            boolean success = false;
            if (spsSku != null) {
                Job.Entity entity = null;
                Enumeration e = this.omitSourceSpsSkus.elements();
                while (entity == null && e.hasMoreElements()) {
                    entity = (Job.Entity)e.nextElement();
                    if (!spsSku.equals(entity.getSpsSku())) {
                        entity = null;
                        continue;
                    }
                    if (!this.omitSourceSpsSkus.remove(entity)) continue;
                    if (this.entities.add(entity)) {
                        success = true;
                        continue;
                    }
                    this.omitSourceSpsSkus.add(entity);
                }
            }
            return success;
        }

        private void initVJRManager() {
            if (this.mode == 1) {
                if (this.getSource() != null) {
                    VJRManager sourceVJRManager = VJRManager.getInstance();
                    if (!this.getSource().equalsIgnoreCase(sourceVJRManager.getDepotHome())) {
                        try {
                            sourceVJRManager.loadDepot(this.getSource());
                        }
                        catch (VJRException vjre) {
                            Logging.log.severe(vjre.toString());
                        }
                    }
                    sourceVJRManager.clearQueueVJRPluginZipsForDepotCreation();
                }
                if (this.getTarget() != null) {
                    try {
                        this.targetVJRManager = new VJRManager();
                        this.targetVJRManager.loadDepot(this.getRealTarget());
                    }
                    catch (VJRException vjre) {
                        Logging.log.severe(vjre.toString());
                    }
                }
            }
        }

        private void loadEntities() {
            this.entities.clear();
            this.omitSourceSpsSkus.clear();
            this.replaceSourceSpsSkus.clear();
            this.initVJRManager();
            OrderData sourceOrderData = this.sourceData.getOrder(this.order);
            if (sourceOrderData != null) {
                VolserData volser = null;
                SpsSkuData spsSku = null;
                SpsSkuData obsoleteSpsSku = null;
                String[] volsers = sourceOrderData.getVolsers(sourceOrderData.getMediaType());
                for (int i = 0; i < volsers.length; ++i) {
                    volser = this.sourceData.getVolser(volsers[i]);
                    String[] spsSkus = volser.getSpsSkus();
                    for (int j = 0; j < spsSkus.length; ++j) {
                        int k;
                        String[] targetVolsers;
                        boolean containsPayload;
                        boolean omitData = false;
                        boolean omitPayload = false;
                        boolean omitPayloadRef = false;
                        if (!volser.isPayloadIncluded(spsSkus[j])) {
                            omitPayload = true;
                        }
                        spsSku = this.sourceData.getSpsSku(spsSkus[j]);
                        obsoleteSpsSku = DepotManager.this.depotData.getSpsSku(spsSkus[j]);
                        if (obsoleteSpsSku == null) {
                            if ("sdwstartup".equals(spsSku.getProdCode())) {
                                obsoleteSpsSku = DepotManager.this.depotData.getNewestSpsSku("sdwstartup", null, true);
                            } else if (spsSku.getProdCode().matches("^sassmu\\d*$")) {
                                obsoleteSpsSku = DepotManager.this.depotData.getNewestSpsSku(spsSku.getProdCode(), null, true);
                            } else if ("installutils".equals(spsSku.getProdCode())) {
                                obsoleteSpsSku = DepotManager.this.depotData.getNewestSpsSku("installutils", null, true);
                            } else if ("depotmover".equals(spsSku.getProdCode())) {
                                obsoleteSpsSku = DepotManager.this.depotData.getNewestSpsSku("depotmover", null, true);
                            }
                            if (obsoleteSpsSku != null) {
                                containsPayload = false;
                                targetVolsers = obsoleteSpsSku.getVolsers();
                                for (k = 0; !containsPayload && k < targetVolsers.length; ++k) {
                                    if (!DepotManager.this.depotData.getVolser(targetVolsers[k]).isPayloadIncluded(obsoleteSpsSku.getSpsSku())) continue;
                                    containsPayload = true;
                                }
                                if (spsSku.getTimeAsLong() <= obsoleteSpsSku.getTimeAsLong()) {
                                    omitData = true;
                                    omitPayload = true;
                                    this.replaceSourceSpsSkus.put(spsSku.getSpsSku(), obsoleteSpsSku.getSpsSku());
                                    obsoleteSpsSku = null;
                                } else if (containsPayload && omitPayload) {
                                    omitData = true;
                                    omitPayload = true;
                                    this.replaceSourceSpsSkus.put(spsSku.getSpsSku(), obsoleteSpsSku.getSpsSku());
                                    obsoleteSpsSku = null;
                                }
                            }
                        } else {
                            containsPayload = false;
                            targetVolsers = obsoleteSpsSku.getVolsers();
                            for (k = 0; !containsPayload && k < targetVolsers.length; ++k) {
                                if (!DepotManager.this.depotData.getVolser(targetVolsers[k]).isPayloadIncluded(obsoleteSpsSku.getSpsSku())) continue;
                                containsPayload = true;
                            }
                            if (spsSku.getTimeAsLong() < obsoleteSpsSku.getTimeAsLong()) {
                                omitData = true;
                                omitPayload = true;
                                if (!containsPayload) {
                                    omitPayloadRef = true;
                                }
                                obsoleteSpsSku = null;
                            } else if (spsSku.getTimeAsLong() == obsoleteSpsSku.getTimeAsLong()) {
                                omitData = true;
                                if (containsPayload) {
                                    omitPayload = true;
                                }
                                obsoleteSpsSku = null;
                            } else if (containsPayload && omitPayload) {
                                omitData = true;
                                omitPayload = true;
                                omitPayloadRef = true;
                                obsoleteSpsSku = null;
                            }
                        }
                        Job.Entity entity = this.createEntity(spsSku, volser, obsoleteSpsSku);
                        if (omitData) {
                            entity.setProcessData(false);
                        }
                        if (omitPayload) {
                            entity.setProcessPayload(false);
                        }
                        if (omitPayloadRef) {
                            entity.setReferencePayload(false);
                        }
                        if (this.mode == 1 && !omitData && !omitPayload) {
                            String vjrListPath = Utils.joinPath(VJRManager.getInstance().getDepotHome(), entity.getDataPath(), "vjrlist");
                            try {
                                File vjrListFile = new File(vjrListPath);
                                VJRManager.getInstance().queueVJRPluginZipsForDepotCreation(vjrListFile);
                            }
                            catch (VJRException vjre) {
                                Logging.log.severe("Error fetching versioned plugin dependencies for " + vjrListPath);
                                Logging.logStackTrace(vjre);
                            }
                        }
                        this.entities.add(entity);
                    }
                }
            }
        }

        private void setMoveFiles(boolean value) {
            this.move = value;
        }

        private void setTarget(String altTarget) {
            this.altTarget = altTarget;
        }

        public String getTarget() {
            return this.altTarget == null ? DepotManager.this.target : this.altTarget;
        }

        public String getRealTarget() {
            return DepotManager.this.target;
        }

        private void setSource(String altSource) {
            this.altSource = altSource;
        }

        private String getSource() {
            return this.altSource == null ? this.source : this.altSource;
        }

        private String getCloneDataSource() {
            return this.cloneDataSource == null ? this.getSource() : this.cloneDataSource;
        }

        private void cleanupStaging(boolean success) {
            File dir = null;
            switch (this.mode) {
                case 1: {
                    if (success) break;
                    dir = new File(this.getTarget());
                    break;
                }
                case 2: {
                    dir = new File(this.getSource());
                    break;
                }
                case 3: {
                    if (Globals.g_logLevel != 0 || Globals.g_debug) break;
                    dir = new File(this.getSource());
                }
            }
            if (dir != null) {
                Utils.deleteFolder(dir);
                dir = dir.getParentFile();
                if (dir.list().length == 0 && this.deleteFile(dir) && this.mode == 1 && (dir = dir.getParentFile()).list().length == 0) {
                    this.deleteFile(dir);
                }
            }
        }

        @Override
        public void interrupt() {
            super.interrupt();
            this.cleanupStaging(false);
            this.status = 3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Job.Entity entity;
            int i;
            this.status = 1;
            boolean success = true;
            this.cloneDataSource = this.mode == 1 && Globals.g_subsetData != null && Globals.g_subsetData.isSubsetActive() ? DepotManager.this.target + File.separator + "staging" + File.separator + this.order + File.separator + "cloneddata" : null;
            File file = new File(this.getTarget());
            if (!file.isDirectory()) {
                success = file.mkdirs();
            } else if (this.mode == 1) {
                Logging.log.info("Staging Directory Already Exists: " + this.getTarget());
            }
            if (success && this.mode != 4) {
                file = new File(this.getTarget(), "sassd.txt");
                if (file.exists()) {
                    success = file.isFile();
                } else {
                    try (PrintStream stream = null;){
                        stream = new PrintStream((OutputStream)new FileOutputStream(file), false, "UTF-8");
                        if (this.sourceData.getOrder(this.order).getDepotVersionAsInt() >= 2) {
                            stream.println("locked");
                        }
                        if (this.type == 2) {
                            stream.println("personal");
                        } else if (this.type == 1) {
                            stream.println("client");
                        }
                        success = !stream.checkError();
                    }
                }
            }
            if (success) {
                boolean bl = success = Utils.copyFile(this.sourceData.getOrderDir(this.getCloneDataSource()) + File.separator + this.order, DepotManager.this.depotData.getOrderDir(this.getTarget()) + File.separator + this.order) == 0;
            }
            if (success && this.mode != 2 && this.type == 2) {
                try {
                    success = Globals.g_sid.write(DepotManager.this.depotData.getOrderDir(this.getTarget()) + File.separator + this.order + File.separator + "sid.txt");
                }
                catch (IOException e) {
                    success = false;
                }
            }
            if (success) {
                try {
                    CdId id = new CdId(this.getTarget() + File.separator + "cd.id");
                    OrderData orderData = this.sourceData.getOrder(this.order);
                    String[] volsers = this.mode == 4 ? orderData.getVolsers(orderData.getMediaType()) : orderData.getVolsers();
                    for (i = 0; success && i < volsers.length; ++i) {
                        success = this.moveFile(new File(this.sourceData.getMediaDir(this.getCloneDataSource()), volsers[i] + ".xml"), new File(DepotManager.this.depotData.getMediaDir(this.getTarget()), volsers[i] + ".xml"), !this.move, false, this.mode == 4);
                        if (success && this.mode != 2) {
                            boolean write = false;
                            try {
                                String obsoleteSpsSku;
                                VolserData volserData = new VolserData(DepotManager.this.depotData.getMediaDir(this.getTarget()) + File.separator + volsers[i] + ".xml");
                                Enumeration<Object> e = this.omitSourceSpsSkus.elements();
                                while (e.hasMoreElements()) {
                                    obsoleteSpsSku = ((Job.Entity)e.nextElement()).getSpsSku();
                                    if (!volserData.removeProduct(obsoleteSpsSku)) continue;
                                    write = true;
                                }
                                e = this.replaceSourceSpsSkus.keys();
                                while (success && e.hasMoreElements()) {
                                    obsoleteSpsSku = (String)e.nextElement();
                                    String existingSpsSku = (String)this.replaceSourceSpsSkus.get(obsoleteSpsSku);
                                    VolserData existingVolserData = DepotManager.this.depotData.getVolser(DepotManager.this.depotData.getSpsSku(existingSpsSku).getVolsers()[0]);
                                    boolean containsPayload = volserData.isPayloadIncluded(obsoleteSpsSku);
                                    if (!volserData.removeProduct(obsoleteSpsSku)) continue;
                                    if (volserData.addProduct(existingSpsSku, existingVolserData.getProductPath(existingSpsSku), existingVolserData.getDataPath(existingSpsSku))) {
                                        if (!containsPayload) {
                                            volserData.setPayloadIncluded(existingSpsSku, false);
                                        }
                                        write = true;
                                        continue;
                                    }
                                    success = false;
                                }
                                e = this.entities.elements();
                                while (success && e.hasMoreElements()) {
                                    String altProductPath;
                                    entity = (Job.Entity)e.nextElement();
                                    String altDataPath = entity.getAltDataPath();
                                    if (altDataPath != null && volserData.getDataPath(entity.getSpsSku()) != null) {
                                        if (volserData.setDataPath(entity.getSpsSku(), altDataPath)) {
                                            write = true;
                                        } else {
                                            success = false;
                                        }
                                    }
                                    if ((altProductPath = entity.getAltProductPath()) != null && volserData.getProductPath(entity.getSpsSku()) != null) {
                                        if (volserData.setProductPath(entity.getSpsSku(), altProductPath)) {
                                            write = true;
                                        } else {
                                            success = false;
                                        }
                                    }
                                    if (entity.getReferencePayload() || !volserData.isPayloadIncluded(entity.getSpsSku())) continue;
                                    volserData.setPayloadIncluded(entity.getSpsSku(), false);
                                    write = true;
                                }
                                if (success && write) {
                                    success = volserData.write();
                                }
                            }
                            catch (Exception e) {
                                success = false;
                                Logging.log.warning(e.getMessage());
                            }
                        }
                        if (!success || !orderData.getMediaType().equals(this.sourceData.getVolser(volsers[i]).getType())) continue;
                        id.add(volsers[i]);
                    }
                    success &= id.write();
                }
                catch (IOException e) {
                    success = false;
                    Logging.log.warning(e.getMessage());
                }
            }
            if (success && this.mode == 2) {
                try {
                    for (VJRPluginZip sourcePluginZip : VJRManager.getInstance().getQueuedVJRPluginZipsForDepotCreation()) {
                        this.targetVJRManager.copySourceVJRPluginZip(sourcePluginZip);
                        Globals.g_bytesMoved += sourcePluginZip.getSize();
                    }
                }
                catch (VJRException vjre) {
                    success = false;
                    Logging.log.severe(vjre.getMessage());
                }
            }
            if (success) {
                SpsSkuData obsoleteSpsSku = null;
                Enumeration e = this.entities.elements();
                while (success && e.hasMoreElements()) {
                    SpsSkuData spsSku;
                    String targetDataPath;
                    boolean containsPayload;
                    entity = (Job.Entity)e.nextElement();
                    if (this.mode != 4 && this.mode != 2 && this.mode != 3) {
                        this.status = 2;
                        String newSource = null;
                        while (newSource == null && success) {
                            if (Globals.g_subsetData != null && Globals.g_subsetData.isSubsetActive()) {
                                String newVolser = entity.getVolser();
                                String oldVolser = Globals.g_subsetData.getOldVolser(newVolser);
                                newSource = Globals.g_kit.diskSearch(Globals.g_wizard.getFrame(), this.getSource(), entity.getMediaName(), oldVolser);
                            } else {
                                newSource = Globals.g_kit.diskSearch(Globals.g_wizard.getFrame(), this.getSource(), entity.getMediaName(), entity.getVolser());
                            }
                            if (newSource != null) {
                                this.setSource(newSource);
                                continue;
                            }
                            if (Globals.g_wizard.getFrame() == null) {
                                success = false;
                                continue;
                            }
                            if (CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), DepotManager.this.bundle.getString("PanelProgress.InterruptMsg.txt"), Globals.g_wizard.getWizardTitle(), 0, 3, 1) != 0) continue;
                            success = false;
                        }
                    }
                    if (!success) continue;
                    this.status = 1;
                    if (success && (obsoleteSpsSku = this.mode == 1 ? null : (entity.getObsoleteSpsSku() == null ? null : DepotManager.this.depotData.getSpsSku(entity.getObsoleteSpsSku()))) != null) {
                        containsPayload = false;
                        String[] targetVolsers = obsoleteSpsSku.getVolsers();
                        for (int i2 = 0; !containsPayload && i2 < targetVolsers.length; ++i2) {
                            if (!DepotManager.this.depotData.getVolser(targetVolsers[i2]).isPayloadIncluded(obsoleteSpsSku.getSpsSku())) continue;
                            containsPayload = true;
                        }
                        Job.Entity obsoleteEntity = this.createEntity(obsoleteSpsSku, DepotManager.this.depotData.getVolser(targetVolsers[0]), null);
                        if (!containsPayload) {
                            obsoleteEntity.setProcessPayload(false);
                        }
                        success = obsoleteEntity.remove();
                    }
                    if (success) {
                        if (!Globals.g_DocUpdate) {
                            success = entity.move(this.getSource(), this.getTarget(), !this.move, this.sourceData.getSpsSku(entity.spsSku).getProdCode().equals("sid_files"), this.mode == 4);
                        } else if (this.sourceData.getSpsSku(entity.spsSku).getDoc()) {
                            String prodCode = this.sourceData.getSpsSku(entity.spsSku).getProdCode();
                            ProductData[] lists = Globals.g_sasHomeStatus.getRequiredInstallSteps();
                            i = 0;
                            boolean found = false;
                            while (i < lists.length && !found) {
                                if (!lists[i].getProdCode().equalsIgnoreCase(prodCode)) {
                                    ++i;
                                    continue;
                                }
                                found = true;
                            }
                            if (found) {
                                success = entity.move(this.getSource(), this.getTarget(), !this.move, this.sourceData.getSpsSku(entity.spsSku).getProdCode().equals("sid_files"), this.mode == 4);
                            }
                        }
                    }
                    if (!success || this.mode == 1) continue;
                    String targetProductPath = entity.getAltProductPath();
                    if (targetProductPath == null) {
                        targetProductPath = entity.getProductPath();
                    }
                    if ((targetDataPath = entity.getAltDataPath()) == null) {
                        targetDataPath = entity.getDataPath();
                    }
                    VolserData[] volsers = DepotManager.this.depotData.getVolsers();
                    if (obsoleteSpsSku != null) {
                        for (int j = 0; success && j < volsers.length; ++j) {
                            containsPayload = volsers[j].isPayloadIncluded(obsoleteSpsSku.getSpsSku());
                            if (!volsers[j].removeProduct(obsoleteSpsSku.getSpsSku())) continue;
                            if (volsers[j].addProduct(entity.getSpsSku(), targetProductPath, targetDataPath)) {
                                if (!containsPayload) {
                                    volsers[j].setPayloadIncluded(entity.getSpsSku(), false);
                                }
                                success = volsers[j].write();
                                continue;
                            }
                            success = false;
                        }
                    }
                    if ((spsSku = this.sourceData.getSpsSku(entity.getSpsSku())).isFileListFound()) continue;
                    success = spsSku.writeFileList(DepotManager.this.target + File.separator + targetDataPath);
                }
            }
            this.cleanupStaging(success);
            if (success && this.mode != 1) {
                DepotManager.this.refreshDepotData(DepotManager.this.depotData, true);
                if (this.mode == 4) {
                    SpsSkuData spsSkuData = DepotManager.this.depotData.getNewestSpsSku("deploywiz", null, false);
                    if (spsSkuData != null) {
                        String spsSkuSource = this.getTarget() + File.separator + DepotManager.this.depotData.getVolser(spsSkuData.getVolsers()[0]).getProductPath(spsSkuData.getSpsSku());
                        if (Utils.getOS() == 1) {
                            success = Utils.copyFile(spsSkuSource + File.separator + "deploywiz.exe", this.getTarget() + File.separator + "sasdm.exe") == 0;
                        } else if (Utils.getOS() == 8) {
                            success = Utils.copyFile(spsSkuSource + File.separator + "deploywiz.rexx", this.getTarget() + File.separator + "sasdm.rexx") == 0;
                        } else {
                            boolean bl = success = Utils.copyFile(spsSkuSource + File.separator + "deploywiz.sh", this.getTarget() + File.separator + "sasdm.sh") == 0;
                        }
                        if (success) {
                            SpsSkuData configData;
                            file = new File(this.getTarget(), "sasdm.ini");
                            try (PrintStream stream = null;){
                                stream = new PrintStream((OutputStream)new FileOutputStream(file), false, "UTF-8");
                                stream.println("[properties]");
                                stream.println("MASTERPROP=" + new File(Globals.g_wizardData.getPreference("SASHome", ""), "sassw.config").getAbsolutePath());
                                stream.println("");
                                stream.println("[default]");
                                if (Utils.getOS() != 1) {
                                    stream.println("umask_user=0");
                                    stream.println("umask_group=2");
                                    stream.println("umask_other=2");
                                }
                                if (Utils.getOS() == 8) {
                                    stream.println("noconsole=-silenthotfix");
                                    stream.println("launchercmd=<DPLMTJREHOME>");
                                    stream.println("launcherargs=-Xnoargsconversion -Dfile.encoding=IBM-1047 -Dconsole.encoding=IBM-1047 -Djava.util.prefs.systemRoot=$HOME/.java -Xmx512M -jar \"" + new File(spsSkuSource, "deploywiz/setup.jar").getAbsolutePath() + "\" -startuplocation \"" + this.getTarget() + "\" -configure");
                                } else {
                                    String deploymentJre = "<PRIVATEJREHOME>";
                                    if (!JREData.isPrivateJreNeeded() && Globals.g_forceJREPrompt) {
                                        deploymentJre = "<JREHOME>";
                                    }
                                    stream.println("launchercmd=" + deploymentJre);
                                    String launcherargs = "launcherargs=";
                                    switch (Utils.getOS()) {
                                        case 1: {
                                            if (Utils.isWindows64OS() && !DepotManager.this.is32bPrivateJRE()) {
                                                launcherargs = launcherargs + "-Xmx2048M ";
                                                break;
                                            }
                                            launcherargs = launcherargs + "-Xmx1024M ";
                                            break;
                                        }
                                        default: {
                                            launcherargs = launcherargs + "-Xmx2048M ";
                                        }
                                    }
                                    launcherargs = launcherargs + "\"-Djavax.net.ssl.trustStore=" + new File(Globals.g_jreHome, "lib/security/jssecacerts").getAbsolutePath() + "\" -jar \"" + new File(spsSkuSource, "deploywiz/setup.jar").getAbsolutePath() + "\" -startuplocation \"" + this.getTarget() + "\" -configure";
                                    stream.println(launcherargs);
                                }
                                if (Utils.getOS() == 8) {
                                    stream.println("[mvs]");
                                    stream.println("x11=NO");
                                    stream.println("jobsubmit=NO");
                                }
                                success = !stream.checkError();
                            }
                            if (success && Utils.getOS() == 1 && (configData = DepotManager.this.depotData.getNewestSpsSku("cfgwizard", null, false)) != null) {
                                Process p;
                                String[] shortcutcmd;
                                file = new File(Globals.g_tempLocation, "sdm_shortcut.ini");
                                stream = null;
                                try {
                                    stream = new PrintStream((OutputStream)new FileOutputStream(file), false, "UTF-8");
                                    stream.println("[Constants]");
                                    stream.println("folderStructure=SAS");
                                    stream.println("");
                                    stream.println("[Shortcut]");
                                    stream.println("displayName=" + configData.getDisplayName("en") + " " + Globals.g_majorReleaseVersion);
                                    stream.println("target=" + new File(this.getTarget(), "sasdm.exe").getAbsolutePath());
                                    stream.println("arguments=");
                                    stream.println("iconLocation=" + new File(this.getTarget(), "sasdm.exe").getAbsolutePath());
                                    stream.println("iconIndex=0");
                                    stream.println("startDirectory=" + this.getTarget());
                                    success = !stream.checkError();
                                }
                                catch (IOException e) {
                                    success = false;
                                    Logging.log.warning(e.getMessage());
                                }
                                finally {
                                    if (stream != null) {
                                        stream.close();
                                    }
                                }
                                if (success) {
                                    shortcutcmd = new String[3];
                                    shortcutcmd[0] = "\"" + this.getTarget();
                                    shortcutcmd[0] = shortcutcmd[0] + File.separator + DepotManager.this.depotData.getVolser(configData.getVolsers()[0]).getProductPath(configData.getSpsSku());
                                    shortcutcmd[0] = shortcutcmd[0] + File.separator + "Utilities";
                                    shortcutcmd[0] = shortcutcmd[0] + File.separator + Utils.getOS_Suffix();
                                    shortcutcmd[0] = shortcutcmd[0] + File.separator + "sasshortcutmgr.exe\"";
                                    shortcutcmd[1] = "-create";
                                    shortcutcmd[2] = file.getAbsolutePath();
                                    Logging.log.info("create shortcut=" + shortcutcmd);
                                    try {
                                        p = Runtime.getRuntime().exec(shortcutcmd);
                                        p.waitFor();
                                        int returnCode = p.exitValue();
                                        Logging.log.info("Return Code: " + returnCode);
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        success = false;
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                        success = false;
                                    }
                                }
                                stream = null;
                                file = new File(Globals.g_tempLocation, "renewal_shortcut.ini");
                                try {
                                    stream = new PrintStream((OutputStream)new FileOutputStream(file), false, "UTF-8");
                                    stream.println("[Constants]");
                                    stream.println("folderStructure=SAS\\Utilities");
                                    stream.println("createForAllUsers=true");
                                    stream.println("");
                                    stream.println("[Shortcut]");
                                    stream.println("displayName=Renew SAS Software " + Globals.g_majorReleaseVersion);
                                    stream.println("target=" + new File(this.getTarget(), "sasdm.exe").getAbsolutePath());
                                    stream.println("arguments=-renew");
                                    stream.println("iconLocation=" + new File(this.getTarget(), "sasdm.exe").getAbsolutePath());
                                    stream.println("iconIndex=0");
                                    stream.println("startDirectory=" + this.getTarget());
                                    success = !stream.checkError();
                                }
                                catch (IOException e) {
                                    success = false;
                                    Logging.log.warning(e.getMessage());
                                }
                                finally {
                                    if (stream != null) {
                                        stream.close();
                                    }
                                }
                                if (success) {
                                    shortcutcmd = new String[3];
                                    shortcutcmd[0] = "\"" + this.getTarget();
                                    shortcutcmd[0] = shortcutcmd[0] + File.separator + DepotManager.this.depotData.getVolser(configData.getVolsers()[0]).getProductPath(configData.getSpsSku());
                                    shortcutcmd[0] = shortcutcmd[0] + File.separator + "Utilities";
                                    shortcutcmd[0] = shortcutcmd[0] + File.separator + Utils.getOS_Suffix();
                                    shortcutcmd[0] = shortcutcmd[0] + File.separator + "sasshortcutmgr.exe\"";
                                    shortcutcmd[1] = "-create";
                                    shortcutcmd[2] = file.getAbsolutePath();
                                    Logging.log.info("create shortcut=" + shortcutcmd);
                                    try {
                                        p = Runtime.getRuntime().exec(shortcutcmd);
                                        p.waitFor();
                                        int returnCode = p.exitValue();
                                        Logging.log.info("Return Code: " + returnCode);
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        success = false;
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                        success = false;
                                    }
                                }
                            }
                        }
                        String sInstallMiscLocation = Globals.g_wizardData.getPreference("SASHome", "");
                        File sInstallMiscLocationDir = new File(sInstallMiscLocation = Utils.joinPath(sInstallMiscLocation, "InstallMisc", Globals.g_majorReleaseVersion));
                        if (!sInstallMiscLocationDir.exists()) {
                            try {
                                sInstallMiscLocationDir.mkdir();
                            }
                            catch (Exception e) {
                                Logging.log.info("Error creating version folder (" + sInstallMiscLocation + ") - " + e.getMessage());
                                System.err.println("Error creating version folder (" + sInstallMiscLocation + ") - " + e.getLocalizedMessage());
                            }
                        }
                        if (Utils.getOS() == 1) {
                            success = Utils.copyFile(spsSkuSource + File.separator + "deploywiz.exe", sInstallMiscLocation + File.separator + "cleanup.exe") == 0;
                        } else if (Utils.getOS() != 8) {
                            boolean bl = success = Utils.copyFile(spsSkuSource + File.separator + "deploywiz.sh", sInstallMiscLocation + File.separator + "cleanup.sh") == 0;
                        }
                        if (success && Utils.getOS() != 8) {
                            file = new File(sInstallMiscLocation, "cleanup.ini");
                            try (PrintStream stream = null;){
                                stream = new PrintStream((OutputStream)new FileOutputStream(file), false, "UTF-8");
                                stream.println("[properties]");
                                stream.println("MASTERPROP=" + new File(Globals.g_wizardData.getPreference("SASHome", ""), "sassw.config").getAbsolutePath());
                                stream.println("");
                                stream.println("[default]");
                                stream.println("launchercmd=<PRIVATEJREHOME>");
                                stream.println("launcherargs=-cp \"" + new File(spsSkuSource, "deploywiz/sas.tools.installs.it.jar").getAbsolutePath() + "\" com.sas.tools.installs.it.cleaner.Cleaner");
                                success = !stream.checkError();
                            }
                        }
                        if (success) {
                            File sashfIni;
                            File sashfFile = null;
                            sashfFile = Utils.getOS() == 1 ? new File(this.getTarget(), "sashf.exe") : (Utils.getOS() == 8 ? new File(this.getTarget(), "sashf.rexx") : new File(this.getTarget(), "sashf.sh"));
                            if (sashfFile.exists()) {
                                sashfFile.delete();
                            }
                            if ((sashfIni = new File(this.getTarget(), "sashf.ini")).exists()) {
                                sashfIni.delete();
                            }
                        }
                    }
                    if (success) {
                        this.processEndDatedFiles();
                        this.copyHotFixFiles();
                    }
                } else {
                    OrderData[] orders = DepotManager.this.depotData.getOrders();
                    if (orders != null) {
                        for (int i3 = 0; i3 < orders.length; ++i3) {
                            if (!orders[i3].isPlanning()) continue;
                            new File(this.getTarget(), "plan_files").mkdirs();
                            i3 = orders.length;
                        }
                    }
                    try {
                        ExtendedOrderData eod = DepotManager.this.depotData.getOrder(this.order).getExtendedData();
                        eod.setUser(System.getProperty("user.name"));
                        eod.setTime(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
                        eod.write();
                    }
                    catch (Exception e) {
                        success = false;
                        Logging.log.warning(e.getMessage());
                    }
                    DepotManager.this.generateBootstrapDataFile(DepotManager.this.depotData);
                    DepotManager.this.generateDepotSummary();
                }
            }
            this.status = success ? 4 : 3;
        }

        private void processEndDatedFiles() {
            boolean result;
            String cfgwizardAltskuDir = null;
            Enumeration e = this.entities.elements();
            while (e.hasMoreElements()) {
                Job.Entity entity = (Job.Entity)e.nextElement();
                if (!entity.spsSku.contains("cfgwizard")) continue;
                cfgwizardAltskuDir = entity.getProductPath();
                break;
            }
            String sashome = Globals.g_wizardData.getPreference("SASHome", "");
            String source = Utils.joinPath(sashome, "SASDeploymentManager", Globals.g_majorReleaseVersion);
            source = Utils.joinPath(source, cfgwizardAltskuDir, "Utilities");
            source = Utils.joinPath(source, "CleanEndDatedProducts");
            String dest = Utils.joinPath(sashome, "InstallMisc", "utilities");
            dest = Utils.joinPath(dest, "CleanEndDatedProducts");
            File sourceDir = new File(source);
            File destDir = new File(dest);
            int numFiles = 0;
            if (sourceDir.isDirectory()) {
                numFiles = sourceDir.listFiles().length;
            }
            if (numFiles == 0) {
                if (destDir.isDirectory()) {
                    Utils.deleteFolder(destDir);
                }
                return;
            }
            if (!destDir.isDirectory()) {
                try {
                    destDir.mkdirs();
                }
                catch (Exception e2) {
                    Logging.logStackTrace(e2);
                    return;
                }
            }
            if (result = Utils.movefiles(sourceDir, destDir)) {
                String[] files;
                for (String filename : files = destDir.list()) {
                    if (!filename.endsWith(".bat") && !filename.endsWith(".sh")) continue;
                    String path = Utils.joinPath(destDir.getAbsolutePath(), filename);
                    File fpath = new File(path);
                    try {
                        String content = Utils.readFile(fpath);
                        String token = "@SASHOME@";
                        String sashome2 = sashome.replaceAll("\\\\", "\\\\\\\\");
                        content = content.replaceAll(token, sashome2);
                        Utils.writeFile(fpath, content);
                    }
                    catch (IOException ioe) {
                        Logging.logStackTrace(ioe);
                    }
                }
            }
        }

        private void copyHotFixFiles() {
            if (Globals.g_mode == 2 || !Globals.g_install) {
                return;
            }
            String srcDir = Utils.joinPath(Globals.g_startupLocation, "hot_fix");
            this.copyHotFixInstructions(srcDir);
            this.copyHotFixSecurityFiles(srcDir);
        }

        private void copyHotFixSecurityFiles(String srcDir) {
            if (Globals.g_hotFixesInChainForSecurity == null || Globals.g_hotFixesInChainForSecurity.isEmpty()) {
                Logging.log.info("There are no security hotfixes in the list Globals.g_hotFixesInChainForSecurity.");
                return;
            }
            String dest = Utils.joinPaths(Globals.g_wizardData.getPreference("SASHome", ""), "InstallMisc", "HotFixes", "SecurityUpdates");
            Utils.createDir(dest);
            ArrayList<String> securityList = new ArrayList<String>(Globals.g_hotFixesInChainForSecurity.size());
            for (HotFix securityHotFix : Globals.g_hotFixesInChainForSecurity) {
                String srcSecureName = securityHotFix.getHotFixPackageFilename();
                srcSecureName = Utils.joinPath(srcDir, srcSecureName);
                securityList.add(srcSecureName);
            }
            if (securityList.size() > 0) {
                String hotfix;
                File srcFile;
                HotFixSecurityManager manager = new HotFixSecurityManager();
                ArrayList<String> hotFixesToCopy = manager.findHotFixesToCopy(securityList, dest);
                if (hotFixesToCopy.isEmpty()) {
                    Logging.log.info("There are no newer security hotfixes in the depot compared to SASHome.");
                    return;
                }
                Logging.log.info("Copying security hotfixes from depot to SASHome.");
                Iterator<String> iterator = hotFixesToCopy.iterator();
                while (iterator.hasNext() && (srcFile = new File(hotfix = iterator.next())).isFile()) {
                    String fileName = srcFile.getName();
                    File destFile = new File(Utils.joinPaths(dest, fileName));
                    if (Utils.copyFile(srcFile, destFile) != -1) continue;
                    String msg = String.format("The copy of security hot fix file %s failed to copy to %s.", srcFile.getAbsolutePath(), destFile.getAbsolutePath());
                    Logging.log.warning(msg);
                }
            }
        }

        private void copyHotFixInstructions(String srcDir) {
            HotFixInstructions hfInstructions = new HotFixInstructions();
            String dest = hfInstructions.getHotFixInstructionsDir();
            for (HotFix hotfix : Globals.g_hotFixesInChainWithCustomDoc) {
                File destFile;
                String srciDoc = Utils.joinPath(srcDir, hotfix.getDocFilename());
                File srciDocFile = new File(srciDoc);
                if (Utils.copyFile(srciDocFile, destFile = new File(Utils.joinPath(dest, hotfix.getDocFilename()))) != -1) continue;
                Logging.log.warning("Unable to copy instructions file " + srciDocFile.getAbsolutePath() + " to " + destFile.getAbsolutePath());
            }
        }
    }

    public class DelJob
    extends Job {
        public DelJob(String order) {
            super(order);
            this.initVJRManager();
            if (DepotManager.this.containsOrder(order)) {
                SpsSkuData spsSku = null;
                VolserData volser = null;
                HashSet<String> dataOrders = new HashSet<String>();
                HashSet<String> payloadOrders = new HashSet<String>();
                SpsSkuData[] spsSkus = DepotManager.this.depotData.getSpsSkus();
                for (int i = 0; i < spsSkus.length; ++i) {
                    spsSku = spsSkus[i];
                    dataOrders.clear();
                    payloadOrders.clear();
                    VolserData entityVolser = null;
                    String[] volsers = spsSku.getVolsers();
                    for (int j = 0; j < volsers.length; ++j) {
                        volser = DepotManager.this.depotData.getVolser(volsers[j]);
                        String[] orders = volser.getOrders();
                        dataOrders.addAll(Arrays.asList(volser.getOrders()));
                        if (volser.isPayloadIncluded(spsSku.getSpsSku())) {
                            payloadOrders.addAll(Arrays.asList(volser.getOrders()));
                            entityVolser = volser;
                            continue;
                        }
                        if (entityVolser != null) continue;
                        entityVolser = volser;
                    }
                    Job.Entity entity = this.createEntity(spsSku, entityVolser, null);
                    if (dataOrders.size() > 1 || !dataOrders.contains(order)) {
                        entity.setProcessData(false);
                    }
                    if (payloadOrders.size() > 1 || !payloadOrders.contains(order)) {
                        entity.setProcessPayload(false);
                    }
                    this.entities.add(entity);
                }
            }
        }

        private void initVJRManager() {
            VJRManager sourceVJRManager = VJRManager.getInstance();
            if (DepotManager.this.target != null && !DepotManager.this.target.equalsIgnoreCase(sourceVJRManager.getDepotHome())) {
                try {
                    sourceVJRManager.loadDepot(DepotManager.this.target);
                }
                catch (VJRException vjre) {
                    Logging.log.severe(vjre.getMessage());
                }
            }
        }

        @Override
        public void run() {
            File file;
            this.status = 1;
            boolean success = true;
            Enumeration e = this.entities.elements();
            while (success && e.hasMoreElements()) {
                success = ((Job.Entity)e.nextElement()).remove();
            }
            try {
                this.processed += VJRManager.getInstance().pruneDepot();
            }
            catch (VJRException vjre) {
                success = false;
                Logging.log.severe(vjre.getMessage());
            }
            if (success) {
                file = new File(DepotManager.this.target, "products");
                this.deleteFile(file);
            }
            if (success) {
                file = new File(DepotManager.this.target, "product_data");
                this.deleteFile(file);
            }
            if (success) {
                try {
                    CdId id = new CdId(DepotManager.this.target + File.separator + "cd.id");
                    String[] volsers = DepotManager.this.depotData.getOrder(this.order).getVolsers();
                    for (int i = 0; success && i < volsers.length; ++i) {
                        file = new File(DepotManager.this.depotData.getMediaDir(), volsers[i] + ".xml");
                        success = this.deleteFile(file);
                        if (!success) continue;
                        id.remove(volsers[i]);
                    }
                    success &= id.write();
                }
                catch (IOException e2) {
                    success = false;
                    Logging.log.warning(e2.getMessage());
                }
                if (success) {
                    file = new File(DepotManager.this.depotData.getMediaDir());
                    this.deleteFile(file);
                }
            }
            if (success && (file = new File(DepotManager.this.depotData.getOrderDir(), this.order)).exists()) {
                success = Utils.deleteFolder(file);
            }
            if (success) {
                file = new File(DepotManager.this.depotData.getOrderDir());
                this.deleteFile(file);
            }
            if (success) {
                DepotManager.this.refreshDepotData(DepotManager.this.depotData, true);
                OrderData[] orders = DepotManager.this.depotData.getOrders();
                if (orders != null) {
                    for (int i = 0; i < orders.length; ++i) {
                        if (orders[i].isPlanning()) {
                            i = orders.length;
                            continue;
                        }
                        if (i != orders.length - 1) continue;
                        new File(DepotManager.this.target, "plan_files").delete();
                    }
                }
                DepotManager.this.generateBootstrapDataFile(DepotManager.this.depotData);
                DepotManager.this.generateDepotSummary();
            }
            if (success && this.order.equals(Globals.g_order)) {
                Globals.g_order = DepotManager.this.depotData.getOrderCount() == 1 ? DepotManager.this.depotData.getOrders()[0].getOrder() : null;
            }
            if (success && DepotManager.this.depotData.getOrderCount() == 0) {
                new File(DepotManager.this.target, "plan_files").delete();
                new File(DepotManager.this.target, "sassd.lck").delete();
                if (success) {
                    file = new File(DepotManager.this.target, "depotsummary.html");
                    success = this.deleteFile(file);
                }
                if (success) {
                    file = new File(DepotManager.this.target, "setup.dat");
                    success = this.deleteFile(file);
                }
                if (success) {
                    file = new File(DepotManager.this.target, "sassd.txt");
                    success = this.deleteFile(file);
                }
                if (success) {
                    DepotManager.this.setLock(false);
                }
            }
            if (success) {
                file = new File(DepotManager.this.target);
                this.deleteFile(file);
            }
            this.status = success ? 4 : 3;
        }
    }

    public class ExportJob
    extends Job {
        private VolserData[] disks;
        private String firstDisk;
        private String mediaType;

        public ExportJob(String target, String order, String type) {
            super(order);
            DepotManager.this.exportTarget = target;
            this.mediaType = type.toLowerCase(Locale.ENGLISH);
            if (DepotManager.this.containsOrder(order)) {
                VolserData volser = null;
                String[] volsers = DepotManager.this.depotData.getOrder(order).getVolsers();
                this.disks = new VolserData[volsers.length];
                for (int i = 0; i < volsers.length; ++i) {
                    this.disks[i] = volser = DepotManager.this.depotData.getVolser(volsers[i]);
                    if (!this.mediaType.equals(volser.getType())) continue;
                    if ("1".equals(volser.getVolnum())) {
                        this.firstDisk = volsers[i];
                    }
                    String[] spsSkus = volser.getSpsSkus();
                    for (int j = 0; j < spsSkus.length; ++j) {
                        Job.Entity entity = this.createEntity(DepotManager.this.depotData.getSpsSku(spsSkus[j]), volser, null);
                        if (!volser.isPayloadIncluded(spsSkus[j])) {
                            entity.setProcessPayload(false);
                        }
                        this.entities.add(entity);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DeploymentData targetData;
            int i;
            this.status = 1;
            boolean success = true;
            File file = new File(DepotManager.this.exportTarget, "labels.txt");
            try (PrintStream stream = null;){
                stream = new PrintStream((OutputStream)new FileOutputStream(file), false, "UTF-8");
                stream.println(Utils.stringReplaceAll(DepotManager.this.bundle.getString("DepotManager.LabelsNote.txt"), "\n", System.getProperty("line.separator")));
                stream.println();
                stream.println(Utils.stringReplaceAll(DepotManager.this.bundle.getString("DepotManager.LabelsNote1.txt"), "\n", System.getProperty("line.separator")));
                stream.println();
                stream.println(Utils.stringReplaceAll(DepotManager.this.bundle.getString("DepotManager.LabelsNote2.txt"), "\n", System.getProperty("line.separator")));
                stream.println();
                for (i = 0; success && i < this.disks.length; ++i) {
                    if (!this.mediaType.equals(this.disks[i].getType())) continue;
                    stream.println("   " + this.disks[i].getVolser() + ": " + this.disks[i].getName("en"));
                }
                success = !stream.checkError();
            }
            for (i = 0; success && i < this.disks.length; ++i) {
                if (!this.mediaType.equals(this.disks[i].getType())) continue;
                success = Utils.copyFile(DepotManager.this.depotData.getOrderDir(DepotManager.this.target) + File.separator + this.order, DepotManager.this.depotData.getOrderDir(DepotManager.this.exportTarget + File.separator + this.disks[i].getVolser()) + File.separator + this.order) == 0;
            }
            for (int i2 = 0; success && i2 < this.disks.length; ++i2) {
                if (this.mediaType.equals(this.disks[i2].getType())) {
                    try {
                        CdId id = new CdId(DepotManager.this.exportTarget + File.separator + this.disks[i2].getVolser() + File.separator + "cd.id");
                        id.add(this.disks[i2].getVolser());
                        success = id.write();
                    }
                    catch (IOException e) {
                        success = false;
                        Logging.log.warning(e.getMessage());
                    }
                }
                for (int j = 0; success && j < this.disks.length; ++j) {
                    if (!this.mediaType.equals(this.disks[j].getType())) continue;
                    success = this.moveFile(new File(DepotManager.this.depotData.getMediaDir(DepotManager.this.target), this.disks[i2].getVolser() + ".xml"), new File(DepotManager.this.depotData.getMediaDir(DepotManager.this.exportTarget + File.separator + this.disks[j].getVolser()), this.disks[i2].getVolser() + ".xml"), true);
                }
            }
            Enumeration e = this.entities.elements();
            while (success && e.hasMoreElements()) {
                Job.Entity entity = (Job.Entity)e.nextElement();
                success = entity.export();
                if (!success || this.firstDisk.equals(entity.getVolser())) continue;
                success = Utils.copyFile(DepotManager.this.exportTarget + File.separator + entity.getVolser() + File.separator + entity.getDataPath(), DepotManager.this.exportTarget + File.separator + this.firstDisk + File.separator + entity.getDataPath()) == 0;
            }
            if (success && (targetData = DepotManager.this.loadDeploymentData(DepotManager.this.exportTarget + File.separator + this.firstDisk, false)) != null) {
                DepotManager.this.generateBootstrapDataFile(targetData);
                if (!this.mediaType.equals(DepotManager.this.depotData.getOrder(this.order).getMediaType())) {
                    success = false;
                    OrderData targetOrderData = targetData.getOrder(this.order);
                    if (targetOrderData != null && targetOrderData.setMediaType(this.mediaType)) {
                        success = targetOrderData.write();
                    }
                    for (int i3 = 0; success && i3 < this.disks.length; ++i3) {
                        if (!this.mediaType.equals(this.disks[i3].getType()) || this.firstDisk.equals(this.disks[i3].getVolser())) continue;
                        success = Utils.copyFile(new File(targetData.getOrderDir(), this.order + File.separator + "order.xml"), new File(targetData.getOrderDir(DepotManager.this.exportTarget + File.separator + this.disks[i3].getVolser()), this.order + File.separator + "order.xml")) == 0;
                    }
                }
            }
            this.status = success ? 4 : 3;
        }
    }

    public abstract class Job
    implements Runnable {
        public static final int IDLE = 0;
        public static final int RUNNING = 1;
        public static final int PAUSED = 2;
        public static final int FAILED = 3;
        public static final int COMPLETE = 4;
        public static final int NONE = 0;
        public static final int STAGE = 1;
        public static final int PROMOTE = 2;
        public static final int ESD = 3;
        public static final int CONFIG_INSTALL = 4;
        protected int status = 0;
        protected int mode = 0;
        protected int type = 0;
        protected String order;
        protected long processed;
        protected Vector entities = new Vector();
        protected Thread thread = null;

        protected Job(String order) {
            this.order = order;
        }

        public boolean start() {
            if (!this.isAlive()) {
                this.thread = new Thread(this);
                this.thread.start();
            }
            return this.isAlive();
        }

        public boolean isAlive() {
            return this.thread != null && this.thread.isAlive();
        }

        public void join() throws InterruptedException {
            if (this.isAlive()) {
                this.thread.join();
            }
        }

        public void interrupt() {
            if (this.isAlive()) {
                this.thread.interrupt();
            }
        }

        public Entity createEntity(SpsSkuData spsSku, VolserData volser, SpsSkuData obsoleteSpsSku) {
            Entity entity = new Entity(spsSku.getSpsSku());
            try {
                entity.setDataSize(Long.parseLong(spsSku.getDataSize()));
            }
            catch (NumberFormatException e) {
                entity.setDataSize(0L);
            }
            try {
                entity.setProductSize(Long.parseLong(spsSku.getProductSize()));
            }
            catch (NumberFormatException e) {
                entity.setProductSize(0L);
            }
            entity.setDataFiles(spsSku.getDataFiles());
            entity.setProductFiles(spsSku.getProductFiles());
            entity.setDataPath(volser.getDataPath(spsSku.getSpsSku()));
            entity.setProductPath(volser.getProductPath(spsSku.getSpsSku()));
            entity.setVolser(volser.getVolser());
            entity.setMediaName(volser.getName("en"));
            if (!spsSku.isFileListFound()) {
                entity.setAltDataPath("product_data/" + spsSku.getSpsSku());
                if ("sdwstartup".equals(spsSku.getProdCode())) {
                    entity.setAltProductPath(".");
                } else {
                    entity.setAltProductPath("products/" + spsSku.getSpsSku());
                }
            }
            boolean copyPayload = true;
            if (this.mode == 4) {
                copyPayload = Utils.getOS() != 8 && Utils.getOS() != 10 ? "deploywiz".equals(spsSku.getProdCode()) || "cfgwizard".equals(spsSku.getProdCode()) || "sampleplans".equals(spsSku.getProdCode()) || "securejava".equals(spsSku.getProdCode()) : "deploywiz".equals(spsSku.getProdCode()) || "cfgwizard".equals(spsSku.getProdCode()) || "sampleplans".equals(spsSku.getProdCode()) || "securejavaz".equals(spsSku.getProdCode());
            } else if (this.type != 0 && "sasinstall".equals(spsSku.getProdCode())) {
                copyPayload = spsSku.getSku(Utils.getOS_Suffix()) == null;
            }
            entity.setProcessPayload(copyPayload);
            entity.setReferencePayload(copyPayload);
            if (obsoleteSpsSku != null) {
                entity.setObsoleteSpsSku(obsoleteSpsSku.getSpsSku());
            }
            return entity;
        }

        protected boolean moveFile(File sourceFile, File targetFile, boolean copy) {
            return this.moveFile(sourceFile, targetFile, copy, false, false);
        }

        protected boolean moveFile(File sourceFile, File targetFile, boolean copy, boolean ignoreMissingSourceErrors, boolean convert_ebcdic) {
            boolean success = false;
            boolean done = false;
            long size = 0L;
            this.status = 1;
            String sourceFilename = sourceFile.toString();
            String targetFilename = targetFile.toString();
            if (!sourceFile.exists() && ignoreMissingSourceErrors) {
                Logging.log.info("Source file doesn't exist, but for this file, it doesn't matter: " + sourceFilename);
                return true;
            }
            while (!success && !done) {
                try {
                    sourceFilename = sourceFile.getCanonicalPath();
                    targetFilename = targetFile.getCanonicalPath();
                    if (copy) {
                        size = sourceFile.length();
                    }
                    if (sourceFile.isDirectory()) {
                        if (targetFile.exists()) {
                            success = targetFile.isDirectory();
                            if (!success) {
                                Logging.log.info("Found Target File With Same Name: " + targetFilename);
                            }
                        } else {
                            success = targetFile.mkdirs();
                            if (!success) {
                                Logging.log.info("Unable To Create Directory: " + targetFilename);
                            }
                        }
                    } else if (sourceFile.isFile()) {
                        if (targetFile.getParentFile().exists()) {
                            success = targetFile.getParentFile().isDirectory();
                            if (!success) {
                                Logging.log.info("Found Target Parent File With Same Name: " + targetFilename);
                            }
                        } else {
                            success = targetFile.getParentFile().mkdirs();
                            if (!success) {
                                Logging.log.warning("Unable To Create Parent Directory: " + targetFilename);
                            }
                        }
                        if (success) {
                            success = copy ? Utils.copyFile(sourceFile, targetFile) == 0 : Utils.rename(sourceFile, targetFile);
                        }
                        if (success && convert_ebcdic && Utils.getOS() == 8 && targetFile.getName().endsWith(".groovy") && Utils.isAscii(targetFile) && !Utils.convertToEbcdic(targetFile)) {
                            Logging.log.severe("Error converting file from ASCII to EBCDIC: " + targetFile.getAbsolutePath());
                            success = false;
                            done = true;
                        }
                        if (success) {
                            try {
                                FileMode file = new FileMode(targetFile);
                                file.setPerm(493);
                                success = file.commit() == 0;
                            }
                            catch (FileNotFoundException e) {
                                Logging.log.severe("Error Setting Permissions: " + targetFilename);
                                Logging.logStackTrace(e);
                                success = false;
                                done = true;
                            }
                        }
                    } else if (sourceFile.exists()) {
                        Logging.log.warning(sourceFilename + " is neither a Directory or a File. Very odd!");
                    } else {
                        Logging.log.warning(sourceFilename + " does not exist.");
                    }
                }
                catch (IOException e) {
                    Logging.log.warning(e.getMessage());
                }
                catch (SecurityException e) {
                    Logging.log.warning(e.getMessage());
                }
                if (success) {
                    this.processed += size;
                    continue;
                }
                if (!copy) {
                    Logging.log.severe("Error Moving File: " + sourceFilename + " => " + targetFilename);
                } else {
                    Logging.log.severe("Error Copying File: " + sourceFilename + " => " + targetFilename);
                }
                if (!(done || this.thread != null && this.thread.isInterrupted())) {
                    this.status = 2;
                    int result = Utils.askToRetry(sourceFilename, targetFilename, copy, this.mode != 4);
                    if (result == 1) {
                        success = true;
                        done = true;
                        continue;
                    }
                    if (result == 2) {
                        done = true;
                        continue;
                    }
                    Logging.log.info("Retrying move/copy...");
                    this.status = 1;
                    continue;
                }
                done = true;
            }
            return success;
        }

        protected boolean deleteFile(File file) {
            boolean success = false;
            long size = 0L;
            String filename = file.toString();
            try {
                filename = file.getCanonicalPath();
                if (!file.exists()) {
                    success = true;
                } else {
                    size = file.length();
                    success = file.delete();
                }
            }
            catch (IOException e) {
                Logging.log.warning(e.getMessage());
            }
            catch (SecurityException e) {
                Logging.log.warning(e.getMessage());
            }
            if (success) {
                this.processed += size;
            } else if (file.isDirectory()) {
                Logging.log.warning("Error Deleting Directory: " + filename);
            } else {
                Logging.log.warning("Error Deleting File: " + filename);
            }
            return success;
        }

        public int getStatus() {
            return this.status;
        }

        public long getTotalSize() {
            long size = 0L;
            Enumeration e = this.entities.elements();
            while (e.hasMoreElements()) {
                Entity entity = (Entity)e.nextElement();
                if (entity.getProcessData()) {
                    size += entity.getDataSize();
                }
                if (!entity.getProcessPayload()) continue;
                size += entity.getProductSize();
            }
            if (this.mode == 1 || this.mode == 2) {
                for (VJRPluginZip pluginZip : VJRManager.getInstance().getQueuedVJRPluginZipsForDepotCreation()) {
                    size += pluginZip.getSize();
                }
            }
            return size;
        }

        public long getTotalProcessed() {
            return this.processed;
        }

        public String[] getSpsSkusToProcess() {
            Vector<String> spsSkus = new Vector<String>();
            Enumeration e = this.entities.elements();
            while (e.hasMoreElements()) {
                Entity entity = (Entity)e.nextElement();
                if (!entity.getProcessPayload()) continue;
                spsSkus.add(entity.getSpsSku());
            }
            return spsSkus.toArray(new String[0]);
        }

        protected class Entity {
            private String spsSku;
            private String obsoleteSpsSku;
            private String dataPath;
            private String productPath;
            private String altDataPath;
            private String altProductPath;
            private String volser;
            private String mediaName;
            private String[] productFiles = new String[0];
            private String[] dataFiles = new String[0];
            private long dataSize;
            private long productSize;
            private boolean processData = true;
            private boolean processPayload = true;
            private boolean referencePayload = true;

            protected Entity(String spsSku) {
                this.spsSku = spsSku;
            }

            protected void setObsoleteSpsSku(String obsoleteSpsSku) {
                this.obsoleteSpsSku = obsoleteSpsSku;
            }

            protected void setDataSize(long dataSize) {
                this.dataSize = dataSize;
            }

            protected void setProductSize(long productSize) {
                this.productSize = productSize;
            }

            protected void setProcessData(boolean processData) {
                this.processData = processData;
            }

            protected void setProcessPayload(boolean processPayload) {
                this.processPayload = processPayload;
            }

            protected void setReferencePayload(boolean referencePayload) {
                this.referencePayload = referencePayload;
            }

            protected void setDataPath(String dataPath) {
                this.dataPath = dataPath;
            }

            protected void setProductPath(String productPath) {
                this.productPath = productPath;
            }

            protected void setAltDataPath(String altDataPath) {
                this.altDataPath = altDataPath;
            }

            protected void setAltProductPath(String altProductPath) {
                this.altProductPath = altProductPath;
            }

            protected void setVolser(String volser) {
                this.volser = volser;
            }

            protected void setMediaName(String mediaName) {
                this.mediaName = mediaName;
            }

            protected void setProductFiles(String[] files) {
                this.productFiles = files;
            }

            protected void setDataFiles(String[] files) {
                this.dataFiles = files;
            }

            protected String getSpsSku() {
                return this.spsSku;
            }

            protected String getObsoleteSpsSku() {
                return this.obsoleteSpsSku;
            }

            protected long getDataSize() {
                return this.dataSize;
            }

            protected long getProductSize() {
                return this.productSize;
            }

            protected boolean getProcessData() {
                return this.processData;
            }

            protected boolean getProcessPayload() {
                return this.processPayload;
            }

            protected boolean getReferencePayload() {
                return this.referencePayload;
            }

            protected String getDataPath() {
                return this.dataPath;
            }

            protected String getProductPath() {
                return this.productPath;
            }

            protected String getAltDataPath() {
                return this.altDataPath;
            }

            protected String getAltProductPath() {
                return this.altProductPath;
            }

            protected String getVolser() {
                return this.volser;
            }

            protected String getMediaName() {
                return this.mediaName;
            }

            protected boolean move(String source, String target, boolean copy) {
                return this.move(source, target, copy, false, false);
            }

            protected boolean move(String source, String target, boolean copy, boolean ignoreMissingSourceErrors, boolean convert_ebcdic) {
                String targetDataPath;
                boolean success = true;
                String sourceDataPath = this.altDataPath;
                if (Job.this.mode != 2 || sourceDataPath == null) {
                    sourceDataPath = this.dataPath;
                }
                if ((targetDataPath = this.altDataPath) == null) {
                    targetDataPath = this.dataPath;
                }
                if (this.processData) {
                    for (int i = 0; success && i < this.dataFiles.length; ++i) {
                        success = Job.this.moveFile(new File(source, sourceDataPath + File.separator + this.dataFiles[i]), new File(target, targetDataPath + File.separator + this.dataFiles[i]), copy, ignoreMissingSourceErrors, convert_ebcdic);
                    }
                }
                if (this.processPayload) {
                    File file;
                    String targetProductPath;
                    String sourceProductPath = this.altProductPath;
                    if (Job.this.mode != 2 || sourceProductPath == null) {
                        sourceProductPath = this.productPath;
                    }
                    if ((targetProductPath = this.altProductPath) == null) {
                        targetProductPath = this.productPath;
                    }
                    if (success && !(file = new File(target, targetProductPath)).isDirectory()) {
                        success = file.mkdirs();
                    }
                    for (int i = 0; success && i < this.productFiles.length; ++i) {
                        success = Job.this.moveFile(new File(source, sourceProductPath + File.separator + this.productFiles[i]), new File(target, targetProductPath + File.separator + this.productFiles[i]), copy, ignoreMissingSourceErrors, convert_ebcdic);
                    }
                }
                return success;
            }

            protected boolean export() {
                return this.move(DepotManager.this.target, DepotManager.this.exportTarget + File.separator + this.volser, true, DepotManager.this.depotData.getSpsSku(this.spsSku).getProdCode().equals("sid_files"), false);
            }

            protected boolean remove() {
                File file;
                int j;
                boolean success = true;
                if (this.processPayload) {
                    for (j = this.productFiles.length - 1; j >= 0; --j) {
                        file = new File(DepotManager.this.target, this.productPath + File.separator + this.productFiles[j]);
                        success &= Job.this.deleteFile(file);
                    }
                    if (success && this.productPath.length() > 0 && !".".equals(this.productPath)) {
                        file = new File(DepotManager.this.target, this.productPath);
                        while (!file.equals(new File(DepotManager.this.target)) && file.delete()) {
                            file = file.getParentFile();
                        }
                    }
                }
                if (this.processData && success) {
                    for (j = this.dataFiles.length - 1; j >= 0; --j) {
                        file = new File(DepotManager.this.target, this.dataPath + File.separator + this.dataFiles[j]);
                        success &= Job.this.deleteFile(file);
                    }
                    if (success) {
                        file = new File(DepotManager.this.target, this.dataPath);
                        Job.this.deleteFile(file);
                    }
                }
                return success;
            }
        }
    }
}

