/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.Utils;

public class DeploymentManager {
    public static RegistryAccess setRegistryData(String version, String platform, RegistryAccess registryAccess) {
        String productCode = "cfgwizard";
        if (registryAccess != null) {
            String[] installVersions = registryAccess.getInstallVersions("cfgwizard", platform);
            for (int i = 0; i < installVersions.length; ++i) {
                registryAccess.removeInstall(productCode, installVersions[i], platform);
            }
        }
        ProductData myprodData = Globals.g_deploymentData.getProduct(Globals.g_order, "cfgwizard", false);
        String cfgwizardVersion = myprodData.getProdVersion();
        String sashome = Globals.g_wizardData.getPreference("SASHome", "");
        String cfgwizardLoc = Utils.joinPath(sashome, "SASDeploymentManager", Globals.g_majorReleaseVersion);
        if (myprodData != null) {
            registryAccess.setInstallOrderNum(myprodData.getProdCode(), cfgwizardVersion, platform, Globals.g_order);
            registryAccess.setInstallDisplayName(myprodData.getProdCode(), cfgwizardVersion, platform, myprodData.getProdName());
            if (myprodData.getLastPortDate().length() > 0) {
                registryAccess.setInstallLastPortDate(myprodData.getProdCode(), cfgwizardVersion, platform, myprodData.getLastPortDate());
            }
            registryAccess.setInstallStatus(myprodData.getProdCode(), cfgwizardVersion, platform, "0");
            registryAccess.updateInstallTime(myprodData.getProdCode(), cfgwizardVersion, platform);
            registryAccess.setInstallLoc(myprodData.getProdCode(), cfgwizardVersion, platform, cfgwizardLoc);
            registryAccess.setMaintDisplayName(myprodData.getProdCode(), cfgwizardVersion, platform, myprodData.getProdMaint(), myprodData.getProdVersion());
            registryAccess.setMaintLevel(myprodData.getProdCode(), cfgwizardVersion, platform, myprodData.getProdMaint());
        }
        return registryAccess;
    }
}

