/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.OrderData;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SkuData;
import com.sas.ssn.SkuFilterIface;
import com.sas.ssn.SkuRequirementsForOrder;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import com.sas.ssn.VolserData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JFrame;

public class DeploymentData {
    protected static SSNResource bundle = new SSNResource(DeploymentData.class);
    protected SpsSkuList spsSkuList;
    protected VolserList mediaCodeList;
    protected OrderList orderList;
    private File mediaRoot;
    private String orderDir;
    private String mediaDir;
    private boolean loadFileListData;
    private static final int FIND_REQUIREMENTS = 0;
    private static final int FIND_REQUIRED_BYS = 1;
    protected HashMap<String, ProductData[]> _codeOrdPlat = new HashMap();
    protected HashMap<String, ProductData[]> _prodsForPlat = new HashMap();

    public DeploymentData() {
    }

    public DeploymentData(String mediaRoot) {
        this(new File(mediaRoot));
    }

    public DeploymentData(File mediaRoot) {
        this.mediaRoot = mediaRoot;
        this.orderDir = "order_data";
        this.mediaDir = "media_data";
        this.loadFileListData = true;
        this.clear();
    }

    public void clear() {
        this.spsSkuList = new SpsSkuList();
        this.mediaCodeList = new VolserList();
        this.orderList = new OrderList();
    }

    public void loadOrders() {
        String[] files = new File(this.mediaRoot, this.orderDir).list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                this.loadOrder(files[i]);
            }
        }
    }

    public void loadOrder(String order) {
        if (order != null) {
            String file = this.getMediaRoot() + File.separator + this.orderDir + File.separator + order + File.separator + "order.xml";
            try {
                this.orderList.add(new OrderData(file, this));
            }
            catch (FileNotFoundException e) {
                if (Globals.g_genFileLists) {
                    Logging.log.fine("Order XML File Not Found: " + file);
                    Logging.log.fine(e.getMessage());
                } else {
                    Logging.log.info("Order XML File Not Found: " + file);
                    Logging.log.info(e.getMessage());
                }
            }
            catch (IOException e) {
                Logging.log.info("Error Reading Order XML File: " + file);
                Logging.log.info(e.getMessage());
            }
            catch (Exception e) {
                Logging.log.info("Error Parsing Order XML File: " + file);
                Logging.log.info(e.getMessage());
            }
        }
    }

    public void cloneOrder(String source, String target, boolean disablePlanning) {
        OrderData sourceOrder = this.getOrder(source);
        if (sourceOrder != null) {
            this.orderList.add(sourceOrder.clone(target, disablePlanning));
        }
    }

    public void cloneOrder(String source, String target, String destDir, boolean disablePlanning) {
        OrderData sourceOrder = this.getOrder(source);
        if (sourceOrder != null) {
            this.orderList.add(sourceOrder.clone(target, destDir, disablePlanning));
        }
    }

    public void setLoadFileLists(boolean load) {
        this.loadFileListData = load;
    }

    public void setOrderDir(String dir) {
        this.orderDir = dir;
    }

    public void setMediaDir(String dir) {
        this.mediaDir = dir;
    }

    public boolean getLoadFileLists() {
        return this.loadFileListData;
    }

    public String getMediaRoot() {
        return this.mediaRoot.getAbsolutePath();
    }

    public void setMediaRoot(String mediaRootStr) {
        this.mediaRoot = new File(mediaRootStr);
    }

    public String getOrderDir() {
        return this.getOrderDir(this.getMediaRoot());
    }

    public String getOrderDir(String altRoot) {
        return altRoot + File.separator + this.orderDir;
    }

    public String getMediaDir() {
        return this.getMediaDir(this.getMediaRoot());
    }

    public String getMediaDir(String altRoot) {
        return altRoot + File.separator + this.mediaDir;
    }

    public OrderData getOrder(String order) {
        return this.orderList.get(order);
    }

    public OrderData[] getOrders() {
        OrderData[] orderData = this.orderList.getAll();
        for (int i = orderData.length - 1; i > 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (orderData[j].getOrder().compareTo(orderData[j + 1].getOrder()) <= 0) continue;
                OrderData temp = orderData[j];
                orderData[j] = orderData[j + 1];
                orderData[j + 1] = temp;
            }
        }
        return orderData;
    }

    public int getOrderCount() {
        return this.orderList.getCount();
    }

    public VolserData getVolser(String volser) {
        return this.mediaCodeList.get(volser);
    }

    public VolserData[] getVolsers() {
        return this.mediaCodeList.getAll();
    }

    public int getVolserCount() {
        return this.mediaCodeList.getCount();
    }

    public SpsSkuData getSpsSku(String spsSku) {
        return this.spsSkuList.get(spsSku);
    }

    public SpsSkuData[] getSpsSkus() {
        return this.spsSkuList.getAll();
    }

    public SpsSkuData getSpsSkuByProdCode(String order, String code, String platform, boolean includeDataOnly) {
        OrderData orderData = this.orderList.get(order);
        String[] volsers = orderData.getVolsers(orderData.getMediaType());
        SpsSkuData spsSkuData = null;
        SkuData sku = null;
        for (int i = 0; sku == null && i < volsers.length; ++i) {
            VolserData volserData = this.mediaCodeList.get(volsers[i]);
            String[] spsSkus = volserData.getSpsSkus();
            for (int j = 0; sku == null && j < spsSkus.length; ++j) {
                spsSkuData = this.spsSkuList.get(spsSkus[j]);
                if (!spsSkuData.getProdCode().equals(code) || !includeDataOnly && !volserData.isPayloadIncluded(spsSkus[j])) continue;
                sku = spsSkuData.getSku(platform);
            }
        }
        if (sku == null) {
            spsSkuData = null;
        }
        return spsSkuData;
    }

    public SpsSkuData[] getSpsSkusByProdCode(String code, String platform, boolean includeDataOnly) {
        Vector<SpsSkuData> list = new Vector<SpsSkuData>();
        code = code.toLowerCase(Locale.ENGLISH);
        SpsSkuData[] spsSkuData = this.getSpsSkus();
        for (int i = 0; i < spsSkuData.length; ++i) {
            if (!spsSkuData[i].getProdCode().equals(code) || platform != null && spsSkuData[i].getSku(platform) == null) continue;
            String[] volsers = spsSkuData[i].getVolsers();
            for (int j = 0; j < volsers.length; ++j) {
                VolserData volserData = this.mediaCodeList.get(volsers[j]);
                if (!includeDataOnly && !volserData.isPayloadIncluded(spsSkuData[i].getSpsSku())) continue;
                list.add(spsSkuData[i]);
                j = volsers.length;
            }
        }
        return list.toArray(new SpsSkuData[0]);
    }

    public SpsSkuData getNewestSpsSku(String code, String platform, boolean includeDataOnly) {
        SpsSkuData retVal = null;
        SpsSkuData[] spsSkuData = this.getSpsSkusByProdCode(code, platform, includeDataOnly);
        for (int i = 0; i < spsSkuData.length; ++i) {
            if (retVal == null) {
                retVal = spsSkuData[i];
                continue;
            }
            long time1 = 0L;
            long time2 = 0L;
            if (Globals.g_depotManager != null && Globals.g_depotManager.isPreSPSDepot() && !spsSkuData[i].getDisplayVer("en").equals(retVal.getDisplayVer("en"))) {
                String portDate1 = spsSkuData[i].getLastPortDate();
                String portDate2 = retVal.getLastPortDate();
                if (portDate1 != null && portDate1.length() == 9) {
                    time1 = new SimpleDateFormat("ddMMMyyyy", Locale.US).parse(portDate1, new ParsePosition(0)).getTime();
                }
                if (portDate2 != null && portDate2.length() == 9) {
                    time2 = new SimpleDateFormat("ddMMMyyyy", Locale.US).parse(portDate2, new ParsePosition(0)).getTime();
                }
            }
            if (time1 > time2) {
                retVal = spsSkuData[i];
                continue;
            }
            if (time1 != time2 || spsSkuData[i].getTimeAsLong() <= retVal.getTimeAsLong()) continue;
            retVal = spsSkuData[i];
        }
        return retVal;
    }

    public int getSpsSkuCount() {
        return this.spsSkuList.getCount();
    }

    public String getProductDataDir(String order, String code, boolean firstDisk, boolean includeDataOnly) {
        return this.getProductDataDir(order, code, Utils.getOS_Suffix(), firstDisk, includeDataOnly);
    }

    public String getProductDataDir(String order, String code, String platform, boolean firstDisk, boolean includeDataOnly) {
        String dir = null;
        ProductData product = this.getProduct(order, code, platform, includeDataOnly);
        if (product != null) {
            dir = this.getSpsSkuDataDir(order, product.getSpsSku(), firstDisk);
        }
        return dir;
    }

    public String getProductDataDir(String order, ProductData product, boolean firstDisk) {
        return this.getProductDataDir(order, product, Utils.getOS_Suffix(), firstDisk);
    }

    public String getProductDataDir(String order, ProductData product, String platform, boolean firstDisk) {
        String dir = null;
        if (product != null) {
            dir = this.getSpsSkuDataDir(order, product.getSpsSku(), firstDisk);
        }
        return dir;
    }

    public String getSpsSkuDataDir(String order, String spsSku, boolean firstDisk) {
        String dir = null;
        OrderData orderData = this.orderList.get(order);
        if (orderData != null) {
            String dataPath = null;
            String name = null;
            String volser = null;
            String[] volsers = orderData.getVolsers(orderData.getMediaType());
            for (int i = 0; dataPath == null && i < volsers.length; ++i) {
                VolserData volserData = this.mediaCodeList.get(volsers[i]);
                dataPath = volserData.getDataPath(spsSku);
                if ((i != 0 || !firstDisk) && (dataPath == null || firstDisk)) continue;
                name = volserData.getName("en");
                volser = volserData.getVolser();
            }
            if (dataPath != null) {
                JFrame parent = null;
                if (Globals.g_wizard != null) {
                    parent = Globals.g_wizard.getFrame();
                }
                if ((dir = Globals.g_kit.diskSearch(parent, firstDisk ? Globals.g_startupLocation : Globals.g_currentDiskLocation, name, volser)) != null) {
                    dir = new File(dir, dataPath).getAbsolutePath();
                }
            }
        }
        return dir;
    }

    public String getProductDir(String order, String code, boolean relative, boolean includeDataOnly) {
        return this.getProductDir(order, code, Utils.getOS_Suffix(), relative, includeDataOnly);
    }

    public String getProductDir(String order, String code, String platform, boolean relative, boolean includeDataOnly) {
        String dir = null;
        ProductData product = this.getProduct(order, code, platform, includeDataOnly);
        if (product != null) {
            dir = this.getSpsSkuProductDir(order, product.getSpsSku(), relative);
        }
        return dir;
    }

    public String getSpsSkuProductDir(String order, String spsSku, boolean relative) {
        String dir = null;
        OrderData orderData = this.orderList.get(order);
        if (orderData != null) {
            String prodPath = null;
            String name = null;
            String volser = null;
            String[] volsers = orderData.getVolsers(orderData.getMediaType());
            for (int i = 0; prodPath == null && i < volsers.length; ++i) {
                VolserData volserData = this.mediaCodeList.get(volsers[i]);
                if (!volserData.isPayloadIncluded(spsSku)) continue;
                prodPath = volserData.getProductPath(spsSku);
                if (relative || prodPath == null) continue;
                name = volserData.getName("en");
                volser = volserData.getVolser();
            }
            if (prodPath != null) {
                if (relative) {
                    dir = prodPath;
                } else {
                    dir = Globals.g_kit.diskSearch(Globals.g_wizard.getFrame(), Globals.g_currentDiskLocation, name, volser);
                    if (dir != null) {
                        dir = new File(dir + "/" + prodPath).getAbsolutePath();
                    }
                }
            }
        }
        return dir;
    }

    public ProductData[] getThirdParty(String order, String[] codes, boolean includeDataOnly) {
        Vector<ProductData> list = new Vector<ProductData>();
        for (int i = 0; i < codes.length; ++i) {
            ProductData product = this.getProduct(order, codes[i], includeDataOnly);
            if (product == null || !product.getPrompt()) continue;
            list.add(product);
        }
        return list.toArray(new ProductData[0]);
    }

    public ProductData[] getConfigured(String order, String[] codes, boolean includeDataOnly) {
        Vector<ProductData> list = new Vector<ProductData>();
        for (int i = 0; i < codes.length; ++i) {
            ProductData product = this.getProduct(order, codes[i], includeDataOnly);
            if (product == null) continue;
            list.add(new ProductData(product.getProdCode(), product.getSpsSku(), null, product.getProdVersion(), product.getProdCustVersion(), null, null, null, product.getProdName(), 2, 0, 2, true, null, null, null, null, null, false, false, false, true, false, null, null, product.getSequenceNum()));
        }
        return list.toArray(new ProductData[0]);
    }

    public ProductData[] getAllProducts(String order, boolean includeDataOnly) {
        Hashtable<String, ProductData> hash = new Hashtable<String, ProductData>();
        ProductData[] products = this.getProdsForPlat(order, Utils.getOS_Suffix(), includeDataOnly);
        for (int i = 0; i < products.length; ++i) {
            hash.put(products[i].getProdCode(), products[i]);
        }
        OrderData orderData = this.orderList.get(order);
        String[] volsers = orderData.getVolsers(orderData.getMediaType());
        for (int i = 0; i < volsers.length; ++i) {
            VolserData volserData = this.mediaCodeList.get(volsers[i]);
            String[] spsSkus = volserData.getSpsSkus();
            for (int j = 0; j < spsSkus.length; ++j) {
                SpsSkuData spsSkuData;
                if (!includeDataOnly && !volserData.isPayloadIncluded(spsSkus[j]) || hash.containsKey((spsSkuData = this.spsSkuList.get(spsSkus[j])).getProdCode())) continue;
                hash.put(spsSkuData.getProdCode(), new ProductData(spsSkuData.getProdCode(), spsSkuData.getSpsSku(), null, this.getDisplayVer(spsSkuData), this.getCustomerVer(spsSkuData), spsSkuData.getMaintLevel(), spsSkuData.getLastPortDate(), spsSkuData.getSASRelease(), this.getDisplayName(spsSkuData), spsSkuData.isInstallable() ? 1 : 2, 0, 2, false, null, null, null, null, null, false, false, false, true, false, null, null, 0L));
            }
        }
        return hash.values().toArray(new ProductData[0]);
    }

    public ProductData[] getProducts(String order, String[] codes, boolean includeDataOnly) {
        Vector<ProductData> list = new Vector<ProductData>();
        for (int i = 0; i < codes.length; ++i) {
            ProductData product = codes[i].equalsIgnoreCase("sasinstall") && Globals.g_sasinstallPlat != null ? this.getProduct(order, "sasinstall", Globals.g_sasinstallPlat, includeDataOnly) : (codes[i].equalsIgnoreCase("statstudio") && Globals.g_sasinstallPlat != null ? this.getProduct(order, "statstudio", Globals.g_sasinstallPlat, includeDataOnly) : (codes[i].equalsIgnoreCase("jmp") && Globals.g_jmpPlat != null ? this.getProduct(order, "jmp", Globals.g_jmpPlat, includeDataOnly) : (codes[i].equalsIgnoreCase("pcfilesrv") && Globals.g_pcfilesrvPlat != null ? this.getProduct(order, "pcfilesrv", Globals.g_pcfilesrvPlat, includeDataOnly) : (codes[i].equalsIgnoreCase("eguide") && Globals.g_eguidePlat != null ? this.getProduct(order, "eguide", Globals.g_eguidePlat, includeDataOnly) : (codes[i].equalsIgnoreCase("msofficeint") && Globals.g_msofficeintPlat != null ? this.getProduct(order, "msofficeint", Globals.g_msofficeintPlat, includeDataOnly) : (codes[i].equalsIgnoreCase("msoffintva") && Globals.g_msoffintvaPlat != null ? this.getProduct(order, "msoffintva", Globals.g_msoffintvaPlat, includeDataOnly) : (codes[i].equalsIgnoreCase("webedtr") && Globals.g_sasinstallPlat != null ? this.getProduct(order, "webedtr", Globals.g_sasinstallPlat, includeDataOnly) : this.getProduct(order, codes[i], includeDataOnly))))))));
            if (product == null || product.getPrompt() || "".equals(product.getChainingRef(false))) continue;
            list.add(product);
        }
        return list.toArray(new ProductData[0]);
    }

    public ProductData[] getMaintenance(String order, String code, String platform, boolean includeDataOnly) {
        Vector<ProductData> maintenance = new Vector<ProductData>();
        ProductData product = this.getProduct(order, code, platform, includeDataOnly);
        if (product != null) {
            SpsSkuData spsSkuData;
            String[] maintSpsSkus = this.getOrder(order).getAllMaintenanceSkus(product.getProdCode(), product.getProdVersion(), platform);
            if (maintSpsSkus.length == 0 && (spsSkuData = this.spsSkuList.get(product.getSpsSku())).isTargetByBaseHost()) {
                maintSpsSkus = this.getOrder(order).getAllMaintenanceSkus(product.getProdCode(), product.getProdVersion(), Utils.getOS_Suffix());
            }
            if (maintSpsSkus.length > 0) {
                OrderData orderData = this.orderList.get(order);
                String[] volsers = orderData.getVolsers(orderData.getMediaType());
                for (int i = 0; i < volsers.length; ++i) {
                    VolserData volserData = this.mediaCodeList.get(volsers[i]);
                    String[] spsSkus = volserData.getSpsSkus();
                    for (int j = 0; j < spsSkus.length; ++j) {
                        SpsSkuData spsSkuData2 = this.spsSkuList.get(spsSkus[j]);
                        if (!spsSkuData2.isMaintLevelGreaterThanZero()) continue;
                        for (int k = 0; k < maintSpsSkus.length; ++k) {
                            SkuData sku;
                            if (!spsSkuData2.getSpsSku().equals(maintSpsSkus[k]) || spsSkuData2.getIndb() || !includeDataOnly && !volserData.isPayloadIncluded(maintSpsSkus[k]) || (sku = spsSkuData2.getSku(platform)) == null) continue;
                            maintenance.add(new ProductData(spsSkuData2.getProdCode(), spsSkuData2.getSpsSku(), platform, this.getDisplayVer(spsSkuData2), this.getCustomerVer(spsSkuData2), spsSkuData2.getMaintLevel(), spsSkuData2.getLastPortDate(), spsSkuData2.getSASRelease(), this.getDisplayName(spsSkuData2), 1, this.getStatus(spsSkuData2), this.getSelectableType(sku), "true".equalsIgnoreCase(sku.getMiscValue("is_config")), this.getInstallTypeCmd(orderData, spsSkuData2, volserData, sku, "interactive"), this.getInstallTypeCmd(orderData, spsSkuData2, volserData, sku, "silent"), this.getInstallTypeCmd(orderData, spsSkuData2, volserData, sku, "index"), this.getInstallTypeArgs(orderData, spsSkuData2, sku, "interactive"), this.getInstallTypeArgs(orderData, spsSkuData2, sku, "silent"), "true".equalsIgnoreCase(sku.getMiscValue("is_foundation")), "true".equalsIgnoreCase(sku.getMiscValue("use_sasinstall")), "true".equalsIgnoreCase(sku.getMiscValue("use_srw")), "true".equalsIgnoreCase(sku.getMiscValue("use_jre")), sku.getInstallType("prompt") != null, volserData.getVolser(), volserData.getName("en"), this.getSequenceNumber(spsSkuData2, volserData)));
                        }
                    }
                }
            }
        }
        return maintenance.toArray(new ProductData[0]);
    }

    public ProductData getMaintenance(String order, String code, String platform, String language, boolean includeDataOnly) {
        ProductData product = this.getProduct(order, code, platform, includeDataOnly);
        return this.getMaintenance(order, platform, language, product, includeDataOnly);
    }

    public ProductData getMaintenance(String order, String platform, String language, ProductData product, boolean includeDataOnly) {
        String maintSpsSku;
        ProductData maintenance = null;
        if (product != null && (maintSpsSku = this.getOrder(order).getMaintenanceSku(product.getProdCode(), product.getProdVersion(), platform, language)) != null) {
            OrderData orderData = this.orderList.get(order);
            String[] volsers = orderData.getVolsers(orderData.getMediaType());
            for (int i = 0; maintenance == null && i < volsers.length; ++i) {
                VolserData volserData = this.mediaCodeList.get(volsers[i]);
                String[] spsSkus = volserData.getSpsSkus();
                for (int j = 0; maintenance == null && j < spsSkus.length; ++j) {
                    SkuData sku;
                    SpsSkuData spsSkuData = this.spsSkuList.get(spsSkus[j]);
                    if (!spsSkuData.isMaintLevelGreaterThanZero() || !maintSpsSku.equals(spsSkus[j]) || spsSkuData.getIndb() || !includeDataOnly && !volserData.isPayloadIncluded(spsSkus[j]) || (sku = spsSkuData.getSku(platform)) == null) continue;
                    maintenance = new ProductData(spsSkuData.getProdCode(), spsSkuData.getSpsSku(), platform, this.getDisplayVer(spsSkuData), this.getCustomerVer(spsSkuData), spsSkuData.getMaintLevel(), spsSkuData.getLastPortDate(), spsSkuData.getSASRelease(), this.getDisplayName(spsSkuData), 1, this.getStatus(spsSkuData), this.getSelectableType(sku), "true".equalsIgnoreCase(sku.getMiscValue("is_config")), this.getInstallTypeCmd(orderData, spsSkuData, volserData, sku, "interactive"), this.getInstallTypeCmd(orderData, spsSkuData, volserData, sku, "silent"), this.getInstallTypeCmd(orderData, spsSkuData, volserData, sku, "index"), this.getInstallTypeArgs(orderData, spsSkuData, sku, "interactive"), this.getInstallTypeArgs(orderData, spsSkuData, sku, "silent"), "true".equalsIgnoreCase(sku.getMiscValue("is_foundation")), "true".equalsIgnoreCase(sku.getMiscValue("use_sasinstall")), "true".equalsIgnoreCase(sku.getMiscValue("use_srw")), "true".equalsIgnoreCase(sku.getMiscValue("use_jre")), sku.getInstallType("prompt") != null, volserData.getVolser(), volserData.getName("en"), this.getSequenceNumber(spsSkuData, volserData));
                }
            }
        }
        return maintenance;
    }

    public ProductData[] getIndbMaintenance(String order, String code, String installPlatform, String indbPlatform, boolean includeDataOnly) {
        String[] maintSpsSkus;
        Vector<ProductData> maintenance = new Vector<ProductData>();
        ProductData product = this.getIndbProduct(order, code, installPlatform, indbPlatform, includeDataOnly);
        if (product != null && (maintSpsSkus = this.getOrder(order).getAllMaintenanceSkus(product.getProdCode(), product.getProdVersion(), installPlatform)).length > 0) {
            OrderData orderData = this.orderList.get(order);
            String[] volsers = orderData.getVolsers(orderData.getMediaType());
            for (int i = 0; i < volsers.length; ++i) {
                VolserData volserData = this.mediaCodeList.get(volsers[i]);
                String[] spsSkus = volserData.getSpsSkus();
                for (int j = 0; j < spsSkus.length; ++j) {
                    SpsSkuData spsSkuData = this.spsSkuList.get(spsSkus[j]);
                    if (!spsSkuData.isMaintLevelGreaterThanZero()) continue;
                    for (int k = 0; k < maintSpsSkus.length; ++k) {
                        SkuData sku;
                        if (!spsSkuData.getSpsSku().equals(maintSpsSkus[k]) || !spsSkuData.getIndb() || !spsSkuData.getPlatform().equals(indbPlatform) || !includeDataOnly && !volserData.isPayloadIncluded(maintSpsSkus[k]) || (sku = spsSkuData.getSku(installPlatform)) == null) continue;
                        maintenance.add(new ProductData(spsSkuData.getProdCode(), spsSkuData.getSpsSku(), indbPlatform, this.getDisplayVer(spsSkuData), this.getCustomerVer(spsSkuData), spsSkuData.getMaintLevel(), spsSkuData.getLastPortDate(), spsSkuData.getSASRelease(), this.getDisplayName(spsSkuData), 1, this.getStatus(spsSkuData), this.getSelectableType(sku), "true".equalsIgnoreCase(sku.getMiscValue("is_config")), this.getInstallTypeCmd(orderData, spsSkuData, volserData, sku, "interactive"), this.getInstallTypeCmd(orderData, spsSkuData, volserData, sku, "silent"), this.getInstallTypeCmd(orderData, spsSkuData, volserData, sku, "index"), this.getInstallTypeArgs(orderData, spsSkuData, sku, "interactive"), this.getInstallTypeArgs(orderData, spsSkuData, sku, "silent"), "true".equalsIgnoreCase(sku.getMiscValue("is_foundation")), "true".equalsIgnoreCase(sku.getMiscValue("use_sasinstall")), "true".equalsIgnoreCase(sku.getMiscValue("use_srw")), "true".equalsIgnoreCase(sku.getMiscValue("use_jre")), sku.getInstallType("prompt") != null, volserData.getVolser(), volserData.getName("en"), this.getSequenceNumber(spsSkuData, volserData)));
                    }
                }
            }
        }
        return maintenance.toArray(new ProductData[0]);
    }

    public ProductData getProduct(String order, String code, boolean includeDataOnly) {
        return this.getProduct(order, code, Utils.getOS_Suffix(), includeDataOnly);
    }

    public ProductData getProduct(String order, String code, String platform, boolean includeDataOnly) {
        ProductData product = null;
        ProductData[] products = this.getProdsForPlat(order, platform, includeDataOnly);
        for (int i = 0; product == null && i < products.length; ++i) {
            SpsSkuData spsSku;
            if (!products[i].getProdCode().equalsIgnoreCase(code) || !(spsSku = this.spsSkuList.get(products[i].getSpsSku())).isStandardLanguage() || spsSku.getIndb()) continue;
            product = products[i];
        }
        return product;
    }

    public ProductData getIndbProduct(String order, String code, String installPlatform, String indbPlatform, boolean includeDataOnly) {
        ProductData product = null;
        ProductData[] products = this.getProdsForPlat(order, installPlatform, includeDataOnly);
        for (int i = 0; product == null && i < products.length; ++i) {
            SpsSkuData spsSku;
            if (!products[i].getProdCode().equalsIgnoreCase(code) || !products[i].getPlatform().equals(indbPlatform) || !(spsSku = this.spsSkuList.get(products[i].getSpsSku())).isStandardLanguage() || !spsSku.getIndb()) continue;
            product = products[i];
        }
        return product;
    }

    public ProductData[] getProductArray(String order, String code, boolean includeDataOnly) {
        return this.getProductArray(order, code, Utils.getOS_Suffix(), includeDataOnly);
    }

    public ProductData[] getProductArray(String order, String code, String platform, boolean includeDataOnly) {
        String cacheKey = code + "|" + order + "|" + platform;
        ProductData[] ret = this._codeOrdPlat.get(cacheKey);
        if (ret == null) {
            Vector<ProductData> productList = new Vector<ProductData>();
            ProductData[] products = this.getProdsForPlat(order, platform, includeDataOnly);
            for (int i = 0; i < products.length; ++i) {
                if (!products[i].getProdCode().equalsIgnoreCase(code)) continue;
                productList.add(products[i]);
            }
            ret = productList.toArray(new ProductData[productList.size()]);
            this._codeOrdPlat.put(cacheKey, ret);
        }
        return ret;
    }

    public ProductData[] getProductArrayByRegPlat(String order, String code, String platform, boolean includeDataOnly) {
        Vector<ProductData> productList = new Vector<ProductData>();
        ProductData[] products = this.getProdsForPlat(order, platform, includeDataOnly);
        if (products.length == 0) {
            products = this.getProdsForPlat(order, Utils.getOS_Suffix(), includeDataOnly);
        }
        for (int i = 0; i < products.length; ++i) {
            if (!products[i].getProdCode().equalsIgnoreCase(code) || !products[i].getPlatform().equals(platform)) continue;
            productList.add(products[i]);
        }
        return productList.toArray(new ProductData[0]);
    }

    public ProductData[] getProdsForPlat(String order, String platform, boolean includeDataOnly) {
        String installPlatform;
        String code;
        ProductData[] retval;
        String cacheKey = order + "_" + platform;
        if (includeDataOnly) {
            cacheKey = cacheKey + "_full";
        }
        if ((retval = this._prodsForPlat.get(cacheKey)) != null) {
            return retval;
        }
        Vector returnList = new Vector();
        Hashtable<String, Vector<ProductData>> productList = new Hashtable<String, Vector<ProductData>>();
        Hashtable<String, Vector<ProductData>> maintenanceList = new Hashtable<String, Vector<ProductData>>();
        ProductData fakeSasInstall = null;
        OrderData orderData = this.orderList.get(order);
        String[] volsers = new String[]{};
        if (orderData != null) {
            volsers = orderData.getVolsers(orderData.getMediaType());
        } else {
            Logging.log.severe("Order not found: " + order);
        }
        boolean addedSasInstall = false;
        for (int i = 0; i < volsers.length; ++i) {
            VolserData volserData = this.mediaCodeList.get(volsers[i]);
            String[] spsSkus = volserData.getSpsSkus();
            for (int j = 0; j < spsSkus.length; ++j) {
                Vector list;
                if (!includeDataOnly && !volserData.isPayloadIncluded(spsSkus[j])) continue;
                SpsSkuData spsSkuData = this.spsSkuList.get(spsSkus[j]);
                code = spsSkuData.getProdCode();
                installPlatform = spsSkuData.platformToDeploy(platform);
                if (installPlatform == null) continue;
                SkuData sku = spsSkuData.getSku(installPlatform);
                if (sku != null && !platform.equals(installPlatform) && Globals.g_mode != 2 && ("true".equalsIgnoreCase(sku.getMiscValue("is_foundation")) || "jmp".equals(code) || "pcfilesrv".equals(code) || "eguide".equals(code) || "msofficeint".equals(code) || "autocadplgn".equals(code))) {
                    sku = null;
                }
                if (sku == null) continue;
                String key = code + ":" + installPlatform;
                if (spsSkuData.getIndb()) {
                    list = returnList;
                } else if (spsSkuData.isDeltaRelease()) {
                    list = (Vector)maintenanceList.get(key);
                    if (list == null) {
                        list = new Vector();
                        maintenanceList.put(key, list);
                    }
                } else {
                    list = (Vector)productList.get(key);
                    if (list == null) {
                        list = new Vector();
                        productList.put(key, list);
                    }
                    if (!addedSasInstall && "base".equalsIgnoreCase(spsSkuData.getProdCode()) && ("en".equalsIgnoreCase(spsSkuData.getLanguage()) || "ne".equalsIgnoreCase(spsSkuData.getLanguage()))) {
                        Logging.log.info(String.format("Found %s, adding sasinstall to chain", spsSkus[j]));
                        addedSasInstall = true;
                        returnList.add(new ProductData("sasinstall", spsSkuData.getSpsSku(), installPlatform, this.getDisplayVer(spsSkuData), this.getCustomerVer(spsSkuData), spsSkuData.getMaintLevel(), spsSkuData.getLastPortDate(), spsSkuData.getSASRelease(), "SAS Foundation", 1, this.getStatus(spsSkuData), 1, "true".equalsIgnoreCase(sku.getMiscValue("is_config")), this.getInstallTypeCmd(orderData, spsSkuData, volserData, sku, "interactive"), this.getInstallTypeCmd(orderData, spsSkuData, volserData, sku, "silent"), this.getInstallTypeCmd(orderData, spsSkuData, volserData, sku, "index"), this.getInstallTypeArgs(orderData, spsSkuData, sku, "interactive"), this.getInstallTypeArgs(orderData, spsSkuData, sku, "silent"), "true".equalsIgnoreCase(sku.getMiscValue("is_foundation")), "true".equalsIgnoreCase(sku.getMiscValue("use_sasinstall")), "true".equalsIgnoreCase(sku.getMiscValue("use_srw")), "true".equalsIgnoreCase(sku.getMiscValue("use_jre")), sku.getInstallType("prompt") != null, volserData.getVolser(), volserData.getName("en"), this.getSequenceNumber(spsSkuData, volserData)));
                    } else if ("deploywiz".equalsIgnoreCase(spsSkuData.getProdCode())) {
                        Logging.log.info(String.format("Found %s, adding installtool to chain", spsSkus[j]));
                        returnList.add(new ProductData("installtool", spsSkuData.getSpsSku(), installPlatform, this.getDisplayVer(spsSkuData), this.getCustomerVer(spsSkuData), spsSkuData.getMaintLevel(), spsSkuData.getLastPortDate(), spsSkuData.getSASRelease(), "Installation Tool", 1, this.getStatus(spsSkuData), 2, "true".equalsIgnoreCase(sku.getMiscValue("is_config")), this.getInstallTypeCmd(orderData, spsSkuData, volserData, sku, "interactive"), this.getInstallTypeCmd(orderData, spsSkuData, volserData, sku, "silent"), this.getInstallTypeCmd(orderData, spsSkuData, volserData, sku, "index"), this.getInstallTypeArgs(orderData, spsSkuData, sku, "interactive"), this.getInstallTypeArgs(orderData, spsSkuData, sku, "silent"), "true".equalsIgnoreCase(sku.getMiscValue("is_foundation")), "true".equalsIgnoreCase(sku.getMiscValue("use_sasinstall")), "true".equalsIgnoreCase(sku.getMiscValue("use_srw")), "true".equalsIgnoreCase(sku.getMiscValue("use_jre")), sku.getInstallType("prompt") != null, volserData.getVolser(), volserData.getName("en"), this.getSequenceNumber(spsSkuData, volserData)));
                    } else if (fakeSasInstall == null && Utils.getOS() == 8 && (!Globals.g_z64 && spsSkus[j].contains("__mvs__") || Globals.g_z64 && spsSkus[j].contains("__z64__"))) {
                        Logging.log.info(String.format("Found %s, adding sasinstall to chain", spsSkus[j]));
                        fakeSasInstall = new ProductData("sasinstall", spsSkuData.getSpsSku(), installPlatform, this.getDisplayVer(spsSkuData), this.getCustomerVer(spsSkuData), spsSkuData.getMaintLevel(), spsSkuData.getLastPortDate(), spsSkuData.getSASRelease(), "SAS Foundation", 1, this.getStatus(spsSkuData), 1, "true".equalsIgnoreCase(sku.getMiscValue("is_config")), this.getInstallTypeCmd(orderData, spsSkuData, volserData, sku, "interactive"), this.getInstallTypeCmd(orderData, spsSkuData, volserData, sku, "silent"), this.getInstallTypeCmd(orderData, spsSkuData, volserData, sku, "index"), this.getInstallTypeArgs(orderData, spsSkuData, sku, "interactive"), this.getInstallTypeArgs(orderData, spsSkuData, sku, "silent"), "true".equalsIgnoreCase(sku.getMiscValue("is_foundation")), "true".equalsIgnoreCase(sku.getMiscValue("use_sasinstall")), "true".equalsIgnoreCase(sku.getMiscValue("use_srw")), "true".equalsIgnoreCase(sku.getMiscValue("use_jre")), sku.getInstallType("prompt") != null, volserData.getVolser(), volserData.getName("en"), this.getSequenceNumber(spsSkuData, volserData));
                    }
                }
                list.add(new ProductData(spsSkuData.getProdCode(), spsSkuData.getSpsSku(), installPlatform, this.getDisplayVer(spsSkuData), this.getCustomerVer(spsSkuData), spsSkuData.getMaintLevel(), spsSkuData.getLastPortDate(), spsSkuData.getSASRelease(), this.getDisplayName(spsSkuData), 1, this.getStatus(spsSkuData), this.getSelectableType(sku), "true".equalsIgnoreCase(sku.getMiscValue("is_config")), this.getInstallTypeCmd(orderData, spsSkuData, volserData, sku, "interactive"), this.getInstallTypeCmd(orderData, spsSkuData, volserData, sku, "silent"), this.getInstallTypeCmd(orderData, spsSkuData, volserData, sku, "index"), this.getInstallTypeArgs(orderData, spsSkuData, sku, "interactive"), this.getInstallTypeArgs(orderData, spsSkuData, sku, "silent"), "true".equalsIgnoreCase(sku.getMiscValue("is_foundation")), "true".equalsIgnoreCase(sku.getMiscValue("use_sasinstall")), "true".equalsIgnoreCase(sku.getMiscValue("use_srw")), "true".equalsIgnoreCase(sku.getMiscValue("use_jre")), sku.getInstallType("prompt") != null, volserData.getVolser(), volserData.getName("en"), this.getSequenceNumber(spsSkuData, volserData)));
            }
        }
        if (!addedSasInstall && fakeSasInstall != null) {
            returnList.add(new ProductData(fakeSasInstall));
        }
        for (String currentKey : productList.keySet()) {
            String[] tokens = currentKey.split(":", 2);
            if (tokens.length != 2) continue;
            code = tokens[0];
            installPlatform = tokens[1];
            if (!installPlatform.equals(platform) && productList.get(code + ":" + platform) != null) continue;
            returnList.addAll((Collection)productList.get(currentKey));
        }
        retval = returnList.toArray(new ProductData[0]);
        this._prodsForPlat.put(cacheKey, retval);
        return retval;
    }

    public ProductData[] getInstallableProducts(String order, boolean includeDataOnly) {
        Vector<ProductData> productList = new Vector<ProductData>();
        Vector<ProductData> maintenanceList = new Vector<ProductData>();
        OrderData orderData = this.orderList.get(order);
        String[] volsers = orderData.getVolsers();
        for (int i = 0; i < volsers.length; ++i) {
            VolserData volserData = this.mediaCodeList.get(volsers[i]);
            if (!orderData.getMediaType().equals(volserData.getType())) continue;
            String[] spsSkus = volserData.getSpsSkus();
            for (int j = 0; j < spsSkus.length; ++j) {
                SpsSkuData spsSkuData;
                if (!includeDataOnly && !volserData.isPayloadIncluded(spsSkus[j]) || (spsSkuData = this.spsSkuList.get(spsSkus[j])) == null) continue;
                Vector<ProductData> list = spsSkuData.isDeltaRelease() ? maintenanceList : productList;
                String prodCode = spsSkuData.getProdCode();
                boolean display = false;
                if (spsSkuData.isInstallable() && spsSkuData.isSelectable()) {
                    display = true;
                } else if (spsSkuData.isInstallable() && (prodCode.equalsIgnoreCase("contentldrm") || prodCode.equalsIgnoreCase("contentldrs")) && Globals.g_planAddList != null) {
                    for (int x = 0; !display && x < Globals.g_planAddList.length; ++x) {
                        if (!prodCode.equalsIgnoreCase(Globals.g_planAddList[x])) continue;
                        display = true;
                    }
                }
                if (!display) continue;
                list.add(new ProductData(spsSkuData.getProdCode(), spsSkuData.getSpsSku(), null, this.getDisplayVer(spsSkuData), this.getCustomerVer(spsSkuData), spsSkuData.getMaintLevel(), spsSkuData.getLastPortDate(), spsSkuData.getSASRelease(), this.getDisplayName(spsSkuData), 1, this.getStatus(spsSkuData), 1, false, null, null, null, null, null, false, false, false, true, false, volserData.getVolser(), volserData.getName("en"), 0L));
            }
        }
        Enumeration e = maintenanceList.elements();
        while (e.hasMoreElements()) {
            ProductData maintData = (ProductData)e.nextElement();
            Enumeration e2 = productList.elements();
            while (maintData != null && e2.hasMoreElements()) {
                ProductData prodData = (ProductData)e2.nextElement();
                if (maintData.getProdCode().equals(prodData.getProdCode()) && maintData.getProdVersion().equals(prodData.getProdVersion())) {
                    maintData = null;
                    continue;
                }
                if (e2.hasMoreElements()) continue;
                productList.add(maintData);
            }
        }
        return productList.toArray(new ProductData[0]);
    }

    private int getStatus(SpsSkuData spsSkuData) {
        int retVal = 0;
        String value = spsSkuData.getStatus();
        if ("prep".equals(value)) {
            retVal = 1;
        }
        return retVal;
    }

    private int getSelectableType(SkuData skuData) {
        int retVal = 1;
        String value = skuData.getMiscValue("selectable").toLowerCase(Locale.ENGLISH);
        if ("false".equals(value)) {
            retVal = 2;
        } else if ("standalone".equals(value)) {
            retVal = 3;
        }
        return retVal;
    }

    private String getInstallTypeCmd(OrderData orderData, SpsSkuData spsSkuData, VolserData volserData, SkuData skuData, String type) {
        String installCMD = this.getInstallTypeMiscValue(orderData, spsSkuData, skuData, type, "cmd");
        String retval = installCMD;
        if (retval != null && retval.length() > 0) {
            retval = retval.equals("install.xml") ? volserData.getDataPath(spsSkuData.getSpsSku()) + File.separator + installCMD : volserData.getProductPath(spsSkuData.getSpsSku()) + File.separator + installCMD;
        }
        return retval;
    }

    private String getInstallTypeArgs(OrderData orderData, SpsSkuData spsSkuData, SkuData skuData, String type) {
        return this.getInstallTypeMiscValue(orderData, spsSkuData, skuData, type, "args");
    }

    private String getInstallTypeMiscValue(OrderData orderData, SpsSkuData spsSkuData, SkuData skuData, String type, String value) {
        String retVal = "";
        SkuData.InstallTypeData typeData = skuData.getInstallType(type);
        if (typeData != null) {
            retVal = typeData.getMiscValue(value);
        }
        return retVal;
    }

    private String getDisplayName(SpsSkuData spsSkuData) {
        String name = spsSkuData.getDisplayName("en");
        if (name == null) {
            name = "UNKNOWN PRODUCT (" + spsSkuData.getProdCode() + ")";
        }
        if (this.getStatus(spsSkuData) == 1) {
            name = bundle.messageString("DeploymentData.PreProduction.txt", name);
        }
        return name;
    }

    private String getDisplayVer(SpsSkuData spsSkuData) {
        String version = spsSkuData.getDisplayVer("en");
        if (version == null) {
            version = "UNKNOWN VERSION";
        }
        return version;
    }

    private String getCustomerVer(SpsSkuData spsSkuData) {
        String version = spsSkuData.getCustomerVer("en");
        return version;
    }

    private long getSequenceNumber(SpsSkuData spsSku, VolserData volser) {
        long longVolserSequence;
        long longSpsSkuSequence;
        try {
            longSpsSkuSequence = Long.parseLong(spsSku.getSequenceNum().trim());
        }
        catch (NumberFormatException e) {
            Logging.log.info("WARNING: the sequence variable: \"" + spsSku.getSequenceNum() + "\" is not a long number.  There is incorrect sequence data in product.xml for atsku: " + spsSku.getSpsSku() + " Defaulting to 100000.");
            longSpsSkuSequence = 100000L;
        }
        longSpsSkuSequence *= 1000L;
        try {
            longVolserSequence = Long.parseLong(volser.getVolnum());
        }
        catch (NumberFormatException e) {
            longVolserSequence = 0L;
        }
        return longSpsSkuSequence + longVolserSequence;
    }

    public HashSet<String> getImmediateSkuRequirements(String platform, String sku, SkuFilterIface filter, String requirementType) {
        return this.getImmediateSkuReqDriver(platform, sku, filter, requirementType, 0);
    }

    public HashSet<String> getImmediateSkuRequiredBys(String platform, String sku, SkuFilterIface filter, String requirementType) {
        return this.getImmediateSkuReqDriver(platform, sku, filter, requirementType, 1);
    }

    private HashSet<String> getImmediateSkuReqDriver(String platform, String sku, SkuFilterIface filter, String requirementType, int whatToFind) {
        HashSet<String> immediateSkus = new HashSet<String>();
        if (filter == null) {
            filter = SkuRequirementsForOrder.getIncludeEverythingSkuFilter();
        }
        for (OrderData oneOrderData : this.orderList.getAll()) {
            SkuRequirementsForOrder skuReqsForOrder = oneOrderData.getSkuRequirements(requirementType);
            if (skuReqsForOrder == null) continue;
            HashSet<String> reqsWithinOneOrder = whatToFind == 1 ? skuReqsForOrder.getImmediateSkuRequiredBys(platform, sku, filter) : skuReqsForOrder.getImmediateSkuRequirements(platform, sku, filter);
            immediateSkus.addAll(reqsWithinOneOrder);
        }
        return immediateSkus;
    }

    public HashSet<String> getFullSkuRequirements(String platform, String sku, SkuFilterIface filter, String requirementType) {
        return this.getFullSkuReqDriver(platform, sku, filter, requirementType, 0);
    }

    public HashSet<String> getFullSkuRequiredBys(String platform, String sku, SkuFilterIface filter, String requirementType) {
        return this.getFullSkuReqDriver(platform, sku, filter, requirementType, 1);
    }

    private HashSet<String> getFullSkuReqDriver(String platform, String sku, SkuFilterIface filter, String requirementType, int whatToFind) {
        HashSet<String> seenSkus = new HashSet<String>();
        if (filter == null) {
            filter = SkuRequirementsForOrder.getIncludeEverythingSkuFilter();
        }
        seenSkus.add(sku);
        this.buildFullSkuRequirementSet(platform, sku, seenSkus, filter, requirementType, whatToFind);
        seenSkus.remove(sku);
        return seenSkus;
    }

    private void buildFullSkuRequirementSet(String platform, String sku, HashSet<String> seenSkus, SkuFilterIface filter, String requirementType, int whatToFind) {
        HashSet<String> immediateSkus = this.getImmediateSkuReqDriver(platform, sku, filter, requirementType, whatToFind);
        for (String nextSku : immediateSkus) {
            if (seenSkus.contains(nextSku)) continue;
            seenSkus.add(nextSku);
            this.buildFullSkuRequirementSet(platform, nextSku, seenSkus, filter, requirementType, whatToFind);
        }
    }

    public class SpsSkuList {
        private Hashtable spsSkuHash = new Hashtable();

        public boolean add(SpsSkuData data) {
            String spsSku;
            boolean added = false;
            if (data != null && (spsSku = data.getSpsSku()) != null && !this.spsSkuHash.containsKey(spsSku)) {
                this.spsSkuHash.put(spsSku, data);
                added = true;
            }
            return added;
        }

        public boolean remove(SpsSkuData data) {
            boolean removed = false;
            if (data != null) {
                removed = this.remove(data.getSpsSku());
            }
            return removed;
        }

        public boolean remove(String spsSku) {
            boolean removed = false;
            if (spsSku != null && this.spsSkuHash.containsKey(spsSku)) {
                this.spsSkuHash.remove(spsSku);
                removed = true;
            }
            return removed;
        }

        public int getCount() {
            return this.spsSkuHash.size();
        }

        public SpsSkuData get(String spsSku) throws NullPointerException {
            return (SpsSkuData)this.spsSkuHash.get(spsSku);
        }

        public SpsSkuData[] getAll() {
            SpsSkuData[] array = new SpsSkuData[this.getCount()];
            int index = 0;
            Enumeration e = this.spsSkuHash.elements();
            while (e.hasMoreElements()) {
                array[index++] = (SpsSkuData)e.nextElement();
            }
            return array;
        }
    }

    public class VolserList {
        private Hashtable volserHash = new Hashtable();

        public boolean add(VolserData data) {
            String volser;
            boolean added = false;
            if (data != null && (volser = data.getVolser()) != null && !this.volserHash.containsKey(volser)) {
                this.volserHash.put(volser, data);
                added = true;
            }
            return added;
        }

        public boolean remove(VolserData data) {
            boolean removed = false;
            if (data != null) {
                removed = this.remove(data.getVolser());
            }
            return removed;
        }

        public boolean remove(String volser) {
            boolean removed = false;
            if (volser != null && this.volserHash.containsKey(volser)) {
                this.volserHash.remove(volser);
                removed = true;
            }
            return removed;
        }

        public int getCount() {
            return this.volserHash.size();
        }

        public VolserData get(String volser) throws NullPointerException {
            return (VolserData)this.volserHash.get(volser);
        }

        public VolserData[] getAll() {
            VolserData[] array = new VolserData[this.getCount()];
            int index = 0;
            Enumeration e = this.volserHash.elements();
            while (e.hasMoreElements()) {
                array[index++] = (VolserData)e.nextElement();
            }
            return array;
        }
    }

    public class OrderList {
        private Hashtable orderHash = new Hashtable();

        public boolean add(OrderData data) {
            String order;
            boolean added = false;
            if (data != null && (order = data.getOrder()) != null && !this.orderHash.containsKey(order)) {
                this.orderHash.put(order, data);
                added = true;
            }
            return added;
        }

        public int getCount() {
            return this.orderHash.size();
        }

        public OrderData get(String order) throws NullPointerException {
            return (OrderData)this.orderHash.get(order);
        }

        public OrderData[] getAll() {
            OrderData[] array = new OrderData[this.getCount()];
            int index = 0;
            Enumeration e = this.orderHash.elements();
            while (e.hasMoreElements()) {
                array[index++] = (OrderData)e.nextElement();
            }
            return array;
        }
    }
}

