/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Logging;
import com.sas.util.SasPasswordString;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;

public class DatabaseAccess {
    public static boolean testConnection(String url, String user, String password) {
        boolean valid = false;
        Properties properties = new Properties();
        properties.put("user", user);
        String decodedPassword = null;
        try {
            decodedPassword = SasPasswordString.decode(password);
        }
        catch (Exception e) {
            decodedPassword = "";
            Logging.log.warning("Unable to decode the database password.");
            Logging.logStackTrace(e);
        }
        properties.put("password", decodedPassword);
        try {
            Connection cx = DriverManager.getConnection(url, properties);
            valid = true;
            Logging.log.fine("Successful connection to the database: \n   URL:  " + url + "\n   User: " + user);
        }
        catch (Exception e) {
            Logging.log.warning("Error testing connection to the database: " + e.getMessage() + "\n   URL:  " + url + "\n   User: " + user);
        }
        return valid;
    }
}

