/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.FileMode;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class CopyFile {
    private File sourceFile;

    public CopyFile(String sourceFile) {
        this.setSourceFile(sourceFile);
    }

    public CopyFile(File sourceFile) {
        this.setSourceFile(sourceFile);
    }

    public void setSourceFile(String sourceFile) {
        this.setSourceFile(new File(sourceFile));
    }

    public void setSourceFile(File sourceFile) {
        if (sourceFile == null) {
            throw new NullPointerException();
        }
        this.sourceFile = sourceFile;
    }

    public boolean copyTo(String targetFile, boolean overwrite) {
        return this.copyTo(new File(targetFile), overwrite);
    }

    public boolean copyTo(File targetFile, boolean overwrite) {
        boolean retVal = false;
        try {
            retVal = this.copyFile(this.sourceFile, targetFile, overwrite);
        }
        catch (FileNotFoundException e) {
            Logging.log.info(e.getMessage());
        }
        return retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean copyFile(File sourceFile, File targetFile, boolean overwrite) throws FileNotFoundException {
        boolean retVal = false;
        if (sourceFile.isFile()) {
            if (targetFile.isDirectory()) throw new FileNotFoundException("Unable to Find/Create Target File: " + targetFile.getAbsolutePath());
            if (!overwrite && targetFile.isFile()) {
                return true;
            }
            if (Utils.getOS() == 4) return this.copyFileStreams(sourceFile, targetFile);
            if (Utils.getOS() == 8) return this.copyFileStreams(sourceFile, targetFile);
            if (Globals.useCopyFileStreams) {
                return this.copyFileStreams(sourceFile, targetFile);
            }
            retVal = this.copyFileIO(sourceFile, targetFile);
            if (retVal) return retVal;
            Logging.log.info("Copy Failure with NIO... Retrying with Java File Streams.");
            return this.copyFileStreams(sourceFile, targetFile);
        }
        if (!sourceFile.isDirectory()) throw new FileNotFoundException("Source File Not Found: " + sourceFile.getAbsolutePath());
        if (!targetFile.isDirectory()) {
            if (!targetFile.mkdirs()) throw new FileNotFoundException("Unable to Find/Create Target Directory: " + targetFile.getAbsolutePath());
        }
        retVal = true;
        File[] fileList = sourceFile.listFiles();
        if (fileList == null) return retVal;
        int i = 0;
        while (retVal) {
            if (i >= fileList.length) return retVal;
            retVal = this.copyFile(fileList[i], new File(targetFile.getAbsolutePath() + File.separator + fileList[i].getName()), overwrite);
            ++i;
        }
        return retVal;
    }

    private boolean copyFileStreams(File sourceFile, File destFile) {
        boolean retVal = true;
        byte[] buffer = new byte[65536];
        int bytesRead = 0;
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            fin = new FileInputStream(sourceFile);
        }
        catch (FileNotFoundException e) {
            Logging.log.info(e.getMessage() + ": " + sourceFile);
            return false;
        }
        try {
            fout = new FileOutputStream(destFile);
        }
        catch (FileNotFoundException e) {
            Logging.log.info(e.getMessage() + ": " + destFile);
            try {
                fin.close();
            }
            catch (IOException e2) {
                Logging.log.info(e2.getMessage() + ": " + sourceFile);
            }
            return false;
        }
        try {
            while ((bytesRead = fin.read(buffer)) != -1) {
                fout.write(buffer, 0, bytesRead);
                Globals.g_bytesMoved += (long)bytesRead;
            }
        }
        catch (IOException e) {
            retVal = false;
            Logging.log.info(e.getMessage() + ": " + sourceFile + "->" + destFile);
        }
        try {
            fin.close();
        }
        catch (IOException e) {
            retVal = false;
            Logging.log.info(e.getMessage() + ": " + sourceFile);
        }
        try {
            fout.close();
        }
        catch (IOException e) {
            retVal = false;
            Logging.log.info(e.getMessage() + ": " + destFile);
        }
        if (retVal && !destFile.setLastModified(sourceFile.lastModified())) {
            retVal = false;
            Logging.log.info("Unable to Set Target File Timestamp: " + destFile.getAbsolutePath());
        }
        if (retVal) {
            try {
                FileMode source = new FileMode(sourceFile);
                FileMode target = new FileMode(destFile);
                target.setPerm(source.getPerm());
                if (target.commit() != 0) {
                    retVal = false;
                    Logging.log.info("Unable to Set Target File Permissions: " + destFile.getAbsolutePath());
                }
            }
            catch (FileNotFoundException e) {
                retVal = false;
                Logging.log.info(e.getMessage());
            }
        }
        return retVal;
    }

    private boolean copyFileIO(File sourceFile, File destFile) {
        boolean retVal = true;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel fcin = null;
        AbstractInterruptibleChannel fcout = null;
        if (retVal) {
            try {
                fis = new FileInputStream(sourceFile);
            }
            catch (FileNotFoundException e) {
                retVal = false;
                Logging.log.info(e.getMessage());
            }
        }
        if (retVal) {
            try {
                fos = new FileOutputStream(destFile);
            }
            catch (FileNotFoundException e) {
                retVal = false;
                Logging.log.info(e.getMessage());
            }
        }
        if (retVal) {
            boolean isVMS = false;
            if (Utils.getOS() == 6) {
                isVMS = true;
            }
            fcin = fis.getChannel();
            fcout = fos.getChannel();
            try {
                int BUFFER_SIZE = 0x100000;
                long sliceCount = sourceFile.length() / 0x100000L;
                long remainder = sourceFile.length() % 0x100000L;
                long bytesMoved = 0L;
                for (long i = 0L; i < sliceCount; ++i) {
                    if (isVMS) {
                        ((FileChannel)fcin).transferTo(bytesMoved, 0x100000L, (WritableByteChannel)((Object)fcout));
                    } else {
                        ((FileChannel)fcout).transferFrom((ReadableByteChannel)((Object)fcin), bytesMoved, 0x100000L);
                    }
                    bytesMoved += 0x100000L;
                    Globals.g_bytesMoved += 0x100000L;
                }
                if (remainder != 0L) {
                    if (isVMS) {
                        ((FileChannel)fcin).transferTo(bytesMoved, remainder, (WritableByteChannel)((Object)fcout));
                    } else {
                        ((FileChannel)fcout).transferFrom((ReadableByteChannel)((Object)fcin), bytesMoved, remainder);
                    }
                    bytesMoved += remainder;
                    Globals.g_bytesMoved += remainder;
                }
            }
            catch (IOException e) {
                retVal = false;
                Logging.log.info(e.getMessage());
            }
        }
        if (fcout != null) {
            try {
                fcout.close();
            }
            catch (IOException e) {
                retVal = false;
                Logging.log.info(e.getMessage());
            }
        }
        if (fcin != null) {
            try {
                fcin.close();
            }
            catch (IOException e) {
                retVal = false;
                Logging.log.info(e.getMessage());
            }
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException e) {
                retVal = false;
                Logging.log.info(e.getMessage());
            }
        }
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e) {
                retVal = false;
                Logging.log.info(e.getMessage());
            }
        }
        if (retVal && !destFile.setLastModified(sourceFile.lastModified())) {
            retVal = false;
            Logging.log.info("Unable to Set Target File Timestamp: " + destFile.getAbsolutePath());
        }
        if (retVal) {
            try {
                FileMode source = new FileMode(sourceFile);
                FileMode target = new FileMode(destFile);
                target.setPerm(source.getPerm());
                if (target.commit() != 0) {
                    retVal = false;
                    Logging.log.info("Unable to Set Target File Permissions: " + destFile.getAbsolutePath());
                }
            }
            catch (FileNotFoundException e) {
                retVal = false;
                Logging.log.info(e.getMessage());
            }
        }
        return retVal;
    }
}

