/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.HotFixInstructions;
import com.sas.ssn.Language;
import com.sas.ssn.Logging;
import com.sas.ssn.MetadataAccess;
import com.sas.ssn.Plan;
import com.sas.ssn.ProductData;
import com.sas.ssn.PropsParser;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SASLocale;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.ThirdParty;
import com.sas.ssn.Utils;
import com.sas.ssn.WizardPromptedIface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConfigureData {
    public static final String ANT_DEBUG_LEVEL = "ant.debug.level";
    public static final String BEA_HOME_DIR = "bea.home.dir";
    public static final String CFGWIZARD_CHANGEPASSPHRASE_TARGET_LIST = "cfgwizard.changePassPhrase.target.list";
    public static final String CFGWIZARD_APPLYMAINT_TARGET_LIST = "cfgwizard.applyMaint.target.list";
    public static final String CFGWIZARD_BUILDWEBAPPS_TARGET_LIST = "cfgwizard.buildWebapps.target.list";
    public static final String CFGWIZARD_DEPLOYWEBAPPS_TARGET_LIST = "cfgwizard.deployWebapps.target.list";
    public static final String CFGWIZARD_CHANGEHOST_TARGET_LIST = "cfgwizard.changeHost.target.list";
    public static final String CFGWIZARD_AUTOLOAD_TARGET_LIST = "cfgwizard.autoload.target.list";
    public static final String CFGWIZARD_INITIALCONFIG_TARGET_LIST = "cfgwizard.initialConfig.target.list";
    public static final String CFGWIZARD_MIGRATION_TARGET_LIST = "cfgwizard.migration.target.list";
    public static final String CFGWIZARD_UNCONFIGURE_ALL = "cfgwizard.unconfigure.all";
    public static final String CFGWIZARD_UNCONFIGURE_TARGET_LIST = "cfgwizard.unconfigure.target.list";
    public static final String CFGWIZARD_UPDATEPASSWORDS_TARGET_LIST = "cfgwizard.updatePasswords.target.list";
    public static final String CFGWIZARD_UPDATESID_TARGET_LIST = "cfgwizard.updatesid.target.list";
    public static final String CFGWIZARD_HOTFIXCONFIG_TARGET_LIST = "cfgwizard.hotFixConfigure.target.list";
    public static final String CFGWIZARD_HOTFIXCONFIG_INSTRUCTIONS_FILE = "cfgwizard.hotFixConfigure.instructions.file";
    public static final String CFGWIZARD_LOADCONTENT_TARGET_LIST = "cfgwizard.loadContent.target.list";
    public static final String CFGWIZARD_UPDATECONTENT_TARGET_LIST = "cfgwizard.updateContent.target.list";
    public static final String CFGWIZARD_ADJUSTURLS_TARGET_LIST = "cfgwizard.adjustURLs.target.list";
    public static final String CFGWIZARD_HADOOP_METADATA_TARGET_LIST = "cfgwizard.updateHadoopMetadata.target.list";
    public static final String CFGWIZARD_TLS_UPDATE_TARGET_LIST = "cfgwizard.updateTLS.target.list";
    public static final String CFGWIZARD_LASRSERVER_TYPE = "cfgwizard.lasrserver.type";
    public static final String CFGWIZARD_LASRMPP = "cfgwizard.lasrmpp";
    public static final String CFGWIZARD_LASRSMP = "cfgwizard.lasrsmp";
    public static final String CFGWIZARD_LASRNONE = "cfgwizard.lasrnone";
    public static final String CFGWIZARD_LASRSERVER_NAME = "cfgwizard.lasrserver.name";
    public static final String CFGWIZARD_LASRSERVER_HOST = "cfgwizard.lasrserver.host";
    public static final String CFGWIZARD_LASRSERVER_PORT = "cfgwizard.lasrserver.port";
    public static final String CFGWIZARD_LASRSERVER_SIGFILES_PATH = "cfgwizard.lasrserver.sigfiles.path";
    public static final String CFGWIZARD_LASRSERVER_TKGRID_PATH = "cfgwizard.lasrserver.path";
    public static final String CFGWIZARD_LINGUISTICS_BINARIES_PATH = "cfgwizard.teragram.location";
    public static final String CFGWIZARD_LASR_LIBRARY_NAME = "cfgwizard.lasr.library.name";
    public static final String CFGWIZARD_LASR_LIBRARY_LIBREF = "cfgwizard.lasr.library.libref";
    public static final String CFGWIZARD_LASRSERVER_CONTEXT = "cfgwizard.lasrserver.context";
    public static final String CFGWIZARD_AUTOLOAD_LOCATION = "cfgwizard.autoload.location";
    public static final String CFGWIZARD_HADOOPC_CFG_FILE = "hadoopc.config.prop.file";
    public static final String CONFIG_CURRPROD_12BYTE = "config.currprod.12byte";
    public static final String CONFIG_CURRPROD_LEGALNAME = "config.currprod.legalname";
    public static final String CONFIG_BACKUP_DIR_NAME = "config.backup.dir.name";
    public static final String CONFIG_DIR_NAME = "config.dir.name";
    public static final String CONFIG_HOME_DIR = "config.home.dir";
    public static final String CONFIG_LEVEL_NAME = "config.level.name";
    public static final String CONFIG_LEVEL_NUM = "config.level.num";
    public static final String CONFIG_LEV_CHANGEHOST_FILE = "config.lev.changehost.file";
    public static final String CONFIG_LEV_AUTOLOAD_FILE = "config.lev.autoload.file";
    public static final String CONFIG_LEV_DIR = "config.lev.dir";
    public static final String CONFIG_LEV_DOCUMENTS_DIR = "config.lev.documents.dir";
    public static final String CONFIG_LEV_ERRORLOG_FILE = "config.lev.errorlog.file";
    public static final String CONFIG_LEV_INSTRUCTIONS_FILE = "config.lev.instructions.file";
    public static final String CONFIG_LEV_INSTRUCTIONS_FILE_BACKUP = "config.lev.instructions.file.backup";
    public static final String CONFIG_ERRORLOG_FILE_NAME = "config.errorlog.file.name";
    public static final String CONFIG_INSTRUCTIONS_FILE_NAME = "config.instructions.file.name";
    public static final String CONFIG_LEV_LOGS_CONFIGURE_DIR = "config.lev.logs.configure.dir";
    public static final String CONFIG_LEV_MAINTCONFIGINSTRUCTIONS_FILE = "config.lev.maintconfiginstructions.file";
    public static final String CONFIG_LEV_UPDATEPASSWORDS_FILE = "config.lev.updatepasswords.file";
    public static final String CONFIG_LEV_UTILITIES_DIR = "config.lev.utilities.dir";
    public static final String CONFIG_MIGRATION_IS_SELECTED = "config.migration.is_selected";
    public static final String CONFIG_MIGRATION_PACKAGE_TIER_DIR = "config.migration.package.tier.dir";
    public static final String CONFIG_MIGRATION_SCHEMA_FILE = "config.migration.schema.file";
    public static final String CONFIG_MIGRATION_SMU_FILE = "config.migration.smu.file";
    public static final String CONFIG_MIGRATION_SAS_VERSION = "config.migration.sas.version";
    public static final String CONFIG_OBJECT_PROPERTIES_ARE_SET = "config.object.properties.are_set";
    public static final String CONFIG_ORDER_NUMBER = "config.order.number";
    public static final String CONFIG_SINGLELOGIN_IS_ENABLED = "config.singlelogin.is_enabled";
    public static final String CONFIG_SMU_VERSION = "config.smu.version";
    public static final String CONFIG_SUDO_SETUID_IS_ENABLED = "config.sudo.setuid.is_enabled";
    public static final String CONFIG_SUDO_SETUID_PASSWD = "config.sudo.setuid.passwd";
    public static final String CONFIG_TARGET_NAME = "config.target.name";
    public static final String CONFIG_UNCONFIGURE_FILE_NAME = "config.unconfigure.file.name";
    public static final String CONFIGURATION_CONFIGBUNDLE_FILE = "configuration.configbundle.file";
    public static final String CONFIGURE_TARGET_ENABLED = "configure.target.enabled";
    public static final String DATABASE_CONNECTION_USERID = "database.connection.userid";
    public static final String DATABASE_CONNECTION_PASSWD = "database.connection.passwd";
    public static final String DEPLOYMGR_APPLY_HOTFIX_PACKAGE_DIR = "deploymgr.applyhotfix.package.dir";
    public static final String DEPLOYMGR_CHANGEHOST_OLD_HOSTNAME = "deploymgr.changehost.old.host.name";
    public static final String DEPLOYMGR_CHANGEHOST_NEW_HOSTNAME = "deploymgr.changehost.new.host.name";
    public static final String GLOBAL_CERTFRAME_TLS_INT_STATE = "global.certframe.tls.int.state";
    public static final String INSTALL_CURRPROD_CONFIG_DIR = "install.currprod.config.dir";
    public static final String IOMSRV_METADATASRV_CONNECTION_IS_REQUIRED = "iomsrv.metadatasrv.connection.is_required";
    public static final String IOMSRV_METADATASRV_HOST = "iomsrv.metadatasrv.host";
    public static final String IOMSRV_METADATASRV_PORT = "iomsrv.metadatasrv.port";
    public static final String JAVA_JRE_COMMAND = "java.jre.command";
    public static final String LEVDIRROOT_CONFIGOBJ_FQID = "levdirroot.configobj.fqid";
    public static final String METADATA_CONNECTION_HOST = "metadata.connection.host";
    public static final String METADATA_CONNECTION_PORT = "metadata.connection.port";
    public static final String METADATA_CONNECTION_REPOSITORY = "metadata.connection.repository.name";
    public static final String METADATA_CONNECTION_USERID = "metadata.connection.userid";
    public static final String METADATA_CONNECTION_PASSWD = "metadata.connection.passwd";
    public static final String METADATA_REMOVED = "metadata.removed";
    public static final String METADATA_NEW_PASSPHRASE = "metadata.new.passphrase";
    public static final String OMA_PERSON_INSTALLER_LOGIN_PASSWD = "oma.person.installer.login.passwd";
    public static final String OMA_PERSON_INSTALLER_LOGIN_USERID = "oma.person.installer.login.userid";
    public static final String OMA_PERSON_ADMIN_LOGIN_PASSWD = "oma.person.admin.login.passwd";
    public static final String OMA_PERSON_ADMIN_LOGIN_USERID = "oma.person.admin.login.userid";
    public static final String OMA_PERSON_DEMO_LOGIN_PASSWD = "oma.person.demo.login.passwd";
    public static final String OMA_PERSON_GENSRVUSR_LOGIN_PASSWD = "oma.person.gensrvusr.login.passwd";
    public static final String OMA_REPOSITORY_FOUNDATION_NAME = "oma.repository.foundation.name";
    public static final String ORDER_LIST = "order.list";
    public static final String OS_EXEC_CMD = "os.exec.cmd";
    public static final String OS_EXEC_EXT = "os.exec.ext";
    public static final String OS_LINUX_VENDOR = "os.linux.vendor";
    public static final String OS_LINUX_VERSION = "os.linux.version";
    public static final String OS_LOCALHOST_ARCH = "os.localhost.arch";
    public static final String OS_LOCALHOST_DEFAULT_LOCALE = "os.localhost.default.locale";
    public static final String OS_LOCALHOST_FQDN_HOST_NAME = "os.localhost.fqdn.host.name";
    public static final String OS_LOCALHOST_HOST_NAME = "os.localhost.host.name";
    public static final String OS_LOCALHOST_IP_ADDRESS_FULL = "os.localhost.ip.address.full";
    public static final String OS_LOCALHOST_IP_ADDRESS_SECTION1 = "os.localhost.ip.address.section1";
    public static final String OS_LOCALHOST_IP_ADDRESS_SECTION2 = "os.localhost.ip.address.section2";
    public static final String OS_LOCALHOST_IP_ADDRESS_SECTION3 = "os.localhost.ip.address.section3";
    public static final String OS_LOCALHOST_IP_ADDRESS_SECTION4 = "os.localhost.ip.address.section4";
    public static final String OS_LOCALHOST_IP_DUAL_STACK = "os.localhost.ip.dual.stack";
    public static final String OS_LOCALHOST_IP_VERSION = "os.localhost.ip.version";
    public static final String OS_LOCALHOST_IP6_ADDRESS_FULL = "os.localhost.ip6.address.full";
    public static final String OS_LOCALHOST_IP6_ADDRESS_SECTION1 = "os.localhost.ip6.address.section1";
    public static final String OS_LOCALHOST_IP6_ADDRESS_SECTION2 = "os.localhost.ip6.address.section2";
    public static final String OS_LOCALHOST_IP6_ADDRESS_SECTION3 = "os.localhost.ip6.address.section3";
    public static final String OS_LOCALHOST_IP6_ADDRESS_SECTION4 = "os.localhost.ip6.address.section4";
    public static final String OS_LOCALHOST_IP6_ADDRESS_SECTION5 = "os.localhost.ip6.address.section5";
    public static final String OS_LOCALHOST_IP6_ADDRESS_SECTION6 = "os.localhost.ip6.address.section6";
    public static final String OS_LOCALHOST_IP6_ADDRESS_SECTION7 = "os.localhost.ip6.address.section7";
    public static final String OS_LOCALHOST_IP6_ADDRESS_SECTION8 = "os.localhost.ip6.address.section8";
    public static final String OS_LOCALHOST_MACHINE_TYPE = "os.localhost.machine.type";
    public static final String OS_LOCALHOST_LOGON_DOMAIN = "os.localhost.logon.domain";
    public static final String OS_LOCALHOST_SELECTED_LOCALE = "os.localhost.selected.locale";
    public static final String OS_LOCALHOST_TYPE = "os.localhost.type";
    public static final String OS_LOCALHOST_USERID = "os.localhost.userid";
    public static final String OS_LOCALHOST_USER_HOME_DIR = "os.localhost.user.home.dir";
    public static final String OS_LOCALHOST_VERSION = "os.localhost.version";
    public static final String OS_TEMP_DIR = "os.temp.dir";
    public static final String OS_TIMESTAMP = "os.timestamp";
    public static final String OS_UNX_SUDO_IS_NEEDED = "os.unx.sudo.is_needed";
    public static final String OS_WIN_PROGRAM_FILES_DIR = "os.win.program_files.dir";
    public static final String OS_WIN_SECURITY_DEMO_PROMPT = "os.win.security.demo.prompt";
    public static final String OS_WIN_SECURITY_GENSRVUSR_PROMPT = "os.win.security.gensrvusr.prompt";
    public static final String PLAN_ALL_CONFIG_LIST = "plan.all.config.list";
    public static final String PLAN_ALL_DEPLOY_LIST = "plan.all.deploy.list";
    public static final String PLAN_ALL_LIST = "plan.all.list";
    public static final String PLAN_CONFIG_NAME = "plan.config.name";
    public static final String PLAN_DIR = "plan.dir";
    public static final String PLAN_FILE = "plan.file";
    public static final String PLAN_MACHINE_CONFIG_LIST = "plan.machine.config.list";
    public static final String PLAN_MACHINE_DEPLOY_LIST = "plan.machine.deploy.list";
    public static final String PLAN_MACHINE_LIST = "plan.machine.list";
    public static final String PLAN_MACHINE_NAME_LIST = "plan.machine.name.list";
    public static final String PLAN_MACHINE_SELECTED_NAME = "plan.machine.selected.name";
    public static final String PLAN_SELECTED_CONFIG_LIST = "plan.selected.config.list";
    public static final String PLAN_SELECTED_DEPLOY_LIST = "plan.selected.deploy.list";
    public static final String PLAN_SELECTED_LIST = "plan.selected.list";
    public static final String SAS_HOME_DIR = "sas.home.dir";
    public static final String SAS_REGISTRY_DIR = "sas.registry.dir";
    public static final String SAS_SETINIT_FILE = "sas.setinit.file";
    public static final String SASHOME_LOCALE_NAME = "sashome.locale.name";
    public static final String SASHOME_ENCODING_NAME = "sashome.encoding.name";
    public static final String SASHOME_ENCODING_FOR_SEL_LOCALE = "sashome.encoding.for.selected.locale";
    public static final String SASHOME_ENCODING_JAVA_NAME = "sashome.encoding.java.name";
    public static final String SASHOME_ZOS_ENCODING_IBM_NAME = "sashome.zos.encoding.ibm.name";
    public static final String SASHOME_ZOS_ENCODING_TYPE = "sashome.zos.encoding.type";
    public static final String SASHOME_ZOS_ENCODING_TWO_BYTE = "sashome.zos.encoding2";
    public static final String SAS_CERTFRAME_PUBLIC_INT_PEM = "sas.certframe.cust.public.ca.certs.int.pem.fqfn";
    public static final String SAS_CERTFRAME_PUBLIC_INT_P12 = "sas.certframe.cust.public.ca.certs.int.p12.fqfn";
    public static final String SAS_CERTFRAME_SERVER_INT_P12 = "sas.certframe.cust.server.certs.int.p12.fqfn";
    public static final String SAS_CERTFRAME_SERVER_INT_PEM = "sas.certframe.cust.server.certs.int.pem.fqfn";
    public static final String SAS_CERTFRAME_SERVER_INT_PRIVATE = "sas.certframe.cust.server.private.key.int.fqfn";
    public static final String TEMP_DIR = "temp.dir";
    public static final String SETUP_LOCATION = "setup.location";
    public static final String UNCONFIGURE_REMOVE_USER_CONTENT = "unconfigure.remove.user.content";
    public static final String UNCONFIGURE_REMOVE_FS_USER_CONTENT = "unconfigure.remove.fs.user.content";
    public static final String VJR_INSTALL_DIR = "vjr.install.dir";
    public static final String WEBAPPSRV_12BYTE = "webappsrv.12byte";
    public static final String WEBAPPSRV_NAME = "webappsrv.name";
    public static final String WEBAPPSRV_SELECTED_REMOTE = "webappsrv.selected.remote";
    public static final String WEBAPPSRV_HORIZONTAL_CLUSTER = "webappsrv.horizontal_cluster";
    public static final String WIZARD_DEBUG_MODE = "wizard.debug.mode";
    public static final String WIZARD_MANAGER_TASK = "wizard.manager.task";
    public static final String WIZARD_TYPE = "wizard.type";
    public static final String ZOS_LOCALE = "zos.locale";
    public static final String ZOS_LOCALE2 = "zos.locale2";
    public static final String ZOS_SASINPUTS_ENCODING = "zos.sasinputs.encoding";
    public static final String ZOS_ENCODING2 = "zos.encoding2";
    public static final String MACHINE_INSTALLED_LIST = "machine.installed.list";
    public static final String MACHINE_CONFIGURED_LIST = "machine.configured.list";
    public static String REQUIRE_METADATASRV_CONNECTION_LIST = "require.metadatasrv.connection.list";
    public static final String CONSOLE_MODE_IS_ENABLED = "console.mode.is_enabled";
    public static final String QUIET_MODE_IS_ENABLED = "quiet.mode.is_enabled";
    public static final String OS_LOCALHOST_FROM_METADATA = "os.localhost.from.metadata";
    private static final String MAIN_JAR_NAME = "setup.jar";
    private static final String IP_VERSION_4 = "ipv4";
    private static final String IP_VERSION_6 = "ipv6";
    private boolean m_changed = false;
    private Properties m_configProps = new Properties();
    private File m_propsFile = new File(Globals.g_tempLocation, "configuration.properties");

    public boolean save() {
        boolean valid = false;
        try {
            FileOutputStream fos = new FileOutputStream(this.m_propsFile);
            this.m_configProps.store(fos, null);
            fos.close();
            valid = true;
        }
        catch (Exception e) {
            Logging.log.severe("Error saving configuration properties file: " + this.m_propsFile.toString());
            Logging.logStackTrace(e);
        }
        return valid;
    }

    public boolean saveWithoutTokens() {
        boolean valid = false;
        Properties notProps = new Properties();
        Properties props = new Properties();
        String key = null;
        String value = null;
        Enumeration<Object> e = this.m_configProps.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            value = this.m_configProps.getProperty(key, null);
            if (value == null) continue;
            if (value.startsWith("@") && value.endsWith("@")) {
                if (!Globals.g_debug) continue;
                notProps.setProperty(key, value);
                continue;
            }
            props.setProperty(key, value);
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.m_propsFile);
            props.store(fos, null);
            fos.close();
            valid = true;
        }
        catch (Exception e2) {
            Logging.log.severe("Error saving configuration properties file: " + this.m_propsFile.toString());
            Logging.logStackTrace(e2);
        }
        if (Globals.g_debug) {
            File notPropsFile = new File(this.m_propsFile.getParent(), "not_configuration.properties");
            try {
                FileOutputStream fos = new FileOutputStream(notPropsFile);
                notProps.store(fos, null);
                fos.close();
                valid = true;
            }
            catch (Exception e2) {
                Logging.log.warning("Error saving omitted configuration properties file: " + notPropsFile.toString());
                Logging.logStackTrace(e2);
            }
        }
        return valid;
    }

    public boolean saveWithoutPasswords(String filePath) {
        boolean valid = false;
        Properties props = new Properties();
        String key = null;
        String value = null;
        Enumeration<Object> e = this.m_configProps.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (Globals.g_configPasswords == null || Globals.g_configPasswords.containsKey(key) || (value = this.m_configProps.getProperty(key, null)) == null) continue;
            props.setProperty(key, value);
        }
        try {
            FileOutputStream fos = new FileOutputStream(new File(filePath));
            props.store(fos, null);
            fos.close();
            valid = true;
        }
        catch (Exception e2) {
            Logging.log.severe("Error saving configuration properties file: " + filePath);
            Logging.logStackTrace(e2);
        }
        return valid;
    }

    public boolean saveWithPasswordHashes(String filePath) {
        boolean valid = false;
        Properties props = new Properties();
        String key = null;
        String value = null;
        Enumeration<Object> e = this.m_configProps.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (Globals.g_configPasswords == null || Globals.g_configPasswords.containsKey(key) && !key.endsWith(".hash") || (value = this.m_configProps.getProperty(key, null)) == null) continue;
            props.setProperty(key, value);
        }
        try {
            FileOutputStream fos = new FileOutputStream(new File(filePath));
            props.store(fos, null);
            fos.close();
            valid = true;
        }
        catch (Exception e2) {
            Logging.log.severe("Error saving configuration properties file: " + filePath);
            Logging.logStackTrace(e2);
        }
        return valid;
    }

    public String saveProductList(String productCode, String productName, String antSrcDir, String filePath, boolean removePasswords) {
        String lcProdCode = productCode.toLowerCase(Locale.ENGLISH);
        String fullFilePath = null;
        fullFilePath = filePath != null ? filePath : Utils.joinPath(Globals.g_tempLocation, lcProdCode + ".configuration.properties");
        boolean webAppServer = Utils.isWebAppServerCode(lcProdCode);
        HashMap ownedProps = (HashMap)Globals.g_propertyOwners.get(lcProdCode);
        HashMap globalProps = (HashMap)Globals.g_propertyOwners.get("globalroot");
        HashMap levDirProps = (HashMap)Globals.g_propertyOwners.get("levdirroot");
        HashMap calcProps = (HashMap)Globals.g_propertyOwners.get("calculated");
        HashMap sdwProps = (HashMap)Globals.g_propertyOwners.get("sdwroot");
        HashMap webAppProps = null;
        if (webAppServer) {
            webAppProps = (HashMap)Globals.g_propertyOwners.get("webappsrv");
        }
        boolean include = false;
        Properties notProps = new Properties();
        Properties props = new Properties();
        String key = null;
        String lcKey = null;
        String value = null;
        Enumeration<Object> e = this.m_configProps.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            lcKey = key.toLowerCase(Locale.ENGLISH);
            boolean bl = include = ownedProps != null && ownedProps.containsKey(key) || globalProps != null && globalProps.containsKey(key) || levDirProps != null && levDirProps.containsKey(key) || calcProps != null && calcProps.containsKey(key) || sdwProps != null && sdwProps.containsKey(key) || lcKey.startsWith(lcProdCode + ".") || lcKey.startsWith("globalroot.") || lcKey.startsWith("levdirroot.") || lcKey.endsWith(".configobj.classid") || lcKey.endsWith(".configobj.type");
            if (!include && webAppServer) {
                boolean bl2 = include = webAppProps != null && webAppProps.containsKey(key) || lcKey.startsWith("webappsrv.");
            }
            if (include && removePasswords && Globals.g_configPasswords.containsKey(key)) {
                include = false;
            }
            if (!include || (value = this.m_configProps.getProperty(key, null)) == null) continue;
            if (value.startsWith("@") && value.endsWith("@")) {
                if (!Globals.g_debug) continue;
                notProps.setProperty(key, value);
                continue;
            }
            props.setProperty(key, value);
        }
        if (Globals.g_mode == 2) {
            props.setProperty(IOMSRV_METADATASRV_HOST, Globals.g_cmtConnectHost);
            props.setProperty(IOMSRV_METADATASRV_PORT, Globals.g_cmtConnectPort);
            props.setProperty(OMA_PERSON_ADMIN_LOGIN_USERID, Globals.g_cmtConnectUser);
            if (!removePasswords) {
                props.setProperty(OMA_PERSON_ADMIN_LOGIN_PASSWD, Globals.g_cmtConnectPassword);
            }
            props.setProperty(OMA_REPOSITORY_FOUNDATION_NAME, Globals.g_cmtConnectRepos);
            props.setProperty(METADATA_CONNECTION_HOST, Globals.g_cmtConnectHost);
            props.setProperty(METADATA_CONNECTION_PORT, Globals.g_cmtConnectPort);
            props.setProperty(METADATA_CONNECTION_USERID, Globals.g_cmtConnectUser);
            if (!removePasswords) {
                props.setProperty(METADATA_CONNECTION_PASSWD, Globals.g_cmtConnectPassword);
            }
            props.setProperty(METADATA_CONNECTION_REPOSITORY, Globals.g_cmtConnectRepos);
        } else {
            props.setProperty(METADATA_CONNECTION_USERID, this.getProperty(OMA_PERSON_ADMIN_LOGIN_USERID, ""));
            if (!removePasswords) {
                props.setProperty(METADATA_CONNECTION_PASSWD, this.getProperty(OMA_PERSON_ADMIN_LOGIN_PASSWD, ""));
            }
        }
        props.setProperty(CONFIG_CURRPROD_12BYTE, productCode);
        props.setProperty(CONFIG_CURRPROD_LEGALNAME, productName);
        props.setProperty(INSTALL_CURRPROD_CONFIG_DIR, antSrcDir);
        props.setProperty(TEMP_DIR, Globals.g_tempLocation);
        ProductData prodData = null;
        ProductData[] maintData = Globals.g_deploymentData.getMaintenance(Globals.g_order, productCode, Utils.getOS_Suffix(), true);
        prodData = maintData.length > 0 ? maintData[0] : Globals.g_deploymentData.getProduct(Globals.g_order, productCode, true);
        if (prodData != null) {
            props.setProperty(productCode + ".configobj.version", prodData.getProdCustVersion());
        }
        File propsFile = new File(fullFilePath);
        try {
            FileOutputStream fos = new FileOutputStream(propsFile);
            props.store(fos, null);
            fos.close();
        }
        catch (Exception e2) {
            fullFilePath = null;
            Logging.log.severe("Error saving configuration properties file: " + fullFilePath);
            Logging.logStackTrace(e2);
        }
        if (Globals.g_debug && !notProps.isEmpty()) {
            File notPropsFile = new File(propsFile.getParent(), "not_" + lcProdCode + ".configuration.properties");
            try {
                FileOutputStream fos = new FileOutputStream(notPropsFile);
                notProps.store(fos, null);
                fos.close();
            }
            catch (Exception e3) {
                Logging.log.warning("Error saving omitted configuration properties file: " + notPropsFile.toString());
                Logging.logStackTrace(e3);
            }
        }
        return fullFilePath;
    }

    public void clear() {
        this.m_configProps.clear();
    }

    public boolean delete() {
        boolean valid = false;
        try {
            valid = this.m_propsFile.exists() ? this.m_propsFile.delete() : true;
        }
        catch (Exception e) {
            Logging.log.warning("Error deleting configuration properties file: " + this.m_propsFile.toString());
            Logging.logStackTrace(e);
        }
        return valid;
    }

    public String getFilePath() {
        return this.m_propsFile.toString();
    }

    public void setProperty(String key, String value) {
        String oldValue = this.getProperty(key, null);
        if (oldValue == null || !oldValue.equals(value)) {
            this.m_changed = true;
        }
        this.m_configProps.setProperty(key, value);
    }

    public void removeProperty(String key) {
        this.m_configProps.remove(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.m_configProps.getProperty(key, defaultValue);
    }

    public Properties getProperties() {
        return this.m_configProps;
    }

    public boolean changed() {
        return this.m_changed;
    }

    public void resetChanged() {
        this.m_changed = false;
    }

    public String loadMachineConfiguredList() {
        String machineConfiguredList = this.getProperty(MACHINE_CONFIGURED_LIST, null);
        if (machineConfiguredList == null) {
            String host = Globals.g_cmtConnectHost != null ? Globals.g_cmtConnectHost : this.getProperty(METADATA_CONNECTION_HOST, this.getProperty(IOMSRV_METADATASRV_HOST, null));
            String port = Globals.g_cmtConnectPort != null ? Globals.g_cmtConnectPort : this.getProperty(METADATA_CONNECTION_PORT, this.getProperty(IOMSRV_METADATASRV_PORT, null));
            String user = Globals.g_cmtConnectUser != null ? Globals.g_cmtConnectUser : this.getProperty(METADATA_CONNECTION_USERID, this.getProperty(OMA_PERSON_ADMIN_LOGIN_USERID, null));
            String pwd = Globals.g_cmtConnectPassword != null ? Globals.g_cmtConnectPassword : this.getProperty(METADATA_CONNECTION_PASSWD, this.getProperty(OMA_PERSON_ADMIN_LOGIN_PASSWD, null));
            String repo = Globals.g_cmtConnectRepos != null ? Globals.g_cmtConnectRepos : this.getProperty(METADATA_CONNECTION_REPOSITORY, this.getProperty(OMA_REPOSITORY_FOUNDATION_NAME, null));
            File statusFile = new File(Utils.joinPath(Globals.g_cmtConfigDir, "ConfigData", "status.xml"));
            if (statusFile.isFile() && host != null && port != null && user != null && pwd != null && repo != null) {
                MetadataAccess.getInstanceData(host, port, repo, user, pwd, statusFile, true);
            }
            machineConfiguredList = this.getProperty(MACHINE_CONFIGURED_LIST, "");
        }
        return machineConfiguredList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateProperties() {
        if (Globals.g_mode == 2 || Globals.g_mode == 5) {
            this.setCalculatedProperty(WIZARD_TYPE, "sdm");
        } else {
            this.setCalculatedProperty(WIZARD_TYPE, "sdw");
        }
        if (Globals.g_debug) {
            this.setCalculatedProperty(WIZARD_DEBUG_MODE, "TRUE");
        } else {
            this.setCalculatedProperty(WIZARD_DEBUG_MODE, "FALSE");
        }
        this.setSDWProperty(SETUP_LOCATION, Globals.g_tempLocation);
        String sasHomeDir = null;
        sasHomeDir = Globals.g_cmtSASHome != null ? Globals.g_cmtSASHome : Globals.g_wizardData.getPreference("SASHome", "");
        if (Globals.g_install && Globals.g_configure) {
            if (Globals.g_promptedInstalls != null) {
                WizardPromptedIface promptedPanel = null;
                for (int i = 0; i < Globals.g_promptedInstalls.length; ++i) {
                    promptedPanel = (WizardPromptedIface)Globals.g_wizard.getPanel(Globals.g_promptedInstalls[i]);
                    this.setProperty(promptedPanel.getProductCode() + ".install.dir", promptedPanel.getLocation());
                }
            }
            if (Globals.g_jreHome != null) {
                this.setProperty("javaruntime.install.dir", Globals.g_jreHome);
                Logging.log.fine("javaruntime.install.dir" + Globals.g_jreHome);
            }
        } else if (!Globals.g_install && Globals.g_configure) {
            if (Globals.g_jreHome != null) {
                String java_jre_command_filename = Utils.buildJavaCommand(Globals.g_jreHome);
                this.setSDWProperty(JAVA_JRE_COMMAND, java_jre_command_filename);
                Logging.log.info("java.jre.command: " + java_jre_command_filename);
            }
        } else if (Globals.g_mode != 2 && Globals.g_mode != 5) {
            try (RegistryAccess registryAccess = null;){
                registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                if (registryAccess != null && registryAccess.open()) {
                    String prodCode = null;
                    String version = null;
                    String location = null;
                    ProductData[] products = Globals.g_deploymentData.getProdsForPlat(Globals.g_order, Utils.getOS_Suffix(), true);
                    for (int i = 0; i < products.length; ++i) {
                        prodCode = products[i].getProdCode();
                        if (!products[i].getPrompt() && !prodCode.equalsIgnoreCase("javaruntime")) continue;
                        version = products[i].getProdVersion();
                        if (prodCode.equalsIgnoreCase("sasinstall") && Globals.g_sasinstallPlat != null) {
                            location = registryAccess.getInstallLoc(prodCode, version, Globals.g_sasinstallPlat);
                            if (location == null) {
                                location = registryAccess.getInstallLoc(prodCode, "default", Globals.g_sasinstallPlat);
                            }
                        } else if (prodCode.equalsIgnoreCase("jmp") && Globals.g_jmpPlat != null) {
                            location = registryAccess.getInstallLoc(prodCode, version, Globals.g_jmpPlat);
                            if (location == null) {
                                location = registryAccess.getInstallLoc(prodCode, "default", Globals.g_jmpPlat);
                            }
                        } else if (prodCode.equalsIgnoreCase("pcfilesrv") && Globals.g_pcfilesrvPlat != null) {
                            location = registryAccess.getInstallLoc(prodCode, version, Globals.g_pcfilesrvPlat);
                            if (location == null) {
                                location = registryAccess.getInstallLoc(prodCode, "default", Globals.g_pcfilesrvPlat);
                            }
                        } else if (prodCode.equalsIgnoreCase("eguide") && Globals.g_eguidePlat != null) {
                            location = registryAccess.getInstallLoc(prodCode, version, Globals.g_eguidePlat);
                            if (location == null) {
                                location = registryAccess.getInstallLoc(prodCode, "default", Globals.g_eguidePlat);
                            }
                        } else if (prodCode.equalsIgnoreCase("msofficeint") && Globals.g_msofficeintPlat != null) {
                            location = registryAccess.getInstallLoc(prodCode, version, Globals.g_msofficeintPlat);
                            if (location == null) {
                                location = registryAccess.getInstallLoc(prodCode, "default", Globals.g_msofficeintPlat);
                            }
                        } else if (prodCode.equalsIgnoreCase("msoffintva") && Globals.g_msoffintvaPlat != null) {
                            location = registryAccess.getInstallLoc(prodCode, version, Globals.g_msoffintvaPlat);
                            if (location == null) {
                                location = registryAccess.getInstallLoc(prodCode, "default", Globals.g_msoffintvaPlat);
                            }
                        } else {
                            String beaHome;
                            if (products[i].getPrompt() || prodCode.equalsIgnoreCase("javaruntime")) {
                                location = registryAccess.getInstallLoc(prodCode, Globals.g_majorReleaseVersion);
                            } else {
                                location = registryAccess.getInstallLoc(prodCode, version);
                                if (location == null) {
                                    location = registryAccess.getInstallLoc(prodCode, "default");
                                }
                            }
                            if (prodCode.equalsIgnoreCase("weblogic") && (beaHome = ThirdParty.getBEAHomePath(location)) == null) {
                                location = ThirdParty.getWebLogicPath(location);
                            }
                        }
                        if (location == null || !new File(location).isDirectory()) continue;
                        this.setProperty(prodCode + ".install.dir", location);
                    }
                }
            }
        }
        this.setRemoteWebAppsProperty();
        if (Globals.g_logLevel == 0) {
            this.setCalculatedProperty(ANT_DEBUG_LEVEL, "info");
        } else if (Globals.g_logLevel == 1) {
            this.setCalculatedProperty(ANT_DEBUG_LEVEL, "verbose");
        } else if (Globals.g_logLevel == 2) {
            this.setCalculatedProperty(ANT_DEBUG_LEVEL, "debug");
        }
        this.setCalculatedProperty(CONFIG_ORDER_NUMBER, Globals.g_order);
        if (Utils.getOS() == 1) {
            this.setCalculatedProperty(OS_EXEC_CMD, "call");
            this.setCalculatedProperty(OS_EXEC_EXT, "bat");
        } else {
            this.setCalculatedProperty(OS_EXEC_CMD, "");
            this.setCalculatedProperty(OS_EXEC_EXT, "sh");
        }
        this.setCalculatedProperty(OS_UNX_SUDO_IS_NEEDED, "false");
        if (Utils.getOS() != 1 && Utils.getOS() != 8) {
            boolean updateMode = false;
            if (Globals.g_cmtTask == 5) {
                updateMode = true;
            }
            boolean sasInstalled = false;
            if (Globals.g_machine != null) {
                String[] components = Globals.g_machine.getDeployedComponentIds();
                for (int i = 0; i < components.length && !sasInstalled; ++i) {
                    if (!components[i].equalsIgnoreCase("sasinstall")) continue;
                    sasInstalled = true;
                }
            }
            if (sasInstalled || updateMode) {
                String[] checkSudoCmd = new String[]{"which", "sudo"};
                Utils.ProcessData processData = Utils.runProcess(checkSudoCmd, true);
                Logging.log.finer(processData.toString());
                if (processData.getExitValue() == 0) {
                    String sasInstallLoc = null;
                    ProductData sasProdData = null;
                    sasProdData = Globals.g_sasinstallPlat != null ? Globals.g_deploymentData.getProduct(Globals.g_order, "base", Globals.g_sasinstallPlat, true) : Globals.g_deploymentData.getProduct(Globals.g_order, "base", true);
                    RegistryAccess registryAccess = null;
                    if (!Globals.g_srwOnly) {
                        try {
                            if (Globals.g_cmtSASHome != null) {
                                File deployRegJar = new File(Utils.joinPath(Globals.g_cmtSASHome, "deploymntreg"), "sas.tools.deploymntreg.jar");
                                registryAccess = new RegistryAccess(deployRegJar.getAbsolutePath());
                            } else {
                                String deployRegLoc = RegistryData.getDeployRegJar();
                                if (deployRegLoc != null && new File(deployRegLoc).exists()) {
                                    registryAccess = new RegistryAccess(deployRegLoc);
                                } else {
                                    Logging.log.info("Could not access deployment registry. Proceeding with new installation.");
                                }
                            }
                        }
                        catch (Exception e) {
                            registryAccess = null;
                            Logging.logStackTrace(e);
                        }
                    }
                    if (sasProdData != null && registryAccess != null && registryAccess.open()) {
                        if (Globals.g_sasinstallPlat != null) {
                            sasInstallLoc = registryAccess.getInstallLoc("base", sasProdData.getProdVersion(), Globals.g_sasinstallPlat);
                            if (sasInstallLoc == null) {
                                sasInstallLoc = registryAccess.getInstallLoc("base", "default", Globals.g_sasinstallPlat);
                            }
                        } else {
                            sasInstallLoc = registryAccess.getInstallLoc("base", sasProdData.getProdVersion());
                            if (sasInstallLoc == null) {
                                sasInstallLoc = registryAccess.getInstallLoc("base", "default");
                            }
                        }
                        registryAccess.close();
                    }
                    if (sasInstallLoc != null) {
                        Logging.log.info("Checking SAS file permissions: " + sasInstallLoc);
                        File scriptFile = new File(Utils.joinPath(sasInstallLoc, "utilities", "bin"), "elsconf");
                        if (scriptFile.exists()) {
                            String[] command = new String[]{"/bin/sh", "-c", "./" + scriptFile.getName()};
                            try {
                                Process p = Runtime.getRuntime().exec(command, null, scriptFile.getParentFile());
                                p.waitFor();
                                int retVal = p.exitValue();
                                if (retVal != 0) {
                                    this.setCalculatedProperty(OS_UNX_SUDO_IS_NEEDED, "true");
                                }
                            }
                            catch (Exception e) {
                                Logging.logStackTrace(e);
                            }
                        }
                    } else if (!updateMode) {
                        this.setCalculatedProperty(OS_UNX_SUDO_IS_NEEDED, "true");
                    }
                }
            }
        }
        this.setCalculatedProperty(OS_LOCALHOST_ARCH, System.getProperty("os.arch"));
        this.setCalculatedProperty(OS_LOCALHOST_VERSION, System.getProperty("os.version"));
        this.setCalculatedProperty(OS_LOCALHOST_DEFAULT_LOCALE, Utils.localeTwoLangCode(Locale.getDefault()));
        this.setCalculatedProperty(OS_LOCALHOST_MACHINE_TYPE, Utils.getOS_Suffix());
        this.setCalculatedProperty(OS_LOCALHOST_LOGON_DOMAIN, Utils.getUserDomain());
        this.setCalculatedProperty(OS_LOCALHOST_SELECTED_LOCALE, Language.gs_SelectedLanguage);
        if (Globals.g_zos || Utils.getOS() == 8) {
            this.setCalculatedProperty(OS_LOCALHOST_TYPE, "zos");
        } else if (Utils.getOS() == 1) {
            this.setCalculatedProperty(OS_LOCALHOST_TYPE, "win");
        } else {
            this.setCalculatedProperty(OS_LOCALHOST_TYPE, "unx");
        }
        this.setCalculatedProperty(OS_LOCALHOST_USERID, System.getProperty("user.name"));
        this.setCalculatedProperty(OS_LOCALHOST_USER_HOME_DIR, System.getProperty("user.home"));
        this.setCalculatedProperty(OS_TEMP_DIR, Utils.trimTrailingSlashes(System.getProperty("java.io.tmpdir")));
        this.setCalculatedProperty(OS_TIMESTAMP, this.getCurrentDateTime());
        this.setCalculatedProperty(OS_WIN_PROGRAM_FILES_DIR, Utils.getProgramFilesDir());
        this.setCalculatedProperty(ORDER_LIST, this.getOrderList());
        if (Globals.g_plan != null) {
            this.setCalculatedProperty(PLAN_ALL_LIST, this.getPlanAll());
            this.setCalculatedProperty(PLAN_ALL_DEPLOY_LIST, this.getPlanDeploy());
            this.setCalculatedProperty(PLAN_ALL_CONFIG_LIST, this.getPlanConfig());
            this.setCalculatedProperty(PLAN_SELECTED_LIST, this.getSelectedAll());
            this.setCalculatedProperty(PLAN_SELECTED_DEPLOY_LIST, this.getSelectedDeploy());
            this.setCalculatedProperty(PLAN_SELECTED_CONFIG_LIST, this.getSelectedConfig());
            this.setCalculatedProperty(PLAN_CONFIG_NAME, Globals.g_plan.getName());
            this.setCalculatedProperty(PLAN_DIR, Globals.g_plan.getDirectory());
            this.setCalculatedProperty(PLAN_FILE, Globals.g_plan.getFile());
            this.setCalculatedProperty(PLAN_MACHINE_NAME_LIST, this.getPlanMachines());
            if (Globals.g_machine != null) {
                this.setCalculatedProperty(PLAN_MACHINE_LIST, this.getMachineAll());
                this.setCalculatedProperty(PLAN_MACHINE_DEPLOY_LIST, this.getMachineDeploy());
                this.setCalculatedProperty(PLAN_MACHINE_CONFIG_LIST, this.getMachineConfig());
                this.setCalculatedProperty(PLAN_MACHINE_SELECTED_NAME, Globals.g_machine.getName());
            }
        }
        this.setCalculatedProperty(SAS_HOME_DIR, sasHomeDir);
        this.setCalculatedProperty(SAS_REGISTRY_DIR, Utils.joinPath(sasHomeDir, "deploymntreg"));
        HotFixInstructions hfInstructions = new HotFixInstructions();
        String hfPath = hfInstructions.getHotFixInstructionsPath();
        this.setCalculatedProperty(CFGWIZARD_HOTFIXCONFIG_INSTRUCTIONS_FILE, hfPath);
        if (Utils.getOS() == 2) {
            File rhatFile = new File("/etc/redhat-release");
            File suseFile = new File("/etc/SuSE-release");
            String linuxVendor = "unknown";
            String linuxVersion = "unknown";
            if (rhatFile.exists()) {
                linuxVendor = "redhat";
                linuxVersion = Utils.getLinuxVersion(linuxVendor, rhatFile);
            } else if (suseFile.exists()) {
                linuxVendor = "SuSE";
                linuxVersion = Utils.getLinuxVersion(linuxVendor, suseFile);
            }
            this.setCalculatedProperty(OS_LINUX_VENDOR, linuxVendor);
            this.setCalculatedProperty(OS_LINUX_VERSION, linuxVersion);
        }
        this.setIPAddressProperties();
        this.setLocaleProperties();
        if (Globals.g_mode == 2) {
            this.setCalculatedProperty(MACHINE_INSTALLED_LIST, Globals.g_installData.loadMachineInstalledList());
        }
    }

    private void setRemoteWebAppsProperty() {
        block13: {
            if (Globals.g_install && Globals.g_configure) {
                if (Globals.g_showRemoteWebApps) {
                    if (Globals.g_remoteWebApps) {
                        Globals.g_configData.setSDWProperty(WEBAPPSRV_SELECTED_REMOTE, "true");
                    } else {
                        Globals.g_configData.setSDWProperty(WEBAPPSRV_SELECTED_REMOTE, "false");
                    }
                } else {
                    Globals.g_configData.removeProperty(WEBAPPSRV_SELECTED_REMOTE);
                }
            } else {
                String sasHome = null;
                sasHome = Globals.g_mode == 2 ? Globals.g_cmtSASHome : Globals.g_wizardData.getPreference("SASHome", "");
                File sasswFile = new File(sasHome, "sassw.config");
                if (sasswFile.isFile()) {
                    PropsParser sasswINIFile = new PropsParser(true);
                    try {
                        sasswINIFile.load(sasswFile, null);
                        String remoteValue = sasswINIFile.getINIValue("properties", "REMOTE_WEB_APPS", null);
                        if (remoteValue != null) {
                            if (remoteValue.equalsIgnoreCase("true")) {
                                Globals.g_configData.setSDWProperty(WEBAPPSRV_SELECTED_REMOTE, "true");
                            } else {
                                Globals.g_configData.setSDWProperty(WEBAPPSRV_SELECTED_REMOTE, "false");
                            }
                            break block13;
                        }
                        Globals.g_configData.removeProperty(WEBAPPSRV_SELECTED_REMOTE);
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                } else {
                    Globals.g_configData.removeProperty(WEBAPPSRV_SELECTED_REMOTE);
                }
            }
        }
    }

    public void setCalculatedProperty(String key, String value) {
        this.setProperty(key, value);
        Globals.g_configDefaults.setDefault(key, value);
        HashMap<String, Object> ownedProperties = (HashMap<String, Object>)Globals.g_propertyOwners.get("calculated");
        if (ownedProperties != null) {
            ownedProperties.put(key, null);
        } else {
            ownedProperties = new HashMap<String, Object>();
            ownedProperties.put(key, null);
            Globals.g_propertyOwners.put("calculated", ownedProperties);
        }
    }

    public void setSDWProperty(String key, String value) {
        this.setProperty(key, value);
        HashMap<String, Object> ownedProperties = (HashMap<String, Object>)Globals.g_propertyOwners.get("sdwroot");
        if (ownedProperties != null) {
            ownedProperties.put(key, null);
        } else {
            ownedProperties = new HashMap<String, Object>();
            ownedProperties.put(key, null);
            Globals.g_propertyOwners.put("sdwroot", ownedProperties);
        }
    }

    private void setIPAddressProperties() {
        StringTokenizer ipSections;
        boolean hasIPv4 = false;
        boolean hasIPv6 = false;
        String ip4Address = "";
        String ip6Address = "";
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            if (networkInterfaces != null) {
                while (networkInterfaces.hasMoreElements()) {
                    InetAddress address;
                    NetworkInterface networkInterface = networkInterfaces.nextElement();
                    Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                    while (addresses.hasMoreElements() && !(address = addresses.nextElement()).isLoopbackAddress()) {
                        if (address instanceof Inet6Address) {
                            hasIPv6 = true;
                            if (!"".equals(ip6Address)) continue;
                            ip6Address = address.getHostAddress();
                            Logging.log.finer("ConfigureData::setIPAddressProperties() Found IPv6 address=" + ip6Address);
                            int iPercent = ip6Address.indexOf(37);
                            if (iPercent == -1) continue;
                            ip6Address = ip6Address.substring(0, iPercent);
                            Logging.log.finer("ConfigureData::setIPAddressProperties() Trimmed %n suffix from IPv6 address=" + ip6Address);
                            continue;
                        }
                        if (!(address instanceof Inet4Address)) continue;
                        hasIPv4 = true;
                        if (!"".equals(ip4Address)) continue;
                        ip4Address = address.getHostAddress();
                    }
                }
            }
        }
        catch (Exception e) {
            Logging.log.warning("Unable to determine the IP Address for this computer.");
            Logging.logStackTrace(e);
        }
        if (!hasIPv4 && !hasIPv6) {
            Logging.log.warning("Unable to determine the IP characteristics for this computer.");
        }
        if (hasIPv4 && hasIPv6) {
            this.setCalculatedProperty(OS_LOCALHOST_IP_DUAL_STACK, "true");
            this.setCalculatedProperty(OS_LOCALHOST_IP_VERSION, IP_VERSION_4);
        } else {
            this.setCalculatedProperty(OS_LOCALHOST_IP_DUAL_STACK, "false");
            this.setCalculatedProperty(OS_LOCALHOST_IP_VERSION, hasIPv6 ? IP_VERSION_6 : IP_VERSION_4);
        }
        this.setCalculatedProperty(OS_LOCALHOST_IP_ADDRESS_FULL, hasIPv4 ? ip4Address : ip6Address);
        if (hasIPv4) {
            ipSections = new StringTokenizer(ip4Address, ".");
            if (ipSections.countTokens() == 4) {
                this.setCalculatedProperty(OS_LOCALHOST_IP_ADDRESS_SECTION1, ipSections.nextToken());
                this.setCalculatedProperty(OS_LOCALHOST_IP_ADDRESS_SECTION2, ipSections.nextToken());
                this.setCalculatedProperty(OS_LOCALHOST_IP_ADDRESS_SECTION3, ipSections.nextToken());
                this.setCalculatedProperty(OS_LOCALHOST_IP_ADDRESS_SECTION4, ipSections.nextToken());
            } else {
                Logging.log.warning("Invalid format of IPv4 Address for this computer: " + ip4Address);
            }
        }
        if (hasIPv6) {
            this.setCalculatedProperty(OS_LOCALHOST_IP6_ADDRESS_FULL, ip6Address);
            ipSections = new StringTokenizer(ip6Address, ":");
            if (ipSections.countTokens() == 8) {
                this.setCalculatedProperty(OS_LOCALHOST_IP6_ADDRESS_SECTION1, ipSections.nextToken());
                this.setCalculatedProperty(OS_LOCALHOST_IP6_ADDRESS_SECTION2, ipSections.nextToken());
                this.setCalculatedProperty(OS_LOCALHOST_IP6_ADDRESS_SECTION3, ipSections.nextToken());
                this.setCalculatedProperty(OS_LOCALHOST_IP6_ADDRESS_SECTION4, ipSections.nextToken());
                this.setCalculatedProperty(OS_LOCALHOST_IP6_ADDRESS_SECTION5, ipSections.nextToken());
                this.setCalculatedProperty(OS_LOCALHOST_IP6_ADDRESS_SECTION6, ipSections.nextToken());
                this.setCalculatedProperty(OS_LOCALHOST_IP6_ADDRESS_SECTION7, ipSections.nextToken());
                this.setCalculatedProperty(OS_LOCALHOST_IP6_ADDRESS_SECTION8, ipSections.nextToken());
            } else {
                Logging.log.warning("Invalid format of IPv6 Address for this computer: " + ip6Address);
            }
        }
    }

    public static HashMap<String, String> getLocaleProperties() {
        HashMap<String, String> locPropsWithNulls = new HashMap<String, String>();
        if (Globals.g_sasDefaultLocale == null) {
            Globals.g_sasDefaultLocale = SASLocale.getSASLocaleFromDeploymentReg();
        }
        if (Globals.g_sasDefaultLocale != null && Globals.g_sasDefaultLocale.getMVAPosixName() != null) {
            locPropsWithNulls.put(SASHOME_LOCALE_NAME, Globals.g_sasDefaultLocale.getMVAPosixName());
            locPropsWithNulls.put(SASHOME_ENCODING_NAME, Globals.g_sasDefaultLocale.getSASEncoding());
            locPropsWithNulls.put(SASHOME_ENCODING_JAVA_NAME, Globals.g_sasDefaultLocale.getJavaEncoding());
            locPropsWithNulls.put(SASHOME_ENCODING_FOR_SEL_LOCALE, Globals.g_sasDefaultLocale.getSASEncodingForSelectedLocale());
            if (Utils.getOS() == 8) {
                String encodingTwoByteUpcase = Globals.g_sasDefaultLocale.getEncodingTwoByte();
                if (encodingTwoByteUpcase != null) {
                    encodingTwoByteUpcase = encodingTwoByteUpcase.toUpperCase(Locale.ENGLISH);
                }
                locPropsWithNulls.put(SASHOME_ZOS_ENCODING_IBM_NAME, Globals.g_sasDefaultLocale.getIbmEncoding());
                locPropsWithNulls.put(SASHOME_ZOS_ENCODING_TYPE, Globals.g_sasDefaultLocale.getEncodingType());
                locPropsWithNulls.put(SASHOME_ZOS_ENCODING_TWO_BYTE, encodingTwoByteUpcase);
                locPropsWithNulls.put(ZOS_LOCALE, Globals.g_sasDefaultLocale.getMVAPosixName());
                locPropsWithNulls.put(ZOS_SASINPUTS_ENCODING, Globals.g_sasDefaultLocale.getIbmEncoding());
                locPropsWithNulls.put(ZOS_LOCALE2, Globals.g_sasDefaultLocale.getMVAPosixName().substring(0, 2).toUpperCase());
                locPropsWithNulls.put(ZOS_ENCODING2, encodingTwoByteUpcase);
            }
        }
        HashMap<String, String> localeProperties = new HashMap<String, String>();
        for (String key : locPropsWithNulls.keySet()) {
            String value = (String)locPropsWithNulls.get(key);
            if (key == null || value == null) continue;
            localeProperties.put(key, value);
        }
        return localeProperties;
    }

    private void setLocaleProperties() {
        HashMap<String, String> localeProperties = ConfigureData.getLocaleProperties();
        for (String key : localeProperties.keySet()) {
            this.setCalculatedProperty(key, localeProperties.get(key));
        }
    }

    private String getCurrentDateTime() {
        GregorianCalendar calendar = new GregorianCalendar();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-hh.mm", Locale.getDefault());
        return dateFormat.format(calendar.getTime());
    }

    public static String getDefaultHost() {
        String host = "";
        try {
            host = Utils.getFullLocalHostName();
            if (host == null || !host.contains(".")) {
                File mainJarFile = new File(Globals.g_setupLocation, MAIN_JAR_NAME);
                if (mainJarFile.isFile()) {
                    String[] cmd = new String[]{Utils.getOS() == 1 ? Utils.joinPath(System.getProperty("java.home"), "\\bin\\java.exe") : (Utils.getOS() == 6 ? "java" : Utils.joinPath(System.getProperty("java.home"), "/bin/java")), "-jar", mainJarFile.getAbsolutePath(), "-getfqdn"};
                    Process p = Runtime.getRuntime().exec(cmd);
                    BufferedReader errIn = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    String errOut = errIn.readLine();
                    while (errOut != null) {
                        errOut = errIn.readLine();
                    }
                    BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    String sysOut = in.readLine();
                    String hostName = null;
                    while (sysOut != null) {
                        hostName = sysOut;
                        sysOut = in.readLine();
                    }
                    p.waitFor();
                    if (p.exitValue() == 0 && hostName != null) {
                        host = hostName;
                    }
                } else {
                    Logging.log.warning("Could not find the following file to determine the fully qualified domain name for this computer: " + mainJarFile.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            Logging.log.warning("Unable to determine the fully qualified domain name for this computer.");
            Logging.logStackTrace(e);
        }
        return host;
    }

    public static String getHostName() {
        String hostName = "";
        try {
            InetAddress inetAddrLocalHost = InetAddress.getLocalHost();
            hostName = Utils.getShortHostName(inetAddrLocalHost);
            Logging.log.finer("ConfigureData::getHostName() Found hostName=" + hostName);
            int iPeriod = hostName.indexOf(46);
            String address = inetAddrLocalHost.getHostAddress();
            Logging.log.finer("ConfigureData::getHostName() Found address=" + address);
            if (iPeriod != -1 && !hostName.equals(address)) {
                hostName = hostName.substring(0, iPeriod);
                Logging.log.finer("ConfigureData::getHostName() Truncate domain to get hostName=" + hostName);
            }
        }
        catch (Exception e) {
            Logging.log.warning("Unable to determine the host name for this computer.");
            Logging.logStackTrace(e);
        }
        return hostName;
    }

    private String getSelectedAll() {
        int i;
        ArrayList<String> prodList = new ArrayList<String>();
        String prodCode = null;
        String property = "";
        this.addSelectedInstalls(prodList);
        if (Globals.g_planConfigs != null) {
            for (i = 0; i < Globals.g_planConfigs.length; ++i) {
                prodCode = Globals.g_planConfigs[i].toUpperCase(Locale.ENGLISH);
                if (prodList.contains(prodCode)) continue;
                prodList.add(prodCode);
            }
        }
        for (i = 0; i < prodList.size(); ++i) {
            if (i > 0) {
                property = property + " ";
            }
            property = property + prodList.get(i);
        }
        return property;
    }

    private String getSelectedDeploy() {
        ArrayList<String> prodList = new ArrayList<String>();
        String property = "";
        this.addSelectedInstalls(prodList);
        for (int i = 0; i < prodList.size(); ++i) {
            if (i > 0) {
                property = property + " ";
            }
            property = property + prodList.get(i);
        }
        return property;
    }

    private void addSelectedInstalls(ArrayList<String> prodList) {
        block5: {
            String prodCode;
            block6: {
                prodCode = null;
                if (Globals.g_fullInstalls != null) {
                    for (int i = 0; i < Globals.g_fullInstalls.length; ++i) {
                        prodCode = Globals.g_fullInstalls[i].getProdCode().toUpperCase(Locale.ENGLISH);
                        if (prodList.contains(prodCode)) continue;
                        prodList.add(prodCode);
                    }
                }
                if (Globals.g_deploymentData == null) break block5;
                if (Globals.g_fullMVAAltSkus == null) break block6;
                SpsSkuData spsSkuData = null;
                for (int i = 0; i < Globals.g_fullMVAAltSkus.length; ++i) {
                    spsSkuData = Globals.g_deploymentData.getSpsSku(Globals.g_fullMVAAltSkus[i]);
                    if (spsSkuData == null || prodList.contains(prodCode = spsSkuData.getProdCode().toUpperCase(Locale.ENGLISH))) continue;
                    prodList.add(prodCode);
                }
                break block5;
            }
            if (!prodList.contains("sasinstall".toUpperCase(Locale.ENGLISH)) || Globals.g_order == null) break block5;
            String basePlatform = null;
            basePlatform = Globals.g_sasinstallPlat == null ? Utils.getOS_Suffix() : Globals.g_sasinstallPlat;
            String[] mvaAltSkus = Globals.g_deploymentData.getOrder(Globals.g_order).getMVAAltSkus(basePlatform);
            if (mvaAltSkus != null) {
                SpsSkuData spsSkuData = null;
                for (int i = 0; i < mvaAltSkus.length; ++i) {
                    spsSkuData = Globals.g_deploymentData.getSpsSku(mvaAltSkus[i]);
                    if (spsSkuData == null || prodList.contains(prodCode = spsSkuData.getProdCode().toUpperCase(Locale.ENGLISH))) continue;
                    prodList.add(prodCode);
                }
            }
        }
    }

    private String getSelectedConfig() {
        int i;
        ArrayList<String> prodList = new ArrayList<String>();
        String prodCode = null;
        String property = "";
        if (Globals.g_planConfigs != null) {
            for (i = 0; i < Globals.g_planConfigs.length; ++i) {
                prodCode = Globals.g_planConfigs[i].toUpperCase(Locale.ENGLISH);
                if (prodList.contains(prodCode)) continue;
                prodList.add(prodCode);
            }
        }
        for (i = 0; i < prodList.size(); ++i) {
            if (i > 0) {
                property = property + " ";
            }
            property = property + (String)prodList.get(i);
        }
        return property;
    }

    private String getMachineAll() {
        int i;
        String[] components = Globals.g_machine.getDeployedComponentIds();
        ArrayList<String> prodList = new ArrayList<String>();
        String prodCode = null;
        String property = "";
        for (i = 0; i < components.length; ++i) {
            prodCode = components[i].toUpperCase(Locale.ENGLISH);
            if (prodList.contains(prodCode)) continue;
            prodList.add(prodCode);
        }
        components = Globals.g_machine.getConfiguredComponentIds();
        for (i = 0; i < components.length; ++i) {
            prodCode = components[i].toUpperCase(Locale.ENGLISH);
            if (prodList.contains(prodCode)) continue;
            prodList.add(prodCode);
        }
        for (i = 0; i < prodList.size(); ++i) {
            if (i > 0) {
                property = property + " ";
            }
            property = property + (String)prodList.get(i);
        }
        return property;
    }

    private String getMachineDeploy() {
        int i;
        String[] components = Globals.g_machine.getDeployedComponentIds();
        ArrayList<String> prodList = new ArrayList<String>();
        String prodCode = null;
        String property = "";
        for (i = 0; i < components.length; ++i) {
            prodCode = components[i].toUpperCase(Locale.ENGLISH);
            if (prodList.contains(prodCode)) continue;
            prodList.add(prodCode);
        }
        for (i = 0; i < prodList.size(); ++i) {
            if (i > 0) {
                property = property + " ";
            }
            property = property + (String)prodList.get(i);
        }
        return property;
    }

    private String getMachineConfig() {
        int i;
        String[] components = Globals.g_machine.getConfiguredComponentIds();
        ArrayList<String> prodList = new ArrayList<String>();
        String prodCode = null;
        String property = "";
        for (i = 0; i < components.length; ++i) {
            prodCode = components[i].toUpperCase(Locale.ENGLISH);
            if (prodList.contains(prodCode)) continue;
            prodList.add(prodCode);
        }
        for (i = 0; i < prodList.size(); ++i) {
            if (i > 0) {
                property = property + " ";
            }
            property = property + (String)prodList.get(i);
        }
        return property;
    }

    private String getPlanAll() {
        int i;
        Plan.Machine[] machines = Globals.g_plan.getMachines();
        String[] components = null;
        ArrayList<String> prodList = new ArrayList<String>();
        String prodCode = null;
        String property = "";
        for (i = 0; i < machines.length; ++i) {
            int j;
            components = machines[i].getDeployedComponentIds();
            for (j = 0; j < components.length; ++j) {
                prodCode = components[j].toUpperCase(Locale.ENGLISH);
                if (prodList.contains(prodCode)) continue;
                prodList.add(prodCode);
            }
            components = machines[i].getConfiguredComponentIds();
            for (j = 0; j < components.length; ++j) {
                prodCode = components[j].toUpperCase(Locale.ENGLISH);
                if (prodList.contains(prodCode)) continue;
                prodList.add(prodCode);
            }
        }
        for (i = 0; i < prodList.size(); ++i) {
            if (i > 0) {
                property = property + " ";
            }
            property = property + (String)prodList.get(i);
        }
        return property;
    }

    private String getPlanDeploy() {
        int i;
        Plan.Machine[] machines = Globals.g_plan.getMachines();
        String[] components = null;
        ArrayList<String> prodList = new ArrayList<String>();
        String prodCode = null;
        String property = "";
        for (i = 0; i < machines.length; ++i) {
            components = machines[i].getDeployedComponentIds();
            for (int j = 0; j < components.length; ++j) {
                prodCode = components[j].toUpperCase(Locale.ENGLISH);
                if (prodList.contains(prodCode)) continue;
                prodList.add(prodCode);
            }
        }
        for (i = 0; i < prodList.size(); ++i) {
            if (i > 0) {
                property = property + " ";
            }
            property = property + (String)prodList.get(i);
        }
        return property;
    }

    private String getPlanConfig() {
        int i;
        Plan.Machine[] machines = Globals.g_plan.getMachines();
        String[] components = null;
        ArrayList<String> prodList = new ArrayList<String>();
        String prodCode = null;
        String property = "";
        for (i = 0; i < machines.length; ++i) {
            components = machines[i].getConfiguredComponentIds();
            for (int j = 0; j < components.length; ++j) {
                prodCode = components[j].toUpperCase(Locale.ENGLISH);
                if (prodList.contains(prodCode)) continue;
                prodList.add(prodCode);
            }
        }
        for (i = 0; i < prodList.size(); ++i) {
            if (i > 0) {
                property = property + " ";
            }
            property = property + (String)prodList.get(i);
        }
        return property;
    }

    private String getPlanMachines() {
        Plan.Machine[] machines = Globals.g_plan.getMachines();
        String property = "";
        for (int i = 0; i < machines.length; ++i) {
            if (i > 0) {
                property = property + " ";
            }
            property = property + machines[i].getName();
        }
        return property;
    }

    private String getOrderList() {
        String property = "";
        if (Globals.g_deploymentData != null && Globals.g_order != null) {
            ProductData[] allProducts = Globals.g_deploymentData.getAllProducts(Globals.g_order, true);
            for (int i = 0; i < allProducts.length; ++i) {
                if (i > 0) {
                    property = property + " ";
                }
                property = property + allProducts[i].getProdCode().toUpperCase(Locale.ENGLISH);
            }
        }
        return property;
    }

    public void loadProperties(Properties props) {
        this.m_configProps.putAll((Map<?, ?>)props);
    }
}

