/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.KitAction;
import com.sas.ssn.Language;
import com.sas.ssn.Logging;
import com.sas.ssn.PickList;
import com.sas.ssn.ProductData;
import com.sas.ssn.PropertyRules;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.Utils;
import com.sas.ssn.utils.ProductDirUtils;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class Configure {
    public static final String GROOVY_JAR_NAME = "groovy-all.jar";
    public static final String GROOVY_JAR_NAME_V3_plus = "groovy.jar";
    private static PickList cfgWizardPickList = null;
    private static String cfgwizardUtilsDir = null;
    private static String cfgwizardContribDir = null;
    private static String cfgwizardGateDir = null;
    private static String tempGroovyFilePath = null;
    private static String sasHomeGroovyFilePath = null;
    private static String sasHomeWebAppConfigJarPath = null;
    private static boolean hasSetSDWDefaultGroovyProp = false;

    public static String getDefaultGroovyFilePath() {
        String ret = Configure.getSasHomeGroovyFilePath();
        File file = new File(ret);
        if (!file.exists()) {
            ret = Configure.getTempGroovyFilePath();
        }
        Logging.log.finer("CONFIGURE: getDefaultGroovyFilePath returning=" + ret);
        return ret;
    }

    public static String getTempGroovyFilePath() {
        if (tempGroovyFilePath == null) {
            tempGroovyFilePath = new File(Utils.joinPath(Globals.g_setupLocation, "groovy")).getAbsolutePath();
        }
        return tempGroovyFilePath;
    }

    private static String getSasHomeDeploywizProductDir() {
        String deploywizProductDir = "";
        deploywizProductDir = Globals.g_mode == 2 ? new File(Utils.getSDMHome(Globals.g_cmtSASHome) + File.separator + "products" + File.separator + Globals.g_deploymentData.getNewestSpsSku("deploywiz", null, false).getSpsSku() + File.separator + "deploywiz").getAbsolutePath() : new File(Utils.getSDMHome(Globals.g_wizardData.getPreference("SASHome", "")), Globals.g_deploymentData.getProductDir(Globals.g_order, "deploywiz", true, false) + File.separator + "deploywiz").getAbsolutePath();
        return deploywizProductDir;
    }

    private static String getSasHomeGroovyFilePath() {
        if (sasHomeGroovyFilePath == null) {
            sasHomeGroovyFilePath = new File(Configure.getSasHomeDeploywizProductDir() + File.separator + "groovy").getAbsolutePath();
        }
        return sasHomeGroovyFilePath;
    }

    private static String getSasHomeWebAppConfigJarLocation() {
        if (sasHomeWebAppConfigJarPath == null) {
            sasHomeWebAppConfigJarPath = new File(Configure.getSasHomeDeploywizProductDir() + File.separator + "sas.tools.webappconfig.jar").getAbsolutePath();
        }
        return sasHomeWebAppConfigJarPath;
    }

    private static String getCfgWizardUtilsDir() {
        if (cfgwizardUtilsDir == null) {
            cfgwizardUtilsDir = Globals.g_mode == 2 ? new File(Utils.getSDMHome(Globals.g_cmtSASHome) + File.separator + "products" + File.separator + Globals.g_deploymentData.getNewestSpsSku("cfgwizard", null, false).getSpsSku(), "Utilities").getAbsolutePath() : new File(Utils.getSDMHome(Globals.g_wizardData.getPreference("SASHome", "")), Globals.g_deploymentData.getProductDir(Globals.g_order, "cfgwizard", true, false) + "/Utilities").getAbsolutePath();
        }
        return cfgwizardUtilsDir;
    }

    private static String getCfgWizardContribDir() {
        if (cfgwizardContribDir == null) {
            cfgwizardContribDir = Utils.joinPath(Configure.getCfgWizardUtilsDir(), "contrib");
        }
        return cfgwizardContribDir;
    }

    private static String getCfgWizardGateDir() {
        if (cfgwizardGateDir == null) {
            cfgwizardGateDir = Utils.joinPath(Configure.getCfgWizardContribDir(), "gate");
        }
        return cfgwizardGateDir;
    }

    private static String convertPathToWildcards(String path) {
        String pathWildcards = new String();
        StringTokenizer tokens = new StringTokenizer(path, System.getProperty("path.separator"));
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String aPath = tokens.nextToken();
            if (pathWildcards.length() > 0) {
                pathWildcards = pathWildcards + System.getProperty("path.separator");
            }
            pathWildcards = aPath.endsWith(".jar") ? pathWildcards + aPath : (aPath.endsWith(System.getProperty("file.separator")) ? pathWildcards + aPath + "*" : pathWildcards + aPath + System.getProperty("file.separator") + "*");
            ++i;
        }
        Configure.removeDuplicates(pathWildcards);
        return pathWildcards;
    }

    private static String[] splitPathToDirsAndFiles(String path) {
        String pathDirs = new String();
        String pathFiles = new String();
        StringTokenizer tokens = new StringTokenizer(path, System.getProperty("path.separator"));
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String aPath = tokens.nextToken();
            if (aPath.endsWith(".jar")) {
                if (pathFiles.length() > 0) {
                    pathFiles = pathFiles + System.getProperty("path.separator");
                }
                pathFiles = pathFiles + aPath;
            } else {
                if (pathDirs.length() > 0) {
                    pathDirs = pathDirs + System.getProperty("path.separator");
                }
                pathDirs = pathDirs + aPath;
            }
            ++i;
        }
        return new String[]{pathDirs, pathFiles};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProcessBuilder getProcessBuilder(ArrayList<String> cmdArray) {
        ProcessBuilder processBuilder = null;
        ArrayList<String> trimmedCmdArray = new ArrayList<String>();
        for (String cmd : cmdArray) {
            String cmd2 = cmd.replace("\"", "").trim();
            trimmedCmdArray.add(cmd2);
        }
        if (Globals.g_install && Globals.g_fullInstalls != null && Utils.getOS() == 1) {
            String prodVer = null;
            boolean securestrongInstalled = false;
            for (int i = 0; i < Globals.g_fullInstalls.length && !securestrongInstalled; ++i) {
                if (!Globals.g_fullInstalls[i].getProdCode().equalsIgnoreCase("securestrong")) continue;
                securestrongInstalled = true;
                prodVer = Globals.g_fullInstalls[i].getProdVersion();
            }
            if (securestrongInstalled) {
                String path32bit = null;
                String path64bit = null;
                try (RegistryAccess registryAccess = null;){
                    registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                    if (registryAccess != null && registryAccess.open()) {
                        path32bit = registryAccess.getInstallLoc("securestrong", prodVer, "win");
                        if (path32bit == null) {
                            path32bit = registryAccess.getInstallLoc("securestrong", "default", "win");
                        }
                        if (Utils.getOS_Suffix() == "wx6" && (path64bit = registryAccess.getInstallLoc("securestrong", prodVer, "wx6")) == null) {
                            path64bit = registryAccess.getInstallLoc("securestrong", "default", "wx6");
                        }
                    }
                }
                if (path32bit != null || path64bit != null) {
                    int i;
                    processBuilder = new ProcessBuilder(trimmedCmdArray.toArray(new String[0]));
                    Map<String, String> env = processBuilder.environment();
                    String envVarNameForPath = "Path";
                    String envVarValForPath = "";
                    Set<Map.Entry<String, String>> envVariables = System.getenv().entrySet();
                    for (Map.Entry<String, String> variable : envVariables) {
                        if (!variable.getKey().equalsIgnoreCase("Path")) continue;
                        envVarNameForPath = variable.getKey();
                        envVarValForPath = variable.getValue();
                        break;
                    }
                    String newPathEnv = envVarValForPath;
                    String[] paths = envVarValForPath.split(File.pathSeparator);
                    boolean found64bitInPath = false;
                    boolean found32bitInPath = false;
                    if (path64bit != null) {
                        for (i = 0; i < paths.length; ++i) {
                            if (!paths[i].equalsIgnoreCase(path64bit)) continue;
                            found64bitInPath = true;
                        }
                        if (!found64bitInPath) {
                            newPathEnv = newPathEnv + File.pathSeparator + path64bit;
                        }
                    }
                    if (path32bit != null) {
                        found32bitInPath = false;
                        for (i = 0; i < paths.length; ++i) {
                            if (!paths[i].equalsIgnoreCase(path32bit)) continue;
                            found32bitInPath = true;
                        }
                        if (!found32bitInPath) {
                            newPathEnv = newPathEnv + File.pathSeparator + path32bit;
                        }
                    }
                    if (Utils.getOS_Suffix() == "wx6" && !found64bitInPath || !found32bitInPath) {
                        processBuilder.directory(new File(Globals.g_setupLocation));
                        env.put(envVarNameForPath, newPathEnv);
                        Logging.log.info("New Path: " + newPathEnv);
                        List<String> cmdList = processBuilder.command();
                        String logText = null;
                        Iterator<String> it = cmdList.iterator();
                        while (it.hasNext()) {
                            if (logText == null) {
                                logText = "      " + it.next();
                                continue;
                            }
                            logText = logText + Globals.g_eol + "      " + it.next();
                        }
                        if (logText != null) {
                            Logging.log.info("CONFIGURE: Launching Ant script with ProcessBuilder:" + Globals.g_eol + logText);
                        }
                    } else {
                        processBuilder = null;
                    }
                }
            }
        }
        return processBuilder;
    }

    private static String getJavaCommand() {
        String javaCmd = null;
        javaCmd = Globals.g_scriptJREHome != null ? new File(Utils.buildJavaCommand(Globals.g_scriptJREHome)).getAbsolutePath() : new File(Utils.getJavaCommand()).getAbsolutePath();
        return javaCmd;
    }

    private static String getConfigDataProperty(String property, String defaultValue) {
        return Globals.g_configData.getProperty(property, defaultValue);
    }

    private static String getConfigDefaultProperty(String property, String defaultValue) {
        return Globals.g_configDefaults.getDefault(property, defaultValue);
    }

    private static PickList getCfgWizardPickList() {
        if (cfgWizardPickList == null) {
            File cfgWizardPickListFile = null;
            String cfgProdDataDir = ProductDirUtils.getCfgWizardMaintenanceDir();
            if (cfgProdDataDir != null) {
                cfgWizardPickListFile = new File(Utils.joinPath(cfgProdDataDir, "picklist"));
            }
            if (!(cfgWizardPickListFile != null && cfgWizardPickListFile.exists() || (cfgProdDataDir = ProductDirUtils.getCfgWizardProductDataDir()) == null)) {
                cfgWizardPickListFile = new File(Utils.joinPath(cfgProdDataDir, "picklist"));
            }
            if (cfgWizardPickListFile == null || !cfgWizardPickListFile.exists()) {
                Logging.log.severe("Configure::getCfgWizardPickList() Could not find picklist for cfgwizard!");
            } else {
                cfgWizardPickList = new PickList(cfgWizardPickListFile);
                cfgWizardPickList.removeItem(GROOVY_JAR_NAME);
                cfgWizardPickList.removeItem(GROOVY_JAR_NAME_V3_plus);
                Logging.log.finer("Configure::getCfgWizardPickList() Found picklist for cfgwizard here: " + cfgWizardPickListFile.getAbsolutePath());
            }
        }
        return cfgWizardPickList;
    }

    public static void appendPickListLibProperty(String propertyFile, String prodCode, String picklistLibPath) {
        File file = new File(propertyFile);
        String propertyName = "config." + prodCode + ".picklist.lib";
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(propertyFile));
            props.setProperty(propertyName, picklistLibPath);
            props.store(new FileOutputStream(propertyFile), null);
        }
        catch (IOException ioe) {
            Logging.log.severe("Failed to append the property " + propertyName + " to properties file " + propertyFile);
        }
    }

    public static void appendClassPathProperties(String propertyFile, String pathWildcards, String pathDirs, String pathFiles) {
        File file = new File(propertyFile);
        String propertyNameWildcards = "java.class.path.wildcards";
        String propertyNameDirs = "java.class.path.dirs";
        String propertyNameFiles = "java.class.path.files";
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(propertyFile));
            props.setProperty(propertyNameWildcards, pathWildcards);
            props.setProperty(propertyNameDirs, pathDirs);
            props.setProperty(propertyNameFiles, pathFiles);
            props.store(new FileOutputStream(propertyFile), null);
        }
        catch (IOException ioe) {
            Logging.log.severe("Failed to append one of the java class path properties to properties file " + propertyFile);
        }
    }

    public static int runAntScript(ProductData prodData, String antScript, String antLogFile, String propertyFile, boolean retrySetting, String target) {
        PickList cfgPickList;
        int returnCode = -1;
        if (!hasSetSDWDefaultGroovyProp) {
            Globals.g_configData.setSDWProperty("default.groovy.path", Configure.getSasHomeGroovyFilePath());
            hasSetSDWDefaultGroovyProp = true;
        }
        if (Globals.g_pauseConfig) {
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), "Paused", "Paused", 1);
        }
        if (Globals.g_doNoConfigHarm) {
            return 0;
        }
        String prodCode = prodData.getProdCode();
        String prodGroovyPath = Configure.getDefaultGroovyFilePath();
        PickList pickList = prodCode.equalsIgnoreCase("cfgwizard") ? Configure.getCfgWizardPickList() : new PickList(prodData);
        PickList.Item groovyItemOld = pickList.removeItem(GROOVY_JAR_NAME);
        if (groovyItemOld != null) {
            Logging.log.warning("groovy-all.jar was found in product picklist " + prodCode + " and removed because it is too old (Groovy V1 or V2)");
        }
        PickList.Item groovyItem = pickList.removeItem(GROOVY_JAR_NAME_V3_plus);
        String path = pickList.getCombinedPickListPath();
        boolean isGateEnabled = Configure.getConfigDataProperty(prodCode + ".gate.enabled", "false").equalsIgnoreCase("true");
        if (groovyItem != null) {
            prodGroovyPath = groovyItem.getResolvedParentPath();
            Logging.log.info("groovy.jar was found in product picklist " + prodCode + " using path " + prodGroovyPath);
        } else {
            if (path.length() > 0) {
                path = path + System.getProperty("path.separator");
            }
            path = path + prodGroovyPath;
        }
        path = path + System.getProperty("path.separator");
        path = path + Configure.getSasHomeWebAppConfigJarLocation();
        if (!prodCode.equalsIgnoreCase("cfgwizard") && (cfgPickList = Configure.getCfgWizardPickList()) != null) {
            if (path.length() > 0) {
                path = path + System.getProperty("path.separator");
            }
            path = path + cfgPickList.getCombinedPickListPath();
        }
        Configure.appendPickListLibProperty(propertyFile, prodCode, path);
        path = Configure.removeDuplicates(path);
        String pathWildcards = Configure.convertPathToWildcards(path);
        String[] pathDirsAndfiles = Configure.splitPathToDirsAndFiles(path);
        String pathDirs = pathDirsAndfiles[0];
        String pathFiles = pathDirsAndfiles[1];
        if (pathWildcards.length() > 0) {
            pathWildcards = pathWildcards + System.getProperty("path.separator");
        }
        if (pathDirs.length() > 0) {
            pathDirs = pathDirs + System.getProperty("path.separator");
        }
        pathWildcards = pathWildcards + Globals.g_setupLocation + System.getProperty("file.separator") + "*";
        pathDirs = pathDirs + Globals.g_setupLocation;
        Configure.appendClassPathProperties(propertyFile, pathWildcards, pathDirs, pathFiles);
        ArrayList<String> cmdArray = new ArrayList<String>();
        String javaCmd = Configure.getJavaCommand();
        cmdArray.add("\"" + javaCmd + "\"");
        if (Globals.g_javaOptions != null) {
            cmdArray.add(Globals.g_javaOptions);
        }
        if (Globals.g_javaOptions == null || !Globals.g_javaOptions.contains("-Xmx")) {
            if (Utils.getOS() == 8) {
                cmdArray.add("-Xmx512M");
            } else {
                cmdArray.add("-Xmx1024M");
            }
        }
        cmdArray.add("-classpath");
        cmdArray.add("\"" + new File(Globals.g_setupLocation, "ant-launcher.jar").getAbsolutePath() + "\"");
        cmdArray.add("-Dant.home=\"" + Globals.g_setupLocation + "\"");
        cmdArray.add("org.apache.tools.ant.launch.Launcher");
        cmdArray.add("-logger");
        cmdArray.add("com.sas.tools.webappconfig.logging.LogTransformer");
        if (Globals.g_logLevel < 2) {
            cmdArray.add("-verbose");
        } else if (Globals.g_logLevel == 2) {
            cmdArray.add("-debug");
        }
        if (Globals.g_antOptions != null) {
            cmdArray.add(Globals.g_antOptions);
        }
        String configLevDir = Configure.getConfigDataProperty("config.lev.dir", null);
        String cfgwizUtil = Configure.getCfgWizardUtilsDir();
        String fullTarget = null;
        String additionalTargets = Configure.getConfigDataProperty("cfgwizard." + target + ".additionalTargets", "");
        fullTarget = additionalTargets.length() > 0 ? target + " " + additionalTargets : target;
        String container = Configure.getConfigDefaultProperty("webappsrv.12byte", null);
        if (container != null) {
            if (PropertyRules.containsProperty(container)) {
                container = PropertyRules.resolveProperties(container, 0);
            }
            if (container.equalsIgnoreCase("websphereba") || container.equalsIgnoreCase("webspherend")) {
                container = "websphere";
            }
            if (container.equalsIgnoreCase("tcsclusterc")) {
                container = "vfabrictcsvr";
            }
        }
        if (propertyFile != null) {
            cmdArray.add("-Dconfiguration.properties.file=\"" + propertyFile + "\"");
        }
        if (antLogFile != null) {
            cmdArray.add("-Dant.log.file=\"" + antLogFile + "\"");
        }
        if (cfgwizUtil != null) {
            cmdArray.add("-Dinstall.cfgwizard.utilities.dir=\"" + cfgwizUtil + "\"");
            cmdArray.add("-Dinstall.cfgwizard.contrib.dir=\"" + cfgwizUtil + File.separator + "contrib\"");
        }
        if (target != null) {
            cmdArray.add("-Dconfig.target.name=" + target);
        }
        if (retrySetting) {
            cmdArray.add("-Dwizard.retry=true");
        }
        if (antLogFile != null) {
            cmdArray.add("-l");
            cmdArray.add("\"" + antLogFile + "\"");
        }
        if (path.length() > 0) {
            cmdArray.add("-lib");
            cmdArray.add("\"" + path + "\"");
        }
        if (antScript != null) {
            cmdArray.add("-f");
            cmdArray.add("\"" + antScript + "\"");
        }
        if (configLevDir != null) {
            cmdArray.add("-Dbasedir=\"" + configLevDir + "\"");
        }
        if (container != null) {
            cmdArray.add("-Dwebappsrv.container.type=" + container);
        }
        if (Configure.getDefaultGroovyFilePath() != null) {
            cmdArray.add("-Ddefault.groovy.path=\"" + Configure.getDefaultGroovyFilePath() + "\"");
        }
        if (prodGroovyPath != null) {
            cmdArray.add("-D12byte.groovy.path=\"" + prodGroovyPath + "\"");
            Globals.g_configData.setSDWProperty(prodCode + ".groovy.path", prodGroovyPath);
        }
        if (isGateEnabled) {
            cmdArray.add("-Dinstall.cfgwizard.gate.dir=\"" + Configure.getCfgWizardGateDir() + "\"");
            if (Globals.g_gateValidate) {
                cmdArray.add("-Dgate.validation.enabled=true");
            }
        }
        if (fullTarget != null) {
            String[] targetList = fullTarget.split(" ");
            for (int i = 0; i < targetList.length; ++i) {
                cmdArray.add(targetList[i]);
            }
        }
        StringBuffer sb = new StringBuffer();
        for (String part : cmdArray) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(part);
        }
        String command = sb.toString();
        try {
            Object[] envp = null;
            ProcessBuilder processBuilder = Configure.getProcessBuilder(cmdArray);
            if (null == processBuilder) {
                if (Utils.getOS() != 8 && Utils.getOS() != 10) {
                    envp = KitAction.getEnvironmentVariables("JAVA_TOOL_OPTIONS", "-Dfile.encoding=COMPAT");
                    Logging.log.finer("Launching with envp vars:  " + Arrays.toString(envp).replaceAll("\r\n", " ").replaceAll("\n", " "));
                }
            } else {
                Map<String, String> envVars = processBuilder.environment();
                if (Utils.getOS() != 8 && Utils.getOS() != 10) {
                    envVars.put("JAVA_TOOL_OPTIONS", "-Dfile.encoding=COMPAT");
                }
                Logging.log.finer("Launching with env vars:  " + envp.toString().replaceAll("\r\n", " ").replaceAll("\n", " "));
            }
            Logging.log.info("CONFIGURE: Launching Ant script - " + command);
            returnCode = KitAction.executeProcess(command, Globals.g_tempLocation + File.separator + "antscript", Globals.g_tempLocation + File.separator + ".antlog", processBuilder, (String[])envp);
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
        Logging.log.info("Return Code: " + returnCode);
        return returnCode;
    }

    private static String removeDuplicates(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        String separator = System.getProperty("path.separator");
        String[] pathElements = path.split(separator);
        HashSet<String> uniquePaths = new HashSet<String>(Arrays.asList(pathElements));
        return String.join((CharSequence)separator, uniquePaths);
    }

    public static int runInstallAntScript(String prodCode, String prodName, String prodVer, String prodCustVer, String prodMaint, String prodSASRel, String orderEncoding, String antScript, String antLogFile, String propertyFile, String target) {
        int returnCode = -1;
        String javaCmd = null;
        javaCmd = Globals.g_scriptJREHome != null ? "\"" + new File(Utils.buildJavaCommand(Globals.g_scriptJREHome)).getAbsolutePath() + "\"" : "\"" + new File(Utils.getJavaCommand()).getAbsolutePath() + "\"";
        String javaCmdArgs = " -Xmx256M -classpath \"" + new File(Globals.g_setupLocation, "ant-launcher.jar").getAbsolutePath() + "\" -Dant.home=\"" + Globals.g_setupLocation + "\" org.apache.tools.ant.launch.Launcher";
        javaCmdArgs = Globals.g_logLevel < 2 ? javaCmdArgs + " -verbose" : javaCmdArgs + " -debug";
        javaCmdArgs = javaCmdArgs + " -logger com.sas.tools.webappconfig.logging.LogTransformer";
        String antSrcDir = new File(antScript).getParent();
        String antTempDir = Globals.g_tempLocation;
        String fullTarget = null;
        String additionalTargets = Globals.g_installData.getProperty("deploywiz." + target + ".additionalTargets", "");
        fullTarget = additionalTargets.length() > 0 ? target + " " + additionalTargets : target;
        String antCmdArgs = (propertyFile == null ? "" : " -Dinstall.properties.file=\"" + propertyFile + "\"") + (antLogFile == null ? "" : " -Dant.log.file=\"" + antLogFile + "\"") + (antLogFile == null ? "" : " -l \"" + antLogFile + "\"") + " -lib \"" + (Configure.getDefaultGroovyFilePath() == null ? "" : Configure.getDefaultGroovyFilePath() + System.getProperty("path.separator")) + Configure.getSasHomeWebAppConfigJarLocation() + "\"" + (antScript == null ? "" : " -f \"" + antScript + "\"") + (antSrcDir == null ? "" : " -Dinstall.currprod.dir=\"" + antSrcDir + "\"") + (antTempDir == null ? "" : " -Dtemp.dir=\"" + antTempDir + "\"") + (Globals.g_antOptions == null ? "" : " " + Globals.g_antOptions) + (prodCode == null ? "" : " -Dinstall.currprod.12byte=\"" + prodCode + "\"") + (prodVer == null ? "" : " -Dinstall.currprod.version=\"" + prodVer + "\"") + (prodName == null ? "" : " -Dinstall.currprod.legalname=\"" + prodName + "\"") + (prodCustVer == null ? "" : " -Dinstall.currprod.custversion=\"" + prodCustVer + "\"") + (prodMaint == null ? "" : " -Dinstall.currprod.maintversion=\"" + prodMaint + "\"") + (prodSASRel == null ? "" : " -Dinstall.currprod.sasrelease=\"" + prodSASRel + "\"") + (orderEncoding == null ? "" : " -Dorder.encoding=\"" + orderEncoding + "\"") + (!"install-nosubmit".equals(target) ? "" : " -Dzos.install.locale=\"" + Language.gs_SelectedLanguage + "\"") + (!"sasinstall".equalsIgnoreCase(prodCode) || Globals.g_jreHome == null ? "" : " -Djre.home=\"" + Globals.g_jreHome + "\"") + " -Dsas.home=\"" + Globals.g_wizardData.getPreference("SASHome", "") + "\"" + (Globals.g_sid == null ? "" : " -Dsid.file=\"" + Globals.g_sid.getFormattedSIDFile().getAbsolutePath() + "\"") + (fullTarget == null ? "" : " " + fullTarget);
        String command = javaCmd + javaCmdArgs + antCmdArgs;
        Object[] envp = null;
        if (Utils.getOS() != 8 && Utils.getOS() != 10) {
            envp = KitAction.getEnvironmentVariables("JAVA_TOOL_OPTIONS", "-Dfile.encoding=COMPAT");
            Logging.log.finer("Launching with env vars:  " + Arrays.toString(envp).replaceAll("\r\n", " ").replaceAll("\n", " "));
        }
        if (Globals.g_mode == 2) {
            Logging.log.info("TASK: Launching Task script - " + command);
        } else {
            Logging.log.info("INSTALL: Launching Install script - " + command);
        }
        try {
            returnCode = KitAction.executeProcess(command, Globals.g_tempLocation + File.separator + "antscript", Globals.g_tempLocation + File.separator + ".antlog", (String[])envp);
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
        Logging.log.info("Return Code: " + returnCode);
        return returnCode;
    }
}

