/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ArchiveWorker;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DestPanel;
import com.sas.ssn.DlgBusyMsg;
import com.sas.ssn.Globals;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class ArchiveFileDialog
extends JDialog {
    public static final int CANCEL = 0;
    public static final int OK = 1;
    private GridBagConstraints c = new GridBagConstraints();
    private DestPanel filePanel;
    private int buttonClicked;
    private File archiveFile;
    private int m_status;
    protected static SSNResource bundle = new SSNResource(ArchiveFileDialog.class);

    public ArchiveFileDialog(Frame owner, File archive, String pid) {
        super(owner, "Save Archive", true);
        String defaultPath = Globals.g_wizardData.getPreference("SASHome", "");
        defaultPath = Utils.joinPath(defaultPath, archive.getName());
        if (defaultPath.length() > 4) {
            defaultPath = defaultPath.substring(0, defaultPath.length() - 4);
        }
        this.archiveFile = archive;
        int iOS = Utils.getOS();
        if (archive.getName().toLowerCase(Locale.ENGLISH).endsWith(".tar") && iOS != 1 && iOS != 6) {
            this.TarArchiveDialog(owner, defaultPath);
        } else if (archive.getName().toLowerCase(Locale.ENGLISH).endsWith(".taz") && iOS != 1 && iOS != 6) {
            this.TazArchiveDialog(owner, defaultPath);
        } else if (archive.getName().toLowerCase(Locale.ENGLISH).endsWith(".zip") || archive.getName().toLowerCase(Locale.ENGLISH).endsWith(".tgz")) {
            this.ZipArchiveDialog(owner, defaultPath);
        } else {
            String defaultSavePath = Globals.g_wizardData.getPreference("ArchiveSaveDefault", "");
            this.SaveArchiveDialog(owner, defaultSavePath);
        }
    }

    private void TarArchiveDialog(final Frame owner, String defaultPath) {
        JTextPane description = new JTextPane();
        description.setBackground(this.getBackground());
        description.setText(bundle.getString("ArchiveFileDialog.PullDescription.txt") + "\n\n" + this.getArchivePath());
        description.setEnabled(false);
        this.filePanel = new DestPanel(bundle.getString("ArchiveFileDialog.PullArchive.txt"), defaultPath, 1, 1);
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        String mtxt = bundle.getString("Common.OK.txt");
        String txt = Util.getLabelWithoutMnemonic(mtxt);
        okButton.setText(txt);
        cancelButton.setText(bundle.getString("Common.Cancel.txt"));
        this.setSize(600, 300);
        this.setLocationRelativeTo(owner);
        this.getContentPane().setLayout(new GridBagLayout());
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.insets = new Insets(10, 10, 0, 10);
        this.c.anchor = 11;
        this.getContentPane().add((Component)description, this.c);
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.anchor = 10;
        this.c.insets = new Insets(0, 10, 0, 10);
        this.getContentPane().add((Component)this.filePanel, this.c);
        this.c.fill = 0;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.anchor = 14;
        this.c.insets = new Insets(0, 10, 10, 10);
        this.getContentPane().add((Component)new navButtons(okButton, cancelButton), this.c);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ArchiveFileDialog.checkLocation(ArchiveFileDialog.this.getPath(), false)) {
                    DlgBusyMsg busyMsg = new DlgBusyMsg(Globals.g_wizard.getFrame(), bundle.getString("Common.Inatalling.txt"), bundle.getString("ArchiveFileDialog.UnarchiveProgressBarMsg.txt"));
                    ArchiveFileDialog.this.m_status = Utils.extractTar(ArchiveFileDialog.this.getArchivePath(), ArchiveFileDialog.this.getPath(), busyMsg);
                    if (ArchiveFileDialog.this.m_status == 0) {
                        CustMsgBox.showMessageDialog((Component)owner, bundle.getString("ArchiveFileDialog.PullOkayMsg.txt"), bundle.getString("ArchiveFileDialog.PullOkayTitle.txt"), 1);
                    } else {
                        CustMsgBox.showMessageDialog((Component)owner, bundle.getString("ArchiveFileDialog.PullFailedMsg.txt"), bundle.getString("Common.Error.txt"), 2);
                    }
                    ArchiveFileDialog.this.buttonClicked = 1;
                    ArchiveFileDialog.this.setVisible(false);
                    ArchiveFileDialog.this.dispose();
                } else {
                    CustMsgBox.showMessageDialog((Component)owner, bundle.getString("ArchiveFileDialog.InvalidDirectoryMsg.txt"), bundle.getString("Common.Warning.txt"), 2);
                }
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArchiveFileDialog.this.buttonClicked = 0;
                ArchiveFileDialog.this.setVisible(false);
                ArchiveFileDialog.this.dispose();
            }
        });
        this.show();
    }

    private void TazArchiveDialog(final Frame owner, String defaultPath) {
        JTextPane description = new JTextPane();
        description.setBackground(this.getBackground());
        description.setText(bundle.getString("ArchiveFileDialog.PullDescription.txt") + "\n\n" + this.getArchivePath());
        description.setEnabled(false);
        this.filePanel = new DestPanel(bundle.getString("ArchiveFileDialog.PullArchive.txt"), defaultPath, 1, 1);
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        String mtxt = bundle.getString("Common.OK.txt");
        okButton.setText(Util.getLabelWithoutMnemonic(mtxt));
        cancelButton.setText(bundle.getString("Common.Cancel.txt"));
        this.setSize(600, 300);
        this.setLocationRelativeTo(owner);
        this.getContentPane().setLayout(new GridBagLayout());
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.insets = new Insets(10, 10, 0, 10);
        this.c.anchor = 11;
        this.getContentPane().add((Component)description, this.c);
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.anchor = 10;
        this.c.insets = new Insets(0, 10, 0, 10);
        this.getContentPane().add((Component)this.filePanel, this.c);
        this.c.fill = 0;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.anchor = 14;
        this.c.insets = new Insets(0, 10, 10, 10);
        this.getContentPane().add((Component)new navButtons(okButton, cancelButton), this.c);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ArchiveFileDialog.checkLocation(ArchiveFileDialog.this.getPath(), false)) {
                    DlgBusyMsg busyMsg = new DlgBusyMsg(Globals.g_wizard.getFrame(), bundle.getString("Common.Inatalling.txt"), bundle.getString("ArchiveFileDialog.UnarchiveProgressBarMsg.txt"));
                    ArchiveFileDialog.this.m_status = Utils.extractTaz(ArchiveFileDialog.this.getArchivePath(), ArchiveFileDialog.this.getPath(), busyMsg);
                    if (ArchiveFileDialog.this.m_status == 0) {
                        CustMsgBox.showMessageDialog((Component)owner, bundle.getString("ArchiveFileDialog.PullOkayMsg.txt"), bundle.getString("ArchiveFileDialog.PullOkayTitle.txt"), 1);
                    } else {
                        CustMsgBox.showMessageDialog((Component)owner, bundle.getString("ArchiveFileDialog.PullFailedMsg.txt"), bundle.getString("Common.Error.txt"), 2);
                    }
                    ArchiveFileDialog.this.buttonClicked = 1;
                    ArchiveFileDialog.this.setVisible(false);
                    ArchiveFileDialog.this.dispose();
                } else {
                    CustMsgBox.showMessageDialog((Component)owner, bundle.getString("ArchiveFileDialog.InvalidDirectoryMsg.txt"), bundle.getString("Common.Warning.txt"), 2);
                }
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArchiveFileDialog.this.buttonClicked = 0;
                ArchiveFileDialog.this.setVisible(false);
                ArchiveFileDialog.this.dispose();
            }
        });
        this.show();
    }

    private void ZipArchiveDialog(final Frame owner, String defaultPath) {
        JTextPane description = new JTextPane();
        description.setBackground(this.getBackground());
        description.setText(bundle.getString("ArchiveFileDialog.PullDescription.txt") + "\n\n" + this.getArchivePath());
        description.setEnabled(false);
        this.filePanel = new DestPanel(bundle.getString("ArchiveFileDialog.PullArchive.txt"), defaultPath, 1, 1);
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        String mtxt = bundle.getString("Common.OK.txt");
        okButton.setText(Util.getLabelWithoutMnemonic(mtxt));
        cancelButton.setText(bundle.getString("Common.Cancel.txt"));
        this.setSize(600, 300);
        this.setLocationRelativeTo(owner);
        this.getContentPane().setLayout(new GridBagLayout());
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.insets = new Insets(10, 10, 0, 10);
        this.c.anchor = 11;
        this.getContentPane().add((Component)description, this.c);
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.anchor = 10;
        this.c.insets = new Insets(0, 10, 0, 10);
        this.getContentPane().add((Component)this.filePanel, this.c);
        this.c.fill = 0;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.anchor = 14;
        this.c.insets = new Insets(0, 10, 10, 10);
        this.getContentPane().add((Component)new navButtons(okButton, cancelButton), this.c);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ArchiveFileDialog.checkLocation(ArchiveFileDialog.this.getPath(), false)) {
                    try {
                        DlgBusyMsg busyMsg = new DlgBusyMsg(Globals.g_wizard.getFrame(), bundle.getString("Common.Inatalling.txt"), bundle.getString("ArchiveFileDialog.UnarchiveProgressBarMsg.txt"));
                        ArchiveWorker worker = new ArchiveWorker(1, ArchiveFileDialog.this.getArchivePath(), ArchiveFileDialog.this.getPath());
                        busyMsg.execute(worker);
                        if (worker.getRC() == 0) {
                            CustMsgBox.showMessageDialog((Component)owner, bundle.getString("ArchiveFileDialog.PullOkayMsg.txt"), bundle.getString("ArchiveFileDialog.PullOkayTitle.txt"), 1);
                        } else {
                            CustMsgBox.showMessageDialog((Component)owner, bundle.getString("ArchiveFileDialog.PullFailedMsg.txt"), bundle.getString("Common.Error.txt"), 2);
                        }
                    }
                    catch (Exception e2) {
                        CustMsgBox.showMessageDialog((Component)owner, bundle.getString("ArchiveFileDialog.PullFailedMsg.txt"), bundle.getString("Common.Error.txt"), 2);
                    }
                    ArchiveFileDialog.this.buttonClicked = 1;
                    ArchiveFileDialog.this.setVisible(false);
                    ArchiveFileDialog.this.dispose();
                } else {
                    CustMsgBox.showMessageDialog((Component)owner, bundle.getString("ArchiveFileDialog.InvalidDirectoryMsg.txt"), bundle.getString("Common.Warning.txt"), 2);
                }
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArchiveFileDialog.this.buttonClicked = 0;
                ArchiveFileDialog.this.setVisible(false);
                ArchiveFileDialog.this.dispose();
            }
        });
        this.show();
    }

    private void SaveArchiveDialog(final Frame owner, String defaultPath) {
        JTextPane description = new JTextPane();
        description.setBackground(this.getBackground());
        description.setText(bundle.getString("ArchiveFileDialog.SaveDescription.txt") + "\n\n" + this.getArchivePath());
        description.setEnabled(false);
        this.filePanel = new DestPanel(bundle.getString("ArchiveFileDialog.SaveArchive.txt"), defaultPath, 1, 1);
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        String mtxt = bundle.getString("Common.OK.txt");
        okButton.setText(Util.getLabelWithoutMnemonic(mtxt));
        okButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        okButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        cancelButton.setText(bundle.getString("Common.Cancel.txt"));
        this.setSize(600, 300);
        this.setLocationRelativeTo(owner);
        this.getContentPane().setLayout(new GridBagLayout());
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.insets = new Insets(10, 10, 0, 10);
        this.c.anchor = 11;
        this.getContentPane().add((Component)description, this.c);
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.anchor = 10;
        this.c.insets = new Insets(0, 10, 0, 10);
        this.getContentPane().add((Component)this.filePanel, this.c);
        this.c.fill = 0;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.anchor = 14;
        this.c.insets = new Insets(0, 10, 10, 10);
        this.getContentPane().add((Component)new navButtons(okButton, cancelButton), this.c);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ArchiveFileDialog.checkLocation(ArchiveFileDialog.this.getPath(), true)) {
                    if (ArchiveFileDialog.this.getPath().equals(ArchiveFileDialog.this.getArchivePath())) {
                        CustMsgBox.showMessageDialog((Component)owner, bundle.getString("ArchiveFileDialog.FileCopySamePlaceMsg.txt"), bundle.getString("Common.Warning.txt"), 2);
                    } else {
                        String from = ArchiveFileDialog.this.getArchivePath();
                        String to = Utils.joinPath(ArchiveFileDialog.this.getPath(), ArchiveFileDialog.this.archiveFile.getName());
                        DlgBusyMsg busyMsg = new DlgBusyMsg(Globals.g_wizard.getFrame(), bundle.getString("ArchiveFileDialog.CopyProgressBarTitle.txt"), bundle.getString("ArchiveFileDialog.CopyProgressBarMsg.txt"));
                        ArchiveWorker worker = new ArchiveWorker(2, from, to);
                        busyMsg.execute(worker);
                        int rc = worker.getRC();
                        if (rc == 0) {
                            Globals.g_wizardData.setPreference("ArchiveSaveDefault", ArchiveFileDialog.this.filePanel.getPath());
                            CustMsgBox.showMessageDialog((Component)owner, bundle.getString("ArchiveFileDialog.SaveOkayMsg.txt"), bundle.getString("ArchiveFileDialog.SaveOkayTitle.txt"), 1);
                        } else {
                            CustMsgBox.showMessageDialog((Component)owner, bundle.getString("ArchiveFileDialog.FileNotCopiedMsg.txt"), bundle.getString("Common.Error.txt"), 2);
                        }
                        ArchiveFileDialog.this.m_status = rc;
                    }
                    ArchiveFileDialog.this.buttonClicked = 1;
                    ArchiveFileDialog.this.setVisible(false);
                    ArchiveFileDialog.this.dispose();
                } else {
                    CustMsgBox.showMessageDialog((Component)owner, bundle.getString("ArchiveFileDialog.InvalidDirectoryMsg.txt"), bundle.getString("Common.Warning.txt"), 2);
                }
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArchiveFileDialog.this.buttonClicked = 0;
                ArchiveFileDialog.this.setVisible(false);
                ArchiveFileDialog.this.dispose();
            }
        });
        this.show();
    }

    public static boolean checkLocation(String searchPath, boolean mustExist) {
        boolean valid = false;
        File path = new File(searchPath);
        if (path.exists() && path.isDirectory()) {
            valid = true;
        } else if (!path.exists() && !mustExist && path.mkdirs()) {
            valid = true;
        }
        return valid;
    }

    public int buttonClicked() {
        return this.buttonClicked;
    }

    public String getPath() {
        return this.filePanel.getPath();
    }

    public String getArchivePath() {
        return this.archiveFile.getPath();
    }

    public int getStatus() {
        return this.m_status;
    }

    private class navButtons
    extends JPanel {
        public navButtons(JButton okButton, JButton cancelButton) {
            GridBagConstraints c = new GridBagConstraints();
            JPanel okPanel = new JPanel();
            JPanel cancelPanel = new JPanel();
            okPanel.setLayout(new GridBagLayout());
            cancelPanel.setLayout(new GridBagLayout());
            c.fill = 2;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 0, 0, 4);
            c.anchor = 10;
            okPanel.add((Component)okButton, c);
            c.fill = 2;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 4, 0, 0);
            c.anchor = 10;
            cancelPanel.add((Component)cancelButton, c);
            this.setLayout(new GridLayout(1, 2));
            this.add(okPanel);
            this.add(cancelPanel);
        }
    }
}

