/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.KitTextField;
import java.awt.Toolkit;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class AdvKeyField
extends KitTextField
implements DocumentListener {
    private int m_numChars = 4;
    private boolean m_shiftFocus = true;

    public AdvKeyField(int numChars, boolean shiftFocus) {
        this.m_numChars = numChars;
        this.m_shiftFocus = shiftFocus;
    }

    public AdvKeyField(int numChars) {
        this.m_numChars = numChars;
    }

    public AdvKeyField() {
    }

    @Override
    protected Document createDefaultModel() {
        KeyDocument keyDoc = new KeyDocument();
        keyDoc.addDocumentListener(this);
        return keyDoc;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        String text;
        if (this.m_shiftFocus && (text = this.getText()) != null && text.length() == this.m_numChars) {
            this.transferFocus();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    static class KeyDocument
    extends PlainDocument {
        KeyDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null || str.length() + this.getContent().length() > 5) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            char[] test = str.toCharArray();
            for (int i = 0; i < test.length; ++i) {
                if (!Character.isLetterOrDigit(test[i])) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                switch (Character.toUpperCase(test[i])) {
                    case '0': 
                    case 'A': 
                    case 'E': 
                    case 'I': 
                    case 'O': 
                    case 'U': {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                }
                test[i] = Character.toUpperCase(test[i]);
            }
            super.insertString(offs, new String(test), a);
        }
    }
}

