/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.registry.client;

import com.sas.svcs.registry.client.ServiceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ServiceParameters
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private ServiceType type;
    private String serviceInterface;
    private int majorVersion = -1;
    private int minorVersion = -1;
    private int microVersion = -1;
    private List<String> keywords;
    private VersionPrecision precision = VersionPrecision.EXACT;

    public ServiceParameters() {
    }

    public ServiceParameters(String name, ServiceType type) {
        this.name = name;
        this.type = type;
    }

    public ServiceParameters(String serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInterface() {
        return this.serviceInterface;
    }

    public void setInterface(String i) {
        this.serviceInterface = i;
    }

    public ServiceType getServiceType() {
        return this.type;
    }

    public void setServiceType(ServiceType type) {
        this.type = type;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public int getMicroVersion() {
        return this.microVersion;
    }

    public void setMicroVersion(int microVersion) {
        this.microVersion = microVersion;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public void addKeyword(String keyword) {
        if (null == this.keywords) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(keyword);
    }

    public void setVersionPrecision(VersionPrecision vp) {
        this.precision = vp;
    }

    public VersionPrecision getVersionPrecision() {
        return this.precision;
    }

    public String toString() {
        return "ServiceParameters [name=" + this.name + ", type=" + (Object)((Object)this.type) + ", serviceInterface=" + this.serviceInterface + ", majorVersion=" + this.majorVersion + ", minorVersion=" + this.minorVersion + ", microVersion=" + this.microVersion + ", keywords=" + this.keywords + ", precision=" + (Object)((Object)this.precision) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keywords == null ? 0 : this.keywords.hashCode());
        result = 31 * result + this.majorVersion;
        result = 31 * result + this.microVersion;
        result = 31 * result + this.minorVersion;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.precision == null ? 0 : this.precision.hashCode());
        result = 31 * result + (this.serviceInterface == null ? 0 : this.serviceInterface.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceParameters other = (ServiceParameters)obj;
        if (this.keywords == null ? other.keywords != null : !this.keywords.equals(other.keywords)) {
            return false;
        }
        if (this.majorVersion != other.majorVersion) {
            return false;
        }
        if (this.microVersion != other.microVersion) {
            return false;
        }
        if (this.minorVersion != other.minorVersion) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.precision != other.precision) {
            return false;
        }
        if (this.serviceInterface == null ? other.serviceInterface != null : !this.serviceInterface.equals(other.serviceInterface)) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum VersionPrecision {
        EXACT,
        AT_LEAST;

    }
}

