/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.registry.client;

import com.sas.svcs.registry.client.ServiceType;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class RegisteredService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String url;
    private String serviceInterface;
    private String serviceNamespace;
    private String applicationName;
    private ServiceType serviceType;
    private boolean secured;
    private boolean generated;
    private boolean optionsEnabled;
    private final Set<String> keywords = new HashSet<String>();
    private Properties properties = new Properties();
    private final Set<String> dependencies = new HashSet<String>();
    private int majorVersion;
    private int minorVersion;
    private int microVersion;
    private String id;

    public RegisteredService() {
    }

    public RegisteredService(String n, String u, String i, boolean s, boolean w, boolean g) {
        this(n, u, i, s, w, g, 0, 0, 0);
    }

    public RegisteredService(String n, String u, String i, boolean s, boolean w, boolean g, int majorVersion, int minorVersion, int microVersion) {
        this(n, u, i, w ? ServiceType.SOAP : ServiceType.JAVA, s, g, majorVersion, minorVersion, microVersion);
    }

    @Deprecated
    public RegisteredService(String n, String u, String i, ServiceType t, boolean s, boolean g, int majorVersion, int minorVersion, int microVersion) {
        this(n, u, i, t, s, g, majorVersion, minorVersion, microVersion, null);
    }

    public RegisteredService(String name, String url, String serviceInterface, ServiceType type, boolean secured, boolean generated, int majorVersion, int minorVersion, int microVersion, String associatedApplication) {
        this.name = name;
        this.url = url;
        this.serviceInterface = serviceInterface;
        this.serviceType = type;
        this.secured = secured;
        this.generated = generated;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.microVersion = microVersion;
        this.addProperty("IsGenerated", String.valueOf(generated));
        this.addProperty("IsSecured", String.valueOf(secured));
        this.addProperty("ServiceType", this.serviceType.toString());
        this.applicationName = associatedApplication;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public String getServiceNamespace() {
        return this.serviceNamespace;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void addKeyword(String keyword) {
        this.keywords.add(keyword);
    }

    public boolean hasKeyword(String keyword) {
        return this.keywords.contains(keyword);
    }

    public Collection<String> getKeywords() {
        return this.keywords;
    }

    public final void addProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public void addDependent(String entityKey) {
        this.dependencies.add(entityKey);
    }

    public Collection<String> getDependencies() {
        return this.dependencies;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean isSoapEnabled() {
        return ServiceType.SOAP == this.getServiceType();
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMicroVersion() {
        return this.microVersion;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(ServiceType st) {
        this.serviceType = st;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setServiceInterface(String serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public void setServiceNamespace(String serviceNamespace) {
        this.serviceNamespace = serviceNamespace;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    public void setGenerated(boolean generated) {
        this.generated = generated;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public void setMicroVersion(int microVersion) {
        this.microVersion = microVersion;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String toString() {
        String next;
        int stringLength = 256;
        StringBuilder sb = new StringBuilder(256).append("Registered Service: ").append(this.getName()).append("[Url=").append(this.getUrl()).append(", secured=").append(this.isSecured()).append(", type=").append(this.getServiceType().toString()).append(", id=").append(this.getId()).append(", serviceInterface=").append(this.getServiceInterface()).append(", namespace=").append(this.getServiceNamespace()).append(", version=").append(this.getMajorVersion()).append(".").append(this.getMinorVersion()).append('.').append(this.getMicroVersion()).append(", keywords=[");
        Iterator<String> it = this.keywords.iterator();
        while (it.hasNext()) {
            next = it.next();
            sb.append(next);
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        sb.append("], properties=[");
        it = this.properties.stringPropertyNames().iterator();
        while (it.hasNext()) {
            String propertyName = it.next();
            String value = this.properties.getProperty(propertyName);
            sb.append(propertyName).append(':').append(value);
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        sb.append("], dependencies=[");
        it = this.dependencies.iterator();
        while (it.hasNext()) {
            next = it.next();
            sb.append(next);
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        sb.append("]]");
        return sb.toString();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public boolean isOptionsEnabled() {
        return this.optionsEnabled;
    }

    public void setOptionsEnabled(boolean optionsEnabled) {
        this.optionsEnabled = optionsEnabled;
    }
}

