/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.MainAttrParser;
import com.sas.app.PickList;
import com.sas.app.Plugin;
import com.sas.app.PluginRequest;
import com.sas.app.Repository;
import com.sas.app.RepositoryException;
import com.sas.app.Util;
import com.sas.app.VersionSpec;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

final class RepositoryUtil {
    private static boolean s_lookedUpFindResources;
    private static Method s_ClassLoader_findResources;
    private static MainAttrParser s_requireBundleParser;

    private RepositoryUtil() {
        throw new UnsupportedOperationException();
    }

    private static synchronized Method getFindResourcesMethod() {
        if (!s_lookedUpFindResources) {
            s_lookedUpFindResources = true;
            s_ClassLoader_findResources = Util.getAccessibleMethod(ClassLoader.class, "getResources", new Class[]{String.class}, false, Enumeration.class);
        }
        return s_ClassLoader_findResources;
    }

    private static synchronized MainAttrParser getRequireBundleParser() {
        MainAttrParser rc = s_requireBundleParser;
        if (rc == null) {
            s_requireBundleParser = rc = new MainAttrParser(new String[]{"Require-Bundle"});
        }
        return rc;
    }

    static Plugin[] getClasspath(Repository repository, PickList pickList, LinkedHashSet rc, Map usedPluginNameVersions) throws IllegalArgumentException, RepositoryException {
        if (repository == null) {
            throw Util.illegalNull("repository");
        }
        if (pickList == null) {
            throw Util.illegalNull("pickList");
        }
        if (rc == null) {
            throw Util.illegalNull("rc");
        }
        if (pickList.isEmpty()) {
            return Plugin.ZERO_PLUGINS;
        }
        if (usedPluginNameVersions == null) {
            usedPluginNameVersions = new HashMap<String, VersionSpec>();
        } else if (!usedPluginNameVersions.isEmpty()) {
            pickList = pickList.addExcludeNames(usedPluginNameVersions.keySet());
        }
        Plugin[] plugins = repository.find(pickList);
        ArrayList<Plugin> rcPlugins = new ArrayList<Plugin>();
        for (int i = 0; i < plugins.length; ++i) {
            Plugin p = plugins[i];
            String name = p.getName();
            if (usedPluginNameVersions.containsKey(name)) continue;
            usedPluginNameVersions.put(name, p.getVersion());
            rcPlugins.add(p);
            URL[] cp = p.getBundleClasspath();
            for (int j = 0; j < cp.length; ++j) {
                rc.add(cp[j]);
            }
        }
        int n = rcPlugins.size();
        return n > 0 ? rcPlugins.toArray(new Plugin[n]) : Plugin.ZERO_PLUGINS;
    }

    static PickList parseDepsFor(ClassLoader cl) throws RepositoryException {
        if (cl == null) {
            return PickList.EMPTY;
        }
        List<URL> urls = null;
        boolean manifests = false;
        Method findResources = RepositoryUtil.getFindResourcesMethod();
        if (findResources != null) {
            try {
                Enumeration e = (Enumeration)findResources.invoke((Object)cl, "META-INF/MANIFEST.MF");
                ArrayList<URL> list = new ArrayList<URL>();
                while (e.hasMoreElements()) {
                    URL u = (URL)e.nextElement();
                    if (u == null) continue;
                    list.add(u);
                }
                urls = list;
                manifests = true;
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        if (urls == null) {
            URL[] entries = Util.getClassLoaderURLs(cl);
            if (entries.length <= 0) {
                return PickList.EMPTY;
            }
            try {
                Enumeration e = new ExposeFindResources(entries).findResources("META-INF/MANIFEST.MF");
                ArrayList<URL> list = new ArrayList<URL>();
                while (e.hasMoreElements()) {
                    list.add((URL)e.nextElement());
                }
                urls = list;
                manifests = true;
            }
            catch (IOException iOException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (urls == null) {
                urls = Arrays.asList(entries);
                manifests = false;
            }
        }
        if (urls == null || urls.isEmpty()) {
            return PickList.EMPTY;
        }
        return RepositoryUtil.parseDepsForURLs(urls, manifests);
    }

    static PickList parseDepsForURLs(Collection urls, boolean manifests) throws RepositoryException {
        if (urls == null || urls.isEmpty()) {
            return PickList.EMPTY;
        }
        PluginRequest.Merger merger = new PluginRequest.Merger();
        for (URL u : urls) {
            String requireBundle;
            if (u == null || (requireBundle = manifests ? RepositoryUtil.calcRequireBundleForManifest(u) : RepositoryUtil.calcRequireBundleForClasspathEntry(u)) == null) continue;
            PluginRequest[] requests = PluginRequest.parseRequireBundle(requireBundle);
            if (requests == null) {
                throw new RepositoryException(Util.format("RepositoryUtil.parseDepsForURLs.parseRequireBundle.ex.fmt.txt", u, requireBundle));
            }
            for (int j = 0; j < requests.length; ++j) {
                merger.add(requests[j]);
            }
        }
        PluginRequest[] merged = merger.finish();
        return merged.length <= 0 ? PickList.EMPTY : new PickList(Arrays.asList(merged), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String calcRequireBundleForClasspathEntry(URL u) {
        URL mfURL;
        if (u == null) {
            return null;
        }
        File f = Util.toFile(u);
        if (f != null) {
            JarFile jf;
            block8: {
                String string;
                jf = null;
                try {
                    if (!f.isFile()) break block8;
                    jf = new JarFile(f);
                    Manifest mf = jf.getManifest();
                    string = mf == null ? null : mf.getMainAttributes().getValue(PickList.ATTR_NAME_REQUIRE_BUNDLE);
                }
                catch (IOException mf) {
                    Util.close(jf);
                }
                catch (SecurityException mf) {
                    Util.close(jf);
                }
                catch (Throwable throwable) {
                    Util.close(jf);
                    throw throwable;
                }
                Util.close(jf);
                return string;
            }
            Util.close(jf);
        }
        try {
            mfURL = new URL(u, "META-INF/MANIFEST.MF");
        }
        catch (MalformedURLException e) {
            return null;
        }
        return RepositoryUtil.calcRequireBundleForManifest(mfURL);
    }

    private static String calcRequireBundleForManifest(URL u) {
        if (u == null) {
            return null;
        }
        InputStream s = null;
        try {
            s = u.openStream();
            String string = RepositoryUtil.getRequireBundleParser().parseValues(s)[0];
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            Util.close(s);
        }
        return null;
    }

    private static final class ExposeFindResources
    extends URLClassLoader {
        public ExposeFindResources(URL[] urls) {
            super(urls);
        }

        public Enumeration findResources(String name) throws IOException {
            return super.findResources(name);
        }
    }
}

