/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.LaunchLocatorEntryPoint;
import com.sas.app.PluginRequest;
import com.sas.app.RepositoryException;
import com.sas.app.Util;
import com.sas.app.VersionSpec;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;

public final class PickList {
    private static final String PICK_LIST_VERSION = "PickList-Version";
    static final Attributes.Name ATTR_NAME_REQUIRE_BUNDLE = new Attributes.Name("Require-Bundle");
    private static final Attributes.Name ATTR_NAME_PICK_LIST_DATA = new Attributes.Name("SAS-Launch-Config");
    private static final String LAUNCH_LOCATOR_CLASS = "com.sas.app.launchLocator.LaunchLocator";
    static final PickList EMPTY = new PickList(null, false, null);
    private final boolean m_recursive;
    private final LinkedHashMap m_requests;
    private final Map m_excludes;

    private static Reader makeUtf8Reader(InputStream s) throws IllegalArgumentException {
        if (s == null) {
            throw Util.illegalNull("s");
        }
        return new InputStreamReader(s, Util.UTF8);
    }

    private static boolean load(Reader s, Map requests, Map excludes) throws IOException, IllegalArgumentException, RepositoryException {
        PluginRequest request;
        String line;
        if (s == null) {
            throw Util.illegalNull("s");
        }
        if (requests == null) {
            throw Util.illegalNull("requests");
        }
        if (excludes == null) {
            throw Util.illegalNull("excludes");
        }
        requests.clear();
        excludes.clear();
        BufferedReader r = s instanceof BufferedReader ? (BufferedReader)s : new BufferedReader(s);
        boolean recursive = false;
        int pickListVersion = 0;
        boolean haveRecursive = false;
        boolean havePickListVersion = false;
        String plPrefix = "PickList-Version=";
        String recursivePrefix = "recursive=";
        while ((line = r.readLine()) != null && (line = line.trim()).length() > 0) {
            String suffix;
            if (line.charAt(0) == '#') continue;
            if (line.startsWith("PickList-Version=")) {
                suffix = line.substring("PickList-Version=".length());
                if (havePickListVersion) {
                    throw PluginRequest.dupLine(PICK_LIST_VERSION, new Integer(pickListVersion), suffix);
                }
                try {
                    pickListVersion = Integer.parseInt(suffix);
                }
                catch (NumberFormatException e) {
                    throw new RepositoryException(Util.format("PickList.parse.pickListVersion.ex.fmt.txt", suffix), e);
                }
                havePickListVersion = true;
                continue;
            }
            if (!line.startsWith("recursive=")) continue;
            suffix = line.substring("recursive=".length());
            if (haveRecursive) {
                throw PluginRequest.dupLine("recursive", recursive ? Boolean.TRUE : Boolean.FALSE, suffix);
            }
            recursive = Boolean.valueOf(suffix);
            haveRecursive = true;
        }
        if (line == null) {
            return false;
        }
        while ((request = PluginRequest.parsePickListSection(r, pickListVersion)) != null) {
            String name = request.getName();
            if (requests.containsKey(name) || excludes.containsKey(name)) {
                throw new RepositoryException(Util.format("PickList.requests.name.duplicate.ex.fmt.txt", name));
            }
            (request.isExclude() ? excludes : requests).put(name, request);
        }
        if (!recursive || requests.isEmpty()) {
            excludes.clear();
        }
        return recursive;
    }

    private static String escapeManifestValue(String s) {
        if (s == null) {
            return null;
        }
        int n = s.length();
        if (n <= 0) {
            return s;
        }
        StringBuffer b = new StringBuffer(s.length() * 2);
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                b.append('\\').append('n');
                continue;
            }
            if (c == '\r') {
                b.append('\\').append('r');
                continue;
            }
            if (c == '\\') {
                b.append('\\').append('\\');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    private static String unEscapeManifestValue(String s) throws IllegalArgumentException {
        if (s == null) {
            return null;
        }
        int n = s.length();
        if (n <= 0) {
            return s;
        }
        StringBuffer b = new StringBuffer(s.length() * 2);
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                if (++i >= n) {
                    throw Util.illegalArgument("s.charAt(" + (i - 1) + ")", s);
                }
                c = s.charAt(i);
                if (c == 'n') {
                    b.append('\n');
                    continue;
                }
                if (c == 'r') {
                    b.append('\r');
                    continue;
                }
                if (c == '\\') {
                    b.append('\\');
                    continue;
                }
                throw Util.illegalArgument("s.charAt(" + i + ")", s);
            }
            b.append(c);
        }
        return b.toString();
    }

    private static LinkedHashMap validateRequests(Collection requests) throws IllegalArgumentException, ClassCastException, RepositoryException {
        if (requests == null) {
            throw Util.illegalNull("requests");
        }
        LinkedHashMap<String, PluginRequest> rc = new LinkedHashMap<String, PluginRequest>();
        long index = 0L;
        for (PluginRequest r : requests) {
            if (r == null) {
                throw Util.illegalNull("requests[i]");
            }
            String name = r.getName();
            if (rc.containsKey(name)) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(rc.get(name));
                list.add(r);
                throw new RepositoryException(Util.format("PickList.requests.name.duplicate.ex.fmt.txt", name), list);
            }
            rc.put(name, r);
            ++index;
        }
        return rc;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static PickList calcMergedPickListForSysProp(String propValue) throws IllegalArgumentException, RepositoryException {
        FileInputStream s;
        if (propValue == null) {
            throw Util.illegalNull("propValue");
        }
        LinkedHashSet pickListFiles = new LinkedHashSet();
        StringTokenizer tok = new StringTokenizer(propValue, File.pathSeparator);
        if (tok.countTokens() <= 0) {
            return EMPTY;
        }
        ArrayList pickListPatternStack = new ArrayList();
        File base = Util.canonical(new File("."));
        ArrayList<String> temp = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            temp.add(tok.nextToken());
        }
        for (int i = temp.size() - 1; i >= 0; --i) {
            pickListPatternStack.add(temp.get(i));
            pickListPatternStack.add(base);
        }
        HashSet<File> atFiles = new HashSet<File>();
        while (!pickListPatternStack.isEmpty()) {
            File base2 = (File)pickListPatternStack.remove(pickListPatternStack.size() - 1);
            String pathPattern = (String)pickListPatternStack.remove(pickListPatternStack.size() - 1);
            if (!pathPattern.startsWith("@")) {
                Util.addMatchingFiles(base2, pathPattern, pickListFiles);
                continue;
            }
            File f = new File(pathPattern = pathPattern.substring(1).trim());
            if (!f.isAbsolute()) {
                f = new File(base2, pathPattern);
            }
            if (!f.exists()) continue;
            File canonical = Util.canonical(f);
            if (!atFiles.add(canonical)) {
                throw new RepositoryException(Util.format("PickList.prop.includes.recursive.ex.fmt.txt", canonical));
            }
            ArrayList<String> temp2 = new ArrayList<String>();
            s = null;
            try {
                String line;
                s = new FileInputStream(f);
                BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)s, Util.UTF8));
                while ((line = r.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                    temp2.add(line);
                }
            }
            catch (IOException e) {
                throw new RepositoryException(Util.format("PickList.parse.ex.fmt.txt", f), e);
            }
            finally {
                Util.close(s);
                s = null;
            }
            File newBase = f.getParentFile();
            if (newBase == null && (newBase = canonical.getParentFile()) == null) {
                newBase = base2;
            }
            for (int i = temp2.size() - 1; i >= 0; --i) {
                pickListPatternStack.add(temp2.get(i));
                pickListPatternStack.add(newBase);
            }
        }
        int n = pickListFiles.size();
        if (n <= 0) {
            return EMPTY;
        }
        if (n == 1) {
            return new PickList((File)pickListFiles.iterator().next());
        }
        PluginRequest.Merger merger = new PluginRequest.Merger();
        LinkedHashMap requests = new LinkedHashMap();
        HashMap excludes = new HashMap();
        boolean rcRecursive = false;
        Iterator it = pickListFiles.iterator();
        while (it.hasNext()) {
            boolean recursive;
            File f = (File)it.next();
            requests.clear();
            excludes.clear();
            s = null;
            try {
                s = new FileInputStream(f);
                recursive = PickList.load(new InputStreamReader((InputStream)s, Util.UTF8), requests, excludes);
            }
            catch (IOException e) {
                try {
                    throw new RepositoryException(Util.format("PickList.parse.ex.fmt.txt", f), e);
                    catch (RepositoryException e2) {
                        throw new RepositoryException(Util.format("PickList.parse.ex.fmt.txt", f), e2);
                    }
                }
                catch (Throwable throwable) {
                    Util.close(s);
                    throw throwable;
                }
            }
            Util.close(s);
            if (requests.isEmpty()) continue;
            if (!excludes.isEmpty()) {
                throw new RepositoryException(Util.format("PickList.merge.excludes.ex.fmt.txt", f));
            }
            rcRecursive |= recursive;
            merger.add(requests.values());
        }
        return new PickList(Arrays.asList(merger.finish()), rcRecursive);
    }

    public PickList(Collection requests) throws IllegalArgumentException, ClassCastException, RepositoryException {
        this(requests, false);
    }

    PickList(Collection requests, boolean recursive) throws IllegalArgumentException, ClassCastException, RepositoryException {
        LinkedHashMap map = PickList.validateRequests(requests);
        int n = map.size();
        if (n <= 0) {
            this.m_requests = null;
            this.m_recursive = false;
        } else {
            this.m_requests = map;
            this.m_recursive = recursive;
        }
        this.m_excludes = null;
    }

    private PickList(LinkedHashMap requests, boolean recursive, Map excludes) {
        this.m_requests = requests;
        this.m_recursive = recursive;
        this.m_excludes = excludes;
    }

    public PickList(InputStream s) throws IOException, IllegalArgumentException, RepositoryException {
        this(PickList.makeUtf8Reader(s));
    }

    public PickList(Reader s) throws IOException, IllegalArgumentException, RepositoryException {
        if (s == null) {
            throw Util.illegalNull("s");
        }
        LinkedHashMap requests = new LinkedHashMap();
        HashMap excludes = new HashMap();
        boolean recursive = PickList.load(s, requests, excludes);
        int n = requests.size();
        if (n <= 0) {
            this.m_requests = null;
            this.m_recursive = false;
            this.m_excludes = null;
        } else {
            this.m_requests = requests;
            this.m_recursive = recursive;
            this.m_excludes = excludes.isEmpty() ? null : excludes;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PickList(File f) throws IllegalArgumentException, RepositoryException {
        boolean recursive;
        if (f == null) {
            throw Util.illegalNull("f");
        }
        LinkedHashMap requests = new LinkedHashMap();
        HashMap excludes = new HashMap();
        FileInputStream fis = null;
        Reader s = null;
        try {
            fis = new FileInputStream(f);
            s = PickList.makeUtf8Reader(fis);
            recursive = PickList.load(s, requests, excludes);
        }
        catch (IOException e) {
            try {
                throw new RepositoryException(Util.format("PickList.parse.ex.fmt.txt", f), e);
                catch (RepositoryException e2) {
                    throw new RepositoryException(Util.format("PickList.parse.ex.fmt.txt", f), e2);
                }
            }
            catch (Throwable throwable) {
                Util.close(s);
                Util.close(fis);
                throw throwable;
            }
        }
        Util.close(s);
        Util.close(fis);
        int n = requests.size();
        if (n <= 0) {
            this.m_requests = null;
            this.m_recursive = false;
            this.m_excludes = null;
            return;
        }
        this.m_requests = requests;
        this.m_recursive = recursive;
        this.m_excludes = excludes.isEmpty() ? null : excludes;
    }

    PickList(Attributes attr, boolean ignoreRequireBundle) throws IllegalArgumentException, RepositoryException {
        if (attr == null) {
            throw Util.illegalNull("attr");
        }
        String temp = attr.getValue(ATTR_NAME_PICK_LIST_DATA);
        if (temp != null) {
            boolean recursive;
            temp = PickList.unEscapeManifestValue(temp);
            LinkedHashMap requests = new LinkedHashMap();
            HashMap excludes = new HashMap();
            try {
                recursive = PickList.load(new StringReader(temp), requests, excludes);
            }
            catch (IOException e) {
                assert (false);
                throw new RepositoryException(Util.format("PickList.parse.fromManifestAttr.ex.fmt.txt", ATTR_NAME_PICK_LIST_DATA, temp), e);
            }
            int n = requests.size();
            if (n <= 0) {
                this.m_requests = null;
                this.m_recursive = false;
                this.m_excludes = null;
            } else {
                this.m_requests = requests;
                this.m_recursive = recursive;
                this.m_excludes = excludes.isEmpty() ? null : excludes;
            }
            return;
        }
        temp = attr.getValue(ATTR_NAME_REQUIRE_BUNDLE);
        if (ignoreRequireBundle || temp == null) {
            this.m_requests = null;
            this.m_recursive = false;
            this.m_excludes = null;
            return;
        }
        PluginRequest[] array = PluginRequest.parseRequireBundle(temp);
        if (array == null) {
            throw new RepositoryException(Util.format("PickList.parse.fromManifestAttr.requireBundle.ex.fmt.txt", temp));
        }
        LinkedHashMap requests = PickList.validateRequests(Arrays.asList(array));
        int n = requests.size();
        if (n <= 0) {
            this.m_requests = null;
            this.m_recursive = false;
        } else {
            this.m_requests = requests;
            this.m_recursive = true;
        }
        this.m_excludes = null;
    }

    boolean isEmpty() {
        return this.m_requests == null || this.m_requests.isEmpty();
    }

    boolean isRecursive() {
        return this.m_recursive;
    }

    PluginRequest[] getRequestsAndExcludes(PluginRequest[] array, Set excludes) {
        if (excludes != null) {
            excludes.clear();
        }
        if (this.isEmpty()) {
            return PluginRequest.ZERO_REQUESTS;
        }
        int n = this.m_requests.size();
        if (array == null || n > array.length) {
            array = new PluginRequest[n];
        }
        if ((array = this.m_requests.values().toArray(array)).length > n) {
            Arrays.fill(array, n, array.length, null);
        }
        if (excludes != null && this.m_excludes != null && !this.m_excludes.isEmpty()) {
            excludes.addAll(this.m_excludes.keySet());
        }
        return array;
    }

    PickList addExcludeNames(Set excludes) throws IllegalArgumentException, ClassCastException {
        if (excludes == null) {
            throw Util.illegalNull("excludes");
        }
        if (this.isEmpty() || excludes.isEmpty()) {
            return this;
        }
        LinkedHashMap newRequests = new LinkedHashMap(this.m_requests);
        if (!this.m_recursive) {
            if (newRequests.keySet().removeAll(excludes)) {
                return new PickList(newRequests, false, null);
            }
            return this;
        }
        boolean changed = false;
        HashMap<String, PluginRequest> newExcludes = this.m_excludes != null ? new HashMap<String, PluginRequest>(this.m_excludes) : new HashMap();
        for (String name : excludes) {
            if (name == null) {
                throw Util.illegalNull("excludes[i]");
            }
            if (!newExcludes.containsKey(name)) {
                changed = true;
                newExcludes.put(name, new PluginRequest(name, VersionSpec.ANY, 1));
            }
            changed |= newRequests.remove(name) != null;
        }
        if (!changed) {
            return this;
        }
        return new PickList(newRequests, true, newExcludes);
    }

    public void write(OutputStream s) throws IOException, IllegalArgumentException {
        if (s == null) {
            throw Util.illegalNull("s");
        }
        BufferedWriter b = new BufferedWriter(new OutputStreamWriter(s, Util.UTF8));
        this.write(b);
        b.flush();
    }

    public void write(Writer s) throws IOException, IllegalArgumentException {
        if (s == null) {
            throw Util.illegalNull("s");
        }
        s.write("PickList-Version=1\n");
        if (this.m_recursive) {
            s.write("recursive=true\n");
        }
        s.write(10);
        if (this.m_requests != null) {
            for (PluginRequest r : this.m_requests.values()) {
                r.writePickListSection(s);
            }
        }
        if (this.m_excludes != null) {
            for (PluginRequest r : this.m_excludes.values()) {
                r.writePickListSection(s);
            }
        }
    }

    void write(Attributes attr, String userMainClass, boolean useLaunchLocator) throws IllegalArgumentException {
        if (attr == null) {
            throw Util.illegalNull("attr");
        }
        if (useLaunchLocator) {
            if (userMainClass == null) {
                throw Util.illegalNull("userMainClass");
            }
            if (userMainClass.trim().length() <= 0) {
                throw Util.illegalArgument("userMainClass", userMainClass);
            }
        }
        if (!this.isEmpty()) {
            StringWriter sw = new StringWriter();
            try {
                this.write(sw);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            attr.put(ATTR_NAME_PICK_LIST_DATA, PickList.escapeManifestValue(sw.toString()));
            StringBuffer b = new StringBuffer();
            for (PluginRequest r : this.m_requests.values()) {
                r.writeRequireBundle(b);
            }
            attr.put(ATTR_NAME_REQUIRE_BUNDLE, b.toString());
        } else {
            attr.remove(ATTR_NAME_PICK_LIST_DATA);
            attr.remove(ATTR_NAME_REQUIRE_BUNDLE);
        }
        if (useLaunchLocator) {
            attr.put(Attributes.Name.MAIN_CLASS, LAUNCH_LOCATOR_CLASS);
            attr.put(LaunchLocatorEntryPoint.ATTR_NAME_USER_MAIN, userMainClass);
        } else {
            attr.remove(LaunchLocatorEntryPoint.ATTR_NAME_USER_MAIN);
            if (userMainClass != null && userMainClass.trim().length() > 0) {
                attr.put(Attributes.Name.MAIN_CLASS, userMainClass);
            }
        }
    }

    public String toString() {
        boolean haveExcludes;
        if (this.m_requests == null || this.m_requests.isEmpty()) {
            return "PickList (EMPTY)";
        }
        StringBuffer b = new StringBuffer();
        b.append("PickList ");
        if (this.m_recursive) {
            b.append("(RECURSIVE) ");
        }
        b.append("size ");
        b.append(this.m_requests.size());
        boolean bl = haveExcludes = this.m_recursive && this.m_excludes != null && !this.m_excludes.isEmpty();
        if (haveExcludes) {
            b.append(" with ");
            b.append(this.m_excludes.size());
            b.append(" excluded names");
        }
        b.append(": { ");
        Iterator it = this.m_requests.values().iterator();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            PluginRequest request = (PluginRequest)it.next();
            b.append(request.toString());
        }
        b.append(" }");
        if (haveExcludes) {
            b.append(" excluding names { ");
            it = this.m_excludes.values().iterator();
            first = true;
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append(it.next().toString());
            }
            b.append(" }");
        }
        return b.toString();
    }
}

