/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.OSGiTokenizer;
import com.sas.app.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;

class Filter {
    private static final boolean ALLOW_EMPTY_FILTER_LISTS = false;
    private static final Filter[] ZERO_FILTERS = new Filter[0];
    private static final byte AND = 38;
    private static final byte OR = 124;
    private static final byte NOT = 33;
    private static final byte EQUAL = 61;
    private static final byte APPROX = 126;
    private static final byte GREATER = 62;
    private static final byte LESS = 60;
    private static final byte PRESENT = 8;
    private static final byte SUBSTRING = 9;
    private static final float APPROX_THRESHOLD = 1.0E-5f;
    private static final double EQUAL_THRESHOLD = 3.0E-16;
    private static final double EQUAL_THRESHOLD_FLOAT = (double)2.0E-6f;
    private final byte m_op;
    private Filter[] m_subFilters;
    private String m_attr;
    private String m_value;
    private String[] m_middle;
    private String m_finish;

    static Filter parse(String filterString) throws IllegalArgumentException {
        if (filterString == null) {
            throw Util.illegalNull("filterString");
        }
        OSGiTokenizer tok = new OSGiTokenizer(filterString);
        return Filter.parse(tok);
    }

    private static Filter parse(OSGiTokenizer tok) {
        tok.skipWhitespace();
        if (!tok.maybe('(')) {
            return null;
        }
        tok.skipWhitespace();
        int c = tok.peek();
        if (c < 0) {
            return null;
        }
        if (c == 38 || c == 124) {
            tok.skipChar();
            Filter[] filterList = Filter.parseFilterList(tok);
            if (filterList == null) {
                return null;
            }
            tok.skipWhitespace();
            if (!tok.maybe(')')) {
                return null;
            }
            return new Filter((byte)c, filterList);
        }
        if (c == 33) {
            tok.skipChar();
            Filter f = Filter.parse(tok);
            if (f == null) {
                return null;
            }
            tok.skipWhitespace();
            if (!tok.maybe(')')) {
                return null;
            }
            return new Filter(33, f);
        }
        String attr = tok.filterAttr();
        if (attr == null) {
            return null;
        }
        tok.skipWhitespace();
        c = tok.read();
        if (c == 126 || c == 62 || c == 60) {
            if (!tok.maybe('=')) {
                return null;
            }
            String value = tok.filterValue();
            if (value == null) {
                return null;
            }
            if (!tok.maybe(')')) {
                return null;
            }
            return new Filter((byte)c, attr, value);
        }
        if (c != 61) {
            return null;
        }
        String initial = tok.filterValue();
        if (!tok.maybe('*')) {
            if (initial == null || !tok.maybe(')')) {
                return null;
            }
            return new Filter(61, attr, initial);
        }
        String value = tok.filterValue();
        if (value == null) {
            if (!tok.maybe(')')) {
                return null;
            }
            if (initial == null) {
                return new Filter(8, attr);
            }
            return new Filter(9, attr, initial, Util.ZERO_STRINGS, null);
        }
        ArrayList<String> middle = new ArrayList<String>();
        while (value != null && tok.maybe('*')) {
            middle.add(value);
            value = tok.filterValue();
        }
        if (!tok.maybe(')')) {
            return null;
        }
        return new Filter(9, attr, initial, middle.toArray(new String[middle.size()]), value);
    }

    private static Filter[] parseFilterList(OSGiTokenizer tok) {
        int c;
        tok.skipSpaces();
        ArrayList<Filter> rc = null;
        while (true) {
            tok.skipWhitespace();
            c = tok.peek();
            if (c != 40) break;
            Filter f = Filter.parse(tok);
            if (f == null) {
                return null;
            }
            if (rc == null) {
                rc = new ArrayList<Filter>();
            }
            rc.add(f);
        }
        if (c == 41) {
            if (rc == null || rc.isEmpty()) {
                return null;
            }
            return rc.toArray(new Filter[rc.size()]);
        }
        return null;
    }

    private Filter(byte op, Filter[] filterList) {
        if (op != 38 && op != 124) {
            throw Util.illegalArgument("op", new Integer(op));
        }
        if (filterList == null) {
            throw Util.illegalNull("filterList");
        }
        for (int i = 0; i < filterList.length; ++i) {
            if (filterList[i] != null) continue;
            throw Util.illegalNull("filterList[" + i + ']');
        }
        this.m_op = op;
        this.m_subFilters = filterList;
    }

    private Filter(byte op, Filter filter) {
        if (op != 33) {
            throw Util.illegalArgument("op", new Integer(op));
        }
        if (filter == null) {
            throw Util.illegalNull("filter");
        }
        this.m_op = op;
        this.m_subFilters = new Filter[]{filter};
    }

    private Filter(byte op, String attr, String value) {
        if (op != 61 && op != 126 && op != 62 && op != 60) {
            throw Util.illegalArgument("op", new Integer(op));
        }
        if (attr == null) {
            throw Util.illegalNull("attr");
        }
        if (value == null) {
            throw Util.illegalNull("value");
        }
        this.m_op = op;
        this.m_attr = attr;
        this.m_value = value;
    }

    private Filter(byte op, String attr) {
        if (op != 8) {
            throw Util.illegalArgument("op", new Integer(op));
        }
        if (attr == null) {
            throw Util.illegalNull("attr");
        }
        this.m_op = op;
        this.m_attr = attr;
    }

    private Filter(byte op, String attr, String initial, String[] middle, String finish) {
        if (op != 9) {
            throw Util.illegalArgument("op", new Integer(op));
        }
        if (attr == null) {
            throw Util.illegalNull("attr");
        }
        if (middle == null) {
            throw Util.illegalNull("middle");
        }
        for (int i = 0; i < middle.length; ++i) {
            if (middle[i] != null) continue;
            throw Util.illegalNull("middle[" + i + ']');
        }
        this.m_op = op;
        this.m_attr = attr;
        this.m_value = initial;
        this.m_middle = middle;
        this.m_finish = finish;
    }

    boolean matches(Map frameworkProps) throws IllegalArgumentException {
        if (frameworkProps == null) {
            throw Util.illegalNull("frameworkProps");
        }
        switch (this.m_op) {
            case 38: {
                if (this.m_subFilters == null || this.m_subFilters.length <= 0) {
                    assert (false);
                    throw new IllegalStateException();
                }
                for (int i = 0; i < this.m_subFilters.length; ++i) {
                    if (this.m_subFilters[i].matches(frameworkProps)) continue;
                    return false;
                }
                return true;
            }
            case 124: {
                if (this.m_subFilters == null || this.m_subFilters.length <= 0) {
                    assert (false);
                    throw new IllegalStateException();
                }
                for (int i = 0; i < this.m_subFilters.length; ++i) {
                    if (!this.m_subFilters[i].matches(frameworkProps)) continue;
                    return true;
                }
                return false;
            }
            case 33: {
                if (this.m_subFilters == null || this.m_subFilters.length != 1) {
                    assert (false);
                    throw new IllegalStateException();
                }
                return !this.m_subFilters[0].matches(frameworkProps);
            }
            case 8: 
            case 9: 
            case 60: 
            case 61: 
            case 62: 
            case 126: {
                break;
            }
            default: {
                assert (false);
                throw new IllegalStateException();
            }
        }
        assert (this.m_op == 61 || this.m_op == 126 || this.m_op == 62 || this.m_op == 60 || this.m_op == 8 || this.m_op == 9);
        if (this.m_attr == null) {
            assert (false);
            return false;
        }
        Object o = frameworkProps.get(this.m_attr.toLowerCase());
        if (o == null) {
            return false;
        }
        if (this.m_op == 8) {
            return true;
        }
        if (o instanceof String) {
            return this.matchesString((String)o);
        }
        if (o instanceof Collection) {
            return this.matchesCollection((Collection)o);
        }
        Class<?> oClass = o.getClass();
        if (!oClass.isArray()) {
            return this.matchesValue(o);
        }
        if (o instanceof String[]) {
            String[] array = (String[])o;
            for (int i = 0; i < array.length; ++i) {
                String s = array[i];
                if (s == null || !this.matchesString(s)) continue;
                return true;
            }
            return false;
        }
        Class<?> eleType = oClass.getComponentType();
        if (!eleType.isPrimitive()) {
            return this.matchesCollection(Arrays.asList((Object[])o));
        }
        if (this.m_op == 9) {
            return false;
        }
        if (this.m_value == null) {
            assert (false);
            throw new IllegalStateException();
        }
        if (Boolean.TYPE.equals(eleType)) {
            boolean[] array = (boolean[])o;
            boolean haveTrue = false;
            boolean haveFalse = false;
            for (int i = 0; i < array.length; ++i) {
                if (array[i]) {
                    haveTrue = true;
                } else {
                    haveFalse = true;
                }
                if (haveTrue && haveFalse) break;
            }
            return haveTrue && this.matchesBoolean(true) || haveFalse && this.matchesBoolean(false);
        }
        if (Character.TYPE.equals(eleType)) {
            char[] array = (char[])o;
            for (int i = 0; i < array.length; ++i) {
                if (!this.matchesInt(array[i])) continue;
                return true;
            }
            return false;
        }
        if (Byte.TYPE.equals(eleType)) {
            byte[] array = (byte[])o;
            for (int i = 0; i < array.length; ++i) {
                if (!this.matchesInt(array[i])) continue;
                return true;
            }
            return false;
        }
        if (Short.TYPE.equals(eleType)) {
            short[] array = (short[])o;
            for (int i = 0; i < array.length; ++i) {
                if (!this.matchesInt(array[i])) continue;
                return true;
            }
            return false;
        }
        if (Integer.TYPE.equals(eleType)) {
            int[] array = (int[])o;
            for (int i = 0; i < array.length; ++i) {
                if (!this.matchesInt(array[i])) continue;
                return true;
            }
            return false;
        }
        if (Long.TYPE.equals(eleType)) {
            long[] array = (long[])o;
            for (int i = 0; i < array.length; ++i) {
                if (!this.matchesLong(array[i])) continue;
                return true;
            }
            return false;
        }
        if (Float.TYPE.equals(eleType)) {
            float[] array = (float[])o;
            for (int i = 0; i < array.length; ++i) {
                if (!this.matchesFloat(array[i])) continue;
                return true;
            }
            return false;
        }
        if (Double.TYPE.equals(eleType)) {
            double[] array = (double[])o;
            for (int i = 0; i < array.length; ++i) {
                if (!this.matchesDouble(array[i])) continue;
                return true;
            }
            return false;
        }
        if (Void.TYPE.equals(eleType)) {
            return false;
        }
        assert (false);
        throw new IllegalStateException();
    }

    private boolean matchesCollection(Collection values) {
        if (values == null) {
            assert (false);
            return false;
        }
        for (Object value : values) {
            if (value == null || !this.matchesValue(value)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesValue(Object value) throws IllegalArgumentException {
        if (value == null) {
            assert (false);
            throw Util.illegalNull("value");
        }
        if (value instanceof String) {
            return this.matchesString((String)value);
        }
        switch (this.m_op) {
            case 60: 
            case 61: 
            case 62: 
            case 126: {
                if (this.m_value != null) break;
                assert (false);
                throw new IllegalStateException();
            }
            case 9: {
                return false;
            }
            default: {
                assert (false);
                throw new IllegalStateException();
            }
        }
        if (value instanceof Number) {
            if (value instanceof Integer || value instanceof Byte || value instanceof Short) {
                return this.matchesInt(((Number)value).intValue());
            }
            if (value instanceof Long) {
                return this.matchesLong((Long)value);
            }
            if (value instanceof Double) {
                return this.matchesDouble((Double)value);
            }
            if (value instanceof Float) {
                return this.matchesFloat(((Float)value).floatValue());
            }
        } else {
            if (value instanceof Character) {
                return this.matchesInt(((Character)value).charValue());
            }
            if (value instanceof Boolean) {
                return this.matchesBoolean((Boolean)value);
            }
        }
        Constructor<?> c = null;
        try {
            c = value.getClass().getConstructor(String.class);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (c == null) {
            return false;
        }
        LinkedHashSet<String> ourValues = new LinkedHashSet<String>();
        if (this.m_op == 126) {
            ourValues.add(this.m_value);
            ourValues.add(this.m_value.trim());
            String temp = this.m_value.toLowerCase();
            ourValues.add(temp);
            ourValues.add(temp.trim());
            temp = this.m_value.replaceAll(" \t\n\r\f", " ");
            ourValues.add(temp);
            ourValues.add(temp.trim());
        } else {
            ourValues.add(this.m_value);
        }
        for (String ourValue : ourValues) {
            Object ourConstructedValue = null;
            try {
                ourConstructedValue = c.newInstance(ourValue);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                // empty catch block
            }
            if (ourConstructedValue == null) continue;
            if (!(ourConstructedValue instanceof Comparable)) {
                return ourConstructedValue.equals(value);
            }
            try {
                int rc = ((Comparable)value).compareTo(ourConstructedValue);
                if (!this.matchesComparisonResult(rc)) continue;
                return true;
            }
            catch (ClassCastException e) {
            }
        }
        return false;
    }

    private boolean matchesString(String value) {
        String remainingValue;
        if (value == null) {
            assert (false);
            throw Util.illegalNull("value");
        }
        assert (this.m_op == 61 || this.m_op == 126 || this.m_op == 62 || this.m_op == 60 || this.m_op == 9);
        if (this.m_op == 9 ? this.m_middle == null : this.m_value == null) {
            assert (false);
            throw new IllegalStateException();
        }
        if (this.m_op == 126) {
            return Filter.removeWhitespace(value).equalsIgnoreCase(Filter.removeWhitespace(this.m_value));
        }
        boolean ignoreCase = false;
        String attr = this.m_attr.trim();
        if (attr.equalsIgnoreCase("org.osgi.framework.processor") || attr.equalsIgnoreCase("org.osgi.framework.os.name")) {
            ignoreCase = true;
        }
        if (this.m_op != 9) {
            String b;
            String a = ignoreCase ? value.trim() : value;
            String string = b = ignoreCase ? this.m_value.trim() : this.m_value;
            if (this.m_op == 61) {
                return ignoreCase ? a.equalsIgnoreCase(b) : a.equals(b);
            }
            if (this.m_op == 62 || this.m_op == 60) {
                return this.matchesComparisonResult(ignoreCase ? a.compareToIgnoreCase(b) : a.compareTo(b));
            }
            assert (false);
            throw new IllegalStateException();
        }
        String string = remainingValue = ignoreCase ? value.toLowerCase() : value;
        if (this.m_finish != null) {
            if (!remainingValue.endsWith(ignoreCase ? this.m_finish.toLowerCase() : this.m_finish)) {
                return false;
            }
            remainingValue = remainingValue.substring(0, remainingValue.length() - this.m_finish.length());
        }
        int pos = 0;
        if (this.m_value != null) {
            if (!remainingValue.startsWith(ignoreCase ? this.m_value.toLowerCase() : this.m_value)) {
                return false;
            }
            pos = this.m_value.length();
        }
        for (int i = 0; i < this.m_middle.length; ++i) {
            String m = this.m_middle[i];
            int loc = remainingValue.indexOf(ignoreCase ? m.toLowerCase() : m, pos);
            if (loc < 0) {
                return false;
            }
            pos = loc + m.length();
        }
        return true;
    }

    private static String removeWhitespace(String s) {
        if (s == null) {
            return null;
        }
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            StringBuffer b = new StringBuffer(s.length() - 1);
            if (i > 0) {
                b.append(s.substring(0, i));
            }
            ++i;
            while (i < n) {
                char c = s.charAt(i);
                if (!Character.isWhitespace(c)) {
                    b.append(c);
                }
                ++i;
            }
            return b.toString();
        }
        return s;
    }

    private boolean matchesInt(int value) {
        int n;
        assert (this.m_op == 61 || this.m_op == 126 || this.m_op == 62 || this.m_op == 60);
        String temp = this.m_value.trim();
        try {
            Number num = NumberFormat.getNumberInstance().parse(temp);
            n = num.intValue();
        }
        catch (ParseException e) {
            try {
                n = Integer.parseInt(temp);
            }
            catch (NumberFormatException e2) {
                return false;
            }
        }
        return value == n || this.m_op == (value < n ? (byte)60 : 62);
    }

    private boolean matchesLong(long value) {
        long n;
        assert (this.m_op == 61 || this.m_op == 126 || this.m_op == 62 || this.m_op == 60);
        String temp = this.m_value.trim();
        try {
            Number num = NumberFormat.getNumberInstance().parse(temp);
            n = num.longValue();
        }
        catch (ParseException e) {
            try {
                n = Long.parseLong(temp);
            }
            catch (NumberFormatException e2) {
                return false;
            }
        }
        return value == n || this.m_op == (value < n ? (byte)60 : 62);
    }

    private boolean matchesDouble(double value) {
        double n;
        assert (this.m_op == 61 || this.m_op == 126 || this.m_op == 62 || this.m_op == 60);
        String temp = this.m_value.trim();
        try {
            Number num = NumberFormat.getNumberInstance().parse(temp);
            n = num.doubleValue();
        }
        catch (ParseException e) {
            try {
                n = Double.parseDouble(temp);
            }
            catch (NumberFormatException e2) {
                return false;
            }
        }
        if (this.m_op == 61) {
            return Math.abs((value - n) / n) <= 3.0E-16;
        }
        if (this.m_op == 126) {
            return Math.abs((value - n) / n) <= (double)1.0E-5f;
        }
        return this.m_op == (value < n ? (byte)60 : 62);
    }

    private boolean matchesFloat(float value) {
        float n;
        assert (this.m_op == 61 || this.m_op == 126 || this.m_op == 62 || this.m_op == 60);
        String temp = this.m_value.trim();
        try {
            Number num = NumberFormat.getNumberInstance().parse(temp);
            n = num.floatValue();
        }
        catch (ParseException e) {
            try {
                n = Float.parseFloat(temp);
            }
            catch (NumberFormatException e2) {
                return false;
            }
        }
        if (this.m_op == 61) {
            return (double)Math.abs((value - n) / n) <= (double)2.0E-6f;
        }
        if (this.m_op == 126) {
            return Math.abs((value - n) / n) <= 1.0E-5f;
        }
        return this.m_op == (value < n ? (byte)60 : 62);
    }

    private boolean matchesBoolean(boolean value) {
        assert (this.m_op == 61 || this.m_op == 126 || this.m_op == 62 || this.m_op == 60);
        String expected = value ? "true" : "false";
        String s = this.m_op == 126 ? this.m_value.trim() : this.m_value;
        return s.equalsIgnoreCase(expected);
    }

    private boolean matchesComparisonResult(int rc) {
        switch (this.m_op) {
            case 61: 
            case 126: {
                return rc == 0;
            }
            case 62: {
                return rc >= 0;
            }
            case 60: {
                return rc <= 0;
            }
        }
        assert (false);
        throw new IllegalStateException();
    }
}

