/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.admin.backup.rest.model;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.sas.commons.rest.util.Timestamp;
import com.sas.svcs.admin.backup.rest.BackupController;
import com.sas.svcs.admin.backup.rest.model.BackupHostDetail;
import com.sas.svcs.backup.client.BackupSourceDetails;
import com.sas.svcs.backup.client.OperationDetails;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Date;
import java.util.List;

@JsonPropertyOrder(value={"id", "name", "type", "status", "comment", "scheduled", "runBy", "startTimeStamp", "endTimeStamp", "errorMessage"})
@XmlRootElement(name="details")
public class OperationDetailedData {
    OperationDetails operationDetails;

    public OperationDetailedData() {
    }

    public OperationDetailedData(OperationDetails backupDetails) {
        this.operationDetails = backupDetails;
    }

    @XmlElement
    public String getComment() {
        return this.operationDetails.getComment();
    }

    @XmlElement
    public String getId() {
        return this.operationDetails.getName();
    }

    @XmlElement
    public String getName() {
        return this.operationDetails.getSlug();
    }

    @XmlElement
    public String getType() {
        return this.operationDetails.getType().toLowerCase();
    }

    @XmlElement
    public String getStartTimeStamp() {
        Date startDate = this.operationDetails.getStartTime();
        if (startDate != null) {
            return Timestamp.timestamp((Date)startDate);
        }
        return null;
    }

    @XmlElement
    public String getEndTimeStamp() {
        Date endDate = this.operationDetails.getEndTime();
        if (endDate != null) {
            return Timestamp.timestamp((Date)endDate);
        }
        return null;
    }

    @XmlElement
    public String getStatus() {
        String status = this.operationDetails.getStatus().toString();
        return BackupController.serviceSideStatusConstants.valueOf(status).toString();
    }

    @XmlElement
    public String getRunBy() {
        return this.operationDetails.getRunBy();
    }

    protected void updateIncludedPaths(BackupSourceDetails srcDetail, BackupHostDetail temp) {
        List includedPaths = srcDetail.getConfigurablePaths();
        if (includedPaths != null && !includedPaths.isEmpty()) {
            temp.setIncludedPaths(includedPaths);
        }
    }
}

