/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.admin.backup.rest.model;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.sas.commons.rest.links.Link;
import com.sas.commons.rest.links.Links;
import com.sas.svcs.admin.backup.rest.BackupController;
import com.sas.svcs.backup.client.BackupSchedule;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;

@JsonPropertyOrder(value={"dayOfWeek", "time", "id", "links"})
@XmlRootElement(name="schedule")
public class BackupScheduleMapper {
    private BackupSchedule backupSchedule;
    public boolean inValidInput = false;
    private Links links = new Links();

    public BackupScheduleMapper() {
    }

    public BackupScheduleMapper(BackupSchedule backupSchedule) {
        this.backupSchedule = backupSchedule;
    }

    public BackupSchedule readBackupSchedule() {
        if (this.backupSchedule == null) {
            this.backupSchedule = new BackupSchedule();
        }
        return this.backupSchedule;
    }

    @XmlElementWrapper(name="links")
    @XmlElement(name="link")
    public List<Link> getLinks() {
        return this.links.getLinks();
    }

    public void setLinks(List<Link> links) {
        this.links = new Links(links);
    }

    public BackupScheduleMapper(String dayOfWeek, String time) {
        this.setDayOfWeek(dayOfWeek);
        this.setTime(time);
    }

    public BackupScheduleMapper(String day, String hour, String min) {
        this.setDayOfWeek(day);
        this.setTime(hour + ":" + min);
    }

    @XmlElement
    public String getTime() {
        int hour = this.readBackupSchedule().getHour();
        int min = this.readBackupSchedule().getMinute();
        String time = "";
        if (hour == 0) {
            time = "00:";
        } else {
            if (hour > 0 && hour < 10) {
                time = "0";
            }
            time = time + hour + ":";
        }
        if (min == 0) {
            time = time + "00";
        } else {
            if (min > 0 && min < 10) {
                time = time + "0";
            }
            time = time + min;
        }
        return time;
    }

    public void setTime(String time) {
        if (time != null && !time.equals("")) {
            String[] timeSplits = time.split(":");
            if (timeSplits.length == 2) {
                this.readBackupSchedule().setHour(Integer.parseInt(timeSplits[0]));
                this.readBackupSchedule().setMinute(Integer.parseInt(timeSplits[1]));
            } else {
                this.inValidInput = true;
            }
        }
    }

    public void setDayOfWeek(String dayOfWeek) {
        BackupSchedule.DayOfWeek day = null;
        if (dayOfWeek != null && !dayOfWeek.equals("")) {
            BackupSchedule.DayOfWeek[] validDays;
            BackupController.serviceSideConstants[] dayConstants;
            for (BackupController.serviceSideConstants validDay : dayConstants = BackupController.serviceSideConstants.values()) {
                if (!validDay.name().equals(dayOfWeek.toLowerCase())) continue;
                dayOfWeek = BackupController.serviceSideConstants.valueOf(dayOfWeek).toString();
            }
            for (BackupSchedule.DayOfWeek validDay : validDays = BackupSchedule.DayOfWeek.values()) {
                if (!validDay.name().equals(dayOfWeek.toUpperCase())) continue;
                day = BackupSchedule.DayOfWeek.valueOf((String)dayOfWeek.toUpperCase());
            }
            this.readBackupSchedule().setDayOfWeek(day);
        }
    }

    @XmlElement
    public String getDayOfWeek() {
        return this.readBackupSchedule().getDayOfweek().getDisplayName();
    }

    @XmlElement
    public String getId() {
        String day = this.getDayOfWeek();
        String dayId = null;
        if (day != null) {
            dayId = day.substring(0, 3).toLowerCase();
            String time = this.getTime();
            if (time != null) {
                time = time.replace(":", "");
            }
            return dayId + time;
        }
        return null;
    }
}

