/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.admin.backup.rest.model;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.sas.svcs.admin.backup.rest.BackupController;
import com.sas.svcs.backup.client.BackupOptions;
import com.sas.svcs.backup.client.BackupSourceConfig;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@JsonPropertyOrder(value={"name", "comment", "configurationId", "exclude", "reorganizeRepositories"})
@XmlRootElement(name="backupOptions")
public class BackupOptionsMapper {
    private String configurationId = "default";
    private BackupOptions backupOptions;

    @XmlElement
    public String getName() {
        return this.getBackupOptions().getBackupSlugName();
    }

    public void setName(String name) {
        this.getBackupOptions().setBackupSlugName(name);
    }

    public BackupOptionsMapper() {
    }

    public BackupOptionsMapper(BackupOptions backupOptions) {
        this.backupOptions = backupOptions;
    }

    @XmlElement
    public BackupOptions getBackupOptions() {
        if (this.backupOptions == null) {
            this.backupOptions = new BackupOptions();
        }
        return this.backupOptions;
    }

    public List<String> getExclude() {
        List excludedSources = this.getBackupOptions().getExcludeFilter();
        ArrayList<String> excludedSourceNames = null;
        for (BackupSourceConfig.BackupSource source : excludedSources) {
            if (excludedSourceNames == null) {
                excludedSourceNames = new ArrayList<String>();
            }
            excludedSourceNames.add(source.name());
        }
        return excludedSourceNames;
    }

    public void setExclude(List<String> exclude) {
        ArrayList<BackupSourceConfig.BackupSource> excludeFilters = new ArrayList<BackupSourceConfig.BackupSource>();
        if (exclude != null && exclude.size() > 0) {
            for (String filter : exclude) {
                excludeFilters.add(BackupSourceConfig.BackupSource.valueOf((String)BackupController.serviceSideConstants.valueOf(filter.toLowerCase()).toString()));
            }
            if (excludeFilters.size() > 0) {
                this.getBackupOptions().setExcludeFilter(excludeFilters);
            }
        }
    }

    @XmlElement
    public String getComment() {
        return this.getBackupOptions().getComment();
    }

    public void setComment(String comment) {
        this.getBackupOptions().setComment(comment);
    }

    @XmlElement
    public boolean isReorganizeRepositories() {
        return this.getBackupOptions().isReorganizeRepositories();
    }

    public void setReorganizeRepositories(boolean reorganizeRepositories) {
        this.getBackupOptions().setReorganizeRepositories(reorganizeRepositories);
    }

    @XmlElement
    public String getConfigurationId() {
        return this.configurationId;
    }

    public void setConfigurationId(String configurationId) {
        this.configurationId = configurationId;
    }
}

