/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.admin.backup.rest.model;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.sas.commons.rest.links.Link;
import com.sas.commons.rest.links.Links;
import com.sas.commons.rest.util.Timestamp;
import com.sas.svcs.admin.backup.rest.BackupController;
import com.sas.svcs.admin.backup.rest.model.BackupHostDetail;
import com.sas.svcs.admin.backup.rest.model.BackupSourceDetail;
import com.sas.svcs.admin.backup.rest.model.BackupSourceEntryDetail;
import com.sas.svcs.admin.backup.rest.model.BackupSourceInstanceDetails;
import com.sas.svcs.admin.backup.rest.model.OperationDetailedData;
import com.sas.svcs.backup.client.BackupDetails;
import com.sas.svcs.backup.client.BackupSourceDetails;
import com.sas.svcs.backup.client.BackupSourceEntryDetails;
import com.sas.svcs.backup.client.OperationDetails;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonPropertyOrder(value={"id", "name", "type", "status", "size", "comment", "scheduled", "runBy", "startTimeStamp", "endTimeStamp", "purged", "expiredDate", "verifiedDate", "errorMessage", "backupSources", "links"})
@XmlRootElement(name="backupDetails")
public class BackupDetailedData
extends OperationDetailedData {
    private Links links = new Links();

    public BackupDetailedData() {
    }

    public BackupDetailedData(OperationDetails backupDetails) {
        super(backupDetails);
        Links links = new Links();
        Link link = new Link("get", "configurations", "/configurations/default");
        links.add(link);
        link = new Link("post", "backupAsynchronously", "/backups/jobs");
        link.setType("application/vnd.sas.admin.backup.request+json");
        links.add(link);
        link = new Link("post", "backup", "/backups");
        link.setType("application/vnd.sas.admin.backup.request+json");
        links.add(link);
        if (backupDetails.getName() != null) {
            link = new Link("post", "restore", "/restores?backupId=" + backupDetails.getName());
            link.setType("application/vnd.sas.admin.restore.request");
            links.add(link);
        }
        this.setLinks(links.getLinks());
    }

    @XmlElementWrapper(name="links")
    @XmlElement(name="link")
    public List<Link> getLinks() {
        return this.links.getLinks();
    }

    public void setLinks(List<Link> links) {
        this.links = new Links(links);
    }

    @XmlElement
    public long getSize() {
        long size = this.operationDetails.getSize();
        return size;
    }

    @XmlElement
    public Boolean isPurged() {
        OperationDetails.OperationStatus oprStatus = this.operationDetails.getStatus();
        if (oprStatus != null && oprStatus != OperationDetails.OperationStatus.NOT_STARTED) {
            return ((BackupDetails)this.operationDetails).isOffline();
        }
        return null;
    }

    @XmlElement
    public String getExpiredDate() {
        Date expiredDate = ((BackupDetails)this.operationDetails).getExpiredDate();
        if (expiredDate != null) {
            return Timestamp.timestamp((Date)expiredDate);
        }
        return null;
    }

    @XmlElement
    public String getVerifiedDate() {
        Date verifiedDate = ((BackupDetails)this.operationDetails).getVerifiedDate();
        if (verifiedDate != null) {
            return Timestamp.timestamp((Date)verifiedDate);
        }
        return null;
    }

    @XmlElement
    public Collection<BackupSourceDetail> getBackupSources() {
        List sourceDetails = this.operationDetails.getSourceDetails();
        LinkedList<BackupSourceDetail> srcDets = new LinkedList<BackupSourceDetail>();
        HashMap<String, List<BackupHostDetail>> hostsForSource = new HashMap<String, List<BackupHostDetail>>();
        for (BackupSourceDetails srcDetail : sourceDetails) {
            List hosts = null;
            String souceType = srcDetail.getSourceConfig().getSourceType().getDisplayName();
            BackupHostDetail temp = null;
            hosts = !hostsForSource.containsKey(souceType) ? new LinkedList() : (List)hostsForSource.get(souceType);
            temp = new BackupHostDetail(srcDetail.getSourceConfig().getBackupSourceNode());
            temp.setSize(srcDetail.getSize());
            temp.setBackupLocation(srcDetail.getBackupLocation());
            temp.setLogFilePath(srcDetail.getLogFilePath());
            this.updateSourceInstanceDetails(srcDetail, temp);
            this.updateIncludedPaths(srcDetail, temp);
            if (srcDetail.getStatus() != null) {
                BackupController.serviceSideStatusConstants tempsts = BackupController.serviceSideStatusConstants.valueOf(srcDetail.getStatus().toString());
                if (tempsts != null) {
                    temp.setStatus(tempsts.toString());
                } else {
                    temp.setStatus(BackupController.serviceSideStatusConstants.UNKNOWN.toString());
                }
            }
            hosts.add(temp);
            this.updateHostsForSourceMap(hostsForSource, hosts, souceType);
        }
        if (sourceDetails != null) {
            HashSet<String> srcTypes = new HashSet<String>();
            for (BackupSourceDetails sourceDetail : sourceDetails) {
                if (srcTypes.contains(sourceDetail.getSourceConfig().getSourceType().getDisplayName())) continue;
                BackupSourceDetail srcDet = new BackupSourceDetail(sourceDetail);
                srcDet.setHosts((Collection)hostsForSource.get(srcDet.getSourceType()));
                srcDets.add(srcDet);
                srcTypes.add(srcDet.getSourceType());
            }
        }
        return srcDets;
    }

    private void updateHostsForSourceMap(Map<String, List<BackupHostDetail>> hostsForSource, List<BackupHostDetail> hosts, String souceType) {
        if (hostsForSource.get(souceType) != null) {
            hostsForSource.remove(souceType);
        }
        hostsForSource.put(souceType, hosts);
    }

    private void updateSourceInstanceDetails(BackupSourceDetails srcDetail, BackupHostDetail temp) {
        Map instanceDetails = srcDetail.getSourceInstances();
        if (instanceDetails != null) {
            Set keys = instanceDetails.keySet();
            LinkedList<BackupSourceInstanceDetails> instancesCollection = new LinkedList<BackupSourceInstanceDetails>();
            for (String key : keys) {
                LinkedList<BackupSourceEntryDetail> srcEntryDets = new LinkedList<BackupSourceEntryDetail>();
                com.sas.svcs.backup.client.BackupSourceInstanceDetails instanceDetail = (com.sas.svcs.backup.client.BackupSourceInstanceDetails)instanceDetails.get(key);
                BackupSourceInstanceDetails tempInstance = new BackupSourceInstanceDetails(instanceDetail.getInstanceName(), instanceDetail.getHost(), instanceDetail.getPort());
                List sourceEntries = instanceDetail.getSourceEntries();
                if (sourceEntries != null && !sourceEntries.isEmpty()) {
                    for (BackupSourceEntryDetails sourceEntry : sourceEntries) {
                        if (instanceDetail.getBackupHoldingNode() == null || !BackupServiceUtils.isHostsEqual((String)instanceDetail.getBackupHoldingNode(), (String)temp.getHostName())) continue;
                        BackupSourceEntryDetail srcEntry = new BackupSourceEntryDetail(sourceEntry);
                        srcEntryDets.add(srcEntry);
                    }
                    tempInstance.setSourceEntries(srcEntryDets);
                }
                instancesCollection.add(tempInstance);
            }
            temp.setSourceInstances(instancesCollection);
        }
    }

    @XmlElement
    public Boolean isScheduled() {
        OperationDetails.OperationStatus oprStatus = this.operationDetails.getStatus();
        if (oprStatus != null && oprStatus != OperationDetails.OperationStatus.NOT_STARTED) {
            return this.operationDetails.isScheduled();
        }
        return null;
    }
}

