/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.admin.backup.rest;

import com.sas.svcs.admin.backup.rest.BackupSourceValidator;
import com.sas.svcs.admin.backup.rest.DefaultConfigurableServerValidator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ValidatorFactory {
    private static final Logger logger = LogManager.getLogger(ValidatorFactory.class);
    @Autowired
    private ApplicationContext applicationContext;

    public BackupSourceValidator getValidator(String sourcetype) {
        BackupSourceValidator validator = null;
        String type = sourcetype + "Validator";
        try {
            validator = (BackupSourceValidator)this.applicationContext.getBean(type.toLowerCase(), DefaultConfigurableServerValidator.class);
        }
        catch (BeansException e) {
            logger.info("Support service not fount" + type);
        }
        if (validator == null) {
            validator = (BackupSourceValidator)this.applicationContext.getBean("defaultvalidator", DefaultConfigurableServerValidator.class);
        }
        return validator;
    }
}

