/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.admin.backup.rest;

import com.sas.svcs.admin.backup.rest.BackupSourceValidator;
import com.sas.svcs.admin.backup.rest.RB;
import com.sas.svcs.admin.backup.rest.model.BackupErrorData;
import com.sas.svcs.admin.backup.rest.model.ConfigurableServerProxyData;
import com.sas.svcs.backup.client.BackupService;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.ConfigurableServerProxy;
import com.sas.svcs.backup.client.SASTierProxy;
import com.sas.svcs.backup.client.SASTiers;
import com.sas.svcs.backup.client.UserConfigurationServiceInterface;
import com.sas.svcs.backup.client.UserSourceConfiguration;
import com.sas.svcs.deployment.DeploymentDiscoveryService;
import com.sas.svcs.deployment.dao.DeploymentDiscoveryDAO;
import com.sas.svcs.deployment.data.ConfigurableServer;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="defaultvalidator")
public class DefaultConfigurableServerValidator
implements BackupSourceValidator {
    @Autowired
    @Qualifier(value="BackupService")
    protected BackupService backupService;
    @Autowired
    @Qualifier(value="UserConfigurationService")
    private UserConfigurationServiceInterface userConfService;
    protected BackupSourceConfig.BackupSource source;
    UserSourceConfiguration userConfigProxy;
    @Autowired
    private DeploymentDiscoveryService discoveryService;

    protected void init(BackupSourceConfig.BackupSource source) {
        this.source = source;
        this.userConfigProxy = this.userConfService.getSourceConfig(source);
    }

    @Override
    public BackupErrorData validatePost(ConfigurableServerProxyData data) {
        List proxies;
        BackupErrorData error = null;
        if (data.getName() == null) {
            error = new BackupErrorData(404, RB.getStringResource("BackupConfigController.invalid.Name.txt"), "BackupConfigController.invalid.Name.txt", RB.getStringResource("BackupConfigController.check.invalid.Name.txt"), "BackupConfigController.check.invalid.Name.txt");
            return error;
        }
        String tierId = data.getSasTierId();
        if (tierId == null) {
            error = new BackupErrorData(404, RB.getStringResource("BackupConfigController.invalid.tier.txt"), "BackupConfigController.invalid.tier.txt", RB.getStringResource("BackupConfigController.check.invalid.tier.txt"), "BackupConfigController.check.invalid.tier.txt");
            return error;
        }
        SASTierProxy tier = null;
        SASTiers sasTiers = this.userConfService.getSASTiers();
        if (sasTiers != null && (proxies = sasTiers.getSasTiers()) != null && proxies.size() > 0) {
            for (SASTierProxy testProxy : proxies) {
                if (!tierId.equals(testProxy.getTierName())) continue;
                tier = testProxy;
                break;
            }
        }
        if (tier == null) {
            error = new BackupErrorData(404, RB.getStringResource("BackupConfigController.invalid.tier.txt"), "BackupConfigController.invalid.tier.txt", RB.getStringResource("BackupConfigController.check.invalid.tier.txt"), "BackupConfigController.check.invalid.tier.txt");
            return error;
        }
        return error;
    }

    @Override
    public BackupErrorData validatePut(ConfigurableServerProxyData data) {
        BackupErrorData error = null;
        String tierId = data.getSasTierId();
        if (tierId != null) {
            List proxies;
            SASTierProxy tier = null;
            SASTiers sasTiers = this.userConfService.getSASTiers();
            if (sasTiers != null && (proxies = sasTiers.getSasTiers()) != null && proxies.size() > 0) {
                for (SASTierProxy testProxy : proxies) {
                    if (!tierId.equals(testProxy.getTierName())) continue;
                    tier = testProxy;
                    break;
                }
            }
            if (tier == null) {
                error = new BackupErrorData(404, RB.getStringResource("BackupConfigController.invalid.tier.txt"), "BackupConfigController.invalid.tier.txt", RB.getStringResource("BackupConfigController.check.invalid.tier.txt"), "BackupConfigController.check.invalid.tier.txt");
            }
        }
        if (this.userConfigProxy != null && !this.isObjectExist(this.userConfigProxy.getConfigurableServers(), data.getId())) {
            error = new BackupErrorData(404, RB.getStringResource("BackupConfigController.no.source.config.found.txt"), "BackupConfigController.no.source.config.found.txt", RB.getStringResource("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt");
            return error;
        }
        return error;
    }

    @Override
    public BackupErrorData validateDelete(String Id) {
        BackupErrorData error = null;
        if (!this.isObjectExist(this.userConfigProxy.getConfigurableServers(), Id)) {
            error = new BackupErrorData(404, RB.getStringResource("BackupConfigController.no.source.config.found.txt"), "BackupConfigController.no.source.config.found.txt", RB.getStringResource("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt");
            return error;
        }
        return error;
    }

    public boolean isObjectExist(List<ConfigurableServerProxy> configurableServers, String id) {
        Boolean isPresent = false;
        if (configurableServers != null && configurableServers.size() > 0) {
            for (ConfigurableServerProxy proxy : configurableServers) {
                if (!proxy.getId().equalsIgnoreCase(id)) continue;
                isPresent = true;
                break;
            }
        }
        return isPresent;
    }

    public boolean isPostInstanceExist(List<ConfigurableServerProxy> configurableServers, String id) {
        Boolean isPresent = false;
        if (configurableServers != null && configurableServers.size() > 0) {
            for (ConfigurableServerProxy proxy : configurableServers) {
                if (!proxy.getName().equalsIgnoreCase(id)) continue;
                isPresent = true;
                break;
            }
        }
        return isPresent;
    }

    public boolean isPresentInDiscovery(String name, BackupSourceConfig.BackupSource backupSource) {
        boolean isExistInMetadata = false;
        DeploymentDiscoveryDAO.ComponentType[] componentTypes = backupSource.getComponentTypes();
        List<ConfigurableServer> discovered = this.getConfigurableServers(componentTypes);
        if (discovered != null && discovered.size() > 0) {
            for (ConfigurableServer server : discovered) {
                if (!server.getObjectName().equalsIgnoreCase(name)) continue;
                isExistInMetadata = true;
                break;
            }
        }
        return isExistInMetadata;
    }

    private List<ConfigurableServer> getConfigurableServers(DeploymentDiscoveryDAO.ComponentType[] componentTypes) {
        ArrayList configServers = null;
        if (componentTypes != null) {
            configServers = new ArrayList();
            for (DeploymentDiscoveryDAO.ComponentType type : componentTypes) {
                List servers = this.discoveryService.getConfigurableServers(type);
                if (servers == null) continue;
                configServers.addAll(servers);
            }
        }
        return configServers;
    }
}

