/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.admin.backup.rest;

import com.sas.commons.rest.links.Link;
import com.sas.commons.rest.links.Links;
import com.sas.commons.rest.util.Collection;
import com.sas.commons.rest.util.ResourceCollection;
import com.sas.svcs.admin.backup.rest.RBUtils;
import com.sas.svcs.admin.backup.rest.ServiceAccessControlUtil;
import com.sas.svcs.admin.backup.rest.model.BackupDetailedData;
import com.sas.svcs.admin.backup.rest.model.BackupErrorData;
import com.sas.svcs.admin.backup.rest.model.BackupErrorDetailsData;
import com.sas.svcs.admin.backup.rest.model.BackupHistoryData;
import com.sas.svcs.admin.backup.rest.model.BackupOptionsMapper;
import com.sas.svcs.admin.backup.rest.model.BackupResultData;
import com.sas.svcs.admin.backup.rest.model.BackupScheduleMapper;
import com.sas.svcs.admin.backup.rest.model.OperationContentsDetailsData;
import com.sas.svcs.admin.backup.rest.model.OperationStatusData;
import com.sas.svcs.admin.backup.rest.model.Schedules;
import com.sas.svcs.backup.client.BackupDetails;
import com.sas.svcs.backup.client.BackupOptions;
import com.sas.svcs.backup.client.BackupSchedule;
import com.sas.svcs.backup.client.BackupService;
import com.sas.svcs.backup.client.BackupServiceResult;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.OperationDetails;
import com.sas.svcs.backup.common.definitions.BackupErrorDetails;
import com.sas.svcs.backup.common.definitions.BackupErrorEntry;
import com.sas.svcs.backup.common.definitions.BackupErrorLogger;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.text.Message;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class BackupController {
    private BackupService backupService;
    protected static String username;
    protected static String password;
    protected static String myFolder;
    public static ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="BackupErrorXmlLogger")
    BackupErrorLogger backupErrorXmlLogger;
    @Autowired
    RBUtils rbUtils;
    @Autowired
    ServiceAccessControlUtil accessControlUtil;

    @Autowired
    public void setBackupService(@Qualifier(value="BackupService") BackupService backupService) {
        this.backupService = backupService;
    }

    @RequestMapping(value={"/rest/backups/jobs"}, method={RequestMethod.POST}, produces={"application/vnd.sas.admin.backup.job+json", "application/vnd.sas.admin.backup.job+xml"}, consumes={"application/vnd.sas.admin.backup.request+json", "application/vnd.sas.admin.backup.request+xml"})
    public ResponseEntity<?> asyncBackup(@RequestBody BackupOptionsMapper options) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        BackupOptions opts = options.getBackupOptions();
        opts.setAsynchronous(true);
        return this.backup(opts);
    }

    @RequestMapping(value={"/rest/backups"}, method={RequestMethod.POST}, produces={"application/vnd.sas.admin.backup+json", "application/vnd.sas.admin.backup+xml"}, consumes={"application/vnd.sas.admin.backup.request+json", "application/vnd.sas.admin.backup.request+xml"})
    public ResponseEntity<?> backup(@RequestBody BackupOptionsMapper options) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        BackupOptions opts = options.getBackupOptions();
        return this.backup(opts);
    }

    private ResponseEntity<?> backup(BackupOptions opts) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        String name = opts.getBackupSlugName();
        OperationDetails backupRecoveryDetails = null;
        BackupServiceResult backupResult = null;
        try {
            if (name != null && !name.equals("")) {
                backupResult = this.backupService.getBackupBySlugName(name);
                if (backupResult != null && backupResult.getActualResult() != null) {
                    return new ResponseEntity((Object)new BackupErrorData(409, this.rbUtils.getPropertyValueFromRB("BackupController.existing.slugname.for.backup.txt"), "BackupController.existing.slugname.for.backup.txt", this.rbUtils.getPropertyValueFromRB("BackupController.provide.nonexisting.backup.slug.txt"), "BackupController.provide.nonexisting.backup.slug.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.CONFLICT);
                }
                if (this.validateOperationName(name)) {
                    opts.setBackupSlugName(name);
                } else {
                    return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupController.operation.name.invalid.txt"), "BackupController.operation.name.invalid.txt", this.rbUtils.getPropertyValueFromRB("BackupController.check.the.valid.operation.name.format.txt"), "BackupController.check.the.valid.operation.name.format.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.BAD_REQUEST);
                }
            }
            if ((backupResult = this.backupService.startBackup(opts)) != null) {
                backupRecoveryDetails = (OperationDetails)backupResult.getActualResult();
                if (opts.isAsynchronous() && backupRecoveryDetails != null && backupRecoveryDetails.getStatus().equals((Object)OperationDetails.OperationStatus.INPROGRESS)) {
                    responseHeaders.add("Content-Location", "/backups/jobs/" + backupRecoveryDetails.getName());
                    OperationDetails.OperationStatus status = backupRecoveryDetails.getStatus();
                    OperationStatusData statusData = new OperationStatusData(backupRecoveryDetails.getName(), status);
                    Links links = new Links();
                    Link link = new Link("get", "self", "/backups/jobs/" + backupRecoveryDetails.getName());
                    link.setType("application/vnd.sas.admin.backup.job");
                    links.add(link);
                    statusData.setLinks(links.getLinks());
                    return new ResponseEntity(new BackupResultData(backupResult, statusData), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.ACCEPTED);
                }
            }
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupController.find.detail.cause.in.mid.tier.log.txt"), "BackupController.find.detail.cause.in.mid.tier.log.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(new BackupResultData(backupResult, new BackupDetailedData(backupRecoveryDetails)), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.CREATED);
    }

    @RequestMapping(value={"/rest/backups"}, method={RequestMethod.GET}, produces={"application/vnd.sas.collection+xml", "application/vnd.sas.collection+json"})
    public ResponseEntity<?> getAllBackups(@RequestParam(value="start", required=false) Integer start, @RequestParam(value="limit", required=false) Integer limit) {
        BackupServiceResult backupServiceResult;
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        responseHeaders.add("Cache-Control", "no-cache, no-store");
        List his = null;
        try {
            backupServiceResult = this.backupService.getAllHistory();
            his = backupServiceResult == null ? null : (List)backupServiceResult.getActualResult();
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupController.internal.server.error.fmt"), (Object)e.getCause()), "BackupController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupController.find.detail.cause.in.mid.tier.log.txt"), "BackupController.find.detail.cause.in.mid.tier.log.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        if (backupServiceResult != null && backupServiceResult.getErrorDetails() != null) {
            BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupServiceResult.getErrorDetails());
            return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (his == null) {
            return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupController.history.file.not.found.txt"), "BackupController.history.file.not.found.txt", this.rbUtils.getPropertyValueFromRB("BackupController.history.file.not.found.check.backup.ws.dir.txt"), "BackupController.history.file.not.found.check.backup.ws.dir.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (start == null) {
            start = 1;
            if (limit == null) {
                limit = his.size();
            }
        } else if (limit == null) {
            limit = 10;
        }
        if (limit > his.size()) {
            limit = his.size();
        }
        LinkedList<OperationDetails> backupsHistory = new LinkedList<OperationDetails>();
        for (int i = 0; i < his.size(); ++i) {
            OperationDetails detail = (OperationDetails)his.get(i);
            if (!detail.getType().equals("Backup".toString())) continue;
            backupsHistory.add(detail);
        }
        if (start < 1 || backupsHistory.size() > 0 && start > backupsHistory.size()) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupController.history.invalid.start.index.txt"), "BackupController.history.invalid.start.index.txt", this.rbUtils.getPropertyValueFromRB("BackupController.history.please.check.invalid.start.index.txt"), "BackupController.history.please.check.invalid.start.index.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (backupsHistory.size() > 0 && limit < 1) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupController.history.invalid.limit.txt"), "BackupController.history.invalid.limit.txt", this.rbUtils.getPropertyValueFromRB("BackupController.history.please.check.invalid.limit.value.txt"), "BackupController.history.please.check.invalid.limit.value.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        LinkedList<BackupHistoryData> history = null;
        history = new LinkedList<BackupHistoryData>();
        int cnt = 0;
        for (int i = start.intValue(); cnt < limit && i <= backupsHistory.size(); ++i) {
            OperationDetails detail = (OperationDetails)backupsHistory.get(i - 1);
            if (!detail.getType().equals("Backup".toString())) continue;
            history.add(new BackupHistoryData(detail));
            ++cnt;
        }
        Links links = null;
        if (backupsHistory.size() > 0) {
            if (limit > backupsHistory.size()) {
                limit = backupsHistory.size();
            }
            links = this.getPaginationLinks(start, limit, "/backups", backupsHistory.size() + 1);
        } else {
            links = new Links();
            links.setLinks(new ArrayList());
        }
        Link backupLink = new Link(HttpMethod.POST.name(), "start backup", "/backups");
        backupLink.setType("application/vnd.sas.admin.backup.request");
        links.add(backupLink);
        Link link = new Link(HttpMethod.POST.name(), "start async backup", "/backups/jobs");
        link.setType("application/vnd.sas.admin.backup.job");
        links.add(link);
        ResourceCollection coll = new ResourceCollection(history, Long.valueOf(start.intValue()), limit, Long.valueOf(history.size()), links, "application/vnd.sas.admin.backup+json", "BackupHistory");
        return new ResponseEntity((Object)coll, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/rest/backups/jobs/{id}"}, method={RequestMethod.GET}, produces={"application/vnd.sas.admin.backup.job+json", "application/vnd.sas.admin.backup.job+xml", "application/vnd.sas.admin.backup+json", "application/vnd.sas.admin.backup+xml"})
    public ResponseEntity<?> getStatusById(@PathVariable(value="id") String id) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        return this.getBackupStatus(id, "Name");
    }

    @RequestMapping(value={"/rest/backups/jobs"}, method={RequestMethod.GET}, produces={"application/vnd.sas.admin.backup.job+json", "application/vnd.sas.admin.backup.job+xml", "application/vnd.sas.admin.backup+json", "application/vnd.sas.admin.backup+xml"})
    public ResponseEntity<?> getStatusByName(@RequestParam(value="name") String name) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        return this.getBackupStatus(name, "Slug");
    }

    private ResponseEntity<?> getBackupStatus(String backupId, String identifier) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        OperationDetails.OperationStatus status = null;
        BackupServiceResult backupServiceResult = null;
        try {
            backupServiceResult = this.backupService.getStatus(backupId, "Backup", identifier);
            status = backupServiceResult == null ? null : (OperationDetails.OperationStatus)backupServiceResult.getActualResult();
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupController.find.detail.cause.in.mid.tier.log.txt"), "BackupController.find.detail.cause.in.mid.tier.log.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        if (backupServiceResult != null && backupServiceResult.getErrorDetails() != null) {
            BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupServiceResult.getErrorDetails());
            return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (status == null || backupId == null) {
            return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupController.no.operation.found.txt"), "BackupController.no.operation.found.txt", this.rbUtils.getPropertyValueFromRB("BackupController.please.check.operation.details.txt"), "BackupController.please.check.operation.details.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        OperationStatusData statusData = new OperationStatusData(backupId, status);
        Links links = new Links();
        Link link = null;
        if (identifier.equals("Slug")) {
            link = new Link("get", "self", "/backups?name=" + backupId);
            link.setType("application/vnd.sas.admin.backup");
        } else {
            link = new Link("get", "self", "/backups/" + backupId);
            link.setType("application/vnd.sas.admin.backup");
        }
        links.add(link);
        statusData.setLinks(links.getLinks());
        ArrayList<OperationStatusData> jobs = new ArrayList<OperationStatusData>();
        jobs.add(statusData);
        if (status != OperationDetails.OperationStatus.INPROGRESS) {
            responseHeaders.add("location", links.get(0).getHref());
            Collection collJobs = new Collection("Backup Jobs", jobs);
            return new ResponseEntity((Object)collJobs, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.SEE_OTHER);
        }
        responseHeaders.add("Content-Location", "/backups/jobs/" + backupId);
        Collection collJobs = new Collection("Backup Jobs", jobs);
        return new ResponseEntity((Object)collJobs, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/rest/backups/{id}"}, method={RequestMethod.GET}, produces={"application/vnd.sas.admin.backup+json", "application/vnd.sas.admin.backup+xml"})
    public ResponseEntity<?> getDetailsById(@PathVariable(value="id") String id) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        return this.getDetails(id, "Name");
    }

    @RequestMapping(value={"/rest/backups"}, method={RequestMethod.GET}, produces={"application/vnd.sas.admin.backup+json", "application/vnd.sas.admin.backup+xml"})
    public ResponseEntity<?> getDetailsByName(@RequestParam(value="name") String name) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        return this.getDetails(name, "Slug");
    }

    private ResponseEntity<?> getDetails(String backupId, String identifier) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        OperationDetails backupRecoveryDetails = null;
        BackupServiceResult backupServiceResult = null;
        try {
            backupServiceResult = this.backupService.getDetails(backupId, "Backup", identifier);
            backupRecoveryDetails = backupServiceResult == null ? null : (OperationDetails)backupServiceResult.getActualResult();
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupController.find.detail.cause.in.mid.tier.log.txt"), "BackupController.find.detail.cause.in.mid.tier.log.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        if (backupServiceResult != null && backupServiceResult.getErrorDetails() != null) {
            BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupServiceResult.getErrorDetails());
            return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (backupRecoveryDetails == null) {
            return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupController.no.operation.found.txt"), "BackupController.no.operation.found.txt", this.rbUtils.getPropertyValueFromRB("BackupController.please.check.operation.details.txt"), "BackupController.please.check.operation.details.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (backupRecoveryDetails instanceof BackupDetails) {
            return new ResponseEntity((Object)new BackupDetailedData(backupRecoveryDetails), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupController.no.operation.found.txt"), "BackupController.no.operation.found.txt", this.rbUtils.getPropertyValueFromRB("BackupController.please.check.operation.details.txt"), "BackupController.please.check.operation.details.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/rest/backups/{id}/{sourceType}/{host:.+}"}, method={RequestMethod.GET}, produces={"application/xml; charset=UTF-8", "application/json; charset=UTF-8"})
    public ResponseEntity<?> getContentDetailsForHost(@PathVariable(value="id") String id, @PathVariable(value="sourceType") String sourceType, @PathVariable(value="host") String host) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        if (sourceType != null) {
            BackupSourceConfig.BackupSource[] sourceValues;
            boolean found = false;
            for (BackupSourceConfig.BackupSource source : sourceValues = BackupSourceConfig.BackupSource.values()) {
                if (!source.getDisplayName().equalsIgnoreCase(sourceType.toUpperCase())) continue;
                found = true;
                sourceType = source.name();
            }
            if (!found) {
                return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupControllerinvalid.sourcetype.txt"), "BackupControllerinvalid.sourcetype.txt", this.rbUtils.getPropertyValueFromRB("BackupController.check.for.valid.sourcetype.txt"), "BackupController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
        } else {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupControllerinvalid.sourcetype.txt"), "BackupControllerinvalid.sourcetype.txt", this.rbUtils.getPropertyValueFromRB("BackupController.check.for.valid.sourcetype.txt"), "BackupController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (BackupSourceConfig.BackupSource.METADATASERVER.getDisplayName().equalsIgnoreCase(sourceType)) {
            return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupController.Metadata.contents.not.supported.txt"), "BackupController.Metadata.contents.not.supported.txt", this.rbUtils.getPropertyValueFromRB("BackupController.please.check.metadata.backup.logs.txt"), "BackupController.please.check.metadata.backup.logs.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        Map backupRecoverySourceContentDetails = null;
        BackupServiceResult backupServiceResult = null;
        try {
            BackupDetails det;
            BackupServiceResult getbackupResult = this.backupService.getBackupByName(id);
            BackupDetails backupDetails = det = getbackupResult == null ? null : (BackupDetails)getbackupResult.getActualResult();
            if (getbackupResult != null && getbackupResult.getErrorDetails() != null) {
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(getbackupResult.getErrorDetails());
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            if (det == null) {
                return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupController.no.operation.found.txt"), "BackupController.no.operation.found.txt", this.rbUtils.getPropertyValueFromRB("BackupController.please.check.operation.details.txt"), "BackupController.please.check.operation.details.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            backupServiceResult = this.backupService.getContentDetails(id, "Backup", host, sourceType);
            backupRecoverySourceContentDetails = backupServiceResult == null ? null : (Map)backupServiceResult.getActualResult();
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupController.find.detail.cause.in.mid.tier.log.txt"), "BackupController.find.detail.cause.in.mid.tier.log.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        if (backupServiceResult != null && backupServiceResult.getErrorDetails() != null) {
            BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupServiceResult.getErrorDetails());
            return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (backupRecoverySourceContentDetails == null || backupRecoverySourceContentDetails.isEmpty()) {
            return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupController.no.contents.found.txt"), "BackupController.no.contents.found.txt", this.rbUtils.getPropertyValueFromRB("BackupController.check.input.values.for.contents.txt"), "BackupController.check.input.values.for.contents.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new OperationContentsDetailsData(backupRecoverySourceContentDetails), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/rest/backups/{id}/{sourceType}"}, method={RequestMethod.GET}, produces={"application/xml; charset=UTF-8", "application/json; charset=UTF-8"})
    public ResponseEntity<?> getContentDetails(@PathVariable(value="id") String id, @PathVariable(value="sourceType") String sourceType) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        return this.getContentDetailsForHost(id, sourceType, null);
    }

    @RequestMapping(value={"/rest/schedules"}, method={RequestMethod.GET}, produces={"application/vnd.sas.collection+xml", "application/vnd.sas.collection+json"})
    public ResponseEntity<?> getSchedules(@RequestParam(value="start", required=false) Integer start, @RequestParam(value="limit", required=false) Integer limit) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        responseHeaders.add("Cache-Control", "no-cache, no-store");
        List schedule = null;
        BackupServiceResult backupServiceResult = null;
        try {
            backupServiceResult = this.backupService.getBackupSchedule();
            schedule = backupServiceResult == null ? null : (List)backupServiceResult.getActualResult();
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupController.find.detail.cause.in.mid.tier.log.txt"), "BackupController.find.detail.cause.in.mid.tier.log.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        if (backupServiceResult != null && backupServiceResult.getErrorDetails() != null) {
            BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupServiceResult.getErrorDetails());
            return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (start == null) {
            start = 1;
            if (limit == null) {
                limit = schedule.size();
            }
        } else if (limit == null) {
            limit = 10;
        }
        if (limit > schedule.size()) {
            limit = schedule.size();
        }
        if (start < 1 || schedule.size() > 0 && start > schedule.size()) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupController.history.invalid.start.index.txt"), "BackupController.history.invalid.start.index.txt", this.rbUtils.getPropertyValueFromRB("BackupController.history.please.check.invalid.start.index.txt"), "BackupController.history.please.check.invalid.start.index.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (schedule.size() > 0 && limit < 1) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupController.history.invalid.limit.txt"), "BackupController.history.invalid.limit.txt", this.rbUtils.getPropertyValueFromRB("BackupController.history.please.check.invalid.limit.value.txt"), "BackupController.history.please.check.invalid.limit.value.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        LinkedList<BackupScheduleMapper> schedules = null;
        schedules = new LinkedList<BackupScheduleMapper>();
        int i = start - 1;
        for (int cnt = 0; cnt < limit && i < schedule.size(); ++cnt, ++i) {
            BackupSchedule sc = (BackupSchedule)schedule.get(i);
            BackupScheduleMapper scheduleMapper = new BackupScheduleMapper(sc);
            if (scheduleMapper.getId() != null) {
                Link link = new Link("delete", "delete", "/schedules/" + scheduleMapper.getId());
                link.setType("application/vnd.sas.admin.backup.schedule");
                Links links = new Links();
                links.add(link);
                scheduleMapper.setLinks(links.getLinks());
            }
            schedules.add(scheduleMapper);
        }
        Schedules scheds = new Schedules(schedules);
        Links links = null;
        if (schedules.size() > 0) {
            links = this.getPaginationLinks(start, limit, "/schedules", schedule.size() + 1);
            scheds.setLinks(links.getLinks());
        } else {
            links = new Links();
            links.setLinks(new ArrayList());
        }
        Link setScheduleLink = new Link(HttpMethod.POST.name(), "set Schedule", "/schedules");
        setScheduleLink.setType("application/vnd.sas.admin.backup.schedule");
        links.add(setScheduleLink);
        scheds.setLinks(links.getLinks());
        ResourceCollection coll = new ResourceCollection(schedules, Long.valueOf(start.intValue()), limit, Long.valueOf(schedules.size()), links, "application/vnd.sas.admin.backup.schedule+json", "ScheduleList");
        return new ResponseEntity((Object)coll, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/rest/schedules"}, method={RequestMethod.POST}, produces={"application/vnd.sas.admin.backup.schedule+json", "application/vnd.sas.admin.backup.schedule+xml"}, consumes={"application/vnd.sas.admin.backup.schedule+json", "application/vnd.sas.admin.backup.schedule+xml"})
    public ResponseEntity<?> saveSchedules(@RequestBody BackupScheduleMapper schedule) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        ArrayList<BackupSchedule> schedulesList = null;
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        BackupServiceResult backupServiceResult = null;
        try {
            backupServiceResult = this.backupService.getBackupSchedule();
            schedulesList = backupServiceResult == null ? null : (ArrayList<BackupSchedule>)backupServiceResult.getActualResult();
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupController.find.detail.cause.in.mid.tier.log.txt"), "BackupController.find.detail.cause.in.mid.tier.log.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        if (backupServiceResult != null && backupServiceResult.getErrorDetails() != null) {
            BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupServiceResult.getErrorDetails());
            return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (schedulesList == null) {
            schedulesList = new ArrayList<BackupSchedule>();
        }
        BackupSchedule bkUpschedule = schedule.readBackupSchedule();
        if (schedule.inValidInput) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupController.invalid.format.schedules.txt"), "BackupController.invalid.format.schedules.txt", this.rbUtils.getPropertyValueFromRB("BackupController.valid.format.schedules.txt"), "BackupController.valid.format.schedules.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (bkUpschedule.getDayOfweek() == null) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupController.invalid.day.schedules.txt"), "BackupController.invalid.day.schedules.txt", this.rbUtils.getPropertyValueFromRB("BackupController.correct.value.day.schedules.txt"), "BackupController.correct.value.day.schedules.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (bkUpschedule.getHour() > 23 || bkUpschedule.getHour() < 0) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupController.invalid.hour.schedules.txt"), "BackupController.invalid.hour.schedules.txt", this.rbUtils.getPropertyValueFromRB("BackupController.correct.value.hour.schedules.txt"), "BackupController.correct.value.hour.schedules.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (bkUpschedule.getMinute() > 59 || bkUpschedule.getMinute() < 0) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupController.invalid.minute.schedules.txt"), "BackupController.invalid.minute.schedules.txt", this.rbUtils.getPropertyValueFromRB("BackupController.correct.value.minute.schedules.txt"), "BackupController.correct.value.minute.schedules.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (!schedulesList.contains(bkUpschedule)) {
            if (schedule.getId() != null) {
                Link link = new Link("delete", "delete", "/schedules/" + schedule.getId());
                link.setType("application/vnd.sas.admin.backup.schedule");
                Links links = new Links();
                links.add(link);
                schedule.setLinks(links.getLinks());
            }
        } else {
            return new ResponseEntity((Object)new BackupErrorData(409, this.rbUtils.getPropertyValueFromRB("BackupController.schedule.conflict.with.existing.schedule.txt"), "BackupController.schedule.conflict.with.existing.schedule.txt", this.rbUtils.getPropertyValueFromRB("BackupController.schedule.conflict.with.existing.schedule.remedy.txt"), "BackupController.schedule.conflict.with.existing.schedule.remedy.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.CONFLICT);
        }
        schedulesList.add(schedule.readBackupSchedule());
        if (!schedulesList.isEmpty()) {
            BackupServiceResult setScheduleResult = null;
            try {
                setScheduleResult = this.backupService.setBackupSchedule(schedulesList);
            }
            catch (BackupException e) {
                try {
                    BackupErrorDetails backupError = new BackupErrorDetails();
                    BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                    backupError.addBackupErrorEntry(errorEntry);
                    BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                    return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
                catch (Throwable t) {
                    return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupController.find.detail.cause.in.mid.tier.log.txt"), "BackupController.find.detail.cause.in.mid.tier.log.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
            if (setScheduleResult != null && setScheduleResult.getErrorDetails() != null) {
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(setScheduleResult.getErrorDetails());
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity((Object)schedule, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.CREATED);
        }
        return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupController.schedule.list.empty.txt"), "BackupController.schedule.list.empty.txt", this.rbUtils.getPropertyValueFromRB("BackupController.enter.valid.list.schedules.txt"), "BackupController.enter.valid.list.schedules.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/rest/schedules/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> deleteSchedule(@PathVariable(value="id") String id) {
        BackupSchedule bkUpschedule;
        List schedulesList;
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        BackupServiceResult backupServiceResult = null;
        try {
            backupServiceResult = this.backupService.getBackupSchedule();
            schedulesList = backupServiceResult == null ? null : (List)backupServiceResult.getActualResult();
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupController.find.detail.cause.in.mid.tier.log.txt"), "BackupController.find.detail.cause.in.mid.tier.log.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        if (backupServiceResult != null && backupServiceResult.getErrorDetails() != null) {
            BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupServiceResult.getErrorDetails());
            return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (schedulesList == null) {
            // empty if block
        }
        boolean deleted = false;
        BackupScheduleMapper schedule = null;
        if (id != null && !id.equals("")) {
            if (id.length() < 6 || id.length() > 7) {
                return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupController.invalid.day.schedules.txt"), "BackupController.invalid.day.schedules.txt", this.rbUtils.getPropertyValueFromRB("BackupController.correct.value.day.schedules.txt"), "BackupController.correct.value.day.schedules.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            String day = id.substring(0, 3);
            String hour = id.substring(3, 5);
            String min = id.substring(5);
            schedule = new BackupScheduleMapper(day, hour, min);
        }
        if ((bkUpschedule = schedule.readBackupSchedule()).getDayOfweek() == null) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupController.invalid.day.schedules.txt"), "BackupController.invalid.day.schedules.txt", this.rbUtils.getPropertyValueFromRB("BackupController.correct.value.day.schedules.txt"), "BackupController.correct.value.day.schedules.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (bkUpschedule.getHour() > 23 || bkUpschedule.getHour() < 0) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupController.invalid.hour.schedules.txt"), "BackupController.invalid.hour.schedules.txt", this.rbUtils.getPropertyValueFromRB("BackupController.correct.value.hour.schedules.txt"), "BackupController.correct.value.hour.schedules.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (bkUpschedule.getMinute() > 59 || bkUpschedule.getMinute() < 0) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupController.invalid.minute.schedules.txt"), "BackupController.invalid.minute.schedules.txt", this.rbUtils.getPropertyValueFromRB("BackupController.correct.value.minute.schedules.txt"), "BackupController.correct.value.minute.schedules.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (bkUpschedule != null && schedulesList.contains(bkUpschedule)) {
            deleted = schedulesList.remove(bkUpschedule);
        }
        if (deleted) {
            BackupServiceResult setScheduleResult = null;
            try {
                setScheduleResult = this.backupService.setBackupSchedule(schedulesList);
            }
            catch (BackupException e) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupController.find.detail.cause.in.mid.tier.log.txt"), "BackupController.find.detail.cause.in.mid.tier.log.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            if (setScheduleResult != null && setScheduleResult.getErrorDetails() != null) {
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(setScheduleResult.getErrorDetails());
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity((MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupController.no.schedule.deleted.txt"), "BackupController.no.schedule.deleted.txt", this.rbUtils.getPropertyValueFromRB("BackupController.please.check.schedule.details.txt"), "BackupController.please.check.schedule.details.txt"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    private Links getPaginationLinks(int start, int limit, String uri, int collectionSize) {
        int firstStart;
        int prevStart;
        Links links = new Links();
        Link link = null;
        int nextStart = start + limit;
        int templimit = 10;
        if (nextStart < collectionSize) {
            templimit = nextStart + limit < collectionSize ? limit : collectionSize - nextStart;
            String nextUri = uri + "?start=" + nextStart + "&limit=" + templimit;
            link = new Link("get", "next", nextUri);
            link.setType("application/vnd.sas.collection");
            links.add(link);
        }
        if ((prevStart = start - limit) >= 1) {
            templimit = prevStart + limit < collectionSize ? limit : collectionSize - prevStart;
            String prevUri = uri + "?start=" + prevStart + "&limit=" + templimit;
            link = new Link("get", "prev", prevUri);
            link.setType("application/vnd.sas.collection");
            links.add(link);
        }
        templimit = (firstStart = 1) + limit <= collectionSize ? limit : collectionSize - firstStart;
        String firstUri = uri + "?start=1&limit=" + templimit;
        link = new Link("get", "first", firstUri);
        link.setType("application/vnd.sas.collection");
        links.add(link);
        int lasstStart = collectionSize - limit;
        templimit = lasstStart + limit <= collectionSize ? limit : collectionSize - lasstStart;
        String lastUri = uri + "?start=" + lasstStart + "&limit=" + templimit;
        link = new Link("get", "last", lastUri);
        link.setType("application/vnd.sas.collection");
        links.add(link);
        return links;
    }

    private boolean validateOperationName(String name) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH_mm_ssZ");
        boolean isValidOperationName = !name.contains(":");
        try {
            df.parse(name);
            isValidOperationName = false;
        }
        catch (ParseException e) {
            isValidOperationName = true;
        }
        return isValidOperationName;
    }

    public static enum serviceSideConstants {
        backup{

            public String toString() {
                return this.name().toUpperCase();
            }
        }
        ,
        restores{

            public String toString() {
                return this.name().toUpperCase();
            }
        }
        ,
        sun{

            public String toString() {
                return "SUNDAY";
            }
        }
        ,
        mon{

            public String toString() {
                return "MONDAY";
            }
        }
        ,
        tue{

            public String toString() {
                return "TUESDAY";
            }
        }
        ,
        wed{

            public String toString() {
                return "WEDNESDAY";
            }
        }
        ,
        thu{

            public String toString() {
                return "THURSDAY";
            }
        }
        ,
        fri{

            public String toString() {
                return "FRIDAY";
            }
        }
        ,
        sat{

            public String toString() {
                return "SATURDAY";
            }
        };

    }

    public static enum serviceSideStatusConstants {
        CANCELLED{

            public String toString() {
                return "cancelled";
            }
        }
        ,
        NOT_STARTED{

            public String toString() {
                return "not started";
            }
        }
        ,
        SUCCESS{

            public String toString() {
                return "completed";
            }
        }
        ,
        ANALYSIS_WARN{

            public String toString() {
                return "completed with analysis warnings";
            }
        }
        ,
        WARN{

            public String toString() {
                return "completed with warnings";
            }
        }
        ,
        FAIL{

            public String toString() {
                return "failed";
            }
        }
        ,
        INPROGRESS{

            public String toString() {
                return "running";
            }
        }
        ,
        FATAL{

            public String toString() {
                return "fatal";
            }
        }
        ,
        UNKNOWN{

            public String toString() {
                return "unknown";
            }
        };

    }
}

