/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

import com.atomikos.beans.PropertyUtils;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.ClassLoadingHelper;
import com.atomikos.util.Proxied;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DynamicProxySupport<RequiredInterfaceType>
implements InvocationHandler {
    private static final Logger LOGGER = LoggerFactory.createLogger(DynamicProxySupport.class);
    protected boolean closed = false;
    protected final RequiredInterfaceType delegate;
    protected final Map<String, Method> proxiedMethods = new HashMap<String, Method>();
    private static List<String> methodsAllowedAfterClose = Arrays.asList("close", "isClosed");

    public static boolean isProxyInstanceOfClass(Class<?> clazz, Object o) {
        return clazz.isAssignableFrom(Proxy.getInvocationHandler(o).getClass());
    }

    protected DynamicProxySupport(RequiredInterfaceType delegate) {
        this.delegate = delegate;
        this.fillProxiedMethodsCache();
    }

    private void fillProxiedMethodsCache() {
        Class<?> dynamicProxyClass = this.getClass();
        Method[] methods = dynamicProxyClass.getMethods();
        if (methods == null) {
            throw new IllegalStateException(dynamicProxyClass.getSimpleName() + ": at least one @Proxied method is expected but none was found.");
        }
        boolean proxiedMethodFound = false;
        for (Method m : methods) {
            if (!m.isAnnotationPresent(Proxied.class)) continue;
            proxiedMethodFound = true;
            this.proxiedMethods.put(this.createSignature(m), m);
        }
        if (!proxiedMethodFound) {
            throw new IllegalStateException(dynamicProxyClass.getSimpleName() + ": at least one @Proxied method is expected but none was found.");
        }
    }

    private String createSignature(Method m) {
        StringBuilder ret = new StringBuilder(32);
        ret.append(m.getName());
        for (Class<?> c : m.getParameterTypes()) {
            ret.append(c.getName());
        }
        return ret.toString();
    }

    private String formatCallDetails(Method method, Object ... args) {
        StringBuffer ret = new StringBuffer();
        ret.append(method.getName());
        if (args != null && args.length > 0) {
            ret.append("(");
            for (int i = 0; i < args.length; ++i) {
                ret.append(args[i]);
                if (i >= args.length - 1) continue;
                ret.append(",");
            }
            ret.append(")");
        }
        return ret.toString();
    }

    private boolean methodAllowedAfterClose(Method method) {
        return methodsAllowedAfterClose.contains(method.getName()) || ClassLoadingHelper.existsInJavaObjectClass(method);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = null;
        if (this.closed && !this.methodAllowedAfterClose(method)) {
            this.throwInvocationAfterClose(method.getName());
            return null;
        }
        try {
            Method proxiedMethod = this.findProxiedMethodFor(method);
            ret = proxiedMethod != null ? this.callProxiedMethod(proxiedMethod, args) : this.callNativeMethod(method, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("Exception while calling proxied instance", e);
            }
            if ((cause = e.getCause()) != null) {
                this.handleInvocationException(cause);
            }
            this.handleInvocationException(e);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": " + method.getName() + " returning " + ret);
        }
        return ret;
    }

    protected abstract void handleInvocationException(Throwable var1) throws Throwable;

    protected abstract void throwInvocationAfterClose(String var1) throws Exception;

    private Object callProxiedMethod(Method proxiedMethod, Object ... args) throws IllegalAccessException, InvocationTargetException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": calling proxied " + this.formatCallDetails(proxiedMethod, args));
        }
        return proxiedMethod.invoke((Object)this, args);
    }

    protected Object callNativeMethod(Method method, Object ... args) throws Throwable {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": calling native " + this.formatCallDetails(method, args));
        }
        return method.invoke(this.delegate, args);
    }

    private Method findProxiedMethodFor(Method method) {
        return this.proxiedMethods.get(this.createSignature(method));
    }

    public RequiredInterfaceType createDynamicProxy() {
        return ClassLoadingHelper.newProxyInstance(this.getClassLoadersToTry(), this.getRequiredInterfaceType(), this.getInterfaceClasses(), this);
    }

    protected Deque<ClassLoader> getClassLoadersToTry() {
        ArrayDeque<ClassLoader> classLoaders = new ArrayDeque<ClassLoader>();
        this.addIfNotNull(classLoaders, Thread.currentThread().getContextClassLoader());
        this.addIfNotNull(classLoaders, this.delegate.getClass().getClassLoader());
        this.addIfNotNull(classLoaders, DynamicProxySupport.class.getClassLoader());
        return classLoaders;
    }

    protected void addIfNotNull(Deque<ClassLoader> classLoaders, ClassLoader cl) {
        if (cl != null) {
            classLoaders.add(cl);
        }
    }

    protected abstract Class<RequiredInterfaceType> getRequiredInterfaceType();

    public void markClosed() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": marking connection proxy as closed...");
        }
        this.closed = true;
    }

    protected Class<?>[] getInterfaceClasses() {
        Set<Class<?>> interfaces = PropertyUtils.getAllImplementedInterfaces(this.delegate.getClass());
        return interfaces.toArray(new Class[0]);
    }
}

