/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class ClasspathScanner {
    private static Logger LOGGER = LoggerFactory.createLogger(ClasspathScanner.class);
    public static final String VULNERABLE_DEPENDENCY_PROPERTY_FILE_NAME = "atomikos-vulnerable-maven-dependency-versions.properties";
    public static final String OVERRIDDEN_DEPENDENCY_PROPERTY_FILE_NAME = "atomikos-overridden-maven-dependency-versions.properties";
    private Properties vulnerableDependencies;
    private Properties overriddenDependencies;
    private ClassLoader applicationClassLoader;

    private static Properties findVulnerableDependencyProperties() {
        return ClasspathScanner.findProperties(VULNERABLE_DEPENDENCY_PROPERTY_FILE_NAME);
    }

    private static Properties findOverriddenDependencyProperties() {
        return ClasspathScanner.findProperties(OVERRIDDEN_DEPENDENCY_PROPERTY_FILE_NAME);
    }

    private static Properties findProperties(String propertyFileName) {
        Properties ret = new Properties();
        URL url = ClasspathScanner.class.getResource("/" + propertyFileName);
        if (url != null) {
            LOGGER.logDebug("Reading property file: " + url.toString());
            try {
                InputStream in = url.openStream();
                ret.load(in);
                in.close();
            }
            catch (IOException e) {
                LOGGER.logDebug("Unexpected error reading property file: " + url.toString(), e);
            }
        }
        return ret;
    }

    public static void warnForVulnerableMavenDependencyVersions() {
        ClasspathScanner.warnForVulnerableMavenDependencyVersions(ClasspathScanner.class.getClassLoader());
    }

    public static void warnForVulnerableMavenDependencyVersions(ClassLoader applicationClassLoader) {
        ClasspathScanner scanner = new ClasspathScanner(applicationClassLoader, ClasspathScanner.findVulnerableDependencyProperties(), ClasspathScanner.findOverriddenDependencyProperties());
        boolean vulnerableDependencyFound = false;
        for (String entry : scanner.findVulnerableMavenDependenciesInClasspath()) {
            String msg = "Found vulnerable maven dependency on the application classpath: " + entry;
            ClasspathScanner.logMessage(msg);
            vulnerableDependencyFound = true;
        }
        if (vulnerableDependencyFound) {
            ClasspathScanner.logMessage("See https://www.atomikos.com/Documentation/HowToHandleVulnerableDependencyWarnings for what to do...");
        }
    }

    private static void logMessage(String msg) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.logWarning(msg);
        } else {
            System.err.println(msg);
        }
    }

    ClasspathScanner(ClassLoader applicationClassLoader, Properties vulnerableDependencies, Properties overriddenDependencies) {
        this.vulnerableDependencies = vulnerableDependencies;
        this.overriddenDependencies = overriddenDependencies;
        this.applicationClassLoader = applicationClassLoader;
    }

    Set<String> findVulnerableMavenDependenciesInClasspath() {
        HashSet<String> ret = new HashSet<String>();
        Enumeration<?> vulnerableDependencyMavenCoordinates = this.vulnerableDependencies.propertyNames();
        while (vulnerableDependencyMavenCoordinates.hasMoreElements()) {
            String vulnerableMavenDependency = (String)vulnerableDependencyMavenCoordinates.nextElement();
            for (String vulnerableVersion : this.resolveVulnerableDependencyVersions(vulnerableMavenDependency)) {
                String occurrence = this.findInApplicationClasspath(vulnerableMavenDependency, vulnerableVersion);
                if (occurrence == null) continue;
                ret.add(occurrence);
            }
        }
        return ret;
    }

    private String findInApplicationClasspath(String vulnerableMavenDependency, String vulnerableVersion) {
        Properties properties = this.findPomProperties(vulnerableMavenDependency, vulnerableVersion);
        if (vulnerableVersion.equals(properties.getProperty("version"))) {
            return vulnerableMavenDependency + ":" + vulnerableVersion;
        }
        return null;
    }

    private Properties findPomProperties(String vulnerableMavenDependency, String vulnerableVersion) {
        Properties properties = new Properties();
        String pomResourceUrl = this.createPomResourceUrl(vulnerableMavenDependency);
        if (pomResourceUrl != null) {
            InputStream inStream = this.applicationClassLoader.getResourceAsStream(pomResourceUrl);
            try {
                properties.load(inStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return properties;
    }

    private String createPomResourceUrl(String vulnerableMavenDependency) {
        String[] parsedMavenDependency = vulnerableMavenDependency.split(":");
        if (parsedMavenDependency.length < 2) {
            LOGGER.logWarning("Found a syntax error in dependency properties file - make sure to use a backslash before the colon to separate groupId and artifactId");
            return null;
        }
        String groupId = parsedMavenDependency[0];
        String artifactId = parsedMavenDependency[1];
        return "META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties";
    }

    Set<String> parseVulnerableDependencyVersions(String mavenDependencyAsPropertyName) {
        return this.parseDependencyVersions(this.vulnerableDependencies, mavenDependencyAsPropertyName);
    }

    Set<String> parseOverriddenDependencyVersions(String mavenDependencyAsPropertyName) {
        return this.parseDependencyVersions(this.overriddenDependencies, mavenDependencyAsPropertyName);
    }

    Set<String> resolveVulnerableDependencyVersions(String mavenDependencyAsPropertyName) {
        HashSet<String> ret = new HashSet<String>();
        for (String vulnerableVersion : this.parseVulnerableDependencyVersions(mavenDependencyAsPropertyName)) {
            if (this.parseOverriddenDependencyVersions(mavenDependencyAsPropertyName).contains(vulnerableVersion)) continue;
            ret.add(vulnerableVersion);
        }
        return ret;
    }

    private Set<String> parseDependencyVersions(Properties properties, String mavenDependencyAsPropertyName) {
        HashSet<String> ret = new HashSet<String>();
        String allVersions = properties.getProperty(mavenDependencyAsPropertyName);
        if (allVersions != null) {
            String[] parsedVersions;
            for (String version : parsedVersions = allVersions.split(" ")) {
                if ("".equals(version)) continue;
                ret.add(version.trim());
            }
        }
        return ret;
    }
}

