/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.publish;

import com.atomikos.icatch.event.Event;
import com.atomikos.icatch.event.EventListener;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.HashSet;
import java.util.Set;

public enum EventPublisher {
    INSTANCE;

    private static Logger LOGGER;
    private Set<EventListener> listeners = new HashSet<EventListener>();

    public void publish(Event event) {
        if (event != null) {
            this.notifyAllListeners(event);
        }
    }

    private void notifyAllListeners(Event event) {
        for (EventListener listener : this.listeners) {
            try {
                listener.eventOccurred(event);
            }
            catch (Exception e) {
                LOGGER.logError("Error notifying listener " + listener, e);
            }
        }
    }

    public void registerEventListener(EventListener listener) {
        LOGGER.logInfo("Registering EventListener: " + listener);
        this.listeners.add(listener);
    }

    static {
        LOGGER = LoggerFactory.createLogger(EventPublisher.class);
    }
}

