/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.util;

import MITI.expression.analyzer.decoration.MIRDecorUtil;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRJoin;
import MITI.sdk.MIRJoinRole;
import MITI.sdk.MIROperatorNode;
import MITI.sdk.MIRStatementNode;
import MITI.sdk.util.ObjectCollector;
import java.util.ArrayList;
import java.util.SortedSet;

public class Util {
    public static boolean isTableExpression(MIRClassifierMap mIRClassifierMap) {
        MIRExpression mIRExpression;
        if (mIRClassifierMap != null && (mIRExpression = mIRClassifierMap.getExpression()) != null && mIRExpression.getStatementNodeCount() == 1) {
            MIRStatementNode mIRStatementNode = mIRExpression.getStatementNodes().first();
            return mIRStatementNode.getStatementType() == 16;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSimpleExpression(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap == null || mIRClassifierMap.getDestinationClassifier() == null) {
            return false;
        }
        MIRClassifier mIRClassifier = mIRClassifierMap.getDestinationClassifier();
        for (MIRFeature mIRElement : mIRClassifier.getFeatures()) {
            if (mIRElement.getElementType() != 84) continue;
            return false;
        }
        if (mIRClassifierMap.getExpression() != null) {
            void var3_6;
            int n = mIRClassifierMap.getSourceClassifierCount();
            if (mIRClassifierMap.containsSourceClassifier(mIRClassifier)) {
                --n;
            }
            int n2 = mIRClassifierMap.getControlClassifierCount();
            if (mIRClassifierMap.containsControlClassifier(mIRClassifier)) {
                --var3_6;
            }
            if (n != 1 || var3_6 > 0) {
                return false;
            }
            return Util.isSimpleCmExpression(mIRClassifierMap.getExpression());
        }
        if (mIRClassifierMap.getOperation().isEmpty()) {
            for (MIRFeatureMap mIRFeatureMap : mIRClassifierMap.getFeatureMaps()) {
                if (!Util.isSimpleExpression(mIRFeatureMap)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSimpleExpression(MIRFeatureMap mIRFeatureMap) {
        if (mIRFeatureMap == null || mIRFeatureMap.getDestinationFeature() == null || mIRFeatureMap.getSourceFeatureCount() != 1 || mIRFeatureMap.getControlFeatureCount() > 0) {
            return false;
        }
        if (mIRFeatureMap.getExpression() != null) {
            return Util.isSimpleFmExpression(mIRFeatureMap.getExpression());
        }
        return mIRFeatureMap.getOperation().isEmpty();
    }

    public static boolean isSimpleJoinExpression(MIRJoin mIRJoin, ArrayList<MIRFeature> arrayList, ArrayList<MIRFeature> arrayList2) {
        boolean bl = false;
        if (mIRJoin == null || mIRJoin.getJoinRoleCount() != 2 || mIRJoin.getFeatureCount() != 1) {
            return false;
        }
        MIRClassifier mIRClassifier = null;
        MIRClassifier mIRClassifier2 = null;
        SortedSet<MIRJoinRole> sortedSet = mIRJoin.getJoinRoles();
        if (sortedSet.first().getLeft()) {
            mIRClassifier = sortedSet.first().getClassifier();
            mIRClassifier2 = sortedSet.last().getClassifier();
        } else {
            mIRClassifier = sortedSet.last().getClassifier();
            mIRClassifier2 = sortedSet.first().getClassifier();
        }
        MIRFeatureMap mIRFeatureMap = mIRJoin.getFeatures().first().getDestinationOfFeatureMap();
        if (mIRClassifier == null || mIRClassifier2 == null || mIRFeatureMap == null || mIRFeatureMap.getSourceFeatureCount() == 0 || mIRFeatureMap.getControlFeatureCount() > 0) {
            return false;
        }
        MIRExpression mIRExpression = mIRFeatureMap.getExpression();
        if (mIRExpression != null) {
            if (mIRExpression.getStatementNodeCount() != 1 || mIRExpression.getStatementNodes().first().getExpressionNodeCount() != 1) {
                return false;
            }
            bl = Util.traverseJoinExpression(mIRExpression.getStatementNodes().first().getExpressionNodes().first(), mIRClassifier, arrayList, mIRClassifier2, arrayList2);
        } else if (mIRFeatureMap.getOperation().isEmpty()) {
            if (mIRFeatureMap.getSourceFeatureCount() != 2) {
                return false;
            }
            bl = Util.checkFeatures(mIRFeatureMap.getSourceFeatures().first(), mIRFeatureMap.getSourceFeatures().last(), mIRClassifier, arrayList, mIRClassifier2, arrayList2);
        }
        if (!bl) {
            arrayList.clear();
            arrayList2.clear();
        }
        return bl;
    }

    private static boolean isSimpleCmExpression(MIRExpression mIRExpression) {
        int n = 0;
        int n2 = 0;
        ObjectCollector objectCollector = new ObjectCollector(new short[]{113});
        for (MIRExpressionNode mIRExpressionNode : objectCollector.collect(mIRExpression)) {
            if (mIRExpressionNode.getElementType() == 111) {
                MIRElementNamePart mIRElementNamePart;
                MIRElementNode mIRElementNode = (MIRElementNode)mIRExpressionNode;
                if (mIRElementNode.getDestinationElementType() != 75 || (mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode)).getReferencedElementCount() <= 0 || !mIRElementNamePart.getReferencedElements().first().isInstanceOf((short)75)) continue;
                ++n2;
                continue;
            }
            if (mIRExpressionNode.getElementType() != 134) continue;
            ++n;
        }
        return n == 1 && n2 == 1;
    }

    public static boolean isSimpleFmExpression(MIRExpression mIRExpression) {
        MIRElement mIRElement;
        if (mIRExpression == null || mIRExpression.getStatementNodeCount() != 1) {
            return false;
        }
        MIRStatementNode mIRStatementNode = mIRExpression.getStatementNodes().first();
        MIRExpressionNode mIRExpressionNode = null;
        if (mIRStatementNode.getStatementType() == 4 && mIRStatementNode.getReferencedExpressionNodeCount() == 1) {
            mIRExpressionNode = Util.getRefNode(mIRStatementNode.getReferencedExpressionNodes().first());
        } else if (mIRStatementNode.getStatementType() == 0 && mIRStatementNode.getExpressionNodeCount() == 1) {
            mIRExpressionNode = mIRStatementNode.getExpressionNodes().first();
        }
        return mIRExpressionNode != null && mIRExpressionNode.getElementType() == 111 && (mIRElement = MIRDecorUtil.getLastReference((MIRElementNode)mIRExpressionNode)) != null && mIRElement.isInstanceOf((short)77);
    }

    public static MIRExpressionNode getRefNode(MIRExpressionNode mIRExpressionNode) {
        MIRElement mIRElement;
        MIRElementNamePart mIRElementNamePart;
        MIRElementNode mIRElementNode;
        if (mIRExpressionNode.getElementType() == 111 && (mIRElementNode = (MIRElementNode)mIRExpressionNode).getKind() == 2 && (mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode)).getReferencedElementCount() == 1 && (mIRElement = mIRElementNamePart.getReferencedElements().first()).isInstanceOf((short)113)) {
            return (MIRExpressionNode)mIRElement;
        }
        return mIRExpressionNode;
    }

    private static boolean traverseJoinExpression(MIRExpressionNode mIRExpressionNode, MIRClassifier mIRClassifier, ArrayList<MIRFeature> arrayList, MIRClassifier mIRClassifier2, ArrayList<MIRFeature> arrayList2) {
        if (mIRExpressionNode != null && mIRExpressionNode.getElementType() == 115) {
            MIRExpressionNode mIRExpressionNode2 = ((MIROperatorNode)mIRExpressionNode).getLeftExpressionNode();
            MIRExpressionNode mIRExpressionNode3 = ((MIROperatorNode)mIRExpressionNode).getRightExpressionNode();
            if (mIRExpressionNode2 == null || mIRExpressionNode3 == null) {
                return false;
            }
            if (mIRExpressionNode.getName().equalsIgnoreCase("AND")) {
                return Util.traverseJoinExpression(mIRExpressionNode2, mIRClassifier, arrayList, mIRClassifier2, arrayList2) && Util.traverseJoinExpression(mIRExpressionNode3, mIRClassifier, arrayList, mIRClassifier2, arrayList2);
            }
            if (mIRExpressionNode.getName().equalsIgnoreCase("=")) {
                if (mIRExpressionNode2.getElementType() != 111 || mIRExpressionNode3.getElementType() != 111) {
                    return false;
                }
                MIRElement mIRElement = MIRDecorUtil.getLastReference((MIRElementNode)mIRExpressionNode2);
                MIRElement mIRElement2 = MIRDecorUtil.getLastReference((MIRElementNode)mIRExpressionNode3);
                if (mIRElement == null || mIRElement2 == null || !mIRElement.isInstanceOf((short)77) || !mIRElement2.isInstanceOf((short)77)) {
                    return false;
                }
                return Util.checkFeatures((MIRFeature)mIRElement, (MIRFeature)mIRElement2, mIRClassifier, arrayList, mIRClassifier2, arrayList2);
            }
        }
        return false;
    }

    private static boolean checkFeatures(MIRFeature mIRFeature, MIRFeature mIRFeature2, MIRClassifier mIRClassifier, ArrayList<MIRFeature> arrayList, MIRClassifier mIRClassifier2, ArrayList<MIRFeature> arrayList2) {
        if (mIRClassifier.containsFeature(mIRFeature) && mIRClassifier2.containsFeature(mIRFeature2)) {
            if (!arrayList.contains(mIRFeature) && !arrayList2.contains(mIRFeature2)) {
                return arrayList.add(mIRFeature) && arrayList2.add(mIRFeature2);
            }
        } else if (mIRClassifier.containsFeature(mIRFeature2) && mIRClassifier2.containsFeature(mIRFeature) && !arrayList.contains(mIRFeature2) && !arrayList2.contains(mIRFeature)) {
            return arrayList.add(mIRFeature2) && arrayList2.add(mIRFeature);
        }
        return false;
    }
}

