/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.traversal;

import MITI.sdk.MIRBranchingNode;
import MITI.sdk.MIRConstantNode;
import MITI.sdk.MIRDelimiterNode;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIROperatorNode;
import MITI.sdk.MIRPredicateNode;
import MITI.sdk.MIRQueryNode;
import MITI.sdk.MIRStatementNode;

public class ExpressionTraversal {
    protected void traverseExpression(MIRExpression mIRExpression) {
        for (MIRStatementNode mIRStatementNode : mIRExpression.getStatementNodeByPosition()) {
            this.traverseExpressionNode(mIRStatementNode);
        }
    }

    protected void traverseExpressionNode(MIRExpressionNode mIRExpressionNode) {
        if (mIRExpressionNode == null) {
            return;
        }
        switch (mIRExpressionNode.getElementType()) {
            case 103: {
                this.traverseBranchingNode((MIRBranchingNode)mIRExpressionNode);
                break;
            }
            case 104: {
                this.traverseConstantNode((MIRConstantNode)mIRExpressionNode);
                break;
            }
            case 107: {
                this.traverseDelimiterNode((MIRDelimiterNode)mIRExpressionNode);
                break;
            }
            case 111: {
                this.traverseElementNode((MIRElementNode)mIRExpressionNode);
                break;
            }
            case 114: {
                this.traverseOperationNode((MIROperationNode)mIRExpressionNode);
                break;
            }
            case 115: {
                this.traverseOperatorNode((MIROperatorNode)mIRExpressionNode);
                break;
            }
            case 118: {
                this.traversePredicateNode((MIRPredicateNode)mIRExpressionNode);
                break;
            }
            case 339: {
                this.traverseQueryNode((MIRQueryNode)mIRExpressionNode);
                break;
            }
            case 134: {
                this.traverseStatementNode((MIRStatementNode)mIRExpressionNode);
                break;
            }
        }
    }

    protected void traverseBranchingNode(MIRBranchingNode mIRBranchingNode) {
        this.traverseExpressionNode(mIRBranchingNode.getConditionExpressionNode());
        for (MIRExpressionNode mIRExpressionNode : mIRBranchingNode.getExpressionNodeByPosition()) {
            this.traverseExpressionNode(mIRExpressionNode);
        }
    }

    protected void traverseConstantNode(MIRConstantNode mIRConstantNode) {
    }

    protected void traverseDelimiterNode(MIRDelimiterNode mIRDelimiterNode) {
        for (MIRExpressionNode mIRExpressionNode : mIRDelimiterNode.getExpressionNodeByPosition()) {
            this.traverseExpressionNode(mIRExpressionNode);
        }
        this.traverseExpressionNode(mIRDelimiterNode.getConditionExpressionNode());
    }

    protected void traverseElementNode(MIRElementNode mIRElementNode) {
    }

    protected void traverseOperationNode(MIROperationNode mIROperationNode) {
        for (MIRExpressionNode mIRExpressionNode : mIROperationNode.getExpressionNodeByPosition()) {
            this.traverseExpressionNode(mIRExpressionNode);
        }
    }

    protected void traverseOperatorNode(MIROperatorNode mIROperatorNode) {
        this.traverseExpressionNode(mIROperatorNode.getLeftExpressionNode());
        this.traverseExpressionNode(mIROperatorNode.getRightExpressionNode());
        this.traverseExpressionNode(mIROperatorNode.getConditionExpressionNode());
    }

    protected void traversePredicateNode(MIRPredicateNode mIRPredicateNode) {
        this.traverseExpressionNode(mIRPredicateNode.getExpressionNode());
    }

    protected void traverseQueryNode(MIRQueryNode mIRQueryNode) {
        this.traverseExpressionNode(mIRQueryNode.getClassifierElementNode());
        this.traverseExpressionNode(mIRQueryNode.getFeatureDelimiterNode());
        this.traverseExpressionNode(mIRQueryNode.getQueryStatementNode());
    }

    protected void traverseStatementNode(MIRStatementNode mIRStatementNode) {
        for (MIRExpressionNode mIRExpressionNode : mIRStatementNode.getExpressionNodeByPosition()) {
            this.traverseExpressionNode(mIRExpressionNode);
        }
    }
}

