/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.query;

import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRJoinType;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRQueryColumn;
import MITI.sdk.MIRQueryFilter;
import MITI.sdk.MIRQueryFilterType;
import MITI.sdk.MIRQueryGroupBy;
import MITI.sdk.MIRQueryJoin;
import MITI.sdk.MIRQueryLookup;
import MITI.sdk.MIRQuerySort;
import MITI.sdk.MIRQuerySortItem;
import MITI.sdk.MIRQueryTable;
import MITI.sdk.MIRSqlQuery;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class MIRSqlQueryPrinter {
    private boolean formatted = false;
    private StringBuffer sql = null;
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9_]*");

    public MIRSqlQueryPrinter(boolean bl) {
        this.formatted = bl;
    }

    public String getSql(MIRSqlQuery mIRSqlQuery) {
        if (mIRSqlQuery.getOutputTransformationDataSetCount() > 1) {
            return null;
        }
        if (mIRSqlQuery.getOutputTransformationDataSetCount() == 0) {
            return null;
        }
        this.sql = new StringBuffer();
        this.printInsertSql(mIRSqlQuery);
        this.sql.append(this.formatted ? "\n" : "").append(";");
        return this.sql.toString();
    }

    private void printInsertSql(MIRSqlQuery mIRSqlQuery) {
        this.sql.append("INSERT INTO ");
        MIRClassifierMap mIRClassifierMap = mIRSqlQuery.getClassifierMaps().first();
        MIRClassifier mIRClassifier = mIRClassifierMap.getDestinationClassifier();
        this.printName(this.getPhysicalName(mIRClassifier));
        boolean bl = false;
        for (MIRFeature mIRFeature : mIRClassifier.getFeatureByPosition()) {
            String string = this.getOperationSql(mIRFeature);
            if (mIRFeature.getElementType() != 242 || string == null) continue;
            if (bl) {
                this.sql.append(", ");
            } else {
                bl = true;
                this.sql.append("(");
            }
            this.printName(this.getPhysicalName(mIRFeature));
        }
        if (bl) {
            this.sql.append(")");
            if (mIRSqlQuery.getSubSqlQueryCount() == 0) {
                this.printSelectSql(mIRSqlQuery);
            } else {
                this.printSelectSql(mIRSqlQuery.getSubSqlQueries().first());
            }
        }
    }

    private void printSelectSql(MIRSqlQuery mIRSqlQuery) {
        Object object3;
        Iterator<Object> iterator;
        this.sql.append(this.formatted ? "\n" : " ").append("SELECT ");
        MIRClassifierMap mIRClassifierMap = mIRSqlQuery.getClassifierMaps().first();
        MIRClassifier mIRClassifier = mIRClassifierMap.getDestinationClassifier();
        List<Object> list = mIRClassifier != null ? mIRClassifier.getFeatureByPosition() : Collections.emptyList();
        boolean bl = false;
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            iterator = (MIRFeature)object2.next();
            object3 = this.getOperationSql((MIRFeature)((Object)iterator));
            if (((MIRFeature)((Object)iterator)).getElementType() != 242 || object3 == null) continue;
            if (bl) {
                this.sql.append(", ");
            } else {
                bl = true;
            }
            this.sql.append((String)object3);
            if (mIRSqlQuery.getSubOfSqlQuery() == null) continue;
            this.sql.append(" AS ");
            this.printName(((MIRObject)((Object)iterator)).getName());
        }
        if (!bl) {
            this.sql.append("*");
        }
        if ((object2 = mIRSqlQuery.getTopQueryJoin()) != null || mIRClassifierMap.getSourceClassifierCount() > 0) {
            this.sql.append(this.formatted ? "\n" : " ").append("FROM ");
            if (object2 != null) {
                this.printJoinSql((MIRQueryJoin)object2);
            } else {
                boolean bl2 = true;
                object3 = mIRClassifierMap.getSourceClassifiers().iterator();
                while (object3.hasNext()) {
                    MIRClassifier mIRClassifier2 = (MIRClassifier)object3.next();
                    if (bl2) {
                        bl2 = false;
                    } else {
                        this.sql.append(", ");
                    }
                    this.printAliasSql(mIRClassifier2);
                }
            }
            for (Object object3 : list) {
                if (((MIRFeature)object3).getElementType() != 335) continue;
                this.printLookupSql((MIRQueryLookup)object3);
            }
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            object3 = (MIRFeature)iterator.next();
            if (((MIRFeature)object3).getElementType() != 333) continue;
            this.printFilterSql((MIRQueryFilter)object3);
        }
        Iterator<Object> iterator2 = iterator = mIRClassifier == null ? null : ((MIRQueryTable)mIRClassifier).getQueryGroupBy();
        if (iterator != null) {
            this.printGroupBySql((MIRQueryGroupBy)((Object)iterator));
        }
        Object object4 = object3 = mIRClassifier == null ? null : ((MIRQueryTable)mIRClassifier).getQuerySort();
        if (object3 != null) {
            this.printOrderBySql((MIRQuerySort)object3);
        }
    }

    private String getOperationSql(MIRFeature mIRFeature) {
        String string;
        MIRFeatureMap mIRFeatureMap = mIRFeature.getDestinationOfFeatureMap();
        if (mIRFeatureMap != null && !(string = mIRFeatureMap.getOperation().trim()).isEmpty()) {
            return string;
        }
        return null;
    }

    public static String escapeName(String string) {
        if (!NAME_PATTERN.matcher(string).matches()) {
            return "\"" + string.replace("\"", "\\\"") + "\"";
        }
        return string;
    }

    private void printName(String string) {
        this.sql.append(MIRSqlQueryPrinter.escapeName(string));
    }

    private String getPhysicalName(MIRModelObject mIRModelObject) {
        if (!mIRModelObject.getPhysicalName().isEmpty()) {
            return mIRModelObject.getPhysicalName();
        }
        return mIRModelObject.getName();
    }

    protected String getAliasName(MIRClassifier mIRClassifier) {
        return mIRClassifier.getName();
    }

    private void printAliasSql(MIRClassifier mIRClassifier) {
        String string;
        String string2 = this.getPhysicalName(mIRClassifier);
        if (!string2.equals(string = this.getAliasName(mIRClassifier))) {
            this.printName(string2);
            this.sql.append(" ");
        }
        this.printName(string);
    }

    private void printJoinSql(MIRQueryJoin mIRQueryJoin) {
        if (mIRQueryJoin.getLeftQueryJoin() != null) {
            this.printJoinSql(mIRQueryJoin.getLeftQueryJoin());
        } else {
            this.printAliasSql(mIRQueryJoin.getLeftQueryTable());
        }
        this.sql.append(this.formatted ? "\n\t" : " ").append(MIRJoinType.toCppString(mIRQueryJoin.getJoinType())).append(" JOIN ");
        if (mIRQueryJoin.getRightQueryJoin() != null) {
            this.sql.append("(");
            this.printJoinSql(mIRQueryJoin.getRightQueryJoin());
            this.sql.append(")");
        } else {
            this.printAliasSql(mIRQueryJoin.getRightQueryTable());
        }
        String string = this.getOperationSql(mIRQueryJoin);
        if (string != null) {
            this.sql.append(" ON (").append(string).append(")");
        }
    }

    private void printLookupSql(MIRQueryLookup mIRQueryLookup) {
        this.sql.append(this.formatted ? "\n\t" : " ").append("LEFT OUTER JOIN ");
        this.printAliasSql(mIRQueryLookup.getSourceQueryTable());
        String string = this.getOperationSql(mIRQueryLookup);
        if (string != null) {
            this.sql.append(" ON (").append(string).append(")");
        }
    }

    private void printGroupBySql(MIRQueryGroupBy mIRQueryGroupBy) {
        boolean bl = true;
        for (MIRQueryColumn mIRQueryColumn : mIRQueryGroupBy.getQueryColumns()) {
            String string = this.getOperationSql(mIRQueryColumn);
            if (string == null) continue;
            if (bl) {
                bl = false;
                this.sql.append(this.formatted ? "\n\t" : " ").append("GROUP BY ");
            } else {
                this.sql.append(", ");
            }
            this.sql.append(string);
        }
    }

    private void printOrderBySql(MIRQuerySort mIRQuerySort) {
        boolean bl = true;
        for (MIRQuerySortItem mIRQuerySortItem : mIRQuerySort.getQuerySortItemByPosition()) {
            String string;
            MIRQueryColumn mIRQueryColumn = mIRQuerySortItem.getQueryColumn();
            if (mIRQueryColumn == null || (string = this.getOperationSql(mIRQueryColumn)) == null) continue;
            if (bl) {
                bl = false;
                this.sql.append(this.formatted ? "\n\t" : " ").append("ORDER BY ");
            } else {
                this.sql.append(", ");
            }
            this.sql.append(string).append(mIRQuerySortItem.getAscending() ? " ASC" : " DESC");
        }
    }

    private void printFilterSql(MIRQueryFilter mIRQueryFilter) {
        String string = this.getOperationSql(mIRQueryFilter);
        if (string != null) {
            this.sql.append(this.formatted ? "\n" : " ").append(MIRQueryFilterType.toCppString(mIRQueryFilter.getFilterType())).append(" ").append(string);
        }
    }
}

