/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.functions;

public class Argc
implements Comparable<Argc> {
    static final String ARG_N = "n";
    private Type type = Type.EXACT;
    private int argc;

    Argc(int n) {
        this.argc = n + 1;
    }

    Argc(String string) {
        this.argc = 0;
        if (string.indexOf(ARG_N) > -1) {
            char c;
            if (string.indexOf("+") > -1) {
                this.argc = Integer.parseInt(string.substring(0, string.indexOf("+")));
                c = string.charAt(string.indexOf("+") + 1);
            } else {
                c = string.charAt(0);
            }
            if (c == ARG_N.charAt(0)) {
                this.type = Type.ALL;
            } else if (c == '2') {
                this.type = this.argc % 2 == 0 ? Type.EVEN : Type.ODD;
            }
        } else {
            this.argc = Integer.parseInt(string);
        }
    }

    @Override
    public int compareTo(Argc argc) {
        int n = this.argc - argc.argc;
        if (this.type == argc.type) {
            if (this.type == Type.EXACT) {
                return n;
            }
            return 0;
        }
        if (this.type == Type.ALL) {
            if (argc.type == Type.EXACT && n > 0) {
                return n;
            }
            return 0;
        }
        if (argc.type == Type.ALL) {
            if (this.type == Type.EXACT && n < 0) {
                return n;
            }
            return 0;
        }
        if (this.type == Type.EVEN && argc.type == Type.ODD || this.type == Type.ODD && argc.type == Type.EVEN) {
            return n;
        }
        if (this.type == Type.EXACT) {
            if (n < 0) {
                return n;
            }
            if (argc.type == Type.EVEN) {
                return this.argc % 2 == 0 ? 0 : n;
            }
            return this.argc % 2 != 0 ? 0 : n;
        }
        if (n > 0) {
            return n;
        }
        if (this.type == Type.EVEN) {
            return argc.argc % 2 == 0 ? 0 : n;
        }
        return argc.argc % 2 != 0 ? 0 : n;
    }

    private static enum Type {
        EXACT,
        EVEN,
        ODD,
        ALL;

    }
}

