/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.datatypes;

public final class MIRExpressionDataTypeInfo {
    public static MIRExpressionDataTypeInfo TYPE_UNDEFINED = new MIRExpressionDataTypeInfo("undefined", 8, false, false);
    public static MIRExpressionDataTypeInfo TYPE_BINARY = new MIRExpressionDataTypeInfo("binary", 7, true, false);
    public static MIRExpressionDataTypeInfo TYPE_TEXT = new MIRExpressionDataTypeInfo("text", 6, true, false);
    public static MIRExpressionDataTypeInfo TYPE_CHAR = new MIRExpressionDataTypeInfo("char", 5, true, false);
    public static MIRExpressionDataTypeInfo TYPE_DATETIME = new MIRExpressionDataTypeInfo("datetime", 4, false, false);
    public static MIRExpressionDataTypeInfo TYPE_NUMBER = new MIRExpressionDataTypeInfo("number", 3, true, true);
    public static MIRExpressionDataTypeInfo TYPE_INTEGER = new MIRExpressionDataTypeInfo("int", 2, true, true);
    public static MIRExpressionDataTypeInfo TYPE_BOOLEAN = new MIRExpressionDataTypeInfo("boolean", 1, false, false);
    private final String name;
    private final int precedence;
    private final boolean hasLength;
    private final boolean hasScale;

    private MIRExpressionDataTypeInfo(String string, int n, boolean bl, boolean bl2) {
        this.name = string;
        this.precedence = n;
        this.hasLength = bl;
        this.hasScale = bl2;
    }

    public String getName() {
        return this.name;
    }

    int getPrecedence() {
        return this.precedence;
    }

    boolean getHasLength() {
        return this.hasLength;
    }

    boolean getHasScale() {
        return this.hasScale;
    }

    public static MIRExpressionDataTypeInfo fromName(String string) {
        if ("binary".equals(string)) {
            return TYPE_BINARY;
        }
        if ("text".equals(string)) {
            return TYPE_TEXT;
        }
        if ("char".equals(string)) {
            return TYPE_CHAR;
        }
        if ("datetime".equals(string)) {
            return TYPE_DATETIME;
        }
        if ("number".equals(string)) {
            return TYPE_NUMBER;
        }
        if ("int".equals(string)) {
            return TYPE_INTEGER;
        }
        if ("boolean".equals(string)) {
            return TYPE_BOOLEAN;
        }
        return TYPE_UNDEFINED;
    }
}

