/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.datatypes;

import MITI.expression.datatypes.MIRExpressionDataTypeInfo;

public class MIRExpressionDataType {
    private static final String delimiter = ",";
    private final MIRExpressionDataTypeInfo info;
    private Integer length;
    private Integer scale;

    public MIRExpressionDataType(MIRExpressionDataTypeInfo mIRExpressionDataTypeInfo, Integer n, Integer n2) {
        this.info = mIRExpressionDataTypeInfo;
        if (mIRExpressionDataTypeInfo.getHasLength()) {
            this.length = n;
        }
        if (mIRExpressionDataTypeInfo.getHasScale()) {
            this.scale = n2;
        }
    }

    private MIRExpressionDataType(MIRExpressionDataType mIRExpressionDataType) {
        this.info = mIRExpressionDataType.info;
        this.length = mIRExpressionDataType.length;
        this.scale = mIRExpressionDataType.scale;
    }

    public boolean hasLength() {
        return this.length != null;
    }

    public int getLength() {
        return this.length == null ? 0 : this.length;
    }

    public void setLength(Integer n) {
        if (n != null) {
            this.length = n;
        }
    }

    public boolean hasScale() {
        return this.scale != null;
    }

    public int getScale() {
        return this.scale == null ? 0 : this.scale;
    }

    public void setScale(Integer n) {
        if (n != null) {
            this.scale = n;
        }
    }

    public MIRExpressionDataTypeInfo getInfo() {
        return this.info;
    }

    public String serialize() {
        StringBuilder stringBuilder = new StringBuilder(this.info.getName());
        stringBuilder.append("(");
        if (this.length != null) {
            stringBuilder.append(String.valueOf(this.length));
        }
        stringBuilder.append(delimiter);
        if (this.scale != null) {
            stringBuilder.append(String.valueOf(this.scale));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static MIRExpressionDataType deserialize(String string) {
        MIRExpressionDataTypeInfo mIRExpressionDataTypeInfo;
        if (string == null || string.isEmpty()) {
            return null;
        }
        Integer n = null;
        Integer n2 = null;
        int n3 = string.indexOf(40);
        if (n3 == -1) {
            mIRExpressionDataTypeInfo = MIRExpressionDataTypeInfo.fromName(string);
        } else {
            String[] stringArray;
            int n4;
            String string2;
            String string3 = string.substring(0, n3);
            mIRExpressionDataTypeInfo = MIRExpressionDataTypeInfo.fromName(string3);
            if (mIRExpressionDataTypeInfo.getHasLength() && !(string2 = string.substring(n3 + 1, n4 = string.indexOf(41))).isEmpty() && (stringArray = string2.split(delimiter)).length > 0 && !stringArray[0].isEmpty()) {
                String string4 = stringArray[0].replaceAll("\\D+", "");
                n = Integer.valueOf(string4);
                if (mIRExpressionDataTypeInfo.getHasScale() && stringArray.length > 1 && !stringArray[1].isEmpty()) {
                    n2 = Integer.valueOf(stringArray[1].trim());
                }
            }
        }
        return new MIRExpressionDataType(mIRExpressionDataTypeInfo, n, n2);
    }

    public static MIRExpressionDataType convert(MIRExpressionDataType mIRExpressionDataType, MIRExpressionDataType mIRExpressionDataType2, String string) {
        if (mIRExpressionDataType2 == null && mIRExpressionDataType == null) {
            return null;
        }
        if (mIRExpressionDataType2 == null) {
            return new MIRExpressionDataType(mIRExpressionDataType);
        }
        if (mIRExpressionDataType == null) {
            return new MIRExpressionDataType(mIRExpressionDataType2);
        }
        MIRExpressionDataType mIRExpressionDataType3 = mIRExpressionDataType.info.getPrecedence() >= mIRExpressionDataType2.info.getPrecedence() ? new MIRExpressionDataType(mIRExpressionDataType) : new MIRExpressionDataType(mIRExpressionDataType2);
        if (string != null) {
            if (mIRExpressionDataType3.getInfo() == MIRExpressionDataTypeInfo.TYPE_TEXT || mIRExpressionDataType3.getInfo() == MIRExpressionDataTypeInfo.TYPE_CHAR) {
                mIRExpressionDataType3.length = mIRExpressionDataType.getLength() + mIRExpressionDataType2.getLength();
            } else {
                mIRExpressionDataType3.scale = Math.min(mIRExpressionDataType.getScale(), mIRExpressionDataType2.getScale());
                mIRExpressionDataType3.length = Math.max(mIRExpressionDataType.getLength(), mIRExpressionDataType2.getLength());
            }
        }
        return mIRExpressionDataType3;
    }

    public String getDataTypeName() {
        String string = this.info.getName();
        if (this.getLength() > 0) {
            string = string + "_" + String.valueOf(this.getLength());
            if (this.getScale() > 0) {
                string = string + "_" + String.valueOf(this.getScale());
            }
        }
        return string;
    }
}

