/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer.rules;

import MITI.expression.analyzer.engine.MIRToken;
import MITI.expression.analyzer.rules.MIRBisonRule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MIRRuleToken {
    private static Map<String, Integer> patterns = new HashMap<String, Integer>();
    private String text;
    private int code;
    private boolean regexp;
    private boolean pattern;
    private HashSet<String> texts = new HashSet();

    public MIRRuleToken(String string) {
        this.text = string;
        this.code = MIRRuleToken.getCode(string);
        if (string.startsWith("{") && string.endsWith("}")) {
            int n = 1;
            int n2 = -1;
            while ((n2 = string.indexOf(124, n)) != -1) {
                this.texts.add(string.substring(n, n2));
                n = n2 + 1;
            }
            this.texts.add(string.substring(n, string.length() - 1));
        } else {
            this.pattern = patterns.containsKey(string);
            this.texts.add(string);
        }
    }

    public boolean match(MIRToken mIRToken, Set<String> set) {
        if (this.code == mIRToken.getCode()) {
            if (this.code == 258) {
                return this.texts.contains(mIRToken.getText().toUpperCase());
            }
            return this.code != 256 || MIRBisonRule.isEOL(mIRToken);
        }
        if (this.text.equals("<STRING>") && (mIRToken.getCode() == 258 || mIRToken.getCode() == 257 || mIRToken.getCode() == 270)) {
            return true;
        }
        return this.text.equals("<NAME>") && mIRToken.getCode() == 258 && !set.contains(mIRToken.getText().toUpperCase());
    }

    public static int getCode(String string) {
        if (string.length() == 1) {
            char c = string.charAt(0);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                return 258;
            }
            return c;
        }
        Integer n = patterns.get(string);
        if (n != null) {
            return n;
        }
        return 258;
    }

    public String getText() {
        return this.text;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isRegexp() {
        return this.regexp;
    }

    public void markRegexp() {
        this.regexp = true;
    }

    boolean isPattern() {
        return this.pattern;
    }

    static {
        patterns.put("<OPERATOR>", 259);
        patterns.put("<BOOL>", 260);
        patterns.put("<DATE>", 261);
        patterns.put("<FLOAT>", 262);
        patterns.put("<INT>", 263);
        patterns.put("<REAL>", 264);
        patterns.put("<STRING>", 265);
        patterns.put("<CONST_STRING>", 265);
        patterns.put("<NAME>", 257);
        patterns.put("<QUOTED_NAME>", 270);
        patterns.put("<EOL>", 256);
    }
}

