/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer.lexer;

import MITI.expression.analyzer.engine.MIRParserOptions;
import MITI.expression.analyzer.engine.MIRToken;
import MITI.expression.analyzer.lexer.MIRBasicFlexLexer;
import MITI.expression.analyzer.lexer.MIRBoCrystalFlexLexer;
import MITI.expression.analyzer.lexer.MIRBoDesignerFlexLexer;
import MITI.expression.analyzer.lexer.MIRBoReporterFlexLexer;
import MITI.expression.analyzer.lexer.MIRBoWebIntelligenceFlexLexer;
import MITI.expression.analyzer.lexer.MIRBteqFlexLexer;
import MITI.expression.analyzer.lexer.MIRCassandraFlexLexer;
import MITI.expression.analyzer.lexer.MIRCognosFlexLexer;
import MITI.expression.analyzer.lexer.MIRDataMappingFlexLexer;
import MITI.expression.analyzer.lexer.MIRDaxFlexLexer;
import MITI.expression.analyzer.lexer.MIRGenericFlexLexer;
import MITI.expression.analyzer.lexer.MIRHiveFlexLexer;
import MITI.expression.analyzer.lexer.MIRIbmCubeViewsFlexLexer;
import MITI.expression.analyzer.lexer.MIRIbmDataStageFlexLexer;
import MITI.expression.analyzer.lexer.MIRInformaticaFlexLexer;
import MITI.expression.analyzer.lexer.MIRInformaticaToolFlexLexer;
import MITI.expression.analyzer.lexer.MIRJavaFlexLexer;
import MITI.expression.analyzer.lexer.MIRLookerFlexLexer;
import MITI.expression.analyzer.lexer.MIRMdxFlexLexer;
import MITI.expression.analyzer.lexer.MIRMicroStrategyFlexLexer;
import MITI.expression.analyzer.lexer.MIROracleBiFlexLexer;
import MITI.expression.analyzer.lexer.MIROracleDiFlexLexer;
import MITI.expression.analyzer.lexer.MIRQlikViewFlexLexer;
import MITI.expression.analyzer.lexer.MIRSalesForceFlexLexer;
import MITI.expression.analyzer.lexer.MIRSnowflakeFlexLexer;
import MITI.expression.analyzer.lexer.MIRSybaseFlexLexer;
import MITI.expression.analyzer.lexer.MIRTableauFlexLexer;
import MITI.expression.analyzer.lexer.MIRTalendFlexLexer;
import MITI.expression.analyzer.lexer.MIRTeradataFastExportFlexLexer;
import MITI.expression.analyzer.lexer.MIRTeradataFastLoadFlexLexer;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public abstract class MIRFlexLexer {
    protected MIRParserOptions options = null;
    protected LexBuffer text = new LexBuffer();
    protected LexBuffer originalText = new LexBuffer();
    protected LexBuffer comments = new LexBuffer();
    protected List<String> extraOptions = new ArrayList<String>();

    protected MIRFlexLexer(MIRParserOptions mIRParserOptions) {
        this.options = mIRParserOptions;
    }

    public static MIRFlexLexer createLexer(MIRParserOptions mIRParserOptions) {
        MIRFlexLexer mIRFlexLexer = null;
        switch (mIRParserOptions.getToolType()) {
            case 8: {
                mIRFlexLexer = new MIRBoCrystalFlexLexer(null, mIRParserOptions);
                break;
            }
            case 3: {
                mIRFlexLexer = new MIRBoDesignerFlexLexer(null, mIRParserOptions);
                break;
            }
            case 2: {
                mIRFlexLexer = new MIRBoReporterFlexLexer(null, mIRParserOptions);
                break;
            }
            case 4: {
                mIRFlexLexer = new MIRBoWebIntelligenceFlexLexer(null, mIRParserOptions);
                break;
            }
            case 1: {
                mIRFlexLexer = new MIRCognosFlexLexer(null, mIRParserOptions);
                break;
            }
            case 6: {
                mIRFlexLexer = new MIRIbmCubeViewsFlexLexer(null, mIRParserOptions);
                break;
            }
            case 11: {
                if (mIRParserOptions.getLangType() == 8) {
                    mIRFlexLexer = new MIRBasicFlexLexer(null, mIRParserOptions);
                    break;
                }
                mIRFlexLexer = new MIRIbmDataStageFlexLexer(null, mIRParserOptions);
                break;
            }
            case 10: {
                if (mIRParserOptions.getLangType() == 9) {
                    mIRFlexLexer = new MIRInformaticaToolFlexLexer(null, mIRParserOptions);
                    break;
                }
                mIRFlexLexer = new MIRInformaticaFlexLexer(null, mIRParserOptions);
                break;
            }
            case 14: {
                mIRFlexLexer = new MIRMicroStrategyFlexLexer(null, mIRParserOptions);
                break;
            }
            case 7: {
                mIRFlexLexer = new MIROracleBiFlexLexer(null, mIRParserOptions);
                break;
            }
            case 15: {
                mIRFlexLexer = new MIROracleDiFlexLexer(null, mIRParserOptions);
                break;
            }
            case 5: {
                mIRFlexLexer = new MIRMdxFlexLexer(null, mIRParserOptions);
                break;
            }
            case 16: {
                mIRFlexLexer = new MIRTableauFlexLexer(null, mIRParserOptions);
                break;
            }
            case 12: {
                if (mIRParserOptions.getLangType() == 7) {
                    mIRFlexLexer = new MIRJavaFlexLexer(null, mIRParserOptions);
                    break;
                }
                mIRFlexLexer = new MIRTalendFlexLexer(null, mIRParserOptions);
                break;
            }
            case 17: {
                if (mIRParserOptions.getLangType() == 9) {
                    mIRFlexLexer = new MIRQlikViewFlexLexer(null, mIRParserOptions);
                    break;
                }
                mIRFlexLexer = new MIRGenericFlexLexer(null, mIRParserOptions);
                break;
            }
            case 18: {
                mIRFlexLexer = new MIRBteqFlexLexer(null, mIRParserOptions);
                break;
            }
            case 19: {
                mIRFlexLexer = new MIRTeradataFastLoadFlexLexer(null, mIRParserOptions);
                break;
            }
            case 20: {
                mIRFlexLexer = new MIRTeradataFastExportFlexLexer(null, mIRParserOptions);
                break;
            }
            case 22: {
                mIRFlexLexer = new MIRDaxFlexLexer(null, mIRParserOptions);
                break;
            }
            case 26: {
                mIRFlexLexer = new MIRLookerFlexLexer(null, mIRParserOptions);
                break;
            }
            case 28: {
                mIRFlexLexer = new MIRDataMappingFlexLexer(null, mIRParserOptions);
                break;
            }
            default: {
                mIRFlexLexer = mIRParserOptions.getLangType() == 11 ? new MIRHiveFlexLexer(null, mIRParserOptions) : (mIRParserOptions.getLangType() == 15 ? new MIRCassandraFlexLexer(null, mIRParserOptions) : (mIRParserOptions.getLangType() == 17 ? new MIRSalesForceFlexLexer(null, mIRParserOptions) : (mIRParserOptions.getLangType() == 20 ? new MIRSnowflakeFlexLexer(null, mIRParserOptions) : (mIRParserOptions.getLangType() == 26 ? new MIRSybaseFlexLexer(null, mIRParserOptions) : (mIRParserOptions.getLangType() == 6 ? new MIRMdxFlexLexer(null, mIRParserOptions) : new MIRGenericFlexLexer(null, mIRParserOptions))))));
            }
        }
        return mIRFlexLexer;
    }

    public MIRToken readFlexToken() {
        int n = 0;
        try {
            n = this.yylex();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n == 267) {
            this.comments.append(this.originalText.toString());
            n = 256;
        }
        if (n == 268) {
            this.extraOptions.add(this.originalText.toString());
            n = 256;
        }
        MIRToken mIRToken = new MIRToken(this.text.toString(), this.originalText.toString(), n, this.getLineNumber(), this.originalText.length() - (this.originalText.str.lastIndexOf("\n") + 1));
        this.text.empty();
        this.originalText.empty();
        return mIRToken;
    }

    public String getComments() {
        return this.comments.toString();
    }

    public List<String> getExtraOptions() {
        return this.extraOptions;
    }

    public void init(String string) {
        this.text.empty();
        this.originalText.empty();
        this.comments.empty();
        this.extraOptions.clear();
        this.init(new StringReader(string));
    }

    public abstract int yylex() throws IOException;

    protected abstract void init(Reader var1);

    protected abstract int getLineNumber();

    protected abstract char[] matchText();

    protected abstract int matchLength();

    protected abstract int matchPos();

    protected class LexBuffer {
        StringBuilder str = new StringBuilder();

        protected LexBuffer() {
        }

        protected void empty() {
            this.str.setLength(0);
        }

        protected int length() {
            return this.str.length();
        }

        protected LexBuffer set(String string) {
            this.str.setLength(0);
            this.str.append(string);
            return this;
        }

        protected LexBuffer set(char[] cArray) {
            this.str.setLength(0);
            this.str.append(cArray, MIRFlexLexer.this.matchPos(), MIRFlexLexer.this.matchLength());
            return this;
        }

        protected LexBuffer append(String string) {
            this.str.append(string);
            return this;
        }

        protected LexBuffer append(char[] cArray) {
            this.str.append(cArray, MIRFlexLexer.this.matchPos(), MIRFlexLexer.this.matchLength());
            return this;
        }

        protected LexBuffer append(char[] cArray, int n) {
            this.str.append(cArray, MIRFlexLexer.this.matchPos(), n);
            return this;
        }

        protected char charAt(int n) {
            return this.str.charAt(n);
        }

        protected String substring(int n) {
            return this.substring(n, this.str.length());
        }

        protected String substring(int n, int n2) {
            return this.str.substring(n, n2);
        }

        public String toString() {
            return this.str.toString();
        }
    }
}

