/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer.engine;

public class MIRToken {
    private String text;
    private String originalText;
    private int code = 0;
    private int linePos = 0;
    private int columnPos = 0;

    public MIRToken(String string, String string2, int n, int n2, int n3) {
        this.text = string;
        this.originalText = string2;
        this.code = n;
        this.linePos = n2;
        this.columnPos = n3;
    }

    public MIRToken(MIRToken mIRToken) {
        this.text = mIRToken.text;
        this.originalText = mIRToken.originalText;
        this.code = mIRToken.code;
        this.linePos = mIRToken.linePos;
        this.columnPos = mIRToken.columnPos;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public void setOriginalText(String string) {
        this.originalText = string;
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public int getCode() {
        return this.code;
    }

    public int getLine() {
        return this.linePos;
    }

    public int getColumn() {
        return this.columnPos;
    }

    public void merge(MIRToken mIRToken) {
        this.merge(mIRToken, false);
    }

    public void merge(MIRToken mIRToken, boolean bl) {
        if (this == mIRToken) {
            return;
        }
        if (bl || mIRToken.code == 256) {
            if (!this.text.endsWith(" ")) {
                this.text = this.text + " ";
            }
            if (!this.originalText.endsWith(" ")) {
                this.originalText = this.originalText + " ";
            }
        }
        if (mIRToken.code != 256) {
            this.text = this.text + mIRToken.text;
            this.originalText = this.originalText + mIRToken.originalText;
        }
        this.mergePositions(mIRToken);
    }

    public void mergePositions(MIRToken mIRToken) {
        if (this.linePos == mIRToken.linePos) {
            this.columnPos += mIRToken.columnPos;
        } else {
            this.linePos = mIRToken.linePos;
            this.columnPos = mIRToken.columnPos;
        }
    }
}

