/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer.decoration;

import MITI.expression.analyzer.decoration.MIRDecor;
import MITI.expression.analyzer.decoration.MIRDecorUtil;
import MITI.expression.analyzer.decoration.MIRDecors;
import MITI.expression.analyzer.decoration.MIRStatementOutput;
import MITI.expression.analyzer.decoration.MIRVariables;
import MITI.expression.analyzer.engine.MIRParserOptions;
import MITI.expression.functions.FunctionImplementation;
import MITI.expression.functions.MIRFunctionMapping;
import MITI.sdk.MIRBranchingNode;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassType;
import MITI.sdk.MIRDataAttribute;
import MITI.sdk.MIRDelimiterNode;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIROperatorNode;
import MITI.sdk.MIRQueryNode;
import MITI.sdk.MIRStatementNode;
import MITI.sdk.MIRStoredProcedure;
import MITI.sdk.MIRSynonym;
import MITI.sdk.MIRType;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class MIRStatementDecor {
    private MIRDecors decors = null;
    private MIRStatementNode statement = null;
    private final MIRParserOptions options;
    private ArrayList<MIRElementNode> classifiers = new ArrayList();
    private ArrayList<MIRElementNode> features = new ArrayList();
    private ArrayList<MIRStatementOutput> outputFeatures = new ArrayList();
    ArrayList<MIRElementNode> generatedFeatures = new ArrayList();
    boolean hasCondition;

    Set<MIRStatementDecor> getOutputStatementDecors() {
        LinkedHashSet<MIRStatementDecor> linkedHashSet = new LinkedHashSet<MIRStatementDecor>();
        for (MIRStatementOutput mIRStatementOutput : this.outputFeatures) {
            for (MIRExpressionNode mIRExpressionNode : mIRStatementOutput.features) {
                MIRStatementDecor mIRStatementDecor = this.decors.getDecor(mIRExpressionNode).getStatementDecor();
                linkedHashSet.add(mIRStatementDecor);
            }
        }
        return linkedHashSet;
    }

    public MIRStatementDecor(MIRDecors mIRDecors, MIRStatementNode mIRStatementNode, MIRParserOptions mIRParserOptions) {
        this.decors = mIRDecors;
        this.statement = mIRStatementNode;
        this.options = mIRParserOptions;
    }

    public int getStatementType() {
        return this.statement.getStatementType();
    }

    ArrayList<MIRElementNode> getClassifiers() {
        return this.classifiers;
    }

    public void addElementNode(MIRElementNode mIRElementNode) {
        if (mIRElementNode == null) {
            return;
        }
        switch (mIRElementNode.getDestinationElementType()) {
            case 23: 
            case 66: 
            case 75: 
            case 209: {
                this.classifiers.add(mIRElementNode);
                break;
            }
            case 77: {
                this.features.add(mIRElementNode);
            }
        }
    }

    public void addOutputElementNode(MIRElementNode mIRElementNode) {
        MIRStatementOutput mIRStatementOutput = new MIRStatementOutput(mIRElementNode, null, this.options.supportExpressionNameComputation());
        this.outputFeatures.add(mIRStatementOutput);
    }

    public MIRStatementNode getOutputStatement() {
        MIRExpressionNode mIRExpressionNode;
        if (this.statement.getStatementType() == 4 && (mIRExpressionNode = this.statement.getReferencedExpressionNodes().first()) != null && mIRExpressionNode.getElementType() == 134) {
            MIRStatementDecor mIRStatementDecor = this.decors.getDecor(mIRExpressionNode).getStatementDecor();
            return mIRStatementDecor.getOutputStatement();
        }
        return this.statement;
    }

    public void computeOutputFeatures(boolean bl) {
        List<MIRExpressionNode> list;
        if (!this.outputFeatures.isEmpty()) {
            return;
        }
        int n = this.statement.getStatementType();
        if (n == 1) {
            MIRDelimiterNode mIRDelimiterNode = (MIRDelimiterNode)this.statement.getExpressionNode("FOR");
            if (mIRDelimiterNode != null) {
                this.processDelimiterNode(mIRDelimiterNode);
            } else {
                MIRDelimiterNode mIRDelimiterNode2 = (MIRDelimiterNode)this.statement.getExpressionNode("SELECT");
                this.processDelimiterNode(mIRDelimiterNode2);
            }
        } else if (n == 6) {
            MIRExpressionNode mIRExpressionNode;
            MIROperatorNode mIROperatorNode = (MIROperatorNode)this.statement.getExpressionNodeByPosition().get(0);
            MIRExpressionNode mIRExpressionNode2 = mIROperatorNode.getLeftExpressionNode();
            if (mIRExpressionNode2.getElementType() == 134) {
                this.processStatementNode((MIRStatementNode)mIRExpressionNode2);
            }
            if ((mIRExpressionNode = mIROperatorNode.getRightExpressionNode()).getElementType() == 134) {
                this.processStatementNode((MIRStatementNode)mIRExpressionNode);
            }
        } else if (n == 5 || n == 36) {
            MIRExpressionNode mIRExpressionNode;
            MIRExpressionNode mIRExpressionNode3;
            if (this.statement.getExpressionNodeCount() > 1 && (mIRExpressionNode3 = this.statement.getExpressionNodeByPosition().get(1)) instanceof MIRDelimiterNode && (mIRExpressionNode3.getName().equals("TABLE") || mIRExpressionNode3.getName().equals("VIEW") || mIRExpressionNode3.getName().equals("RECORD"))) {
                this.processDelimiterNode((MIRDelimiterNode)mIRExpressionNode3);
            }
            if ((mIRExpressionNode = this.statement.getExpressionNode("RETURN")) != null) {
                this.processDelimiterNode((MIRDelimiterNode)mIRExpressionNode);
            }
        } else if (n == 2) {
            MIRDelimiterNode mIRDelimiterNode = (MIRDelimiterNode)this.statement.getExpressionNode("INTO");
            this.processDelimiterNode(mIRDelimiterNode);
        } else if (n == 3) {
            MIRDelimiterNode mIRDelimiterNode = (MIRDelimiterNode)this.statement.getExpressionNode("SET");
            this.processDelimiterNode(mIRDelimiterNode);
        } else if (n == 9) {
            this.processDelimiterNode((MIRDelimiterNode)this.statement.getExpressionNodeByPosition().get(this.statement.getExpressionNodeCount() - 1));
        } else if (n == 10) {
            Object object;
            MIRExpressionNode mIRExpressionNode = ((MIRDelimiterNode)this.statement.getExpressionNode("FROM")).getExpressionNodeByPosition().get(0);
            if (mIRExpressionNode instanceof MIROperatorNode) {
                mIRExpressionNode = ((MIROperatorNode)mIRExpressionNode).getLeftExpressionNode();
            }
            if (mIRExpressionNode instanceof MIRStatementNode) {
                object = this.decors.getDecor(mIRExpressionNode).getStatementDecor();
                for (int i = 0; i < ((MIRStatementDecor)object).getOutputCount(); ++i) {
                    MIRStatementOutput mIRStatementOutput = ((MIRStatementDecor)object).getOutput(i);
                    boolean bl2 = false;
                    for (MIRExpressionNode mIRExpressionNode4 : mIRStatementOutput.features) {
                        if (mIRExpressionNode4.getReferencedByElementNamePartCount() <= 0) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    this.outputFeatures.add(new MIRStatementOutput(mIRStatementOutput));
                }
            }
            object = (MIRDelimiterNode)this.statement.getExpressionNode("IN");
            this.processDelimiterNode((MIRDelimiterNode)object);
        } else if (n == 28) {
            MIRExpressionNode mIRExpressionNode = ((MIRDelimiterNode)this.statement.getExpressionNode("FROM")).getExpressionNodeByPosition().get(0);
            if (mIRExpressionNode instanceof MIROperatorNode) {
                mIRExpressionNode = ((MIROperatorNode)mIRExpressionNode).getLeftExpressionNode();
            }
            if (mIRExpressionNode instanceof MIRStatementNode) {
                MIRStatementDecor mIRStatementDecor = this.decors.getDecor(mIRExpressionNode).getStatementDecor();
                for (int i = 0; i < mIRStatementDecor.getOutputCount(); ++i) {
                    MIRStatementOutput mIRStatementOutput = mIRStatementDecor.getOutput(i);
                    boolean bl3 = false;
                    for (MIRExpressionNode mIRExpressionNode5 : mIRStatementOutput.features) {
                        if (mIRExpressionNode5.getReferencedByElementNamePartCount() <= 0) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl3) continue;
                    this.outputFeatures.add(new MIRStatementOutput(mIRStatementOutput));
                }
            }
            this.processDelimiterNode((MIRDelimiterNode)this.statement.getExpressionNode("SELECT"));
            this.processDelimiterNode((MIRDelimiterNode)this.statement.getExpressionNode("FOR"));
        } else if (n == 4) {
            for (MIRExpressionNode mIRExpressionNode : this.statement.getReferencedExpressionNodes()) {
                MIRStatementOutput mIRStatementOutput = new MIRStatementOutput(mIRExpressionNode, null, this.options.supportExpressionNameComputation());
                this.outputFeatures.add(mIRStatementOutput);
            }
        } else if (n == 14) {
            MIRExpressionNode mIRExpressionNode = this.statement.getExpressionNodeByPosition().get(this.statement.getExpressionNodeCount() - 1);
            if (mIRExpressionNode.getElementType() == 134 && (((MIRStatementNode)mIRExpressionNode).getStatementType() == 1 || ((MIRStatementNode)mIRExpressionNode).getStatementType() == 6)) {
                this.processStatementNode((MIRStatementNode)mIRExpressionNode);
            } else if (mIRExpressionNode.getElementType() == 111) {
                this.processElementNode((MIRElementNode)mIRExpressionNode);
            } else if (mIRExpressionNode.getElementType() == 115 || mIRExpressionNode.getElementType() == 104 || mIRExpressionNode.getElementType() == 114) {
                if (mIRExpressionNode.getElementType() == 114 && "table".equals(mIRExpressionNode.getDataType())) {
                    MIROperationNode mIROperationNode = (MIROperationNode)mIRExpressionNode;
                    for (MIRExpressionNode mIRExpressionNode6 : mIROperationNode.getExpressionNodes()) {
                        MIROperatorNode mIROperatorNode;
                        MIRExpressionNode mIRExpressionNode7;
                        if (!(mIRExpressionNode6 instanceof MIROperatorNode) || !((mIRExpressionNode7 = (mIROperatorNode = (MIROperatorNode)mIRExpressionNode6).getRightExpressionNode()) instanceof MIRElementNode)) continue;
                        MIRElementNode mIRElementNode = (MIRElementNode)mIRExpressionNode7;
                        this.processElementNode(mIRElementNode);
                    }
                } else {
                    MIRStatementOutput mIRStatementOutput = new MIRStatementOutput(mIRExpressionNode, null, this.options.supportExpressionNameComputation());
                    this.outputFeatures.add(mIRStatementOutput);
                }
            }
        } else if (n == 17) {
            List<MIRExpressionNode> list2 = this.statement.getExpressionNodeByPosition();
            if (!list2.get(2).getName().equals("INTO")) {
                this.processDelimiterNode((MIRDelimiterNode)list2.get(2));
            }
        } else if (n == 18) {
            MIRBranchingNode mIRBranchingNode = (MIRBranchingNode)this.statement.getExpressionNode("MERGE");
            for (MIRExpressionNode mIRExpressionNode : mIRBranchingNode.getExpressionNodeByPosition()) {
                MIRStatementNode mIRStatementNode = (MIRStatementNode)((MIRBranchingNode)mIRExpressionNode).getExpressionNodeByPosition().get(0);
                this.processStatementNodeByName(mIRStatementNode);
            }
        } else if (n == 20) {
            for (MIRExpressionNode mIRExpressionNode : this.statement.getExpressionNodeByPosition()) {
                if (!(mIRExpressionNode instanceof MIROperationNode) && !(mIRExpressionNode instanceof MIRElementNode)) continue;
                MIRStatementOutput mIRStatementOutput = new MIRStatementOutput(mIRExpressionNode, null, this.options.supportExpressionNameComputation());
                this.outputFeatures.add(mIRStatementOutput);
            }
        } else if (n == 21) {
            this.processDelimiterNode((MIRDelimiterNode)this.statement.getExpressionNodeByPosition().get(this.statement.getExpressionNodeCount() - 1));
        } else if (n == 32) {
            this.processDelimiterNode((MIRDelimiterNode)this.statement.getExpressionNodeByPosition().get(this.statement.getExpressionNodeCount() - 1));
        } else if (n == 23) {
            if (this.statement.getExpressionNodeCount() > 1) {
                MIRDelimiterNode mIRDelimiterNode = (MIRDelimiterNode)this.statement.getExpressionNodeByPosition().get(1);
                this.processDelimiterNode(mIRDelimiterNode);
            }
        } else if (n == 11 || bl && n == 0) {
            for (MIRExpressionNode mIRExpressionNode : this.statement.getExpressionNodeByPosition()) {
                if (mIRExpressionNode instanceof MIROperatorNode) {
                    mIRExpressionNode = ((MIROperatorNode)mIRExpressionNode).getRightExpressionNode();
                }
                if (!(mIRExpressionNode instanceof MIROperationNode) || !"table".equals(mIRExpressionNode.getDataType()) && MIRDecorUtil.getLastPart((MIROperationNode)mIRExpressionNode).getReferencedElementCount() <= 0) continue;
                for (MIRExpressionNode mIRExpressionNode8 : ((MIROperationNode)mIRExpressionNode).getExpressionNodeByPosition()) {
                    if (mIRExpressionNode8 instanceof MIROperatorNode && "=".equals(mIRExpressionNode8.getName())) {
                        if (!this.decors.getDecor(mIRExpressionNode8 = ((MIROperatorNode)mIRExpressionNode8).getLeftExpressionNode()).isData()) continue;
                        this.outputFeatures.add(new MIRStatementOutput(mIRExpressionNode8, null, this.options.supportExpressionNameComputation()));
                        continue;
                    }
                    this.outputFeatures.add(new MIRStatementOutput(mIRExpressionNode8, null, this.options.supportExpressionNameComputation()));
                }
            }
        } else if (n == 34 && (list = this.statement.getExpressionNodeByPosition()).get(0) instanceof MIRQueryNode) {
            this.processQueryNode((MIRQueryNode)list.get(0));
        }
    }

    public MIRElementNode qualifyClassifier(MIRElementNode mIRElementNode, MIRVariables mIRVariables, boolean bl) {
        Object object;
        MIRObject mIRObject;
        int n;
        List<MIRElementNamePart> list = mIRElementNode.getElementNamePartByPosition();
        for (n = list.size(); n > 0; --n) {
            mIRObject = list.get(n - 1);
            if (mIRObject.getSourceElementType() != 75) continue;
            if (mIRObject.getReferencedElementCount() <= 0) break;
            return null;
        }
        mIRObject = null;
        while (n > 0) {
            object = this.classifiers.iterator();
            while (object.hasNext()) {
                MIRElementNode mIRElementNode2 = object.next();
                if (mIRObject != null && ((MIRElementNode)mIRObject).getElementNamePartCount() >= mIRElementNode2.getElementNamePartCount()) continue;
                List<MIRElementNamePart> list2 = mIRElementNode2.getElementNamePartByPosition();
                int n2 = list2.size();
                int n3 = Math.min(n, n2);
                int n4 = 0;
                for (n4 = 0; n4 < n3; ++n4) {
                    MIRElementNamePart mIRElementNamePart = list.get(n - 1 - n4);
                    MIRElementNamePart mIRElementNamePart2 = list2.get(n2 - 1 - n4);
                    if (!mIRVariables.getOptions().compareNames(mIRElementNamePart.getName(), mIRElementNamePart.getQuoted(), mIRElementNamePart2.getName(), mIRElementNamePart2.getQuoted())) break;
                }
                if (n4 != n3) continue;
                mIRObject = mIRElementNode2;
            }
            if (mIRObject == null && n == 1 && (mIRObject = mIRVariables.get(list.get(n - 1))) == mIRElementNode) {
                mIRObject = null;
            }
            if (mIRObject != null || mIRElementNode.getDestinationElementType() != 77) break;
            if (mIRObject == null && this.hasCondition && this.statement.getStatementType() == 1 && (object = this.getParent()) != null) {
                ((MIRStatementDecor)object).qualifyClassifier(mIRElementNode, mIRVariables, bl);
            }
            --n;
        }
        if (mIRObject != null) {
            object = list.get(n - 1);
            ((MIRElementNamePart)object).setSourceElementType((short)75);
            if (!((MIRElementNamePart)object).containsReferencedElement((MIRElement)mIRObject)) {
                ((MIRElementNamePart)object).addReferencedElement((MIRElement)mIRObject);
            }
            for (int i = n; i < list.size(); ++i) {
                object = list.get(i);
                ((MIRElementNamePart)object).setSourceElementType((short)77);
            }
        } else if ((bl || this.statement.getExpression() != null) && this.classifiers.size() == 1) {
            mIRObject = this.classifiers.get(0);
        }
        return mIRObject;
    }

    public List<MIRElement> qualifyFeature(MIRElementNode mIRElementNode, boolean bl, MIRFunctionMapping mIRFunctionMapping) {
        boolean bl2;
        FunctionImplementation functionImplementation;
        MIROperationNode mIROperationNode;
        LinkedList<MIRElement> linkedList = new LinkedList<MIRElement>();
        MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getFirstNotQualifiedPart(mIRElementNode);
        if (bl && mIRElementNode.getElementNamePartCount() == 1) {
            this.computeOutputFeatures(false);
            MIRStatementOutput mIRStatementOutput = this.getOutput(mIRElementNamePart.getName(), mIRElementNamePart.getQuoted());
            if (mIRStatementOutput != null) {
                mIRStatementOutput.qualifyFeature(mIRElementNamePart);
                linkedList.addAll(mIRStatementOutput.features);
                return linkedList;
            }
        }
        boolean bl3 = this.options.supportHierarchies();
        if (this.options.supportStructuralOperations() && (mIROperationNode = this.getOperationQualitifer(mIRElementNode)) != null && (functionImplementation = mIRFunctionMapping.getImplementation(mIROperationNode, mIROperationNode.getExpressionNodeCount())) != null) {
            bl2 = false;
            for (MIRExpressionNode mIRExpressionNode : mIROperationNode.getExpressionNodeByPosition()) {
                if (functionImplementation.isReturnValueArgument(bl2 ? 1 : 0)) {
                    MIRExpressionNode mIRExpressionNode2 = mIRExpressionNode instanceof MIROperatorNode && "=".equals(mIRExpressionNode.getName()) ? ((MIROperatorNode)mIRExpressionNode).getLeftExpressionNode() : mIRExpressionNode;
                    mIRElementNamePart.addReferencedElement(mIRExpressionNode2);
                    linkedList.add(mIRExpressionNode2);
                }
                bl2 += 1;
            }
        }
        if (linkedList.isEmpty()) {
            bl2 = bl3 && mIRElementNamePart != MIRDecorUtil.getLastPart(mIRElementNode);
            MIRElementNamePart mIRElementNamePart2 = MIRDecorUtil.getClassifierPart(mIRElementNode);
            if (mIRElementNamePart2 != null && mIRElementNamePart2.getReferencedElementCount() > 0) {
                for (MIRElement mIRElement : mIRElementNamePart2.getReferencedElements()) {
                    linkedList.addAll(this.qualifyFeature(mIRElementNamePart, mIRElement, bl2));
                }
                if (!bl3) {
                    for (MIRElementNamePart mIRElementNamePart3 : mIRElementNode.getElementNamePartByPosition()) {
                        if (77 != mIRElementNamePart3.getSourceElementType() || mIRElementNamePart3 == mIRElementNamePart) continue;
                        for (MIRElement mIRElement : linkedList) {
                            mIRElementNamePart3.addReferencedElement(mIRElement);
                        }
                    }
                }
            } else {
                for (MIRElementNode mIRElementNode2 : this.classifiers) {
                    linkedList.addAll(this.qualifyFeature(mIRElementNamePart, mIRElementNode2, bl2));
                }
                if (!linkedList.isEmpty()) {
                    mIRElementNamePart.setSourceElementType((short)77);
                }
            }
        }
        return linkedList;
    }

    public <T extends MIRElement> void buildQualifierList(MIRElementNode mIRElementNode, Set<T> set, boolean bl, boolean bl2) {
        if (mIRElementNode == null) {
            return;
        }
        MIRElement mIRElement = null;
        short s = 75;
        if (mIRElementNode.getRightOfOperatorNode() != null && ".".equals(mIRElementNode.getRightOfOperatorNode().getName())) {
            mIRElement = mIRElementNode.getRightOfOperatorNode().getLeftExpressionNode();
        } else if (mIRElementNode.getDestinationElementType() == 77) {
            mIRElement = MIRDecorUtil.getReference(mIRElementNode, (short)75);
            if (mIRElement == null) {
                mIRElement = MIRDecorUtil.getReference(mIRElementNode, (short)23);
            }
        } else {
            s = 144;
        }
        if (mIRElement != null) {
            this.buildQualifierList(s, mIRElement, set, bl, bl2, new HashSet<MIRElement>());
        } else {
            this.buildQualifierList(s, this.statement, set, bl, bl2, new HashSet<MIRElement>());
        }
    }

    public <T extends MIRElement> void buildQualifierList(MIROperationNode mIROperationNode, Set<T> set, HashSet<MIRElement> hashSet) {
        if (mIROperationNode == null || !hashSet.add(mIROperationNode)) {
            return;
        }
        this.buildQualifierList((short)144, this.statement, set, false, false, hashSet);
    }

    public void propagate(boolean bl) {
        MIRStatementDecor mIRStatementDecor = this.getParent();
        if (mIRStatementDecor == null) {
            return;
        }
        switch (this.statement.getStatementType()) {
            case 1: 
            case 6: 
            case 9: 
            case 17: 
            case 34: {
                if (mIRStatementDecor.getStatementType() == 1 || mIRStatementDecor.getStatementType() == 6 || mIRStatementDecor.getStatementType() == 2 || mIRStatementDecor.getStatementType() == 5 || mIRStatementDecor.getStatementType() == 36) {
                    mIRStatementDecor.hasCondition |= this.hasCondition;
                    break;
                }
                if (mIRStatementDecor.getStatementType() != 7 && mIRStatementDecor.getStatementType() != 0 && mIRStatementDecor.getStatementType() != 19 && mIRStatementDecor.getStatementType() != 14 || this.getOutputCount() <= 0) break;
                mIRStatementDecor.hasCondition |= this.hasCondition;
                if (bl || !mIRStatementDecor.hasCondition && mIRStatementDecor.getStatementType() == 7 && mIRStatementDecor.getOutputCount() != 0) break;
                mIRStatementDecor.processStatementNode(this.statement);
                break;
            }
            case 10: {
                if (mIRStatementDecor.getStatementType() != 1) break;
                mIRStatementDecor.hasCondition |= this.hasCondition;
                break;
            }
            case 0: 
            case 7: 
            case 14: 
            case 19: {
                if (mIRStatementDecor.getStatementType() != 0 && mIRStatementDecor.getStatementType() != 19 && mIRStatementDecor.getStatementType() != 7) break;
                if (!bl) {
                    mIRStatementDecor.processStatementNode(this.statement);
                }
                if (this.getOutputCount() <= 0) break;
                mIRStatementDecor.hasCondition |= this.hasCondition;
            }
        }
    }

    MIRStatementDecor getParent() {
        MIRStatementDecor mIRStatementDecor = null;
        MIRObject mIRObject = this.statement.getParent();
        if (mIRObject != null && mIRObject instanceof MIRExpressionNode) {
            mIRStatementDecor = this.decors.getDecor((MIRExpressionNode)mIRObject).getStatementDecor();
        }
        return mIRStatementDecor;
    }

    public boolean propagateFeatures(MIRElementNode mIRElementNode, MIRDelimiterNode mIRDelimiterNode, MIRElementNode mIRElementNode2, boolean bl) {
        return this.propagateFeaturesInternal(mIRElementNode, mIRDelimiterNode, mIRElementNode2, bl, new HashSet<MIRExpressionNode>());
    }

    public boolean propagateFeaturesInternal(MIRElementNode mIRElementNode, MIRDelimiterNode mIRDelimiterNode, MIRElementNode mIRElementNode2, boolean bl, Set<MIRExpressionNode> set) {
        boolean bl2 = false;
        if (mIRElementNode == null || !set.add(mIRElementNode)) {
            return bl2;
        }
        MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode);
        for (MIRElement mIRElement : mIRElementNamePart.getReferencedElements()) {
            if (mIRElement == null) continue;
            if (mIRElement.getElementType() == 111) {
                if (((MIRElementNode)mIRElement).getDestinationElementType() == 77) {
                    for (MIRExpressionNode mIRExpressionNode : mIRDelimiterNode.getExpressionNodes()) {
                        MIRDecorUtil.getLastPart((MIRElementNode)mIRExpressionNode).addReferencedElement(mIRElement);
                        bl2 = true;
                    }
                    continue;
                }
                bl2 = this.propagateFeaturesInternal((MIRElementNode)mIRElement, mIRDelimiterNode, mIRElementNode2, bl, set) || bl2;
                continue;
            }
            if (mIRElement.getElementType() == 339) {
                bl2 = this.propagateFeatures((MIRQueryNode)mIRElement, mIRDelimiterNode, mIRElementNode2, bl) || bl2;
                continue;
            }
            if (mIRElement.getElementType() != 134) continue;
            bl2 = this.propagateFeatures((MIRStatementNode)mIRElement, mIRDelimiterNode, mIRElementNode2, bl) || bl2;
        }
        return bl2;
    }

    public boolean propagateFeatures(MIRQueryNode mIRQueryNode, MIRDelimiterNode mIRDelimiterNode, MIRElementNode mIRElementNode, boolean bl) {
        block4: {
            block3: {
                if (mIRQueryNode == null) {
                    return false;
                }
                if (mIRDelimiterNode.getExpressionNodeCount() != 0) break block3;
                for (MIRExpressionNode mIRExpressionNode : mIRQueryNode.getFeatureDelimiterNode().getExpressionNodeByPosition()) {
                    MIRElementNode mIRElementNode2 = this.buildFeatureNode(mIRDelimiterNode, mIRExpressionNode.getName(), false, mIRElementNode);
                    MIRDecorUtil.getLastPart(mIRElementNode2).addReferencedElement(mIRExpressionNode);
                }
                break block4;
            }
            if (!bl) break block4;
            Iterator<MIRExpressionNode> iterator = mIRDelimiterNode.getExpressionNodeByPosition().iterator();
            Iterator<MIRExpressionNode> iterator2 = mIRQueryNode.getFeatureDelimiterNode().getExpressionNodeByPosition().iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                MIRDecorUtil.getLastPart((MIRElementNode)iterator.next()).addReferencedElement(iterator2.next());
            }
        }
        return true;
    }

    public boolean propagateFeatures(MIRStatementNode object, MIRDelimiterNode mIRDelimiterNode, MIRElementNode mIRElementNode, boolean bl) {
        Iterator iterator;
        Object object2;
        Iterator iterator2;
        Object object3;
        if (object == null) {
            return false;
        }
        MIRDecor mIRDecor = this.decors.getDecor((MIRExpressionNode)object);
        MIRStatementDecor mIRStatementDecor = mIRDecor.getStatementDecor();
        if (((MIRStatementNode)object).getStatementType() == 4 && (object3 = mIRStatementDecor.getOutputStatement()) != object) {
            object = object3;
            mIRStatementDecor = this.decors.getDecor((MIRExpressionNode)object).getStatementDecor();
        }
        object3 = this;
        while ((object3 = ((MIRStatementDecor)object3).getParent()) != null && ((MIRStatementDecor)object3).getStatementType() == 6) {
        }
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        if (mIRDelimiterNode.getExpressionNodeCount() == 0) {
            iterator2 = mIRStatementDecor.outputFeatures.iterator();
            while (iterator2.hasNext()) {
                object2 = (MIRStatementOutput)iterator2.next();
                if (!this.hasStar((MIRStatementOutput)object2, mIRStatementDecor) || object3 != null && ((MIRStatementDecor)object3).getStatementType() == 1) {
                    iterator = this.buildFeatureNode(mIRDelimiterNode, ((MIRStatementOutput)object2).getName(), ((MIRStatementOutput)object2).isQuoted(), mIRElementNode);
                    ((MIRElementNode)((Object)iterator)).setKind(bl ? (byte)2 : 3);
                    ((MIRStatementOutput)object2).qualifyFeature(MIRDecorUtil.getLastPart((MIRElementNode)((Object)iterator)));
                    continue;
                }
                linkedHashSet.add(object2);
            }
            if (this.getStatementType() == 32) {
                iterator2 = mIRDelimiterNode.getExpressionNodes().iterator();
                while (iterator2.hasNext()) {
                    object2 = (MIRExpressionNode)iterator2.next();
                    if (mIRStatementDecor.generatedFeatures.containsAll(MIRDecorUtil.getLastPart((MIRElementNode)object2).getReferencedElements())) continue;
                    this.generatedFeatures.remove(object2);
                }
            }
        }
        Iterator iterator3 = iterator2 = object3 != null ? ((MIRStatementDecor)object3).getParent() : null;
        if (mIRDelimiterNode.getExpressionNodeCount() == 0 && linkedHashSet.size() == 1 && (iterator2 == null || iterator2 != null && ((MIRStatementDecor)((Object)iterator2)).getStatementType() != 4 && ((MIRStatementDecor)((Object)iterator2)).getStatementType() != 7)) {
            object2 = this.buildFeatureNode(mIRDelimiterNode, "*", false, mIRElementNode);
            this.generatedFeatures.remove(object2);
            ((MIRElementNode)object2).setKind(bl ? (byte)2 : 3);
            for (Object object4 : linkedHashSet) {
                ((MIRStatementOutput)object4).qualifyFeature(MIRDecorUtil.getLastPart((MIRElementNode)object2));
            }
        }
        if (bl && mIRStatementDecor.outputFeatures.size() > 0) {
            Object object4;
            object2 = mIRStatementDecor.outputFeatures.iterator();
            iterator = (MIRStatementOutput)object2.next();
            object4 = mIRDelimiterNode.getExpressionNodeByPosition();
            Iterator<MIRExpressionNode> iterator4 = object4.iterator();
            while (iterator4.hasNext()) {
                if (!linkedHashSet.contains(iterator)) {
                    MIRExpressionNode mIRExpressionNode = iterator4.next();
                    if (iterator != null && mIRExpressionNode instanceof MIRElementNode) {
                        ((MIRStatementOutput)((Object)iterator)).qualifyFeature(MIRDecorUtil.getLastPart((MIRElementNode)mIRExpressionNode));
                    }
                    if (((MIRStatementNode)object).getStatementType() == 20 || ((MIRStatementNode)object).getStatementType() == 4) continue;
                }
                iterator = object2.hasNext() ? (MIRStatementOutput)object2.next() : null;
            }
        }
        return true;
    }

    public boolean propagateFeatures(MIRDelimiterNode mIRDelimiterNode, MIRDelimiterNode mIRDelimiterNode2, MIRElementNode mIRElementNode, boolean bl) {
        MIRElementNamePart mIRElementNamePart;
        MIRElementNode mIRElementNode2;
        Object object;
        if (mIRDelimiterNode == null || mIRDelimiterNode2 == null) {
            return false;
        }
        if (mIRDelimiterNode2.getExpressionNodeCount() == 0) {
            for (MIRExpressionNode mIRExpressionNode : mIRDelimiterNode.getExpressionNodeByPosition()) {
                object = new MIRStatementOutput(mIRExpressionNode, null, this.options.supportExpressionNameComputation());
                mIRElementNode2 = this.buildFeatureNode(mIRDelimiterNode2, ((MIRStatementOutput)object).getName(), ((MIRStatementOutput)object).isQuoted(), mIRElementNode);
                mIRElementNode2.setKind(bl ? (byte)2 : 3);
                mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode2);
                if (mIRElementNamePart.containsReferencedElement(mIRExpressionNode)) continue;
                mIRElementNamePart.addReferencedElement(mIRExpressionNode);
            }
        }
        if (bl) {
            int n = mIRDelimiterNode2.getExpressionNodeCount();
            for (int i = 0; i < n; ++i) {
                MIRExpressionNode mIRExpressionNode;
                if (i >= mIRDelimiterNode.getExpressionNodeCount() || !((object = mIRDelimiterNode2.getExpressionNodeByPosition().get(i)) instanceof MIRElementNode) || (mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode2 = (MIRElementNode)object)).containsReferencedElement(mIRExpressionNode = mIRDelimiterNode.getExpressionNodeByPosition().get(i))) continue;
                mIRElementNamePart.addReferencedElement(mIRExpressionNode);
            }
        }
        return true;
    }

    public List<MIRExpressionNode> propagateFeatures(MIRElementNode mIRElementNode, boolean bl) {
        LinkedList<MIRExpressionNode> linkedList = new LinkedList<MIRExpressionNode>();
        for (MIRElementNode mIRElementNode2 : this.classifiers) {
            MIRDelimiterNode mIRDelimiterNode;
            if (!this.propagateFeaturesInternal(mIRElementNode2, mIRDelimiterNode = new MIRDelimiterNode(), mIRElementNode, bl, new HashSet<MIRExpressionNode>())) continue;
            linkedList.addAll(mIRDelimiterNode.getExpressionNodes());
            mIRDelimiterNode.removeExpressionNodes();
        }
        return linkedList;
    }

    public MIRElementNode buildFeatureNode(MIRDelimiterNode mIRDelimiterNode, String string, boolean bl, MIRElementNode mIRElementNode) {
        List<MIRElementNamePart> list = mIRElementNode != null ? mIRElementNode.getElementNamePartByPosition() : null;
        return this.buildFeatureNode(mIRDelimiterNode, string, bl, list);
    }

    MIRElementNode buildFeatureNode(MIRDelimiterNode mIRDelimiterNode, String string, boolean bl, MIROperationNode mIROperationNode) {
        List<MIRElementNamePart> list = mIROperationNode != null ? mIROperationNode.getElementNamePartByPosition() : null;
        return this.buildFeatureNode(mIRDelimiterNode, string, bl, list);
    }

    private MIRElementNode buildFeatureNode(MIRDelimiterNode mIRDelimiterNode, String string, boolean bl, Collection<MIRElementNamePart> collection) {
        MIRElementNode mIRElementNode = new MIRElementNode();
        mIRElementNode.setName(string);
        mIRElementNode.setDestinationElementType((short)77);
        mIRElementNode.setKind((byte)3);
        if (collection != null) {
            for (MIRElementNamePart mIRElementNamePart : collection) {
                if (mIRElementNamePart.getSourceElementType() == 77) continue;
                MIRElementNamePart mIRElementNamePart2 = new MIRElementNamePart(mIRElementNamePart);
                mIRElementNode.addElementNamePart(mIRElementNamePart2);
                for (MIRElement mIRElement : mIRElementNamePart.getReferencedElements()) {
                    mIRElementNamePart2.addReferencedElement(mIRElement);
                }
            }
        }
        MIRElementNamePart mIRElementNamePart = new MIRElementNamePart();
        mIRElementNamePart.setName(string);
        mIRElementNamePart.setQuoted(bl);
        mIRElementNamePart.setSourceElementType((short)77);
        mIRElementNamePart.setPosition((short)mIRElementNode.getElementNamePartCount());
        mIRElementNode.addElementNamePart(mIRElementNamePart);
        mIRElementNode.setPosition((short)this.generatedFeatures.size());
        if (mIRDelimiterNode != null) {
            mIRDelimiterNode.addExpressionNode(mIRElementNode);
        }
        this.generatedFeatures.add(mIRElementNode);
        return mIRElementNode;
    }

    public int getOutputCount() {
        return this.outputFeatures.size();
    }

    public MIRStatementOutput getOutput(int n) {
        if (n >= 0 && n < this.outputFeatures.size()) {
            return this.outputFeatures.get(n);
        }
        return null;
    }

    public void addStatementOutput(MIRStatementOutput mIRStatementOutput) {
        this.outputFeatures.add(mIRStatementOutput);
    }

    MIRStatementOutput removeOutput(int n) {
        return this.outputFeatures.remove(n);
    }

    private void processDelimiterNode(MIRDelimiterNode mIRDelimiterNode) {
        if (mIRDelimiterNode == null) {
            return;
        }
        for (MIRExpressionNode mIRExpressionNode : mIRDelimiterNode.getExpressionNodeByPosition()) {
            if (mIRExpressionNode.getElementType() == 115) {
                if (mIRExpressionNode.getName().equals("=")) {
                    mIRExpressionNode = ((MIROperatorNode)mIRExpressionNode).getLeftExpressionNode();
                } else if (mIRExpressionNode.getName().equals(".")) {
                    mIRExpressionNode = ((MIROperatorNode)mIRExpressionNode).getRightExpressionNode();
                }
                if (this.getStatementType() == 1 && this.decors.getDecor((MIRExpressionNode)mIRExpressionNode).isVariable) {
                    return;
                }
            }
            if (mIRExpressionNode.getElementType() == 107 && mIRExpressionNode.getName().equals("*")) {
                this.processDelimiterNode((MIRDelimiterNode)mIRExpressionNode);
                continue;
            }
            if (mIRExpressionNode.getElementType() == 339) {
                this.processQueryNode((MIRQueryNode)mIRExpressionNode);
                continue;
            }
            if (this.getStatementType() == 9 && mIRExpressionNode instanceof MIRElementNode && ((MIRElementNode)mIRExpressionNode).getDestinationElementType() == 75) {
                this.processElementNode((MIRElementNode)mIRExpressionNode);
                continue;
            }
            MIRStatementOutput mIRStatementOutput = new MIRStatementOutput(mIRExpressionNode, this.decors, this.options.supportExpressionNameComputation());
            this.outputFeatures.add(mIRStatementOutput);
        }
    }

    private void processQueryNode(MIRQueryNode mIRQueryNode) {
        if (mIRQueryNode == null) {
            return;
        }
        this.processDelimiterNode(mIRQueryNode.getFeatureDelimiterNode());
    }

    private void processStatementNode(MIRStatementNode mIRStatementNode) {
        int n;
        if (mIRStatementNode == null) {
            return;
        }
        MIRDecor mIRDecor = this.decors.getDecor(mIRStatementNode);
        MIRStatementDecor mIRStatementDecor = mIRDecor.getStatementDecor();
        int n2 = -1;
        for (n = 0; n < mIRStatementDecor.outputFeatures.size(); ++n) {
            if (!this.hasStar(mIRStatementDecor.getOutput(n), mIRStatementDecor)) continue;
            if (n2 == -1) {
                n2 = n;
                continue;
            }
            n2 = -1;
            break;
        }
        n = 0;
        for (int i = 0; i < mIRStatementDecor.outputFeatures.size(); ++i) {
            MIRStatementOutput mIRStatementOutput = mIRStatementDecor.outputFeatures.get(i);
            if (i < this.outputFeatures.size()) {
                if (i == n2) {
                    while (n < this.outputFeatures.size() - mIRStatementDecor.outputFeatures.size()) {
                        this.outputFeatures.get(i + n).add(mIRStatementOutput);
                        ++n;
                    }
                }
                this.outputFeatures.get(i + n).add(mIRStatementOutput);
                continue;
            }
            this.outputFeatures.add(new MIRStatementOutput(mIRStatementOutput));
        }
        this.generatedFeatures.addAll(mIRStatementDecor.generatedFeatures);
    }

    private void processStatementNodeByName(MIRStatementNode mIRStatementNode) {
        MIRDecor mIRDecor;
        if (mIRStatementNode == null || (mIRDecor = this.decors.getDecor(mIRStatementNode)) == null) {
            return;
        }
        MIRStatementDecor mIRStatementDecor = mIRDecor.getStatementDecor();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (MIRStatementOutput mIRStatementOutput : this.outputFeatures) {
            hashMap.put(mIRStatementOutput.getName(), mIRStatementOutput);
        }
        for (MIRStatementOutput mIRStatementOutput : mIRStatementDecor.outputFeatures) {
            Object object;
            boolean bl = false;
            for (MIRExpressionNode mIRExpressionNode : mIRStatementOutput.features) {
                if (!mIRStatementDecor.generatedFeatures.contains(mIRExpressionNode)) continue;
                this.generatedFeatures.add((MIRElementNode)mIRExpressionNode);
                bl = true;
            }
            if (bl) {
                object = new MIRStatementOutput(mIRStatementOutput);
                this.outputFeatures.add((MIRStatementOutput)object);
                continue;
            }
            object = (MIRStatementOutput)hashMap.get(mIRStatementOutput.getName());
            if (object == null) {
                object = new MIRStatementOutput(mIRStatementOutput);
                hashMap.put(((MIRStatementOutput)object).getName(), object);
                this.outputFeatures.add((MIRStatementOutput)object);
                continue;
            }
            ((MIRStatementOutput)object).add(mIRStatementOutput);
        }
    }

    private void processElementNode(MIRElementNode mIRElementNode) {
        block4: {
            MIRDataAttribute mIRDataAttribute;
            MIRType mIRType;
            MIRElement mIRElement;
            block5: {
                MIRElement mIRElement2;
                block8: {
                    block7: {
                        block6: {
                            block3: {
                                if (mIRElementNode == null) {
                                    return;
                                }
                                if (mIRElementNode.getDestinationElementType() != 77) break block3;
                                this.outputFeatures.add(new MIRStatementOutput(mIRElementNode, null, this.options.supportExpressionNameComputation()));
                                break block4;
                            }
                            if (mIRElementNode.getDestinationElementType() != 75) break block5;
                            mIRElement2 = MIRDecorUtil.getLastReference(mIRElementNode);
                            if (mIRElement2 == null) break block4;
                            if (mIRElement2.getElementType() != 111) break block6;
                            this.processElementNode((MIRElementNode)mIRElement2);
                            break block4;
                        }
                        if (mIRElement2.getElementType() != 339) break block7;
                        this.processQueryNode((MIRQueryNode)mIRElement2);
                        break block4;
                    }
                    if (mIRElement2.getElementType() != 134) break block8;
                    this.processStatementNode((MIRStatementNode)mIRElement2);
                    break block4;
                }
                if (mIRElement2.getElementType() != 115 && mIRElementNode.getElementType() != 104) break block4;
                this.outputFeatures.add(new MIRStatementOutput(mIRElementNode, null, this.options.supportExpressionNameComputation()));
                break block4;
            }
            if (mIRElementNode.getDestinationElementType() == 24 && mIRElementNode.getPredicateNode() != null && mIRElementNode.getPredicateNode().getName() != null && mIRElementNode.getPredicateNode().getName().equals("COMPLEX_DATATYPE_FORMAT") && (mIRElement = MIRDecorUtil.getLastReference(mIRElementNode)) != null && mIRElement instanceof MIRDataAttribute && (mIRType = (mIRDataAttribute = (MIRDataAttribute)mIRElement).getType()) != null && mIRType instanceof MIRClassType) {
                MIRClassType mIRClassType = (MIRClassType)mIRType;
                MIRClass mIRClass = mIRClassType.getAssociatedClass();
                for (int i = 0; i < mIRClass.getFeatureCount(); ++i) {
                    this.outputFeatures.add(new MIRStatementOutput(mIRElementNode, null, this.options.supportExpressionNameComputation()));
                }
            }
        }
    }

    private List<MIRElement> qualifyFeature(MIRElementNamePart mIRElementNamePart, MIRElement mIRElement, boolean bl) {
        LinkedList<MIRElement> linkedList = new LinkedList<MIRElement>();
        if (mIRElementNamePart == null) {
            return linkedList;
        }
        Stack<MIRElement> stack = new Stack<MIRElement>();
        stack.push(mIRElement);
        int n = 0;
        while (stack.size() > n++ && stack.peek() != null) {
            Object object2;
            Object object3;
            Object object4;
            MIRObject mIRObject;
            MIRElement mIRElement2 = (MIRElement)stack.peek();
            if (mIRElement2.getElementType() == 111) {
                mIRObject = (MIRElementNode)mIRElement2;
                object4 = MIRDecorUtil.getReference((MIRElementNode)mIRObject, (short)77);
                if (object4 == null) {
                    object4 = MIRDecorUtil.getReference((MIRElementNode)mIRObject, (short)75);
                }
                if (object4 == null) {
                    object4 = MIRDecorUtil.getReference((MIRElementNode)mIRObject, (short)23);
                }
                if (object4 == null) {
                    object4 = MIRDecorUtil.getReference((MIRElementNode)mIRObject, (short)24);
                }
                if (object4 == null && ((MIRElementNode)mIRObject).getElementNamePartCount() == 1) {
                    object3 = MIRDecorUtil.getLastPart((MIRElementNode)mIRObject);
                    for (MIRElement mIRElement3 : ((MIRElementNamePart)object3).getReferencedElements()) {
                        object4 = mIRElement3;
                    }
                }
                stack.push((MIRElement)object4);
                continue;
            }
            if (mIRElement2.getElementType() == 114) {
                mIRObject = MIRDecorUtil.getLastPart((MIROperationNode)mIRElement2);
                if (((MIRElementNamePart)mIRObject).getReferencedElementCount() != 1) continue;
                stack.push(((MIRElementNamePart)mIRObject).getReferencedElementIterator().next());
                continue;
            }
            if (mIRElement2.getElementType() == 339) {
                mIRObject = (MIRQueryNode)mIRElement2;
                object4 = ((MIRQueryNode)mIRObject).getFeatureDelimiterNode();
                boolean bl2 = false;
                if (object4 != null) {
                    object2 = ((MIRDelimiterNode)object4).getExpressionNodes().iterator();
                    while (object2.hasNext()) {
                        boolean bl3;
                        MIRExpressionNode mIRExpressionNode = (MIRExpressionNode)object2.next();
                        boolean bl4 = bl3 = mIRExpressionNode instanceof MIRElementNode ? MIRDecorUtil.getLastPart((MIRElementNode)mIRExpressionNode).getQuoted() : false;
                        if (!this.options.compareNames(mIRElementNamePart.getName(), mIRElementNamePart.getQuoted(), mIRExpressionNode.getName(), bl3)) continue;
                        bl2 = true;
                        if (bl) {
                            stack.add(mIRExpressionNode);
                            break;
                        }
                        if (mIRElementNamePart.containsReferencedElement(mIRExpressionNode)) break;
                        mIRElementNamePart.addReferencedElement(mIRExpressionNode);
                        linkedList.add(mIRExpressionNode);
                        break;
                    }
                    if (linkedList.isEmpty() && (object2 = ((MIRDelimiterNode)object4).getExpressionNode("*")) != null && !mIRElementNamePart.containsReferencedElement((MIRElement)object2)) {
                        mIRElementNamePart.addReferencedElement((MIRElement)object2);
                        linkedList.add((MIRElement)object2);
                    }
                    if (!bl2) {
                        for (MIRExpressionNode mIRExpressionNode : ((MIRDelimiterNode)object4).getExpressionNodes()) {
                            if (!this.options.compareNames(mIRElementNamePart.getName(), false, mIRExpressionNode.getName(), false)) continue;
                            if (mIRElementNamePart.containsReferencedElement(mIRExpressionNode)) break;
                            mIRElementNamePart.addReferencedElement(mIRExpressionNode);
                            linkedList.add(mIRExpressionNode);
                            break;
                        }
                    }
                }
                if (bl2 || stack.size() <= 1 || ((MIRElement)stack.get(stack.size() - 2)).getParent() == mIRElement2) continue;
                stack.push(((MIRQueryNode)mIRObject).getQueryStatementNode());
                continue;
            }
            if (mIRElement2.getElementType() == 134) {
                mIRObject = (MIRStatementNode)mIRElement2;
                object4 = this.decors.getDecor((MIRExpressionNode)mIRObject);
                object3 = ((MIRDecor)object4).getStatementDecor();
                object2 = super.getOutput(mIRElementNamePart.getName(), mIRElementNamePart.getQuoted());
                if (object2 == null) {
                    for (MIRStatementOutput mIRStatementOutput : ((MIRStatementDecor)object3).outputFeatures) {
                        if (!this.hasStar(mIRStatementOutput, (MIRStatementDecor)object3)) continue;
                        object2 = mIRStatementOutput;
                        break;
                    }
                }
                if (object2 == null) continue;
                if (bl) {
                    stack.addAll(((MIRStatementOutput)object2).features);
                    continue;
                }
                ((MIRStatementOutput)object2).qualifyFeature(mIRElementNamePart);
                linkedList.addAll(((MIRStatementOutput)object2).features);
                continue;
            }
            if (!(mIRElement2 instanceof MIRFeature) || mIRElementNamePart.containsReferencedElement(mIRElement2)) continue;
            mIRElementNamePart.addReferencedElement(mIRElement2);
            linkedList.add(mIRElement2);
        }
        return linkedList;
    }

    private MIRStatementOutput getOutput(String string, boolean bl) {
        for (MIRStatementOutput mIRStatementOutput : this.outputFeatures) {
            if (!this.options.compareNames(mIRStatementOutput.getName(), mIRStatementOutput.isQuoted(), string, bl)) continue;
            return mIRStatementOutput;
        }
        for (MIRStatementOutput mIRStatementOutput : this.outputFeatures) {
            if (!this.options.compareNames(mIRStatementOutput.getName(), false, string, false)) continue;
            return mIRStatementOutput;
        }
        return null;
    }

    <T extends MIRElement> void buildQualifierList(short s, MIRElement mIRElement, Set<T> set, boolean bl, boolean bl2, HashSet<MIRElement> hashSet) {
        if (mIRElement == null || !hashSet.add(mIRElement)) {
            return;
        }
        if (mIRElement.getElementType() == 111) {
            MIRElementNode mIRElementNode = (MIRElementNode)mIRElement;
            MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode);
            if (mIRElementNamePart != null) {
                for (MIRElement mIRElement2 : mIRElementNamePart.getReferencedElements()) {
                    this.buildQualifierList(s, mIRElement2, set, bl, bl2, hashSet);
                }
            }
        } else if (mIRElement.getElementType() == 114) {
            MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart((MIROperationNode)mIRElement);
            if (mIRElementNamePart != null) {
                for (MIRElement mIRElement3 : mIRElementNamePart.getReferencedElements()) {
                    if (mIRElement3 instanceof MIRStoredProcedure && s == 75) {
                        mIRElement3 = ((MIRStoredProcedure)mIRElement3).getResultDataSet();
                    }
                    this.buildQualifierList(s, mIRElement3, set, bl, bl2, hashSet);
                }
            }
        } else if (mIRElement.getElementType() == 134) {
            MIRStatementNode mIRStatementNode = (MIRStatementNode)mIRElement;
            if (mIRStatementNode.getStatementType() == 6) {
                MIRExpressionNode mIRExpressionNode;
                MIROperatorNode mIROperatorNode = (MIROperatorNode)mIRStatementNode.getExpressionNodeByPosition().get(0);
                MIRExpressionNode mIRExpressionNode2 = mIROperatorNode.getLeftExpressionNode();
                if (mIRExpressionNode2.getElementType() == 134) {
                    this.buildQualifierList(s, mIRExpressionNode2, set, bl, bl2, hashSet);
                }
                if ((mIRExpressionNode = mIROperatorNode.getRightExpressionNode()).getElementType() == 134) {
                    this.buildQualifierList(s, mIRExpressionNode, set, bl, bl2, hashSet);
                }
            } else {
                MIRDecor mIRDecor = this.decors.getDecor(mIRStatementNode);
                MIRStatementDecor mIRStatementDecor = mIRDecor.getStatementDecor();
                boolean bl3 = !bl2 || mIRStatementDecor == this || mIRStatementDecor.getStatementType() == 28 || mIRStatementDecor.getStatementType() == 10;
                AbstractList abstractList = bl3 ? mIRStatementDecor.classifiers : new LinkedList();
                int n = 0;
                while (!bl3 && n < mIRStatementDecor.getOutputCount()) {
                    Object object;
                    if (!((MIRStatementOutput)(object = mIRStatementDecor.getOutput(n++))).hasStar()) continue;
                    int n2 = abstractList.size();
                    for (MIRExpressionNode mIRExpressionNode : ((MIRStatementOutput)object).features) {
                        MIRElementNamePart mIRElementNamePart;
                        if (!(mIRExpressionNode instanceof MIRElementNode) || (mIRElementNamePart = MIRDecorUtil.getClassifierPart((MIRElementNode)mIRExpressionNode)) == null) continue;
                        for (MIRElement mIRElement4 : mIRElementNamePart.getReferencedElements()) {
                            if (!(mIRElement4 instanceof MIRElementNode)) continue;
                            abstractList.add((MIRElementNode)mIRElement4);
                        }
                    }
                    if (n2 != abstractList.size()) continue;
                    abstractList = mIRStatementDecor.classifiers;
                    break;
                }
                for (MIRElement mIRElement5 : abstractList) {
                    this.buildQualifierList(s, mIRElement5, set, bl, bl2, hashSet);
                }
            }
        } else if (mIRElement.getElementType() == 49) {
            if (bl && s == 75) {
                set.add(mIRElement);
            } else {
                this.buildQualifierList(s, ((MIRSynonym)mIRElement).getModelObject(), set, bl, bl2, hashSet);
            }
        } else if (mIRElement.getElementType() == 67) {
            this.buildQualifierList(s, ((MIRStoredProcedure)mIRElement).getParametersDataSet(), set, bl, bl2, hashSet);
        } else if (mIRElement.getElementType() == 339) {
            MIRQueryNode mIRQueryNode = (MIRQueryNode)mIRElement;
            MIRDelimiterNode mIRDelimiterNode = mIRQueryNode.getDelimiterNode();
            if (mIRDelimiterNode != null && mIRDelimiterNode.getName().equals("WITH")) {
                MIRStatementNode mIRStatementNode = mIRQueryNode.getQueryStatementNode();
                this.buildQualifierList(s, mIRStatementNode, set, bl, bl2, hashSet);
            }
        } else if (mIRElement.isInstanceOf(s)) {
            set.add(mIRElement);
        }
    }

    private boolean hasStar(MIRStatementOutput mIRStatementOutput, MIRStatementDecor mIRStatementDecor) {
        return mIRStatementOutput.hasStar() && (mIRStatementOutput.features.isEmpty() || !mIRStatementDecor.generatedFeatures.contains(mIRStatementOutput.features.get(0)));
    }

    private MIROperationNode getOperationQualitifer(MIRElementNode mIRElementNode) {
        MIROperatorNode mIROperatorNode = mIRElementNode.getRightOfOperatorNode();
        if (mIROperatorNode != null && ".".equals(mIROperatorNode.getName()) && mIROperatorNode.getLeftExpressionNode() instanceof MIROperationNode) {
            return (MIROperationNode)mIROperatorNode.getLeftExpressionNode();
        }
        MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastQualifiedPart(mIRElementNode);
        if (mIRElementNamePart != null) {
            Stack<MIRElement> stack = new Stack<MIRElement>();
            stack.addAll(mIRElementNamePart.getReferencedElements());
            while (!stack.isEmpty()) {
                MIRElement mIRElement = (MIRElement)stack.pop();
                if (mIRElement instanceof MIRElementNode) {
                    mIRElementNamePart = MIRDecorUtil.getLastQualifiedPart((MIRElementNode)mIRElement);
                    if (mIRElementNamePart == null) continue;
                    stack.addAll(mIRElementNamePart.getReferencedElements());
                    continue;
                }
                if (mIRElement instanceof MIROperationNode) {
                    return (MIROperationNode)mIRElement;
                }
                if (!(mIRElement instanceof MIRStatementNode)) continue;
                MIRDecor mIRDecor = this.decors.getDecor((MIRStatementNode)mIRElement);
                MIRStatementDecor mIRStatementDecor = mIRDecor.getStatementDecor();
                for (int i = 0; i < mIRStatementDecor.getOutputCount(); ++i) {
                    MIRStatementOutput mIRStatementOutput = mIRStatementDecor.getOutput(i);
                    if (mIRStatementOutput == null) continue;
                    stack.addAll(mIRStatementOutput.features);
                }
            }
        }
        return null;
    }
}

