/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer;

import MITI.MIRException;
import MITI.expression.MIRExpressionLangType;
import MITI.expression.MIRExpressionToolType;
import MITI.expression.analyzer.LookupOptions;
import MITI.expression.analyzer.MIRExpressionAnalyzerHelper;
import MITI.expression.analyzer.StatementMetaInfo;
import MITI.expression.analyzer.decoration.MIRDecorUtil;
import MITI.expression.analyzer.decoration.MIRDecoration;
import MITI.expression.analyzer.engine.CollationMode;
import MITI.expression.analyzer.engine.MIRParser;
import MITI.expression.analyzer.engine.MIRParserError;
import MITI.expression.analyzer.engine.MIRParserOptions;
import MITI.expression.functions.FunctionMapping;
import MITI.expression.functions.MIRFunctionMapping;
import MITI.expression.util.Util;
import MITI.messages.MIRExpressionLib.EXPLIB;
import MITI.sdk.MIRArgument;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRDataAttribute;
import MITI.sdk.MIRDataSet;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIROperation;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIRStatementNode;
import MITI.sdk.MIRStoredProcedure;
import MITI.sdk.MIRType;
import MITI.util.log.MIRLogger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class MIRExpressionAnalyzer
extends FunctionMapping {
    protected MIRClassifierMap cm;
    protected MIRFeatureMap fm;
    private MIRLogger log;
    private int parserType;
    private int dbType;
    private CollationMode cMode;
    private boolean failed;
    private boolean recoverFromSyntaxErrors;
    private boolean reportedError;
    private MIRParser parser;
    private String[] expressionString;
    protected static final String SQL_CONDITION = "SQL CONDITION";
    public static final String ARRAY_DIMENSION_FEATURE = "$nameless_array_item";
    public static final String MAP_KEY_FEATURE = "$nameless_map_key";
    public static final String MAP_VALUE_FEATURE = "$nameless_map_value";

    public MIRExpressionAnalyzer(MIRLogger mIRLogger, int n, int n2) {
        this.log = mIRLogger;
        this.parserType = n;
        this.dbType = n2;
    }

    public MIRClassifierMap getClassifierMap() {
        return this.cm;
    }

    public MIRFeatureMap getFeatureMap() {
        return this.fm;
    }

    public boolean hasFailed() {
        return this.failed;
    }

    protected MIRLogger getLog() {
        return this.log;
    }

    public int getParserType() {
        return this.parserType;
    }

    public void setDatabaseType(int n) {
        if (n != this.dbType) {
            this.dbType = n;
            this.parser = null;
        }
    }

    public int getDatabaseType() {
        return this.dbType;
    }

    public CollationMode getCollationMode() {
        return this.cMode;
    }

    public void setCollationMode(CollationMode collationMode) {
        this.cMode = collationMode;
    }

    public static int getExpressionDatabaseType(String string) {
        String string2 = string.toUpperCase();
        if (string2.contains("ORACLE")) {
            if (string2.contains("ADF")) {
                return 14;
            }
            return 1;
        }
        if (string2.contains("SQL SERVER")) {
            return 2;
        }
        if (string2.contains("SQL AZURE")) {
            return 2;
        }
        if (string2.contains("DB2")) {
            return 3;
        }
        if (string2.contains("TERADATA")) {
            return 4;
        }
        if (string2.contains("GREENPLUM") || string2.contains("NETEZZA") || string2.contains("POSTGRESQL")) {
            return 5;
        }
        if (string2.contains("MYSQL")) {
            return 10;
        }
        if (string2.contains("HIVE")) {
            return 11;
        }
        if (string2.contains("ACCESS")) {
            return 12;
        }
        if (string2.contains("VECTORWISE")) {
            return 13;
        }
        if (string2.contains("CASSANDRA")) {
            return 15;
        }
        if (string2.contains("VERTICA")) {
            return 16;
        }
        if (string2.contains("SALESFORCE")) {
            return 17;
        }
        if (string2.contains("SAP HANA")) {
            return 18;
        }
        if (string2.contains("PRESTO")) {
            return 19;
        }
        if (string2.contains("SNOWFLAKE")) {
            return 20;
        }
        if (string2.contains("REDSHIFT")) {
            return 21;
        }
        if (string2.contains("DENODO")) {
            return 22;
        }
        if (string2.contains("AMAZONAURORA")) {
            return 23;
        }
        if (string2.contains("BIGQUERY")) {
            return 24;
        }
        if (string2.contains("AMAZONATHENA")) {
            return 25;
        }
        if (string2.contains("SYBASE")) {
            return 26;
        }
        return 0;
    }

    public static boolean isSchemaBasedDatabase(int n) {
        return n == 1 || n == 3 || n == 4 || n == 5 || n == 10 || n == 11 || n == 22;
    }

    public boolean getRecoverFromSyntaxErrors() {
        return this.recoverFromSyntaxErrors;
    }

    public void setRecoverFromSyntaxErrors(boolean bl) {
        this.recoverFromSyntaxErrors = bl;
    }

    public boolean parse(MIRClassifierMap mIRClassifierMap) throws MIRException {
        this.cm = mIRClassifierMap;
        this.fm = null;
        if (this.cm == null) {
            return false;
        }
        if (this.cm.getExpression() != null) {
            throw new MIRException(EXPLIB.ERR_INVALID_MAP.getMessage(this.cm.getPath()));
        }
        MIRExpression mIRExpression = this.parse(mIRClassifierMap.getOperation());
        return mIRExpression != null;
    }

    public boolean parse(MIRFeatureMap mIRFeatureMap) throws MIRException {
        this.cm = null;
        this.fm = mIRFeatureMap;
        if (this.fm == null) {
            return false;
        }
        if (this.fm.getExpression() != null) {
            throw new MIRException(EXPLIB.ERR_INVALID_MAP.getMessage(this.fm.getPath()));
        }
        MIRExpression mIRExpression = this.parse(mIRFeatureMap.getOperation());
        MIRFeature mIRFeature = mIRFeatureMap.getDestinationFeature();
        if (mIRExpression != null) {
            if (mIRFeature != null && mIRFeature.getElementType() != 84 && this.optimizeSimpleExpression() && Util.isSimpleFmExpression(mIRExpression) && this.fm.getSourceFeatureCount() == 1) {
                mIRExpression.delete();
                this.fm.setOperation("");
            } else if (!this.fm.getOperation().isEmpty() && this.fm.getSourceFeatureCount() == 0) {
                this.fm.setConstant(true);
            }
            return true;
        }
        return false;
    }

    public boolean parse(MIROperation mIROperation) throws MIRException {
        if (mIROperation.getElementType() == 67) {
            this.prepareStoredProcedure((MIRStoredProcedure)mIROperation);
        } else {
            this.cm = new MIRClassifierMap();
            this.cm.setOperation(mIROperation.getSemantics());
            mIROperation.addClassifierMap(this.cm);
        }
        MIRExpression mIRExpression = this.parse(this.cm.getOperation());
        return mIRExpression != null;
    }

    private void prepareStoredProcedure(MIRStoredProcedure mIRStoredProcedure) throws MIRException {
        Object object;
        MIRClassifierMap mIRClassifierMap;
        String string = mIRStoredProcedure.getPhysicalName().isEmpty() ? mIRStoredProcedure.getName() : mIRStoredProcedure.getPhysicalName();
        MIRDataSet mIRDataSet = mIRStoredProcedure.getResultDataSet();
        if (mIRDataSet == null) {
            mIRDataSet = new MIRDataSet();
            mIRDataSet.setName(string);
            mIRStoredProcedure.addResultDataSet(mIRDataSet);
        }
        if ((mIRClassifierMap = mIRDataSet.getDestinationOfClassifierMap()) == null) {
            mIRClassifierMap = new MIRClassifierMap();
            mIRClassifierMap.setOperation(mIRStoredProcedure.getSemantics());
            mIRClassifierMap.addDestinationClassifier(mIRDataSet);
            mIRStoredProcedure.addClassifierMap(mIRClassifierMap);
        } else if (mIRClassifierMap.getExpression() != null) {
            throw new MIRException(EXPLIB.ERR_INVALID_MAP.getMessage(this.cm.getPath()));
        }
        MIRDataSet mIRDataSet2 = mIRStoredProcedure.getParametersDataSet();
        if (mIRDataSet2 == null) {
            mIRDataSet2 = new MIRDataSet();
            mIRDataSet2.setName(string);
            mIRStoredProcedure.addParametersDataSet(mIRDataSet2);
        }
        if (mIRDataSet2.getFeatureCount() == 0) {
            object = mIRStoredProcedure.getArguments().iterator();
            while (object.hasNext()) {
                MIRArgument mIRArgument = (MIRArgument)object.next();
                MIRDataAttribute mIRDataAttribute = new MIRDataAttribute();
                mIRDataAttribute.setName(mIRArgument.getName());
                mIRDataAttribute.addType(mIRArgument.getType());
                mIRDataAttribute.setPosition(mIRArgument.getPosition());
                mIRDataSet2.addFeature(mIRDataAttribute);
            }
        }
        if ((object = mIRDataSet2.getDestinationOfClassifierMap()) == null) {
            object = new MIRClassifierMap();
            ((MIRClassifierMap)object).setOperation(mIRStoredProcedure.getSemantics());
            ((MIRClassifierMap)object).addDestinationClassifier(mIRDataSet2);
            mIRStoredProcedure.addClassifierMap((MIRClassifierMap)object);
        }
        this.cm = mIRClassifierMap;
    }

    public void fail() {
        this.failed = true;
    }

    public String getComments() {
        if (this.parser != null && !this.failed) {
            return this.parser.getComments();
        }
        return "";
    }

    public List<String> getExtraOptions() {
        if (this.parser != null && !this.failed) {
            return this.parser.getExtraOptions();
        }
        return Collections.emptyList();
    }

    public boolean buildReference(MIRFeatureMap mIRFeatureMap, MIRExpressionNode mIRExpressionNode) {
        if (mIRFeatureMap == null || mIRExpressionNode == null) {
            return false;
        }
        MIRExpression mIRExpression = new MIRExpression();
        MIRStatementNode mIRStatementNode = new MIRStatementNode();
        mIRStatementNode.setStatementType(4);
        mIRStatementNode.addReferencedExpressionNode(mIRExpressionNode);
        mIRExpression.addStatementNode(mIRStatementNode);
        mIRFeatureMap.addExpression(mIRExpression);
        return true;
    }

    public abstract void getSrcElements(MIRElementNode var1, Collection<MIRClassifier> var2, Collection<MIRElement> var3);

    public void getSrcElements(LookupOptions lookupOptions, Collection<MIRClassifier> collection, Collection<MIRElement> collection2) {
        this.getSrcElements(lookupOptions.getNode(), collection, collection2);
    }

    public void getSrcElements(MIROperationNode mIROperationNode, Collection<MIRElement> collection) {
    }

    public abstract MIRFeature getDstFeature(MIRClassifier var1, LookupOptions var2);

    public MIRFeature getDstCondition(MIRClassifier mIRClassifier) {
        return null;
    }

    public MIRFeature getDstCondition(MIRClassifier mIRClassifier, String string) {
        return this.getDstCondition(mIRClassifier);
    }

    public void setDstClassifier(MIRElementNode mIRElementNode) {
    }

    public void setUnknownOperation(MIROperationNode mIROperationNode) {
    }

    public void setBuiltinOperation(MIROperationNode mIROperationNode) {
    }

    public boolean startStatement(MIRStatementNode mIRStatementNode) {
        return true;
    }

    public MIRType getDataType(String string) {
        return null;
    }

    public boolean isStarCandidate(MIRFeature mIRFeature, boolean bl) {
        return bl;
    }

    public boolean isClassifierDefined(MIRClassifier mIRClassifier) {
        return false;
    }

    public MIRFeature getStarFeature(MIRClassifier mIRClassifier, int n) {
        return null;
    }

    public boolean optimizeSimpleExpression() {
        return false;
    }

    public boolean captureConstantExpressions() {
        return true;
    }

    public boolean captureConditionExpressions() {
        return false;
    }

    public void move(MIRClassifier mIRClassifier, MIRClassifier mIRClassifier2) {
    }

    protected void setParsingError(String string, String string2, String string3) {
        this.setParsingError(string, string2, string3, null);
    }

    protected void setParsingError(String string, String string2, String string3, Throwable throwable) {
        String string4 = "";
        String string5 = "";
        if (this.cm != null) {
            string4 = this.cm.getParent() != null ? this.cm.getParent().getPath(false) : (this.cm.getDestinationClassifier() != null ? this.cm.getDestinationClassifier().getPath(false) : this.cm.getName());
            string5 = this.cm.getOperation();
        } else if (this.fm != null) {
            string4 = this.fm.getDestinationFeature() != null ? this.fm.getDestinationFeature().getPath(false) : this.fm.getName();
            string5 = this.fm.getOperation();
        }
        if (!this.reportedError) {
            EXPLIB.WRN_EXPRESSION_PARSING_ERROR.log(this.log, string4);
            this.reportedError = true;
        } else {
            string5 = "== See the first reported error ==";
        }
        EXPLIB.DBG_EXPRESSION_PARSING_ERROR_DETAILED.log(this.log, throwable, string2, string3, string, MIRExpressionToolType.getName(this.parserType), MIRExpressionLangType.getName(this.dbType), string5);
    }

    private MIRExpression parse(String string) {
        if (this.parser == null) {
            this.parser = new MIRParser(this);
            this.setCollationMode(this.parser.getOptions().getCollationMode());
        }
        if (this.getFeatureMap() != null) {
            this.parser.getFlags().flagNewScript(false);
        }
        this.failed = false;
        this.reportedError = false;
        MIRExpression mIRExpression = null;
        try {
            mIRExpression = this.parser.parse(string);
            if (mIRExpression != null) {
                if (this.cm != null) {
                    this.cm.addExpression(mIRExpression);
                } else if (this.fm != null) {
                    this.fm.addExpression(mIRExpression);
                }
                this.expressionString = string.split("\n", -1);
                MIRDecoration mIRDecoration = new MIRDecoration(this.parser.getOptions(), this);
                mIRDecoration.run(mIRExpression);
                this.expressionString = null;
            }
        }
        catch (Error | Exception throwable) {
            this.fail();
            this.setParsingError("", throwable.getClass().getName() + (throwable.getMessage() != null && !throwable.getMessage().isEmpty() ? ": " + throwable.getMessage() : ""), "", throwable);
        }
        if (this.failed) {
            if (mIRExpression != null) {
                mIRExpression.delete();
            }
            mIRExpression = null;
        }
        if (mIRExpression == null || MIRLogger.getGlobalLevel() == 6) {
            for (int i = 0; i < this.parser.getErrorCount(); ++i) {
                MIRParserError mIRParserError = this.parser.getError(i);
                this.setParsingError(mIRParserError.getLocation(), mIRParserError.getMessage(), mIRParserError.getContext());
            }
        }
        return mIRExpression;
    }

    public boolean isMultiStatement() {
        return false;
    }

    public boolean isMultiStatementQuery() {
        return false;
    }

    public boolean supportRegexColumns() {
        return false;
    }

    public boolean supportDoubleQuoteStrings() {
        return false;
    }

    public boolean supportFunctionCalls() {
        return false;
    }

    public boolean supportLocation() {
        return true;
    }

    public boolean supportRecursiveLinks() {
        return false;
    }

    public boolean isOperation() {
        return this.cm != null && this.cm.getParent() instanceof MIROperation;
    }

    public boolean getApplyDataTypes() {
        return false;
    }

    public MIRClassifierMap getOutput(MIRElementNode mIRElementNode, Collection<MIRClassifier> collection, byte by) {
        return null;
    }

    public MIRClassifierMap getOutput(MIROperationNode mIROperationNode, Collection<MIRClassifier> collection) {
        MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIROperationNode);
        if (mIRElementNamePart != null) {
            for (MIRElement mIRElement : mIRElementNamePart.getReferencedElements()) {
                MIRClassifier mIRClassifier = null;
                if (mIRElement instanceof MIRStoredProcedure) {
                    mIRClassifier = ((MIRStoredProcedure)mIRElement).getParametersDataSet();
                } else if (mIRElement instanceof MIRClassifier) {
                    mIRClassifier = (MIRClassifier)mIRElement;
                }
                if (mIRClassifier == null) continue;
                if (this.getClassifierMap().getDatabaseOperation() != null) {
                    MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
                    mIRClassifierMap.addDatabaseOperation(this.getClassifierMap().getDatabaseOperation());
                    mIRClassifierMap.addDestinationClassifier(mIRClassifier);
                    return mIRClassifierMap;
                }
                if (!(mIRElement instanceof MIRStoredProcedure)) continue;
                MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
                mIRClassifierMap.addDatabaseOperation((MIRStoredProcedure)mIRElement);
                mIRClassifierMap.addDestinationClassifier(mIRClassifier);
                return mIRClassifierMap;
            }
        }
        return null;
    }

    public MIRClassifierMap getOutput(MIRStatementNode mIRStatementNode) {
        return null;
    }

    public MIRFunctionMapping getFunctions() {
        return this.getFunctions(this.parserType, this.dbType);
    }

    public StatementMetaInfo getStatementMetaInfo(MIRExpressionNode mIRExpressionNode) {
        MIRStatementNode mIRStatementNode = MIRExpressionAnalyzerHelper.getStatementNode(mIRExpressionNode);
        int[] nArray = this.parser.getStatementNodeLocation(mIRStatementNode);
        StringBuilder stringBuilder = new StringBuilder();
        if (this.expressionString != null && nArray != null && nArray.length == 4) {
            int n;
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = nArray[2];
            int n5 = nArray[3];
            if (n2 <= n4 && n4 <= this.expressionString.length) {
                if (n2 == n4) {
                    stringBuilder.append(this.expressionString[n2 - 1].substring(n3 - 1, n5 - 1));
                } else {
                    stringBuilder.append(this.expressionString[n2 - 1].substring(n3 - 1));
                    for (n = n2; n < n4 - 1; ++n) {
                        stringBuilder.append('\n');
                        stringBuilder.append(this.expressionString[n]);
                    }
                    stringBuilder.append('\n');
                    stringBuilder.append(this.expressionString[n4 - 1].substring(0, n5 - 1));
                }
            }
            for (n = 0; n < stringBuilder.length(); ++n) {
                char c = stringBuilder.charAt(n);
                if (c == ' ' || c == '\t' || c == '\r') {
                    ++n3;
                    continue;
                }
                if (c == '\n') {
                    ++n2;
                    n3 = 1;
                    continue;
                }
                if (n <= 0) break;
                nArray[0] = n2;
                nArray[1] = n3;
                stringBuilder = new StringBuilder(stringBuilder.substring(n));
                break;
            }
        }
        return new StatementMetaInfo(stringBuilder.toString(), nArray);
    }

    protected MIRParserOptions getOptions() {
        return this.parser.getOptions();
    }

    public String toString() {
        String string = MIRExpressionToolType.getName(this.parserType);
        String string2 = MIRExpressionLangType.getName(this.dbType);
        return String.format("Tool type=%s ; Db type=%s", string, string2);
    }
}

